
interrupt	equ	0feh	;interrupt for this function manager
dos		equ	021h	;ms-dos interrupt
fcb_1		equ	05ch	;location of default fcb
fcb_2		equ	06ch	;second default
command_line	equ	080h	;command line
false		equ	000h
true		equ	0ffh
disp_string	equ	09
set_memory	equ	4ah	;modify memory allocation for this task
exec		equ	4bh	;exec system call for load child process
finish		equ	4ch	;terminate program
term_code	equ	8fh	;ACT statement

	code segment
	assume cs:code,ds:code,es:code,ss:code
	org 100h
start:	jmp	entry_point

image_store	db	8000h dup(0)
                db	7000h dup(0)


load_mess  	db  27,'z',13,10,10,10,10,10
db  '                 *************************************************',13,10
db  '                 *               Apricot ARTIST                  *',13,10
db  '                 *                                               *',13,10
db  '                 *    Version Alpha 0.2   28th October 1984      *',13,10
db  '                 *       For the Apricot Portable & P.C.         *',13,10
db  '                 *                                               *',13,10
db  '                 *    (For INTERNAL & DEMONSTRATION use only)    *',13,10
db  '                 *                                               *',13,10
db  '                 *  Va. 0.2 Supports Mouse and Joystick input.   *',13,10
db  '                 *                                               *',13,10
db  '                 *************************************************',13,10
		db  13,10,'$'

memory_err	db	'memory arena trashed',13,10,'$'
err_memory	db	'Not enough memory to run Apricot ARTIST.',13,10,'$'
err_file	db	'ARTIST.000 not found.',13,10,'$'

pathname 	db	'ARTIST.000',0,6ch,2eh,6fh,76h,6ch,00
		db	80 dup (?)

block	dw	0
	dw	0080h
mseg1	dw	?
	dw	5ch
mseg2	dw	?
	dw	6ch
mseg3	dw	?

	dw	100 dup(?)		;reserve a stack segment
stak:	dw	10  dup (0)		;insurance agains stak under run


entry_point:
	cli				;turn off interrupts
	mov	sp,offset stak
	sti
;set up interrupt
	push	ds
	mov	ax,0
	mov	ds,ax
	mov	bx,interrupt * 4		;interrupts are two words
	mov	word ptr[bx],offset image_store
	inc	bx
	inc	bx
	mov	ax,cs
	mov	[bx],ax			;set up segment
;
	pop	ds
;set up memory
	mov bx,offset last_address	;calculate memory required
	shr	bx,1
	shr	bx,1
	shr	bx,1
	shr	bx,1
	inc	bx			;force next highest para
	mov	ah,set_memory		;now set our min memory requirements
	int	dos
	jnc	mem_ok
	mov	dx,offset memory_err
	mov	ah,disp_string
	int	dos
	jmp	l_error_f
;
mem_ok:	mov	dx,offset load_mess
	mov	ah,disp_string
	int	dos

	mov 	ax,cs
	mov 	mseg1,ax
	mov 	mseg2,ax
	mov 	mseg3,ax
	mov	dx,offset pathname
	mov	bx,offset block
	mov	ah,exec
	mov	al,0			;set load and go option
	int	dos
	jnc	l_error_f
	cmp	ax,8			;not enough memory test
	jne	l_error_1
	mov	dx,offset err_memory
	mov	ah,disp_string
	int	dos
	jmp	l_error_f
l_error_1:
	cmp	ax,2			;file not found test
	jne	l_error_2
	mov	dx,offset err_file
	mov	ah,disp_string
	int	dos
	jmp	l_error_f
l_error_2:				;must be bad evironment by default
	mov	dx,offset err_memory
	mov	ah,disp_string
	int	dos
l_error_f:
	mov	dx,offset load_mess
	mov	ah,disp_string
	int	dos

	mov	ah,finish
	int	dos


last_address:
code	ends
	end start 


