  	program	utility(input,output);
const
	icon_range = 940;
	one_plus_no_of_root_icons = 0;
	xleft = 5750;
	xright = 32267;
	ytop = 29200;
	ybottom = 6500;


type
	predeclared_aray = array [0..1] of string[12];
{$iutility.inc}
type 
	file_arr = array [0..1] of string [12];

	int_arr	= array [0..2] of integer;

	byte_array	= array [0..1] of byte;
var
	winds	: absolute[0:1016] array[0..1] of word;
	pdown	: array[1..65] of string[13];
	winmess : array[0..5] of integer;
	popx1,popy1,popxe,popye : array[0..5] of integer;
	blat_pointer : gen_ptr_kludge;

	filein : array[0..127] of byte;
	totalcolours	: external integer;
	grids		: ^grid_list;
	tutor_grid	: grid_list;
	this_overlay,next_overlay : integer;

	cntl,inin,ptin,ints,pts	: external intptr;
	no_of_pts	: external integer;
	sx,sy		: external integer;
	gotcol		: external integer;
	type_mask	: integer;
	oldcount	: integer;
	oldchar		: integer;
        oldcury,
	text_height,
	text_width,
	cell_width	: integer;
	vers		: integer;
	user_icons	: integer;
	pops,cursor_on,got_stopped,active	: boolean;
	switchx,switchy	: integer;
	active_row	: integer;
	xpixels,ypixels	: external integer; { no of pixels on screen x and y }
	xwidth,ywidth	: integer; { pixel width in 1/32768 ths ( x and y ) }
	ricons		: array [0..one_plus_no_of_root_icons] of icon_type;
	icon_table	: ^icon_list;
	window		: ^window_list;
	overlay	: integer;
	cur_tab	: integer;
	scale	: integer;
	curx,cury	: external integer;
	contrl 	: cntrl_array ;	(* global arrays for calling gsx *)
	intin 	: intin_array ;
	intout 	: intout_array ;
	ptsin 	: ptsin_array ;
	ptsout 	: ptsout_array ;
	i,j	: integer;
	sxl,syl : longint;
	cp,p	: intptr;
	ss	: string[10];
	reply: word;
	oldtime,count	: integer;
	movx,movy,micex,micey: integer;
	mousex,mousey: external integer;
	already_run : boolean;


{*****************************************************************************
			Tutorial global definitions
 ****************************************************************************}

	gen_string	: string;
	number_of_colours	: integer;
	colour	: array[0..15] of integer;
	pause,arrow_enable	: boolean;
	cur_text,text_to_show_next : integer;
	over_to_run : integer;
	cursor_pointer : gen_ptr_kludge;
	key_point : gen_ptr_kludge;
	key_buff	: array[0..1024] of byte;
	keyp,old_key	: intptr;
	pkey : gen_ptr_kludge;
	mac_pointer : gen_ptr_kludge;
	cur_drive   : integer;
	pc,pc7220,portlcd,portcol,f1	: boolean;


{*****************************************************************************}

external procedure pointercursor;
external procedure blockcursor;
external procedure helpcursor;

external procedure get_run_files(var filearr:file_list_type);

external function find_run(	exclude		: integer;
				var ex_files	: predeclared_array):boolean;

external function dicon(p:intptr):intptr;

external procedure initcrtc(p1 : integer);

external function scale_x(i:integer):integer;
external function num_sc(n,m,d:integer):integer;
external function getchr:char;

external procedure grid(var x,y : integer; mx,my : integer;var g:grid_list);

external function mouse(w:word):word;
external procedure @HLT;

(* gsx procedure tools *)


external function diskcheck(i : integer) : integer;
external procedure newgsx;
external procedure Gsx( var ptsout : integer;
			var intout : integer;
			var ptsin  : integer;
			var intin  : integer;
			var contrl : integer);

external [1] procedure ovl1;
external [2] procedure ovl2;
external [3] procedure ovl3;
external [4] procedure ovl4;
external [5] procedure ovl5;
external [6] procedure initialise_the_screen(aid : boolean);
external [6] procedure open_wk;
external procedure cur;
external procedure cur2;
external function @bdos86(fntn:integer;ptr:intptr):integer;
external function drive_number : integer;
external function joy : integer;



{$i bitblat.inc}

{
*******************************************************************************
 procedure ABORT_PROG

 purpose:-
	close workstation print message, and terminate.

*******************************************************************************
}

procedure abort_prog(s:string);
var
	i : integer;
begin
	exit_gsx;
	key_restore;
	@HLT;
end;


function get_keyboard : boolean;
var
	f : file;
	result : boolean;
	i : integer;
begin
	assign(f,'TUTOR.007');
	reset(f);
	result := (ioresult=0);
	if result then
	begin
		blockread(f,key_buff[0],i,896,1);
		pkey.offset := wrd($712);
		pkey.segment := wrd(0);
		old_key := pkey.ptr^;
		key_p := addr(key_buff[0]);
		pkey.ptr^ := key_p;
	end;
	get_keyboard := result;
end;


procedure key_restore;
begin
	pkey.offset := wrd($712);
	pkey.segment:= wrd(0);
	pkey.ptr^ := old_key;
end;


{
*******************************************************************************
 procedure BAR
  
 purpose:-
	draw a bar (rectangle) in the current drawing style and mode
	betwween the specified extreems (x1,y1),(x2,y2).

*******************************************************************************
}
procedure bar(x1,y1,x2,y2:integer);
begin
	contrl[1]:=gdp_cmd;
	contrl[2]:=2;
	contrl[4]:=0;
	contrl[6]:=1;
	ptsin[1]:=x1;
	ptsin[2]:=y1;
	ptsin[3]:=x2;
	ptsin[4]:=y2;
	contrl[1]:=contrl[1] ! type_mask;
	newgsx;
end;



{
*******************************************************************************
 procedure CENTRE_TEXT
  
 purpose:-
	Draws string (s) centred about the specified point (x,y) with text of
	the specified height (hgt), in the specified drawing mode (mode).

*******************************************************************************
}
procedure centre_text(x,y,hgt:integer;var s:string;mode:integer);
var
	w:integer;
begin
	if length(s)>0 then
	begin
		set_attrib(set_wr_mode,mode);
		set_txt_hgt(hgt);
		w:=((length(s)-1)*ptsout[3])+ptsout[1];
		draw_text(x-shr(w,1),y-shr(ptsout[2],1),s);
	end;
end;


procedure set_txt_hgt(height : integer);
begin
	contrl[1] := text_hgt_cmd;
	contrl[2] := 1;
	ptsin[1] := 0;
	ptsin[2] := height;
	newgsx;
end;


{
*******************************************************************************
 procedure MOVE_MOUSE

 purpose:-
	Modifies the current mouse co-ordinates by x and y.

*******************************************************************************
}

procedure move_mouse(x,y:integer);
var
	i,j,k,new_x,new_y : integer;
begin
	new_x := curx;
	new_y := cury;
	grid(new_x,new_y,x,y,grids^);
	micex := new_x-curx;
	micey := new_y-cury;
	i := scalex(micex);
	if i<0 then i:= - i;
	j := micey;
	if j<0 then j:=-j;
	if i<j then i:=j;
	if i>0 then
	begin
		j := shr(i,8);
		i := 0;
		while i<=j do
		begin
			oldcury := cury;
			curx:=new_x-(j-i)*(micex div (j+1));
			cury:=new_y-(j-i)*(micey div (j+1));
			draw_cursor(false);
			draw_cursor(true);
			for k := 0 to 200 do
			begin
			end;
		 	i := i + 1;
		end;
		micex := 0;
		micey := 0;
	end;
end;


{
*******************************************************************************
 procedure DRAW_TEXT

 purpose:-
	draws the specified string (s) from the specified co-ordinate (x,y)
	in the current drawing mode at the current height.

*******************************************************************************
}
procedure draw_text( x, y : integer ; s : string ) ;
var 
	i : integer ;
begin
	contrl[ 1 ] := TEXT_CMD ;
	contrl[ 2 ] := 1 ;
	contrl[ 4 ] := length( s ) ;
	ptsin[ 1 ] := x ;
	ptsin[ 2 ] := y ;
	for i := 1 to length( s ) do
	intin[ i ] := ord( s[ i ] ) ;
	contrl[1]:=contrl[1] ! type_mask;
	newgsx;
	set_attrib(32,1);
end;


{
*******************************************************************************
 procedure DISPLAY_ICON

 purpose:-
	This displays the icon number (n) from the icon list at the 
	co-ordinate specified (x,y) scaled by sc/1000 in both dimensions
	and further scaled in the x dimension to account for aspect ratio
	(the icon should be created as if for a screen with a 1:1 aspect
	ratio).

*******************************************************************************
}
procedure display_icon(x,y,n,sc:integer);
var
	k : integer;
	p : intptr;
begin
	if n>=30000 then p:=ricons[n-30000].ptr else p:=icon_table^[n].ptr;
	while p^<>0 do
	begin
		p:=dicon(p);	{move gsx buffers}
		if no_of_pts>0 then for k:=1 to no_of_pts do
		begin
			ptsin[k+k-1]:=num_sc(ptsin[k+k-1],sc,1000);
			ptsin[k+k-1]:=x+scale_x(ptsin[k+k-1]);
			ptsin[k+k]:=y+num_sc(ptsin[k+k],sc,1000);
		end;
		newgsx;
	end;
end;

{
*******************************************************************************
 procedure BLANK_AREA

 purpose:-
	Erases the area defined by the two extemities (x1,y1) and (x2,y2).

*******************************************************************************
}


{
*******************************************************************************
 procedure DRAW_LINE

 purpose:-
	Draw a line between the two specified points.

*******************************************************************************
}
procedure draw_line(x1, y1, x2, y2 : integer ) ;
begin
	contrl[ 1 ] := PLINE_CMD ;
	contrl[ 2 ] := 2 ;
	ptsin[ 1 ] := x1 ;
	ptsin[ 2 ] := y1 ;
	ptsin[ 3 ] := x2 ;
	ptsin[ 4 ] := y2 ;
	contrl[1]:=contrl[1] ! type_mask;
	newgsx;
end ; (* procedure draw_line *)

{
*******************************************************************************
 procedure DRAW_OUTLINE

 purpose:-
	Draw a rectangular outline arround the two specified
	exremities. in the specified line type (l_type) and
	drawing mode (d_mode).

*******************************************************************************
}
procedure draw_outline(x1,y1,x2,y2,l_type,d_mode:integer);
begin
	set_attrib(line_styl_cmd,l_type);
	set_attrib(set_wr_mode,d_mode);

	contrl[1] := 6;
	contrl[2] := 5;
	intin[1] := 0;
	ptsin[1] := x1;
	ptsin[2] := y1;
	ptsin[3] := x1;
	ptsin[4] := y2;
	ptsin[5] := x2;
	ptsin[6] := y2;
	ptsin[7] := x2;
	ptsin[8] := y1;
	ptsin[9] := x1;
	ptsin[10] := y1;
	newgsx;

end;


procedure outline(on : boolean);
begin
	contrl[1]:=104;
	contrl[2]:=0;
	contrl[4]:=1;

	if on then intin[1]:=1 else intin[1]:=0;
	newgsx;
end;


{
*******************************************************************************
 procedure SET_ATTRIB

 purpose:-
	set the specified type (i.e. line type, fill pattern)  in (cmd) to
	the new style specified in attribute.

*******************************************************************************
}
procedure set_attrib( cmd, attribute : integer ) ; (* use something else if *)
begin						   (* want to get set style *)
	contrl[ 1 ] := cmd ;			   (* back from gsx *)
	contrl[ 2 ] := 0 ;
	intin[ 1 ]  := attribute ;
	newgsx;
end ; (* procedure set_attrib *)

{
*******************************************************************************
 procedure EXIT_GSX

 purpose:-
	Close graphics workstation.

*******************************************************************************}

procedure exit_gsx ;
begin
	contrl[ 1 ] := CLOSE_CMD ;
	contrl[ 2 ] := 0 ;
	newgsx;
end ; (* procedure exit_gsx *)



procedure draw_structure(pp:intptr;x,y,sc:integer;scl:boolean);
var
	k:integer;
	p:intptr;
begin
	p:=pp;
	while p^<>0 do
	begin
		p:=dicon(p);	{move gsx buffers}
		if no_of_pts>0 then for k:=1 to no_of_pts do
		begin
			ptsin[k+k-1]:=num_sc(ptsin[k+k-1],sc,1000);
			if scl then ptsin[k+k-1]:=x+scale_x(ptsin[k+k-1])
				else ptsin[k+k-1]:=x+ptsin[k+k-1];
			ptsin[k+k]:=y+num_sc(ptsin[k+k],sc,1000);
		end;
		newgsx;
	end;
end;

{
*******************************************************************************
 procedure DRAW_CURSOR

 purpose:-
	draw cursor on or off as specified.

*******************************************************************************
}
procedure draw_cursor(on:boolean);
begin
  set_attrib(25 ! col_only,colour[3] ! colour[11]);
  if cursor_on then
  begin
	contrl[1]:=5;
	if on then contrl[2]:=2 else contrl[2]:=0;
	if on then contrl[6]:=18 else contrl[6]:=19;
	ptsin[1]:=curx;
	ptsin[2]:=cury;
	newgsx;
  end;
end;



{
*******************************************************************************
 function IS_IT_AN_ICON
  
  parameters :-
		none.

  returns :-
		char.
			chr(0) if no icon under cursor.
			character out of icon array if there is.

*******************************************************************************
}

function is_it_an_icon:integer;
var
	new,i,icon_no,dist,x,y :integer;
	ret:integer;
begin
  ret:=0;
  if user_icons>0 then
  begin
	{ look at the user icons to see if we have picked one up}
	icon_no:=-1;
	dist:=32767;
	for i:=0 to user_icons-1 do	{ first find nearest icon }
	begin
		x:=icon_table^[i].x-curx;	{ x seperation }
		y:=icon_table^[i].y-cury; { y seperation }
		if x<0 then x:=-x;	{ remove signs }
		if y<0 then y:=-y;
		y:=scale_x(y);		{ scale y to aspect }
		if ((x<icon_range) and (y<icon_range)) then
		begin
			new:=(shr(x,4)*shr(x,4))+(shr(y,4)*shr(y,4));
			if new<dist then
			begin
				dist:=new;
				icon_no:=i;
			end;
		end;
	end;
	{ now, if it's close enough select it }
	if icon_no<>-1 then ret:=icon_table^[icon_no].return;
  end;
  is_it_an_icon:=ret;
end;


{
*******************************************************************************
 function GETACHR
  
  parameters :-
		none.

  purpose :-
		To determine what the user is after.
		This routine interrogates the mouse and the keyboard.

  returns :-
		if the mouse lh switch is pressed then we call IS_IT_AN_ICON
		and see if the user has selected an icon, if so we pass the
		character from the icon array back.
		if the rh switch is pressed, we send through a chr(255) and 
		update the values in SWITCHX and SWITCHY. if the rh switch 
		is down still from a previous push we do the same but send 
		through a chr(254).
		if none of the above, the keyboard is interrogated and the
		result passed on ie a character or chr(0) if no user input.

*******************************************************************************
}
function getachr:integer;
var
	i,ch	: integer;
	c	: char;
	w	: word;
begin
	mousex := 0;
	mousey := 0;
	ch:=0;
	w:=reply;
	reply:=mouse(wrd(0));
	if (((reply & 1)=1) ! ((reply & 2) = 2)) & ((w & 1)=0) then
	begin
		ch:=is_it_an_icon;
		if ch=0 then 
		begin
			switchx:=cur_x;
			switchy:=cur_y;
			ch:=255;
		end;
	end;

	micey:=micey+numsc(mousey,1,1);
	micex:=micex+numsc(mousex,1,1);

	if ch=0 then
	begin
		scale := 1;
		c:=getchr;
		case ord(c) of
			49,$81 :	move_mouse(-scale,-scale);
			50,$82 :	move_mouse(0,-scale);
			51,$83 :	move_mouse(+scale,-scale);
			52,$84 :	move_mouse(-scale,0);
			54,$86 :	move_mouse(+scale,0);
			55,$87 :	move_mouse(-scale,+scale);
			56,$88 :	move_mouse(0,+scale);
			57,$89 :	move_mouse(+scale,+scale);
			46,$8a,13   :   begin
					ch:=is_it_an_icon;
					if ch=0 then 
					begin
						switchx:=cur_x;
						switchy:=cur_y;
						ch:=255;
					end;
				end;
			$8b :	begin
					switchx:=cur_x;
					switchy:=cur_y;
					ch:=255;
				end;
			else ch:=ord(c);
		end;
	end;
	getachr:=ch;
end;

{
*******************************************************************************
 function CONIN

 purpose:-
	Same as GETACHR above which CONIN calls, but also updates the cursor
	on the screen after scaleing the mouse motion to reflect the aspect 
	ratio (so  45 degree of the mouse moves the cursor at 45 degrees).

	returns
		char from GETACHR.

*******************************************************************************
}

function conin:integer;
var
	i,j,k:integer;
	inchar : char;
begin
	if not(pause) then
	begin
	   cursor_on:=true;
	   draw_cursor(true);
	end;

	repeat
	   i:=conins;
	until (i<>0) ! (got_stopped) ! (pause);
	if not(pause) then
	begin
	   draw_cursor(false);
	   cursor_on:=false;
	end;
	conin:=i;
end;


function conins:integer;
var
	c,oldx,oldy:integer;
	l:longint;
begin
	if ((oldchar=0) or (oldcount<=0)) then
	begin
		micex:=0;
		micey:=0;
		oldcount:=50;
		c:=getachr;
		oldx:=cur_x;
		oldy:=cur_y;
		l:=xlong(cur_x)+xlong(micex);
		if l<long(minx) then l:=long(minx) 
			else if l>long(maxx) then l:=long(maxx);
		cur_x:=short(l);
		l:=xlong(cur_y)+xlong(micey);
		if l<long(miny) then l:=long(miny) 
			else if l>long(maxy) then l:=long(maxy);
		cur_y:=short(l);

		if ((cur_x<>oldx) or (cur_y<>oldy)) then
		begin
			draw_cursor(false);
if (oldx<=xleft)&(curx>xleft)&(cury>=ybottom) then alter_cursor(2);
if (curx>xleft)&(cury>=ybottom)&(oldy<ybottom) then alter_cursor(2);
if (curx<=xleft)&(oldx>xleft) then alter_cursor(1);
if (cury<=ybottom)&(oldy>ybottom) then alter_cursor(1);
			draw_cursor(true);
		end;
	end else
	begin
		c:=getachr;
		oldcount:=oldcount-1;
	end;


	oldchar:=c;
	conins:=c;
end;

{
*******************************************************************************
 procedure SHRINK

 purpose:-
	reduces the size of the ratio x:y to as small no's as possible
	ie 800:400 would get reduced to 2:1 (hopefully).

*******************************************************************************
}
procedure shrink(var x,y:longint);
var
	i:integer;
begin
  for i:=2 to 7 do
  begin
	while ( ((x mod long(i))=#0) and ((y mod long(i))=#0)) do
	begin
		x:=x div long(i);
		y:=y div long(i);
	end;
  end;
end;


procedure set_col_index(i,r,g,b:integer);
begin
	contrl[1]:=14;
	contrl[2]:=0;
	intin[1]:=i;
	intin[2]:=r;
	intin[3]:=g;
	intin[4]:=b;
	newgsx;
end;




procedure altercursor(cursor_type : integer);
begin
	if cursor_type = 1 then cursor_pointer.ptr := addr(pointer_cursor);
	if cursor_type = 2 then cursor_pointer.ptr := addr(block_cursor);
	if cursor_type = 3 then cursor_pointer.ptr := addr(helpcursor);

	contrl[1] := 111;
	contrl[2] := 0;
	contrl[4] := 0;
	contrl[7] := 0;
	contrl[8] := ord(cursor_pointer.offset);
	contrl[9] := ord(cursor_pointer.segment);
	contrl[10]:= 0;
	contrl[11]:= 0;
	newgsx;
end;


procedure setwins;
begin
        popx1[0] := 2000;
	popy1[0] := 16850;
	popxe[0] := 6500;
	popye[0] := 15000;
	winmess[0]:= 9;
	pdown[0] := ' Files ';
	pdown[1] := 'New          ';
	pdown[2] := 'Open         ';
	pdown[3] := 'Close        ';
	pdown[4] := 'Save         ';
	pdown[5] := 'Save As      ';
	pdown[6] := 'Revert       ';
	pdown[7] := 'Print        ';
	pdown[8] := 'Print Catalog';
	pdown[9] := 'Quit         ';
        popx1[1] := 4700;
	popy1[1] := 15350;
	popxe[1] := 7000;
	popye[1] := 16500;
	winmess[1]:= 10;
	pdown[13] := ' Edit  ';
	pdown[14] := 'Undo         ';
	pdown[15] := 'Cut          ';
	pdown[16] := 'Copy         ';
	pdown[17] := 'Paste        ';
	pdown[18] := 'Flip Vertical';
	pdown[19] := 'Show Page    ';
	pdown[20] := 'Brush Mirrors';
	pdown[21] := 'Brush Shapes ';
	pdown[22] := 'Edit Patterns';
	pdown[23] := 'Undo Mode [N]';
        popx1[2] := 7500;
	popy1[2] := 22920;
	popxe[2] := 7000;
	popye[2] := 9000;
	winmess[2]:= 5;
	pdown[26] := ' Goodies  ';
	pdown[27] := 'Grid         ';
	pdown[28] := 'Fatbits      ';
	pdown[29] := 'Invert    [N]';
	pdown[30] := 'Type over [N]';
	pdown[31] := 'S-Impose  [N]';
        popx1[3] := 11400;
	popy1[3] := 27300;
	popxe[3] := 7000;
	popye[3] := 4700;
	winmess[3]:= 2;
	pdown[39] := ' Font   ';
	pdown[40] := 'English     ';
	pdown[41] := 'American    ';
        popx1[4] := 14500;
	popy1[4] := 16800;
	popxe[4] := 6000;
	popye[4] := 15000;
	winmess[4]:= 9;
	pdown[52] := ' Fontsize  ';
	pdown[53] := '3  Point   ';
	pdown[54] := '6  Point   ';
 	pdown[55] := '9  Point   ';
	pdown[56] := '12 Point   ';
 	pdown[57] := '15 Point   ';
	pdown[58] := '18 Point   ';
 	pdown[59] := '24 Point   ';
	pdown[60] := '36 Point   ';
 	pdown[61] := '72 Point   ';
end;


{
*******************************************************************************
 MAIN CODE

 purpose:-
	performs initialisation then calls the manager overlay.

*******************************************************************************
}

begin
	movx := 300;
	movy := 400;
	already_run := get_keyboard;
	cntl:=addr(contrl[1]);
	inin:=addr(intin[1]);
	ptin:=addr(ptsin[1]);
	ints:=addr(intout[1]);
	pts:=addr(ptsout[1]);
	setwins;
	active := false;
	open_wk;
	set_attrib(21,1);
	syl:=long(xwidth)*long(xpixels+1);
	sxl:=long(ywidth)*long(ypixels+1);
	shrink(sxl,syl);
	sy:=short(syl);
	sx:=short(sxl);

	if gotcol=1 then
	begin
		sx:=3;
		sy:=4;
	end;
	curx := 16384;
	cury := 16384;
	initialise_the_screen(false);
	reply:=mouse(wrd(0));
	alter_cursor(1);

	ovl3;
	Exit_gsx;
	writeln(chr(27),'E');		(* exit graphics *)
	key_restore;
end.


