
	module paint;
const
	maxtutoricons = 10;
	xleft = 5750;
	xright = 32267;
	ytop = 29200;
	ybottom = 6500;
	xwidth = 27017;
	ywidth = 22700;

type
	l_store_type = array[0..256] of byte;
	predeclaredarray = array[0..1] of string[12];

{$i utility.inc}
var
	line_pattern : array[1..16] of word;
	winds	: absolute[0 : 1016] array[0..1] of word;
	iconstore : array[0..1000] of byte;
	window_store : array[0..10000] of byte;
	line_store   : array[1..3] of l_store_type;
	pdown	: array[1..65] of string[13];
        winmess: array[0..5] of integer;
	popx1,popy1,popxe,popye : array[0..5] of integer;
	image_pointer,genpointer : genptrkludge;
	curcolour,curpattern,icon,leftx,lefty,rightx,righty : integer;
	xext,blatmode,xpos,ypos : integer;
	upsidedown,spray,pencil,brushpos,solids,rubber : boolean;
        undomode,saved,actives,paintmode,boxmode,copymode : boolean;
	px,py,middle	: integer;
	portcol	: external boolean;


{$I define.inc}
{$i icon.inc}

external function conins: integer;

external procedure key1;
external procedure revkey;
external procedure portable;
external procedure computer;
external procedure door;
external procedure question;
external procedure cont;
external procedure filecab;
external procedure bboard;
external proecdure paper;



{****************************************************************************
		Procedure to draw a circle given x,y and radius
 ****************************************************************************}
procedure circle(xco,yco,radius : integer);
begin
	radius := radius;
	contrl[1] := 11;
	contrl[2] := 3;
	contrl[6] := 4;
	ptsin[1]  := xco;
	ptsin[2]  := yco;
	ptsin[3]  := xco + radius;
	ptsin[4]  := yco;
	ptsin[5]  := radius;
	ptsin[6]  := 0;
	gsx(ptsout[1],intout[1],ptsin[1],intin[1],contrl[1]);
end;



procedure set_line_style(line_number : integer);
begin
	contrl[1] := 5;
	contrl[2] := 0;
	contrl[4] := 1;
	contrl[6] := 52;
	intin[1]  := ord(line_pattern[line_number]);
	newgsx;
end;


procedure assignicons;
var
	i : integer;
	p : ^integer;
begin
	usericons 		:= 16;

        for i := 0 to 7 do
	begin
		tutoricons[i].ptr    := addr(diskicon);
		tutoricons[i].return := i+1;
		tutoricons[i].x      := 1813;
		tutoricons[i].y      := 8125+3000*i;

		tutoricons[i+8].ptr    := addr(diskicon);
		tutoricons[i+8].return := i+9;
		tutoricons[i+8].x      := 4063;
		tutoricons[i+8].y      := 8125+3000*i;
	end;
	p := addr(tutoricons);
	icontable := p;
end;


procedure saveicons;
var
	i : integer;
begin
	genpointer.ptr := addr(iconstore);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := ord(genpointer.offset);
	contrl[8] := ord(genpointer.segment);
	contrl[9] := 0;
	contrl[10]:= 0;
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 0;
	intin[2] := 1;
	ptsin[1] := 0;
	ptsin[2] := 0;
	ptsin[3] := curx-600;
	ptsin[4] := cury-800;
	ptsin[5] := 1200;
	ptsin[6] := 1600;
	ptsin[7] := 1600;
	ptsin[8] := 1200;
	ptsin[9] := 32767;
	ptsin[10]:= 32767;
	newgsx;
	for i:=0 to 13 do contrl[i] := 0;
end;


procedure restoreicons;
var
	i : integer;
begin
	genpointer.ptr := addr(iconstore);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := 0;
	contrl[8] := 0;
	contrl[9] := ord(genpointer.offset);
	contrl[10]:= ord(genpointer.segment);
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 1;
	intin[1] := 1;
	intin[2] := 0;
	ptsin[1] := curx-600;
	ptsin[2] := cury-800;
	ptsin[3] := 0;
	ptsin[4] := 0;
	ptsin[5] := 1200;
	ptsin[6] := 1600;
	ptsin[7] := 32767;
	ptsin[8] := 32767;
	ptsin[9] := 1600;
	ptsin[10]:= 1200;
	newgsx;
	for i:= 1 to 13 do contrl[i] := 0;
end;


procedure savewindow(x1,y1,xe,ye : integer);
var
	i : integer;
begin
	genpointer.ptr := addr(windowstore[0]);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := ord(genpointer.offset);
	contrl[8] := ord(genpointer.segment);
	contrl[9] := 0;
	contrl[10]:= 0;
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 0;
	intin[2] := 1;
	ptsin[1] := 0;
	ptsin[2] := 0;
	ptsin[3] := x1;
	ptsin[4] := y1;
	ptsin[5] := xe;
	ptsin[6] := ye;
	ptsin[7] := xe;
	ptsin[8] := ye;
	ptsin[9] := 32767;
	ptsin[10]:= 32767;
	newgsx;
	for i:=0 to 13 do contrl[i] := 0;
end;


procedure restwindow(x1,y1,xe,ye : integer);
var
	i : integer;
begin
	genpointer.ptr := addr(windowstore[0]);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := 0;
	contrl[8] := 0;
	contrl[9] := ord(genpointer.offset);
	contrl[10]:= ord(genpointer.segment);
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 1;
	intin[2] := 0;
	ptsin[1] := x1;
	ptsin[2] := y1;
	ptsin[3] := 0;
	ptsin[4] := 0;
	ptsin[5] := xe;
	ptsin[6] := ye;
	ptsin[7] := 32767;
	ptsin[8] := 32767;
	ptsin[9] := xe;
	ptsin[10]:= ye;
	newgsx;
	for i:= 1 to 13 do contrl[i] := 0;
end;


procedure storeline(line,x1,y1,xe,ye : integer);
var
	i : integer;
begin
	genpointer.ptr := addr(line_store[line]);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := ord(genpointer.offset);
	contrl[8] := ord(genpointer.segment);
	contrl[9] := 0;
	contrl[10]:= 0;
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 0;
	intin[2] := 1;
	ptsin[1] := 0;
	ptsin[2] := 0;
	ptsin[3] := x1;
	ptsin[4] := y1;
	ptsin[5] := xe;
	ptsin[6] := ye;
	ptsin[7] := xe;
	ptsin[8] := ye;
	ptsin[9] := 32767;
	ptsin[10]:= 32767;
	newgsx;
	for i:=0 to 13 do contrl[i] := 0;
end;


procedure restoline(line,x1,y1,xe,ye : integer);
var
	i : integer;
begin
	genpointer.ptr := addr(linestore[line]);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := 0;
	contrl[8] := 0;
	contrl[9] := ord(genpointer.offset);
	contrl[10]:= ord(genpointer.segment);
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 1;
	intin[2] := 0;
	ptsin[1] := x1;
	ptsin[2] := y1;
	ptsin[3] := 0;
	ptsin[4] := 0;
	ptsin[5] := xe;
	ptsin[6] := ye;
	ptsin[7] := 32767;
	ptsin[8] := 32767;
	ptsin[9] := xe;
	ptsin[10]:= ye;
	newgsx;
	for i:= 1 to 13 do contrl[i] := 0;
end;


procedure screensave;
var
	i : integer;
begin
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := ord(image_pointer.offset);
	contrl[8] := ord(image_pointer.segment);
	contrl[9] := 0;
	contrl[10]:= 0;
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 0;
	intin[2] := 1;
	ptsin[1] := 0;
	ptsin[2] := 0;
	ptsin[3] := xleft;
	ptsin[4] := ybottom;
	ptsin[5] := xwidth;
	ptsin[6] := ywidth;
	ptsin[7] := xwidth;
	ptsin[8] := ywidth;
	ptsin[9] := 32767;
	ptsin[10]:= 32767;
	newgsx;
	for i:=0 to 13 do contrl[i] := 0;
end;


procedure restscreen;
var
	i : integer;
begin
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := 0;
	contrl[8] := 0;
	contrl[9] := ord(image_pointer.offset);
	contrl[10]:= ord(image_pointer.segment);
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 1;
	intin[2] := 0;
	ptsin[1] := xleft;
	ptsin[2] := ybottom;
	ptsin[3] := 0;
	ptsin[4] := 0;
	ptsin[5] := xwidth;
	ptsin[6] := ywidth;
	ptsin[7] := 32767;
	ptsin[8] := 32767;
	ptsin[9] := xwidth;
	ptsin[10]:= ywidth;
	newgsx;
	for i:= 1 to 13 do contrl[i] := 0;
end;


procedure docopy;
var
	i,xwid,ywid,dum,xoff,yoff,oldx,oldy : integer;
	result : boolean;
begin
	leftx := 0;
	lefty := 0;
	xpos := 0;
	ypos := 0;
	set_attrib(15,7);
	set_line_style(1);
	result := drawbox;
	set_line_style(1);
	if result = true then
	begin
		setattrib(32,1);
		exit;
	end;
	if leftx>xpos then
	begin
		dum := xpos;
		xpos := leftx;
		leftx := dum;
	end;
	if lefty>ypos then
	begin
		dum := ypos;
		ypos := lefty;
		lefty := dum;
	end;
	i := 0;
	storeline(1,leftx-px,lefty-py,3*px,ypos-lefty+py);
	storeline(2,leftx-px,ypos-py,xpos-leftx+px,3*py);
	storeline(3,xpos-px,lefty-py,3*px,ypos-lefty+py);
	storeline(4,leftx-px,lefty-py,xpos-leftx+px,py*3);

	set_attrib(15,7);
	repeat
		i := i + 1;
		if i>16 then i := 1;
		set_line_style(i);
		drawoutline(leftx,lefty,xpos,ypos,7,1);
		drawcursor(true);
		dum := conins;
		drawcursor(false);
	until dum<>0;
	restoline(1,leftx-px,lefty-py,3*px,ypos-lefty+py);
	restoline(2,leftx-px,ypos-py,xpos-leftx+px,3*py);
	restoline(3,xpos-px,lefty-py,3*px,ypos-lefty+py);
	restoline(4,leftx-px,lefty-py,xpos-leftx+px,py*3);
	if (curx<leftx) ! (curx>xpos) ! (cury<lefty) ! (cury>ypos) then
	begin
		setattrib(32,1);
		exit;
	end;

	xoff := curx-leftx;
	yoff := cury-lefty;
	xwid  := xpos-leftx;
	ywid  := ypos-lefty;
	repeat
		oldx := curx;
		oldy := cury;
		drawcursor(true);
		dum := conins;
		drawcursor(false);
		if (curx-xoff+xwid>x_right) ! (curx-xoff < x_left) then
		curx := oldx;
		if (cury-yoff+ywid>y_top) ! (cury-yoff < y_bottom) then
		cury := oldy;
	if (cury<>oldy) ! (curx<>oldx) then
	begin
	  drawoutline(oldx-xoff,oldy-yoff,oldx-xoff+xwid,oldy-yoff+ywid,7,3);
          drawoutline(curx-xoff,cury-yoff,curx-xoff+xwid,cury-yoff+ywid,7,3);
	end;
	until dum<>0;
        drawoutline(curx-xoff,cury-yoff,curx-xoff+xwid,cury-yoff+ywid,7,3);
	setattrib(32,1);
   blat(leftx,lefty,xpos-leftx,ypos-lefty,curx-xoff,cury-yoff,blatmode);

end;


function drawbox : boolean;
var
	dum,i,oldcurx,oldcury : integer;
	result : boolean;
	drawmode : integer;
begin
    if copymode then draw_mode := 7 else draw_mode:=1;
    result := false;
    repeat
	repeat
		drawcursor(true);
		repeat
       			i := conins;
       		until (i<>0);
		drawcursor(false);
		if (curx<x_left) !(cury<y_bottom) then result := checkoptions;
		if result = true then
		begin
			drawbox := true;
			exit;
		end;
	until (curx>x_left) & (cury>y_bottom);
	leftx := curx;
	lefty := cury;
	xpos := curx;
	ypos := cury;
	repeat
		oldcurx := xpos;
		oldcury := ypos;
		drawcursor(true);
		repeat
			i := conins;
until
(i<>0)!((curx<>xpos)!(cury<>ypos))&(curx>xleft)&(curx<xright)&(cury>ybottom)&(cury<ytop);
		drawcursor(false);
		xpos := curx;
		ypos := cury;
		if curx<xleft then xpos := xleft+100;
		if cury<y_bottom then ypos := y_bottom+100;
		set_attrib(17 ! col_only,colour[3] ! colour[11]);
		if (oldcury<>ypos)!(oldcurx<>xpos) then
		begin
			drawoutline(leftx,lefty,oldcurx,oldcury,drawmode,3);
			drawoutline(leftx,lefty,xpos,ypos,drawmode,3);
		end;
	until i<>0;
	setattrib(32,1);
	setattrib(24,curpattern);
	set_attrib(25 ! col_only,curcolour);
	if solids then bar(leftx,lefty,xpos,ypos);
	if upsidedown then
	begin
		drawoutline(leftx,lefty,xpos,ypos,drawmode,3);
		setattrib(32,1);
		if leftx>xpos then
		begin
			xext := xpos;
			xpos := leftx;
			leftx := xext;
		end;
		if lefty>ypos then
		begin
			xext := ypos;
			ypos := lefty;
			lefty := xext;
		end;
		middle := (ypos-lefty) div 2 + lefty;
		xext := xpos-leftx;
		for i :=  ((ypos-middle) div py) downto 1 do
		begin
		   saveline(leftx,middle+i*py,xext,py);
                   blat(leftx,middle-i*py,xext,py,leftx,middle+i*py,0);
		   restline(leftx,middle-i*py,xext,py);
		end;
	end;
	result := checkoptions;
    until (result ! copymode);
    if copymode then drawoutline(leftx,lefty,xpos,ypos,drawmode,3);
    drawbox := result;
end;



procedure saveline(x1,y1,xe,ye : integer);
var
	i : integer;
begin
	genpointer.ptr := addr(iconstore);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := ord(genpointer.offset);
	contrl[8] := ord(genpointer.segment);
	contrl[9] := 0;
	contrl[10]:= 0;
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 0;
	intin[2] := 1;
	ptsin[1] := 0;
	ptsin[2] := 0;
	ptsin[3] := x1;
	ptsin[4] := y1;
	ptsin[5] := xe;
	ptsin[6] := ye+50;
	ptsin[7] := xe;
	ptsin[8] := ye+50;
	ptsin[9] := 32767;
	ptsin[10]:= 32767;
	newgsx;
	for i:=0 to 13 do contrl[i] := 0;
end;


procedure restline(x1,y1,xe,ye : integer);
var
	i : integer;
begin
	genpointer.ptr := addr(iconstore);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := 0;
	contrl[8] := 0;
	contrl[9] := ord(genpointer.offset);
	contrl[10]:= ord(genpointer.segment);
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 1;
	intin[2] := 0;
	ptsin[1] := x1;
	ptsin[2] := y1;
	ptsin[3] := 0;
	ptsin[4] := 0;
	ptsin[5] := xe;
	ptsin[6] := ye+50;
	ptsin[7] := 32767;
	ptsin[8] := 32767;
	ptsin[9] := xe;
	ptsin[10]:= ye+50;
	newgsx;
	for i:= 1 to 13 do contrl[i] := 0;
end;


procedure paint(brx,bry : integer);
var
	i,ox,oy : integer;
	result,brushtmp : boolean;
begin
    if rubber then 
	begin
		setattrib(24,1);
		set_attrib(25 ! col_only,0);
	end
	else 	setattrib(24,curpattern);

    if pencil then set_attrib(17 ! col_only,curcolour);
    result := false;
    repeat
	outline(false);
	repeat
		ox:=curx;
		oy:=cury;
		drawcursor(true);
			repeat
				i := conins;
			until (i<>0) ! (curx<>ox) ! (cury<>oy);
		drawcursor(false);
if (curx<xleft+brx)!(cury<ybottom+bry)!(cury+bry>ytop)!(curx+brx>xright) then
	brushtmp:=false else brushtmp := true;
		if not(rubber) then set_attrib(25 ! col_only,curcolour);
 		if (brushpos&brushtmp&paintmode) then
			bar(curx-brx,cury-bry,curx+brx,cury+bry);
 		if (brushpos&brushtmp&pencil) then
		begin
			set_attrib(17 ! col_only,cur_colour);
			drawline(ox,oy,curx,cury);
		end;
		if (brushpos&brushtmp&spray) then restoreicons;
	until i<>0;
	outline(true);
	result := checkoptions;
     until result;
end;


function button_status : integer;
begin
	contrl[1] := 124;
	contrl[2] := 0;
	contrl[4] := 0;
	newgsx;
	button_status := intout[1];
end;



function popwindow(win : integer) : integer;
var
	result,ypos,oldypos,i,x1,y1,xe,ye : integer;
	one : boolean;
begin
	x1 := popx1[win];
	y1 := popy1[win];
	xe := popxe[win];
	ye := popye[win];

	savewindow(x1,y1,xe+500,ye);
	setattrib(32,1);
	setattrib(25 ! col_only,colour[3] ! colour[11]);
	setattrib(23,2);
	set_attrib(24,1);
	setattrib(24 ! col_only,2);
	bar(x1+100,y1+470,x1+xe,31400);
	set_attrib(17 ! col_only,colour[2] ! colour[8]);
	draw_outline(x1+100,y1+470,x1+xe,31400,1,1);
	drawoutline(x1+100,y1+470+py,x1+xe-px,31400,1,1);
	setattrib(32,3);
	setattrib(24,1);
	set_attrib(24 ! col_only,2);
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	outline(false);
	set_attrib(22 ! col_only,colour[3] ! colour[11]);
	set_attrib(24,2);
	set_attrib(32,3);
	bar(x1+100,31400,x1+100+length(pdown[win*13])*410,32767);
    	for i:=1 to winmess[win] do
		centretext(x1+xe div 2,31800-1500*i,1000,pdown[win*13+i],3);
	set_attrib(23,2);
	set_attrib(24,2);
	set_attrib(32,3);
	outline(false);
	one := true;
	repeat
		draw_cursor(true);
			i := conins;
		draw_cursor(false);
		if (curx>x1)&(curx<x1+xe)&(cury>y1)&(cury<31400) then
		begin
			oldypos := ypos;
			ypos := 1 + (30000 - cury) div 1500;
			result := ypos;
			ypos := 30900-ypos*1500;
			if oldypos<>ypos then
			begin
		if not(one) then bar(x1+100,oldypos,x1+xe-px,oldypos+1700);
				bar(x1+100,ypos,x1+xe-px,ypos+1700);
				one := false;
			end;
		end;
		i := button_status;
	until i=0;
	setattrib(32,3);
	bar(x1+100,31400,x1+100+length(pdown[win*13])*410,32767);
	outline(true);
	restwindow(x1,y1,xe+500,ye);
	popwindow := win * 13 + result;
end;



function checkoptions : boolean;
var
	j,i,xc,yc,option  : integer;
	result : boolean;
begin
	if (cury>30500)  then
	begin
		i := 5;
		repeat
			i := i - 1;
		until popx1[i] < curx;
		option := popwindow(i);
		case option of

			2 : load_screen;
			4 : begin
				if not(saved) then save_screen;
				saved := true;
			     end;
			9  : begin
				abort_prog(genstring);
		     	     end;
			14 : if undomode then restscreen;
			23 : begin
				undomode := not(undomode);
				if undomode then pdown[23][12] := 'Y'
				else pdown[23][12] := 'N';
			     end;
		end;
		brush_pos := false;
		set_attrib(32,1);
		result := false;
        end
	else
	begin
	if (curx>xleft) & (cury>ybottom) then
	begin
		brushpos := not(brushpos);
		result := false;
		if (brushpos & spray) then
		begin
			setattrib(24,3);
			outline(false);
     			circle(curx,cury,600);
			saveicons;
			outline(true);
		end;
	end
	else
	begin
	if (curx>xleft)&(curx<xright) & (cury>1000) & (cury<6000) then
		begin
       			xc := 1 + (curx - 10206) div 2228;
			yc := cury div 3000;
               	 	setattrib(23,2);
			if portcol then 
			begin
			 if yc*10+xc > 8 then curcolour := yc*10+xc-11
				else curpattern := yc*10+xc;
			  set_attrib(25 ! col_only,curcolour);
 			end
			else
			curpattern := yc*10+xc;
	       		setattrib(24,curpattern);
			bar(6400,1304,9378,5296);
	       		brushpos := false;
			result := false;
       		end; 

	icon := isitanicon;
	if icon <>2 then saved := false;
	case icon of
	       15 : begin
			paintmode := false;
			boxmode := false;
			pencil := false;
			result := true;
			brushpos := false;
			spray := true;
			copymode := false;
		    end;
		16 : begin
			paintmode := false;
			boxmode := false;
			pencil := false;
			result := true;
			brushpos := false;
			spray := false;
			copymode := true;
			solids := false;
		    end;
		14 : begin
			paintmode := false;
			boxmode := false;
			spray := false;
			result := true;
			brushpos := false;
			pencil := true;
			copymode := false;
		    end;
              6,13 : begin
			pencil := false;
			spray := false;
			paintmode := true;
			boxmode := false;
			result := true;
			brushpos := false;
			copymode := false;
			boxmode := false;
			if icon<>6 then 
			begin
			rubber:=true;
				for j := 0 to 30 do
				begin
					i := conins;
					if i<>0 then
					begin
    					set_attrib(24,1);
					set_attrib(25 ! col_only,0);
					bar(xleft,ybottom,xright,ytop);
					end;
				end;
			end
			else rubber := false;
		    end;
	     4,12 : begin
			copymode := false;
			spray := false;
	       		paintmode := false;
			pencil := false;
	      		boxmode := true;
			if icon=4 then solids := false else solids := true;
	       		result := true;
		    end;
		8  : upsidedown := not(upsidedown);
		1  : blatmode := 2;
		2  : blatmode := 0;
		10 : blatmode := 1;
	   end;
	if undomode then screensave;
	end;
	end;
	checkoptions := result;
end;


procedure setwins;
begin
        popx1[0] := 2000;
	popy1[0] := 16850;
	popxe[0] := 6500;
	popye[0] := 15000;
	winmess[0]:= 9;
	pdown[0] := ' Files ';
	pdown[1] := 'New          ';
	pdown[2] := 'Open         ';
	pdown[3] := 'Close        ';
	pdown[4] := 'Save         ';
	pdown[5] := 'Save As      ';
	pdown[6] := 'Revert       ';
	pdown[7] := 'Print        ';
	pdown[8] := 'Print Catalog';
	pdown[9] := 'Quit         ';
        popx1[1] := 4700;
	popy1[1] := 15350;
	popxe[1] := 7000;
	popye[1] := 16500;
	winmess[1]:= 10;
	pdown[13] := ' Edit  ';
	pdown[14] := 'Undo         ';
	pdown[15] := 'Cut          ';
	pdown[16] := 'Copy         ';
	pdown[17] := 'Paste        ';
	pdown[18] := 'Flip Vertical';
	pdown[19] := 'Invert       ';
	pdown[20] := 'Show Page    ';
	pdown[21] := 'Invert Mode  ';
	pdown[22] := 'Type Over    ';
	pdown[23] := 'Undo Mode [N]';
        popx1[2] := 7500;
	popy1[2] := 22920;
	popxe[2] := 7000;
	popye[2] := 9000;
	winmess[2]:= 5;
	pdown[26] := ' Goodies  ';
	pdown[27] := 'Grid         ';
	pdown[28] := 'Fatbits      ';
	pdown[29] := 'Brush Shapes ';
	pdown[30] := 'Brush Mirrors';
	pdown[31] := 'Edit Pattern ';
        popx1[3] := 11400;
	popy1[3] := 27300;
	popxe[3] := 7000;
	popye[3] := 4700;
	winmess[3]:= 2;
	pdown[39] := ' Font   ';
	pdown[40] := 'English     ';
	pdown[41] := 'American    ';
        popx1[4] := 14500;
	popy1[4] := 16800;
	popxe[4] := 6000;
	popye[4] := 15000;
	winmess[4]:= 9;
	pdown[52] := ' Fontsize  ';
	pdown[53] := '3  Point   ';
	pdown[54] := '6  Point   ';
 	pdown[55] := '9  Point   ';
	pdown[56] := '12 Point   ';
 	pdown[57] := '15 Point   ';
	pdown[58] := '18 Point   ';
 	pdown[59] := '24 Point   ';
	pdown[60] := '36 Point   ';
 	pdown[61] := '72 Point   ';
  
end;


procedure save_screen;
var
	f : file;
	result : boolean;
	i : integer;
begin
	screensave;
 	assign(f,'PAINT.ACT');
	rewrite(f);
	result := (ioresult=0);
	if result then
	begin
		blockwrite(f,image_pointer.ptr^,i,30000,0);
		close(f,i);
	end;
end;


procedure load_screen;
var
	f : file;
	result : boolean;
	i : integer;
begin
 	assign(f,'PAINT.ACT');
	reset(f);
	result := (ioresult=0);
	if result then
	begin
		blockread(f,image_pointer.ptr^,i,30000,0);
	 	close(f,i);
		restscreen;
	end;
end;



procedure ovl3;
var
	i,j : integer;
	result : boolean;
begin
        line_pattern[1] := wrd($07f80);
	line_pattern[2] := wrd($03fc0);
	line_pattern[3] := wrd($01fe0);
	line_pattern[4] := wrd($00ff0);
	line_pattern[5] := wrd($007f8);
	line_pattern[6] := wrd($003fc);
	line_pattern[7] := wrd($001fe);
	line_pattern[8] := wrd($000ff);
	line_pattern[9] := wrd($0807f);
	line_pattern[10]:= wrd($0c03f);
	line_pattern[11]:= wrd($0e01f);
	line_pattern[12]:= wrd($0f00f);
	line_pattern[13]:= wrd($0f807);
	line_pattern[14]:= wrd($0fc03);
	line_pattern[15]:= wrd($0fe01);
	line_pattern[16]:= wrd($0ff00);

	undomode := false;
	py := 32767 div ypixels;
	px := 32767 div xpixels;
	image_pointer.offset := winds[0];
	image_pointer.segment := winds[1];
	setwins;

	blatmode := 0;
	actives:=false;
	assignicons;
	cursoron := true;
	screensave;
	paintmode := true;
	boxmode := false;
	paint(600,800);
	repeat
		if (paintmode ! pencil ! spray) then paint(600,800);
		if copymode then docopy;
		if boxmode then result := drawbox;
      		result := checkoptions;
	until actives;
	active := true;
end;

modend.

