
 	module disk_tutor;

{*****************************************************************************
		TEXT, ICON, and PATCH AREA DEFINITIONS
 *****************************************************************************
       	PATCH			       ICON	            STRINGS
        *****                          ****                 *******
0,1....X,Y for first disk          0...Disk (Front)    	0...TITLE
2,3....X,Y label text	           1...Disk Label	1...Text for label
4......fill index for shutter      2...Disk (back)	2...2nd line of label
5,6....X,Y for reverse disk        3...Right Arrow     	3...Master disk 1
7......radius for circle                            	4,9.Progs on disk 1
8,9....for,back write protect                       	10..Master disk 2
10.....One unit of time                             	11,16 Progs on disk 2
11,12..X,Y in box disk 1                            	17..Master Disk
13.....Scale in box disk 1                          	18..Blank Disk
14,15..X,Y in box disk 2
16.....Scale in box disk 2
17,18..X,Y for format disk
19,20..X,Y for master copy
21,22..X,Y for blank disk
23,24..X,Y start blat copy
25,26..X,Y end blat copy
34,35..X,Y for 
36.....Scale for 
37.....height for 
38.....fill style for 
39.....fill index for 
40.....fill colour for 

50.....delay after of shutter
51.....delay after 1st close shutter



******************************************************************************}

const
	max_tutor_icons = 10;

type
	predeclared_array	= array[0..1] of string[12];

var
	book	: array[0..100] of string;

{$i utility.inc}
{$i define.inc}
{$i icon.inc}

external procedure floppy;

procedure assign_icons;
var
	p : ^integer;
begin
	user_icons 		:= 9;
	tutor_icons[0].ptr 	:= addr(disk_icon);
	tutor_icons[0].return   := 98;
	tutor_icons[0].x	:= 28250;
	tutor_icons[0].y	:= 24900;

	tutor_icons[1].ptr	:= addr(disk_label);
	tutor_icons[1].return	:= 97;
	tutor_icons[1].x	:= 31250;
	tutor_icons[1].y	:= 24900;

	tutor_icons[2].ptr	:= addr(disk_back);
	tutor_icons[2].return	:= 3;
	tutor_icons[2].x	:= 0;
	tutor_icons[2].y	:= 0;

	tutor_icons[3].ptr	:= addr(rarrow);
	tutor_icons[3].return	:= 4;
	tutor_icons[3].x	:= 0;
	tutor_icons[3].y	:= 0;

	tutor_icons[4].ptr	:= addr(uarrow);
	tutor_icons[4].return	:= 95;
	tutor_icons[4].x	:= patch[34];
	tutor_icons[4].y	:= patch[35];

	tutor_icons[5].ptr	:= addr(darrow);
	tutor_icons[5].return	:= 96;
	tutor_icons[5].x	:= patch[34];
	tutor_icons[5].y	:= patch[35]-5000;

	tutor_icons[6].ptr	:= addr(lister);
	tutor_icons[6].return	:= 99;
	tutor_icons[6].x	:= 24000;
	tutor_icons[6].y	:= 27500;

	tutor_icons[7].ptr	:= addr(finger);
	tutor_icons[7].return	:= 8;
	tutor_icons[7].x	:= 0;
	tutor_icons[7].y	:= 0;

	tutor_icons[8].ptr	:= addr(floppy);
	tutor_icons[8].return	:= 0;

	p := addr(tutor_icons);
	icon_table := p;
end;


{*****************************************************************************
	This procedure displays a disk, shows the use of disk labels,
	and warns the user not to touch the disk surface by sliding the
	AUTO PROTECT shutter back.
 ****************************************************************************}

procedure show_disk;
var
	i : integer;
begin
	set_attrib(32,1);
	set_attrib(17,colour[1] ! colour[9]);
	set_attrib(17 ! col_only,colour[3] ! colour[11]);
	show_text(0,true);
	display_icon(patch[0],patch[1],0,7000);
	set_attrib(23,1);
	open_disk_shutter(patch[0],patch[1]);
	i := delay(15000);
	close_disk_shutter(patch[0],patch[1]);
	wait_for_arrows;
end;

{****************************************************************************
	Show user how to write protect a disk by sliding tab up and down
 ****************************************************************************}
procedure show_write_protection;
var
	i,ypix : integer;
begin
	ypix := 32767 div y_pixels;
	set_attrib(15,1);
	display_icon(patch[5],patch[6],2,7000);		 {show back of disk}
	outline(true);
	set_attrib(32,1);
	set_attrib(23,1);
	set_attrib(24,1);
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	circle(patch[5],patch[6]-1000,patch[7]);	 {draw centre of disk}
	outline(true);
	set_attrib(23,2);
	set_attrib(24,6);		       	 {set halftone}
	set_attrib(25 ! col_only,colour[1] ! colour[9]);
	set_attrib(17 ! col_only,colour[3] ! colour[11]);
	type_mask := 0;
	bar(patch[5]+scale_x(4600),patch[6]-5950,patch[5]+scale_x(5800),patch[6]-4100);
	set_attrib(23,1);
	set_attrib(24,1);			 {set full tone}
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	type_mask :=0;
	bar(patch[5]+scale_x(4600),patch[6]-5000,patch[5]+scale_x(5800),patch[6]-4100);
	set_attrib(17 ! col_only,colour[3] ! colour[11]);
	display_icon(patch[5]+scale_x(9300),patch[6]-5500,7,1500);
	wait_for_arrows;
	if (got_stopped ! active) then exit;
	set_attrib(17 ! col_only,colour[3] ! colour[11]);
	display_icon(patch[5]+scale_x(9300),patch[6]-5500,7,1500);
	set_attrib(32,1);
	set_attrib(23,2);
	set_attrib(24,6);
	set_attrib(23 ! col_only,1);
	set_attrib(25 ! col_only,colour[1] ! colour[9]);
	outline(true);
	set_attrib(17 ! col_only,colour[3] ! colour[11]);
	type_mask:=0;
	bar(patch[5]+scale_x(4600),patch[6]-5950,patch[5]+scale_x(5800),patch[6]-4100);
	draw_outline(patch[5]+scale_x(4600),patch[6]-5950,patch[5]+scale_x(5800),patch[6]-4100,1,1);
	set_attrib(23,1);
	set_attrib(24,1);
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	set_attrib(32,1);
	type_mask:=0;
	bar(patch[5]+scale_x(4600),patch[6]-5950,patch[5]+scale_x(5800),patch[6]-5000);
        i := 7500;
	repeat
		i := i - ypix;
	blat(patch[5]+scale_x(7080),i,6000,10000,patch[5]+scale_x(7080),i-ypix,0);
	until i<6500;
	wait_for_arrows;
	if (got_stopped ! active) then exit;
end;



{****************************************************************************
		Show the contents of the in the box disks
 ****************************************************************************}
procedure show_the_in_the_box_disks;
var
	i : integer;
begin
	display_icon(patch[11],patch[12],0,patch[13]);
centre_text(21000,patch[12]+6000,1000,'MASTER DISK 1     MASTER DISK 2      MASTER DISK 3',2);

	for i:=0 to 4 do
	begin
		get_string(i,50,gen_string);
		centre_text(21000,patch[12]+3000-i*1500,1000,gen_string,2);
	end;
	for i := 0 to 7 do wait_for_arrows;
end;



{****************************************************************************
		Show the user how to format a disk
 ****************************************************************************}
procedure show_formatting;
var
	j : integer;
begin
	display_icon(patch[17],patch[18],0,7000);
	open_disk_shutter(patch[17],patch[18]);
	wait_for_arrows;
	if (got_stopped ! active) then exit;
	set_attrib(17 ! col_only,colour[3] ! colour[11]);
	set_attrib(32,1);
	j:=patch[18]+6500;
	repeat
		j := j - 500;
		draw_line(patch[17]+scale_x(-2100),j,patch[17]+scale_x(800),j);
		dum_int := delay(1500);
	until j < patch[18]+3000;
	wait_for_arrows;
	if (got_stopped ! active) then exit;
end;


{****************************************************************************
		SHOW THE USER HOW TO BACK UP A MASTER DISK
	This procedure draws two disks, one is shown to be a master
	disk and the other a blank formatted disk. Arrows are then
	used to show data flow between the two disks.
 ****************************************************************************}
procedure show_backup;
var
	j,x,start,pix : integer;
begin
	pix := 32767 div x_pixels;
	display_icon(patch[19],patch[20],0,7000);
	centre_text(patch[19],patch[20]+8500,1000,'MASTER DISK',2);
	open_disk_shutter(patch[19],patch[20]);
	close_disk_shutter(patch[19],patch[20]);
	display_icon(patch[21],patch[22],0,7000);
	centre_text(patch[21],patch[20]+8500,1000,'BLANK (FORMATTED) DISK',2);
	open_disk_shutter(patch[21],patch[22]);

	set_attrib(32,1);
	set_attrib(17 ! col_only,colour[3] ! colour[11]);
	j:=patch[20]+6500;
	repeat
		j := j - 500;
		draw_line(patch[21]+scale_x(-2100),j,patch[21]+scale_x(800),j);
		dum_int := delay(15000);
	until j < patch[20]+3000;

	close_disk_shutter(patch[21],patch[22]);
	wait_for_arrows;
	if (got_stopped ! active) then exit;
	x := 0;
	outline(true);
	start := 12200;
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	set_attrib(23,1);
	set_attrib(24,1);
	display_icon(start+x,patch[20]-1500,3,1500);
	x := x + 3400;
	set_attrib(23,0);
	set_attrib(24,0);
	set_attrib(25 ! col_only,colour[1] ! colour[9]);
	set_attrib(23 ! col_only,1);
	set_attrib(24 ! col_only,1);
	display_icon(start+x,patch[20]-1500,3,1500);
	x := x + 3400;
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	set_attrib(23,1);
	set_attrib(24,1);
	display_icon(start+x,patch[20]-1500,3,1500);
	x := 0;
	repeat
		blat(10300,patch[24]-3000,11200,6000,10300+2*pix,patch[24]-3000,0);
		blat(21500-4*pix,patch[24]-3000,4*pix,6000,10300,patch[24]-3000,0);
		x := x + 1;
		dum_int := delay(0);
	until x > 300;
	wait_for_arrows;
end;


{****************************************************************************
		OPEN THE AUTO PROTECT SHUTTER TO REVEAL DISK SURFACE
	DISK ICON scale must be 7000 for the shutter to slide correctly.
		  x_co,y_co are centre points of disk icon.
 ****************************************************************************}
procedure open_disk_shutter(x_co,y_co : integer);
var
	i,pix,left,extent : integer;
begin
	pix := 32767 div x_pixels;
	i := 0;
	set_attrib(32,4);
	set_attrib(32 ! col_only,1);
	set_attrib(25 ! col_only,2);
	set_attrib(23,1);
	set_attrib(24,1);
	outline(false);
	type_mask:=0;
	left := scale_x(-504 * 7) -2*pix+x_co;
	extent := scale_x(864 * 7) +8*pix;

	repeat
		bar(scale_x(126)+x_co,y_co+2800,scale_x(126)+x_co+3*pix,y_co+6250);
		blat(left-i,y_co+1800,extent,5400,left-i-2*pix,y_co+1800,0);
		i := i + 2 * pix;
        	dum_int := delay(0);
	until i> scale_x(1600);
	outline(true);
end;


{****************************************************************************
		CLOSE THE AUTO PROTECT SHUTTER TO CONCEAL DISK SURFACE
	DISK ICON scale must be 7000 for the shutter to slide correctly.
		  x_co,y_co are centre points of disk icon.
 ****************************************************************************}
procedure close_disk_shutter(x_co,y_co : integer);
var
	i,pix,left,extent : integer;
begin
	pix := 32767 div x_pixels;
	left := scale_x(-504 * 7) -2*pix+x_co - scale_x(1800);
	extent := scale_x(864 * 7) + 8*pix;
	set_attrib(32,1);
	set_attrib(23,2);
	set_attrib(24,6);
	set_attrib(23 ! col_only,1);
	set_attrib(24 ! col_only,1);
	set_attrib(25 ! col_only,colour[1] ! colour[9]);
	outline(false);
	type_mask:=0;
	i := 0;
	outline(false);
	repeat
		bar(scale_x(776*7)+left+2*pix,y_co+2800,scale_x(776*7)+left+i+4*pix,y_co+6250);
		blat(left+i,y_co+2000,extent,5300,left+i+2*pix,y_co+2000,0);
		i := i + 2*pix;
		dum_int := delay(0);
	until i>scale_x(1700);
	outline(true);
end;


{****************************************************************************
		Procedure to draw a circle given x,y and radius
 ****************************************************************************}
procedure circle(x_co,y_co,radius : integer);
begin
	radius := scale_x(radius);
	contrl[1] := 11;
	contrl[2] := 3;
	contrl[6] := 4;
	ptsin[1]  := x_co;
	ptsin[2]  := y_co;
	ptsin[3]  := x_co;
	ptsin[4]  := y_co + radius;
	ptsin[5]  := radius;
	ptsin[6]  := 0;
	gsx(ptsout[1],intout[1],ptsin[1],intin[1],contrl[1]);
end;


procedure draw_next_screen(screen_to_draw : integer);
begin
	case screen_to_draw of
		1 :	begin
				show_disk;
				if got_stopped then exit;
				show_write_protection;
	       		end;
		2 : 	show_the_in_the_box_disks;
		3 :	show_formatting;
       		4 :	show_backup;
         end;
end;

{****************************************************************************
			MAIN PROCEDURE FOR THIS MODULE
 ***************************************************************************}
procedure ovl2;
var
	i : integer;
begin
	text_to_show := 12;
	assign_icons;                { Set up ICON table for this overlay }
	clear_window;
	wipe_out;
	over_to_run := 255;
	arrow_up := false;
	arrow_down := true;
	show_arrows;

	arrow_enable := true;

	for i := 1 to 4 do
	begin
		draw_next_screen(i);
		if not(got_stopped) then wipe_out;
		if (got_stopped ! active) then exit;
	end;
	clear_arrows;
	repeat
		i := conin;
	until got_stopped;

	wipe_out;
	clear_window;
end;
modend.

