
	module paint;
const
	maxtutoricons = 10;
	xleft = 5750;
	xright = 32267;
	ytop = 29200;
	ybottom = 6500;
	xwidth = 27017;
	ywidth = 22700;

type
	l_store_type = array[0..760] of byte;
	predeclaredarray = array[0..1] of string[12];

{$i utility.inc}
var
	winds	: absolute[0 : 1016] array[0..1] of word;
	iconstore : array[0..500] of byte;
	window_store : array[0..5000] of integer;
	line_store   : array[1..4] of l_store_type;
	pdown	: external array[1..65] of string[13];
        winmess: external array[0..5] of integer;
	popx1,popy1,popxe,popye : external array[0..5] of integer;
	image_pointer,genpointer : genptrkludge;
	curmode,curcolour,curpattern,icon,leftx,lefty,rightx,righty : integer;
	curheight,point,xext,blatmode,xpos,ypos : integer;
	alpha,upsidedown,spray,pencil,brushpos,solids,rubber : boolean;
        linemode,undomode,saved,actives,paintmode,boxmode,copymode : boolean;
	txtwidth,px,py,middle	: integer;
	txt_style,txt_out,lineout : boolean;
	pops,portcol	: external boolean;
 	line_pattern : array[1..16] of word;


{$I define.inc}
{$i icon.inc}

external function conins: integer;
external function joy : integer;


{****************************************************************************
		Procedure to draw a circle given x,y and radius
 ****************************************************************************}
procedure circle(xco,yco,radius : integer);
begin
	radius := radius;
	contrl[1] := 11;
	contrl[2] := 3;
	contrl[6] := 4;
	ptsin[1]  := xco;
	ptsin[2]  := yco;
	ptsin[3]  := xco + radius;
	ptsin[4]  := yco;
	ptsin[5]  := radius;
	ptsin[6]  := 0;
	gsx(ptsout[1],intout[1],ptsin[1],intin[1],contrl[1]);
end;



procedure set_line_style(line_number : integer);
begin
	contrl[1] := 5;
	contrl[2] := 0;
	contrl[4] := 1;
	contrl[6] := 52;
	intin[1]  := ord(line_pattern[line_number]);
	newgsx;
end;


procedure assignicons;
var
	i : integer;
	p : ^integer;
begin
	usericons 		:= 16;

        for i := 0 to 7 do
	begin
		tutoricons[i].ptr    := addr(diskicon);
		tutoricons[i].return := i+1;
		tutoricons[i].x      := 1813;
		tutoricons[i].y      := 8125+3000*i;

		tutoricons[i+8].ptr    := addr(diskicon);
		tutoricons[i+8].return := i+9;
		tutoricons[i+8].x      := 4063;
		tutoricons[i+8].y      := 8125+3000*i;
	end;
	p := addr(tutoricons);
	icontable := p;
end;


procedure saveicons;
var
	i : integer;
begin
	genpointer.ptr := addr(iconstore);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := ord(genpointer.offset);
	contrl[8] := ord(genpointer.segment);
	contrl[9] := 0;
	contrl[10]:= 0;
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 0;
	intin[2] := 1;
	ptsin[1] := 0;
	ptsin[2] := 0;
	ptsin[3] := curx-600;
	ptsin[4] := cury-800;
	ptsin[5] := 1200;
	ptsin[6] := 1600;
	ptsin[7] := 1600;
	ptsin[8] := 1200;
	ptsin[9] := 32767;
	ptsin[10]:= 32767;
	newgsx;
	for i:=0 to 13 do contrl[i] := 0;
end;


procedure restoreicons;
var
	i : integer;
begin
	genpointer.ptr := addr(iconstore);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := 0;
	contrl[8] := 0;
	contrl[9] := ord(genpointer.offset);
	contrl[10]:= ord(genpointer.segment);
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= blatmode;
	intin[1] := 1;
	intin[2] := 0;
	ptsin[1] := curx-600;
	ptsin[2] := cury-800;
	ptsin[3] := 0;
	ptsin[4] := 0;
	ptsin[5] := 1200;
	ptsin[6] := 1600;
	ptsin[7] := 32767;
	ptsin[8] := 32767;
	ptsin[9] := 1600;
	ptsin[10]:= 1200;
	newgsx;
	for i:= 1 to 13 do contrl[i] := 0;
end;


procedure savewindow(x1,y1,xe,ye : integer);
var
	i : integer;
begin
	genpointer.ptr := addr(windowstore[0]);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := ord(genpointer.offset);
	contrl[8] := ord(genpointer.segment);
	contrl[9] := 0;
	contrl[10]:= 0;
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 0;
	intin[2] := 1;
	ptsin[1] := 0;
	ptsin[2] := 0;
	ptsin[3] := x1;
	ptsin[4] := y1;
	ptsin[5] := xe;
	ptsin[6] := ye;
	ptsin[7] := xe;
	ptsin[8] := ye;
	ptsin[9] := 32767;
	ptsin[10]:= 32767;
	newgsx;
	for i:=0 to 13 do contrl[i] := 0;
end;


procedure restwindow(x1,y1,xe,ye : integer);
var
	i : integer;
begin
	genpointer.ptr := addr(windowstore[0]);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := 0;
	contrl[8] := 0;
	contrl[9] := ord(genpointer.offset);
	contrl[10]:= ord(genpointer.segment);
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= blatmode;
	intin[1] := 1;
	intin[2] := 0;
	ptsin[1] := x1;
	ptsin[2] := y1;
	ptsin[3] := 0;
	ptsin[4] := 0;
	ptsin[5] := xe;
	ptsin[6] := ye;
	ptsin[7] := 32767;
	ptsin[8] := 32767;
	ptsin[9] := xe;
	ptsin[10]:= ye;
	newgsx;
	for i:= 1 to 13 do contrl[i] := 0;
end;


procedure storeline(line,x1,y1,xe,ye : integer);
var
	i : integer;
begin
	if (line=2) ! (line=4) then
	begin
		x1:=0;
		xe:=32767;
	end;

	genpointer.ptr := addr(line_store[line]);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := ord(genpointer.offset);
	contrl[8] := ord(genpointer.segment);
	contrl[9] := 0;
	contrl[10]:= 0;
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 0;
	intin[2] := 1;
	ptsin[1] := 0;
	ptsin[2] := 0;
	ptsin[3] := x1;
	ptsin[4] := y1;
	ptsin[5] := xe;
	ptsin[6] := ye;
	ptsin[7] := xe;
	ptsin[8] := ye;
	ptsin[9] := 32767;
	ptsin[10]:= 32767;
	newgsx;
	for i:=0 to 13 do contrl[i] := 0;
end;


procedure restoline(line,x1,y1,xe,ye : integer);
var
	i : integer;
begin
	if (line=2) ! (line=4) then
	begin
		x1:=0;
		xe:=32767;
	end;
	genpointer.ptr := addr(linestore[line]);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := 0;
	contrl[8] := 0;
	contrl[9] := ord(genpointer.offset);
	contrl[10]:= ord(genpointer.segment);
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 1;
	intin[2] := 0;
	ptsin[1] := x1;
	ptsin[2] := y1;
	ptsin[3] := 0;
	ptsin[4] := 0;
	ptsin[5] := xe;
	ptsin[6] := ye;
	ptsin[7] := 32767;
	ptsin[8] := 32767;
	ptsin[9] := xe;
	ptsin[10]:= ye;
	newgsx;
	for i:= 1 to 13 do contrl[i] := 0;
end;


procedure screensave;
var
	i : integer;
begin
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := ord(image_pointer.offset);
	contrl[8] := ord(image_pointer.segment);
	contrl[9] := 0;
	contrl[10]:= 0;
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 0;
	intin[2] := 1;
	ptsin[1] := 0;
	ptsin[2] := 0;
	ptsin[3] := 4915;
	ptsin[4] := ybottom;
	ptsin[5] := 27800;
	ptsin[6] := ywidth;
	ptsin[7] := 27800;
	ptsin[8] := ywidth;
	ptsin[9] := 32767;
	ptsin[10]:= 32767;
	newgsx;
	for i:=0 to 13 do contrl[i] := 0;
end;


procedure restscreen;
var
	i : integer;
begin
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := 0;
	contrl[8] := 0;
	contrl[9] := ord(image_pointer.offset);
	contrl[10]:= ord(image_pointer.segment);
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 1;
	intin[2] := 0;
	ptsin[1] := 4915;
	ptsin[2] := ybottom;
	ptsin[3] := 0;
	ptsin[4] := 0;
	ptsin[5] := 27800;
	ptsin[6] := ywidth;
	ptsin[7] := 32767;
	ptsin[8] := 32767;
	ptsin[9] := 27800;
	ptsin[10]:= ywidth;
	newgsx;
	for i:= 1 to 13 do contrl[i] := 0;
end;


procedure docopy;
var
	i,xwid,ywid,dum,xoff,yoff,oldx,oldy : integer;
	one,result : boolean;
begin
	leftx := 0;
	lefty := 0;
	xpos := 0;
	ypos := 0;
	set_attrib(15,7);
	set_line_style(1);
	result := drawbox;
	set_line_style(1);
	if result = true then
	begin
		setattrib(32,1);
		exit;
	end;
	if leftx>xpos then
	begin
		dum := xpos;
		xpos := leftx;
		leftx := dum;
	end;
	if lefty>ypos then
	begin
		dum := ypos;
		ypos := lefty;
		lefty := dum;
	end;
	i := 0;
	storeline(1,leftx-px,lefty-py,3*px,ypos-lefty+py);
	storeline(3,xpos-px,lefty-py,3*px,ypos-lefty+py);
	storeline(2,leftx-px,ypos-py,xpos-leftx+px,3*py);
	storeline(4,leftx-px,lefty-py,xpos-leftx+px,py*3);

	set_attrib(15,7);
	set_attrib(32,1);
	repeat
		i := i + 1;
		if i>16 then i := 1;
		set_line_style(i);
		drawoutline(leftx,lefty,xpos,ypos,7,1);
		drawcursor(true);
		dum := conins;
		drawcursor(false);
	until dum<>0;
	restoline(1,leftx-px,lefty-py,3*px,ypos-lefty+py);
	restoline(2,leftx-px,ypos-py,xpos-leftx+px,3*py);
	restoline(3,xpos-px,lefty-py,3*px,ypos-lefty+py);
	restoline(4,leftx-px,lefty-py,xpos-leftx+px,py*3);
	if (curx<leftx) ! (curx>xpos) ! (cury<lefty) ! (cury>ypos) then
	begin
		setattrib(32,1);
		exit;
	end;

	xoff := curx-leftx;
	yoff := cury-lefty;
	xwid  := xpos-leftx;
	ywid  := ypos-lefty;
	one := false;
	repeat
		oldx := curx;
		oldy := cury;
		drawcursor(true);
		dum := conins;
		drawcursor(false);
		if (curx-xoff+xwid>x_right) ! (curx-xoff < x_left) then
		curx := oldx;
		if (cury-yoff+ywid>y_top) ! (cury-yoff < y_bottom) then
		cury := oldy;
	if (cury<>oldy) ! (curx<>oldx) then
	begin
	  if one then
	  drawoutline(oldx-xoff,oldy-yoff,oldx-xoff+xwid,oldy-yoff+ywid,7,3);
          drawoutline(curx-xoff,cury-yoff,curx-xoff+xwid,cury-yoff+ywid,7,3);
	  one := true;
	end;
	until dum<>0;
        drawoutline(curx-xoff,cury-yoff,curx-xoff+xwid,cury-yoff+ywid,7,3);
	setattrib(32,1);
	if (xpos-leftx>2*px) & (ypos-lefty>2*py) then
   blat(leftx,lefty,xpos-leftx,ypos-lefty,curx-xoff,cury-yoff,blatmode);

end;


function drawbox : boolean;
var
	dum,i,oldcurx,oldcury : integer;
	result : boolean;
	drawmode : integer;
begin
    if copymode then draw_mode := 7 else draw_mode:=1;
    result := false;
    repeat
	repeat
		drawcursor(true);
		repeat
       			i := conins;
       		until (i<>0);
		drawcursor(false);
		if (curx<x_left) !(cury<y_bottom) then result := checkoptions;
		if result = true then
		begin
			drawbox := true;
			exit;
		end;
	until (curx>x_left) & (cury>y_bottom);
	leftx := curx;
	lefty := cury;
	xpos := curx;
	ypos := cury;
	repeat
		oldcurx := xpos;
		oldcury := ypos;
		drawcursor(true);
		repeat
			i := conins;
until
(i<>0)!((curx<>xpos)!(cury<>ypos))&(curx>xleft)&(curx<xright)&(cury>ybottom)&(cury<ytop);
		drawcursor(false);
		xpos := curx;
		ypos := cury;
		if curx<xleft then xpos := xleft+100;
		if cury<y_bottom then ypos := y_bottom+100;
		set_attrib(17 ! col_only,colour[3] ! colour[11]);
		if (oldcury<>ypos)!(oldcurx<>xpos) then
		begin
			drawoutline(leftx,lefty,oldcurx,oldcury,drawmode,3);
			drawoutline(leftx,lefty,xpos,ypos,drawmode,3);
		end;
	until i<>0;
	set_current_attribs;
	if solids then bar(leftx,lefty,xpos,ypos);
	if upsidedown then
	begin
		drawoutline(leftx,lefty,xpos,ypos,drawmode,3);
		setattrib(32,1);
		if leftx>xpos then
		begin
			xext := xpos;
			xpos := leftx;
			leftx := xext;
		end;
		if lefty>ypos then
		begin
			xext := ypos;
			ypos := lefty;
			lefty := xext;
		end;
		middle := (ypos-lefty) div 2 + lefty;
		xext := xpos-leftx;
		for i :=  ((ypos-middle) div py) downto 1 do
		begin
		   saveline(leftx,middle+i*py,xext,py);
                   blat(leftx,middle-i*py,xext,py,leftx,middle+i*py,0);
		   restline(leftx,middle-i*py,xext,py);
		end;
	end;
	result := checkoptions;
    until (result ! copymode);
    if copymode then drawoutline(leftx,lefty,xpos,ypos,drawmode,3);
    drawbox := result;
end;



procedure saveline(x1,y1,xe,ye : integer);
var
	i : integer;
begin
	genpointer.ptr := addr(iconstore);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := ord(genpointer.offset);
	contrl[8] := ord(genpointer.segment);
	contrl[9] := 0;
	contrl[10]:= 0;
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 0;
	intin[2] := 1;
	ptsin[1] := 0;
	ptsin[2] := 0;
	ptsin[3] := x1;
	ptsin[4] := y1;
	ptsin[5] := xe;
	ptsin[6] := ye+50;
	ptsin[7] := xe;
	ptsin[8] := ye+50;
	ptsin[9] := 32767;
	ptsin[10]:= 32767;
	newgsx;
	for i:=0 to 13 do contrl[i] := 0;
end;


procedure restline(x1,y1,xe,ye : integer);
var
	i : integer;
begin
	genpointer.ptr := addr(iconstore);
	contrl[1] := 5;
	contrl[2] := 10;
	contrl[4] := 4;
	contrl[6] := 51;
	contrl[7] := 0;
	contrl[8] := 0;
	contrl[9] := ord(genpointer.offset);
	contrl[10]:= ord(genpointer.segment);
	contrl[11]:= 0;
	contrl[12]:= 0;
	contrl[13]:= 0;
	intin[1] := 1;
	intin[2] := 0;
	ptsin[1] := x1;
	ptsin[2] := y1;
	ptsin[3] := 0;
	ptsin[4] := 0;
	ptsin[5] := xe;
	ptsin[6] := ye+50;
	ptsin[7] := 32767;
	ptsin[8] := 32767;
	ptsin[9] := xe;
	ptsin[10]:= ye+50;
	newgsx;
	for i:= 1 to 13 do contrl[i] := 0;
end;

procedure set_current_attribs;
begin
	set_attrib(32,cur_mode);
	set_attrib(24,curpattern);
	set_attrib(25 ! col_only,curcolour);
	set_attrib(17 ! col_only,curcolour);
	set_attrib(22 ! col_only,curcolour);
end;


procedure paint(brx,bry : integer);
var
	i,ox,oy : integer;
	result,brushtmp : boolean;
begin
    if rubber then 
	begin
		setattrib(24,1);
		set_attrib(25 ! col_only,0);
	end
	else 	setattrib(24,curpattern);

    if pencil then set_attrib(17 ! col_only,curcolour);
    result := false;
    repeat
	outline(false);
	repeat
		ox:=curx;
		oy:=cury;
		drawcursor(true);
				i := conins;
		drawcursor(false);
if (curx<xleft+brx)!(cury<ybottom+bry)!(cury+bry>ytop)!(curx+brx>xright) then
	brushtmp:=false else brushtmp := true;
		if not(rubber) then set_attrib(25 ! col_only,curcolour);
		set_current_attribs;
 		if (brushpos&brushtmp&paintmode) then
			bar(curx-brx,cury-bry,curx+brx,cury+bry);
 		if (brushpos&brushtmp&pencil) then
		begin
			set_attrib(17 ! col_only,cur_colour);
			drawline(ox,oy,curx,cury);
		end;
		if (brushpos&brushtmp&spray) then restoreicons;
	until i<>0;
	outline(true);
	result := checkoptions;
     until result;
end;



procedure dolines;
var
	oldx,oldy,ooldx,ooldy,i : integer;
	finish,result : boolean;
begin
	finish := false;
	set_attrib(15,1);
	result := false;
	draw_cursor(true);
	i := 0;
	repeat
		i := conins;
	until (i<>0);
	oldx := curx;
	oldy := cury;
	ooldx := curx;
	ooldy := cury;
	window_store[1] := curx;
	window_store[2] := cury;
	point := 3;
	if (curx>xleft) & (cury>ybottom) & (cury<ytop) then
	begin
	 repeat
		i := conins;
		if i = 0 then
		begin
			if (curx<>ooldx) ! (cury<>ooldy) then
			begin
				set_attrib(32,3);
				draw_cursor(false);
				draw_line(oldx,oldy,ooldx,ooldy);
		       		draw_line(oldx,oldy,curx,cury);
		       		draw_cursor(true);
				ooldx := curx;
		       		ooldy := cury;
			end;
		end
		else
		begin
			set_attrib(32,3);
			draw_cursor(false);
			draw_line(oldx,oldy,ooldx,ooldy);
		if (curx>xleft)&(curx<xright)&(cury<ytop)&(cury>ybottom)
			then
			begin
			  if (curx<>oldx) ! (cury<>oldy) then
			  begin
				set_attrib(32,1);
				draw_line(oldx,oldy,curx,cury);
				draw_cursor(true);
				ooldx := curx;
         			ooldy := cury;
				oldx := curx;
				oldy := cury;
				window_store[point] := curx;
				window_store[point+1] := cury;
				point := point + 2;
			  end
			  else finish := true;
			end
			else finish := true;
		end;
	 until finish;
	 set_current_attribs;
         if (point>4) & not(lineout) then 
	 begin
		 contrl[1] := 9;
		 contrl[2] := point div 2;
	 	 gsx(ptsout[1],intout[1],window_store[1],intin[1],contrl[1]);
	 end;
        end;
	result := check_options;
end;


procedure get_txt;
var
	txtx,txty,i : integer;
	result : boolean;
begin
	set_current_attribs;
	draw_cursor(true);
	repeat
		i := conins;
	until i<>0;
	draw_cursor(false);
	if (curx<xright) & (curx>xleft) & (cury<ytop) & (cury>ybottom) then
	begin
		if txt_style then set_attrib(21,1) else set_attrib(21,2);
		if txt_style then txtwidth := ptsout[3];
		if (i>128) & ((curx<>txtx) ! (cury<>txty)) then
       		begin
			draw_text(txtx,txty,' ');
       			txtx := curx;
       			txty := cury;
       			if txt_style then draw_text(txtx,txty,'_ ');
       		end;
       		if i>128 then i := ord(getchr);
       		if i<>0 then
      		begin
			if (i=127) ! (i=8) then
			begin
				txtx:=txtx-820;
				i := 32;
			end;
       		if txt_style then draw_text(txtx,txty,concat(chr(i),'_ '));
			if txt_out then
			begin
				set_attrib(32,2);
      				draw_text(txtx-px,txty,chr(i));
	       			set_attrib(32,2);
       	       			draw_text(txtx+px,txty,chr(i));
	       			set_attrib(32,2);
       				draw_text(txtx,txty-py,chr(i));
	       			set_attrib(32,2);
       	       			draw_text(txtx,txty+py,chr(i));
				set_attrib(32,3);
		       		draw_text(txtx,txty,chr(i));
			end;
       		      	if txt_style then txtx := txtx + 410
			else
			txtx := txtx + txtwidth;
       		end;
        end;
	result := check_options;
end;


function button_status : integer;
var
	i : integer;
begin
	contrl[1] := 124;
	contrl[2] := 0;
	contrl[4] := 0;
	newgsx;
	i := intout[1];
	button_status := i;
end;


function popwindow(win : integer) : integer;
var
	savblat,result,ypos,oldypos,i,x1,y1,xe,ye : integer;
	txt_type,one : boolean;
begin
	pops := true;
	set_attrib(21,1);
	draw_cursor(false);
	x1 := popx1[win];
	y1 := popy1[win];
	xe := popxe[win];
	ye := popye[win];

        savblat := blatmode;
	blatmode := 0;
	savewindow(x1,y1,xe+500,ye);
	setattrib(32,1);
	setattrib(25 ! col_only,colour[3] ! colour[11]);
	setattrib(23,2);
	set_attrib(24,1);
	setattrib(24 ! col_only,2);
	bar(x1+100,y1+470,x1+xe,31400);
	set_attrib(17 ! col_only,colour[2] ! colour[8]);
	draw_outline(x1+100,y1+470,x1+xe,31400,1,1);
	drawoutline(x1+100,y1+470+py,x1+xe-px,31400,1,1);
	setattrib(32,3);
	setattrib(24,1);
	set_attrib(24 ! col_only,2);
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	outline(false);
	set_attrib(22 ! col_only,colour[3] ! colour[11]);
	set_attrib(24,2);
	set_attrib(32,3);
	bar(x1+100,31400,x1+100+length(pdown[win*13])*410,32767);
    	for i:=1 to winmess[win] do
	   centretext(x1+xe div 2,31800-1500*i,curheight,pdown[win*13+i],3);
	set_attrib(23,2);
	set_attrib(24,2);
	set_attrib(32,3);
	outline(false);
	one := true;
	repeat
		draw_cursor(true);
			i := conins;
		if (curx>x1)&(curx<x1+xe)&(cury>y1)&(cury<31400) then
		begin
			oldypos := ypos;
			ypos := 1 + (30000 - cury) div 1500;
			result := ypos;
			ypos := 30900-ypos*1500;
			if oldypos<>ypos then
			begin
			draw_cursor(false);
		if not(one) then bar(x1+100,oldypos,x1+xe-px,oldypos+1700);
				bar(x1+100,ypos,x1+xe-px,ypos+1700);
				one := false;
			draw_cursor(true);
			end;
		end;
		i := button_status;
	until i=0;
	draw_cursor(false);
	setattrib(32,3);
	bar(x1+100,31400,x1+100+length(pdown[win*13])*410,32767);
	outline(true);
	restwindow(x1,y1,xe+500,ye);
	popwindow := win * 13 + result;
	draw_cursor(true);
	blatmode := savblat;
	pops := false;
end;



function checkoptions : boolean;
var
	j,i,xc,yc,option  : integer;
	result : boolean;
begin
	if (cury>30500)  then
	begin
		i := 5;
		repeat
			i := i - 1;
		until popx1[i] < curx;
		option := popwindow(i);
		if option>52 then 
		begin
			set_txt_hgt((option-52)*500);
			cur_height :=((option-52)*500);
		end;
		case option of
			2 : load_screen;
			4 : begin
				if not(saved) then save_screen;
				saved := true;
			     end;
			9  : begin
				abort_prog(genstring);
		     	     end;
			14 : if undomode then restscreen;
			23 : begin
				undomode := not(undomode);
				if undomode then pdown[23][12] := 'Y'
				else pdown[23][12] := 'N';
			     end;
		  29,30,31 :begin
		       		pdown[29] := 'Invert    [N]';
		      		pdown[30] := 'Type over [N]';
	       	       		pdown[31] := 'S-Impose  [N]';
				if option=29 then
				begin
					curmode := 3;
					blatmode:= 2;
		  			pdown[29] :='Invert    [Y]';
                                end;
				if option=30 then
				begin
					curmode := 1;
					blatmode:= 0;
		  			pdown[30] :='Type over [Y]';
                                end;
				if option=31 then
				begin
					curmode := 2;
					blatmode:= 1;
		  			pdown[31] :='S-Impose  [Y]';
                                end;
			end;
		40,41 : txt_out := not(txt_out);

		end;
		brush_pos := false;
		set_attrib(32,1);
		result := false;
        end
	else
	begin
	if (curx>xleft) & (cury>ybottom) then
	begin
		brushpos := not(brushpos);
		result := false;
		if (brushpos & spray) then
		begin
			setattrib(24,3);
			outline(false);
     			circle(curx,cury,600);
			saveicons;
			outline(true);
		end;
	end
	else
	begin
	if (curx>xleft)&(curx<xright) & (cury>1000) & (cury<6000) then
		begin
       			xc := 1 + (curx - 10206) div 2228;
			yc := cury div 3000;
               	 	setattrib(23,2);
			if portcol then 
			begin
			 if yc*10+xc > 8 then curcolour := yc*10+xc-11
				else curpattern := yc*10+xc;
			  set_attrib(25 ! col_only,curcolour);
 			end
			else
			curpattern := yc*10+xc;
	       		setattrib(24,curpattern);
			set_attrib(32,1);
			bar(6400,1304,9378,5296);
	       		brushpos := false;
			result := false;
       		end; 

	icon := isitanicon;
	saved := false;
	case icon of
		2 : begin
			set_attrib(23,2);
       	       		outline(false);
       	       		for i:= 21 to 27 do
  	       		begin
       	       		       set_attrib(24,i);
	    bar(px*256+(i-21)*16*px,16384,px*256+(i-21)*16*px+16*px,20000);
       	       		end;
                    end;
		3 : if txt_style then txt_style := false
			else txt_style := true;
	       15 : begin
			paintmode := false;
			boxmode := false;
			alpha := false;
			line_mode := false;
			pencil := false;
			result := true;
			brushpos := false;
			spray := true;
			copymode := false;
		    end;
		16 : begin
			paintmode := false;
			boxmode := false;
			alpha := false;
			pencil := false;
			line_mode := false;
			result := true;
			brushpos := false;
			spray := false;
			copymode := true;
			solids := false;
		    end;
		14 : begin
			paintmode := false;
			line_mode := false;
			alpha := false;
			boxmode := false;
			spray := false;
			result := true;
			brushpos := false;
			pencil := true;
			copymode := false;
		    end;
              6,13 : begin
       			line_mode := false;
       			pencil := false;
      	 		spray := false;
			alpha := false;
       			paintmode := true;
      	 		boxmode := false;
       			brushpos := false;
       			copymode := false;
       			boxmode := false;
       			if icon<>6 then 
       			begin
				rubber:=true;
				for j := 0 to 30 do
		       			begin
		       				i := conins;
		       				if i<>0 then
		       				begin
			       				set_attrib(24,1);
			       			set_attrib(25 ! col_only,0);
						bar(xleft,ybottom,xright,ytop);
    						end;
	       				end;
			end
       			else rubber := false;
		    end;
	     4,12 : begin
			copymode := false;
			spray := false;
			alpha := false;
	       		paintmode := false;
			pencil := false;
	      		boxmode := true;
			if icon=4 then solids := false else solids := true;
	       		result := true;
		    end;
	        1,9  : begin
			copymode := false;
			alpha := false;
			spray := false;
	       		paintmode := false;
			pencil := false;
	      		boxmode := false;
			line_mode := true;
			if icon=1 then lineout := true else lineout := false;
	       		result := true;
		    end;
		  8 : begin
			copymode := false;
			spray := false;
	       		paintmode := false;
			pencil := false;
	      		boxmode := false;
			line_mode := false;
			alpha := true;
	       		result := true;
		    end;
	   end;
	if undomode then screensave;
	end;
	end;
	checkoptions := result;
end;


procedure save_screen;
var
	f : file;
	result : boolean;
	i : integer;
	s : string;
begin
	draw_cursor(false);
	screensave;
	set_attrib(32,1);
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	set_attrib(24,2);
	bar(8750,9000,29267,26000);
	set_attrib(17 ! col_only,colour[2] ! colour[10]);
	draw_outline(8750,9000,29267,26000,1,1);
	set_attrib(25 ! col_only,colour[2] ! colour[10]);
	bar(9750,10333,28267,24700);
	if gotcol=1 then
	begin
		draw_outline(9750,10333,28267,24700,1,1);
		draw_outline(9750-px,10333+py,28267+px,24700+py,1,1);
	end
	else
	begin
		draw_outline(9750,10333,28267,24700,1,3);
		draw_outline(9750-px,10333+py,28267+px,24700+py,1,3);
        end;
	genstring := 'Save document as: ';
	set_attrib(22 ! col_only,colour[2] ! colour[10]);
	centretext(15000,22000,cur_height,genstring,3);
	set_attrib(25 ! col_only,colour[2] ! colour[10]);
	set_attrib(24 ! bw_only,1);
	bar(10750,17000,22000,20000);
	draw_outline(10750,17000,22000,20000,1,1);
	draw_outline(10750,17000,22000,20000,1,1);
	bar(15000,14000,21000,16000);
	bar(15000,11000,21000,13000);
	centretext(18000,15000,curheight,'SAVE',1);
	centretext(18000,12000,curheight,'CANCEL',1);
 	assign(f,'PAINT.ACT');
	rewrite(f);
	result := (ioresult=0);
	if result then
	begin
   		blockwrite(f,image_pointer.ptr^,i,61440,0);
		close(f,i);
	end;
	restscreen;
	draw_cursor(true);
end;


procedure load_screen;
var
	f : file;
	result : boolean;
	i : integer;
begin
 	assign(f,'PAINT.ACT');
	reset(f);
	result := (ioresult=0);
	if result then
	begin
		blockread(f,image_pointer.ptr^,i,61440,0);
	 	close(f,i);
		restscreen;
	end;
end;



procedure ovl3;
var
	i,j : integer;
	result : boolean;
begin
        line_pattern[1] := wrd($07f80);
	line_pattern[2] := wrd($03fc0);
	line_pattern[3] := wrd($01fe0);
	line_pattern[4] := wrd($00ff0);
	line_pattern[5] := wrd($007f8);
	line_pattern[6] := wrd($003fc);
	line_pattern[7] := wrd($001fe);
	line_pattern[8] := wrd($000ff);
	line_pattern[9] := wrd($0807f);
	line_pattern[10]:= wrd($0c03f);
	line_pattern[11]:= wrd($0e01f);
	line_pattern[12]:= wrd($0f00f);
	line_pattern[13]:= wrd($0f807);
	line_pattern[14]:= wrd($0fc03);
	line_pattern[15]:= wrd($0fe01);
	line_pattern[16]:= wrd($0ff00);

	pops := false;
	curcolour := colour[3] ! colour[11];
	curpattern:= 2;
	curmode := 1;
	txt_out := false;
	txt_style := true;
	set_txt_hgt(900);
	undomode := false;
	py := 32767 div ypixels;
	px := 32767 div xpixels;
	image_pointer.offset := winds[0];
	image_pointer.segment := winds[1];

	blatmode := 0;
	actives:=false;
	assignicons;
	cursoron := true;
	screensave;
	paintmode := true;
	boxmode := false;
	paint(600,800);
	repeat
		if (paintmode ! pencil ! spray) then paint(600,800);
		if copymode then docopy;
		if boxmode then result := drawbox;
		if linemode then dolines;
		if alpha then get_txt;
    		result := checkoptions;
	until actives;
	active := true;
end;

modend.


