	module keys_lesson;

const
	max_tutor_icons = 20;

type
	predeclared_array = array[0..1] of string[12];

{$i utility.inc}

	list_array	= array[1..100] of integer;

	pptr = ^intptr;
	pptr_kludge = record
		case boolean of
		   true	: (p:pptr);
		   false: (r: word;
			   s: word)
		end;

var
	key_codes		: array[0..120] of integer;
	key_x,key_y		: list_array;
	list_pointer		: ^list_array;
	key_tab_list_pointer	: ^list_array;
	key_len_pointer		: ^list_array;
	key_section_pointer	: ^list_array;
	key_offset		: integer;
	key_tab_pointer		: ^integer;
	key_number,key_size	: integer;
	key_kind		: integer;
	key_width		: array[0..6] of integer;
	sect			: string;

{$i define.inc}

{$i icon.inc}

external procedure keytabs;
external procedure keylens;
external procedure key_pos_table;
external procedure key1;
external procedure key2;
external procedure key3;
external procedure key4;
external procedure key5;
external procedure key6;
external procedure key7;
external procedure key8;
external procedure key9;
external procedure key10;
external procedure key11;
external procedure key12;


procedure set_key_widths;
begin
        key_size := patch[3];
	key_width[1] := patch[0];
	key_width[2] := patch[0] + (patch[0] div 2);
	key_width[3] := key_width[2] + (patch[0] div 4);
	key_width[4] := key_width[3] + (patch[0] div 2);
	key_width[5] := patch[1];
	key_width[6] := patch[0];
	key_width[0] := key_width[3];
end;


procedure assign_icons;
var
	p : ^integer;
begin
	user_icons	:= 14;
	tutor_icons[1].ptr	:= addr(key1);
	tutor_icons[1].return	:= 95;
	tutor_icons[1].x 	:= 24000;
	tutor_icons[1].y	:= 31000;

	tutor_icons[2].ptr	:= addr(key2);
	tutor_icons[2].return	:= 96;
	tutor_icons[2].x 	:= 24000;
	tutor_icons[2].y	:= 24000;

	tutor_icons[3].ptr	:= addr(key3);
	tutor_icons[3].return	:= 99;
	tutor_icons[3].x	:= 24000;
	tutor_icons[3].y	:= 27500;

	tutor_icons[4].ptr	:= addr(key4);
	tutor_icons[4].return	:= 4;

	tutor_icons[5].ptr	:= addr(key5);
	tutor_icons[5].return	:= 5;

	tutor_icons[6].ptr	:= addr(key6);
	tutor_icons[6].return	:= 6;

	tutor_icons[7].ptr	:= addr(key7);
	tutor_icons[8].ptr	:= addr(key8);
	tutor_icons[9].ptr	:= addr(key9);
	tutor_icons[10].ptr	:= addr(key10);

	tutor_icons[11].ptr	:= addr(key11);
	tutor_icons[11].return  := 98;
	tutor_icons[11].x	:= 28250;
	tutor_icons[11].y	:= 24900;

	tutor_icons[12].ptr	:= addr(key12);
	tutor_icons[12].return	:= 97;
	tutor_icons[12].x	:= 31200;
	tutor_icons[12].y	:= 25000;

	tutor_icons[13].ptr	:= addr(uarrow);
	tutor_icons[13].return	:= 95;
	tutor_icons[13].x 	:= 24000;
	tutor_icons[13].y	:= 31000;

	tutor_icons[14].ptr	:= addr(darrow);
	tutor_icons[14].return	:= 96;
	tutor_icons[14].x 	:= 24000;
	tutor_icons[14].y	:= 24000;

	p := addr(tutor_icons);
	icon_table := p;
end;


procedure box(x_low,y_low,x_high,y_high : integer);
begin
	contrl[1] := 9;
	contrl[2] := 4;
	ptsin[1]  := x_low;
	ptsin[2]  := y_low;
	ptsin[3]  := x_low;
	ptsin[4]  := y_high;
	ptsin[5]  := x_high;
	ptsin[6]  := y_high;
	ptsin[7]  := x_high;
	ptsin[8]  := y_low;
	gsx(ptsout[1],intout[1],ptsin[1],intin[1],contrl[1]);
end;


procedure show_keyboard(x_co,y_co : integer);
var
	s_pos,i,j,x,y,key_number,gap,k_size : integer;
begin
	key_tab_pointer		:= addr(keytabs);
	key_tab_list_pointer	:= key_tab_pointer;

	k_size:=36*scale_x(key_width[1])+6*scale_x(key_width[2]);
	x_co := (32767 - k_size) div 2;

if y_pixels<220 then draw_outline(x_co-800,6100,x_co+k_size+800,20000,1,1);
	x := x_co;
	y := y_co;
	i := 1;
	key_number	:= key_tab_list_pointer^[i];
	x := x + scale_x(key_width[key_number]);
	repeat
		set_attrib(32,1);
		set_attrib(25 ! col_only,colour[3] ! colour[11]);
		set_attrib(17 ! col_only,colour[3] ! colour[11]);
		if key_number>0 then 		display_icon(x,y,key_number,key_size);
		key_y[i] := y;
		key_x[i] := x;
		i := i + 1;
x:=x+scale_x(key_width[key_number])+scale_x(key_width[key_tab_list_pointer^[i]]);

		key_number := key_tab_list_pointer^[i];
		if key_number = 8 then
		begin
			i := i + 1;
			key_number := key_tab_list_pointer^[i];
			y := y - 1750;
			x := x_co+scale_x(key_width[key_number]);
		end;
	until i>97
end;


procedure highlight_key(x_co,y_co : integer);
var	
	x,y,i 	 : integer;
	key_type : integer;
begin
	key_tab_pointer		:= addr(keytabs);
	key_tab_list_pointer	:= key_tab_pointer;
	key_type 		:= key_tab_list_pointer^[key_number];
	if (key_type>6) ! (key_type<1) then 
	begin
		key_number := key_number + 1;
		key_type:=key_tab_list_pointer^[key_number];
	end;
	set_attrib(24,6);
	set_attrib(23,1);
	y := key_y[key_number];
	x := key_x[key_number];
	set_attrib(32,3);
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	outline(false);
	display_icon(x,y,key_type+6,key_size);
	outline(true);
end;	


procedure fix_offsets(inchar : char);
begin
	key_number := ord(inchar);
	if ord(inchar) > 21 then key_number := key_number + 1;
	if ord(inchar) > 42 then key_number := key_number + 1;
	if ord(inchar) > 55 then key_number := key_number + 1;
	if ord(inchar) > 61 then key_number := key_number + 1;
	if ord(inchar) > 80 then key_number := key_number + 1;
end;


procedure show_section(inchar : char);
var
	j,i : integer;
begin
	fix_offsets(inchar);
	key_tab_pointer := addr(key_pos_table);
	key_section_pointer := key_tab_pointer;
	key_kind := key_section_pointer^[key_number];
	for i:=0 to 98 do if key_kind=key_section_pointer^[i] then
	begin
		key_number:=i;
		highlight_key(400,15000);
	end;
end;


procedure circle(xp,yp,r : integer);
begin
	r := scale_x(r);
	contrl[1] := 11;
	contrl[2] := 3;
	contrl[6] := 4;
	ptsin[1]  := xp;
	ptsin[2]  := yp;
	ptsin[3]  := xp;
	ptsin[4]  := yp + r;
	ptsin[5]  := r;
	ptsin[6]  := 0;
	gsx(ptsout[1],intout[1],ptsin[1],intin[1],contrl[1]);
end;


procedure high_buttons(b : integer);
begin
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	set_attrib(32,3);
	bar(17000+scale_x(b*5000)-1000,17000,17000+scale_x(b*5000)+1000,19000);
        set_attrib(32,1);
end;


procedure ovl4;
var
	i,j 	: integer;
begin
	assign_icons;
	wipe_out;
	over_to_run := 255;
	set_key_widths;
	text_to_show := 0;
	arrow_up := false;
	arrow_down := true;
	show_arrows;
	show_text(0,true);
	arrow_enable := true;
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	set_attrib(23,1);
	if got_col=1 then bar(500,6000,32267,20000);
	set_attrib(17 ! col_only,colour[0] ! colour[8]);
	if y_pixels>200 then draw_outline(500,6100,32267,20000,1,1);
	set_attrib(32,3);
	if got_col=1 then bar(800,6500,31967,19600);
	set_attrib(32,1);
	show_keyboard(400,15000);
	set_attrib(32,1);
	set_attrib(25 ! col_only,colour[2] ! colour[10]);
	set_attrib(23,1);
	for i :=0 to 3 do circle(17000+scale_x(i*5000),18000,700);
	set_attrib(32,3);
	if (got_col<>1) & (y_pixels>200) then bar(800,6500,31967,19600);

	show_section(chr(48));
	show_section(chr(43));
	wait_for_arrows;
	if (got_stopped ! active) then exit;
	show_section(chr(48));
	wait_for_arrows;
	if (got_stopped ! active) then exit;
	show_section(chr(82));
	wait_for_arrows;
	if (got_stopped ! active) then exit;
	show_section(chr(43));
	show_section(chr(82));
	show_section(chr(84));
	wait_for_arrows;
	if (got_stopped ! active) then exit;
	show_section(chr(84));
	show_section(chr(86));
	wait_for_arrows;
	if (got_stopped ! active) then exit;
	show_section(chr(86));
	show_section(chr(58));
	wait_for_arrows;
	if (got_stopped ! active) then exit;
	show_section(chr(58));
	show_section(chr(60));
	wait_for_arrows;
	if (got_stopped ! active) then exit;
	show_section(chr(60));

	for i:=0 to 3 do
	begin
		high_buttons(i);
		wait_for_arrows;
		if (got_stopped ! active) then exit;
		high_buttons(i);
	end;

	repeat
		i := conin;
	until got_stopped;

end;
modend.



