
	module dos;
{*****************************************************************************
			PATCH TABLE DEFINITIONS
 *****************************************************************************

	0...7..........X,Y coordinates for paper text
	8..15..........X,Y      "       "  monitor text
	16.............Y        "       "  smooth scroll
****************************************************************************}
const
	max_tutor_icons = 10;

type
	predeclared_array	= array[0..1] of string[12];

{$i utility.inc}
{$I define.inc}
{$i icon.inc}

external procedure paper;
external procedure monitor;

procedure assign_icons;
var
	p : ^integer;
begin
	user_icons	:= 7;
	tutor_icons[1].ptr := addr(paper);
	tutor_icons[1].return := 97;
	tutor_icons[1].x := 31000;
	tutor_icons[1].y := 24500;
	tutor_icons[2].ptr := addr(lister);
	tutor_icons[2].return := 99;
	tutor_icons[2].x := 24000;
	tutor_icons[2].y := 27500;
	tutor_icons[3].ptr := addr(diskicon);
	tutor_icons[3].return := 98;
	tutor_icons[3].x := 28500;
	tutor_icons[3].y := 24500;
	tutor_icons[4].ptr := addr(finger);
	tutor_icons[4].return := 0;
	tutor_icons[5].ptr := addr(monitor);
	tutor_icons[5].return := 95;
	tutor_icons[5].x := 24000;
	tutor_icons[5].y := 30000;
	tutor_icons[6].ptr := addr(darrow);
	tutor_icon[6].return := 96;
	tutor_icons[6].x := 24000;
	tutor_icons[6].y := 24000;
	tutor_icons[7].ptr := addr(uarrow);
	tutor_icons[7].return := 0;
	p := addr(tutor_icons);
	icon_table := p;
end;


procedure draw_sheet_of_paper;
var
	csx,csy,i : integer;
begin
	arrow_down := true;
	set_attrib(32,1);
	show_arrows;
	set_attrib(17 ! col_only,colour[0] ! colour[8]);
	csx := sx;
	csy := sy;
	sx := 1;
	sy := 1;
	display_icon(8500,14500,1,900);
	sx := csx;
	sy := csy;

	set_attrib(32,3);
	set_attrib(22 ! col_only,colour[3] ! colour[11]);
	centre_text(patch[0],patch[1],1000,'FILE INDEX',3);
	centre_text(patch[2],patch[3],1000,'GETTING STARTED',3);
	centre_text(patch[4],patch[5],1000,'ORGANISING FILES',3);
	centre_text(patch[6],patch[7],1000,'MS-DOS COMMANDS',3);
end;


procedure draw_monitor(x_pos : integer);
begin
	set_attrib(22,1);
	
	set_attrib(22 ! col_only,colour[3] ! colour[11]);
	centre_text(xpos,patch[9],1000,'DIRECTORY OF A\TUTOR',2);
	centre_text(xpos,patch[11],1000,'OLDNAME             ',2);
	centre_text(xpos,patch[13],1000,'EXAMPLE.TXT         ',2);
	centre_text(xpos,patch[15],1000,'MYFILE              ',2);
	set_attrib(22 ! col_only,colour[3] ! colour[11]);
end;


procedure draw_colour_tabs;
begin
	arrow_up := true;
	show_arrows;
	set_attrib(17 ! col_only,colour[0] ! colour[8]);
	set_attrib(23 ! col_only,1);
	set_attrib(24 ! col_only,1);
	set_attrib(25 ! col_only,colour[2] ! colour[10]);
	bar(2000,patch[3]-600,3000,patch[3]+600);
	set_attrib(25 ! col_only,colour[1] ! colour[9]);
	set_attrib(23 ! bw_only,2);
	set_attrib(24 ! bw_only,6);
	bar(2000,patch[5]-600,3000,patch[5]+600);
	set_attrib(25 ! col_only,colour[0] ! colour[8]);
	set_attrib(24 ! bw_only,4);
	bar(2000,patch[7]-600,3000,patch[7]+600);
end;


procedure draw_direct_icons;
var
	i,pix : integer;
begin
	pix := 32767 div y_pixels;
	i := 0;
	repeat
		blat(18800+i,10000,9400,7800,18800+i+pix,10000,0);
		i := i + pix;
	until i>1500;

	display_icon(19000,patch[11],2,1200);
	display_icon(19000,patch[13],3,1200);
	display_icon(19000,patch[15],4,1200);
end;



procedure delete_a_file;
var
	i,pix : integer;
begin
        pix := 32767 div y_pixels;
	i := 0;
	repeat
		blat(8000,9600+i,9000,6000-i,8000,9600+i+pix,0);
		i := i + pix;
	until i>3000;
end;



procedure put_on_dos_line(comm : string;action : integer);
var
	i,j : integer;
	s : string;
begin
	set_attrib(25 ! col_only,colour[3] ! colour[11]);
	set_attrib(22 ! col_only,colour[3] ! colour[11]);
 	gen_string := concat('Dos>  ',comm);
	if action>0 then
	begin
		for i:=1 to length(gen_string) do
		begin
			s := gen_string[i];
	       		centre_text(17200+(i*410),8300,1000,s,2);
	       		j := delay(5000);
		end;
	end
	else
       	begin
		if gotcol=1 then
		begin
			set_attrib(23 ! col_only,1);
			set_attrib(24 ! col_only,1);
	       		set_attrib(25 ! col_only,colour[1] ! colour[9]);
        		bar(19100,7700,31000,8900);
		end
		else blank_area(19100,7700,31000,8900);
	end;
end;



procedure rename_a_file;
begin
	if gotcol=1 then
	begin
		set_attrib(25,colour[0] ! colour[8]);
		set_attrib(32,1);
		set_attrib(23,1);
		set_attrib(24,1);
	    	bar(patch[14]-1500,patch[15]-500,patch[14]+4000,patch[15]+1500);
	end
	else
        blank_area(patch[14]-1500,patch[15]-500,patch[14]+4000,patch[15]+1500);
	get_string(12,50,gen_string);
	centre_text(patch[14],patch[15],1000,gen_string,2);
	put_on_dos_line('  ',0);
end;


procedure type_a_file;
var
 	i,pix,ypix,j,k : integer;
	smooth    : boolean;
	inchar	  : char;
begin
	smooth := true;
	if gotcol=1 then
	begin
		set_attrib(25,colour[0] ! colour[8]);
		set_attrib(32,1);
		set_attrib(23,1);
		set_attrib(24,1);
	      	bar(9800,8000,23000,21000);
	end
	else
	blank_area(9800,8000,23000,21000);
        set_attrib(22 ! col_only,colour[3] ! colour[11]);
	pix := 32767 div 25;
	ypix:= (32767 div y_pixels) * 4;
	for i := 0 to 8 do
 	begin
  		get_string(i,32,gen_string);
		set_attrib(32,2);
        	draw_text(10000,8000+(i*1310)+ypix,gen_string);
        end;
	set_attrib(32,1);
  j := 0;
  pause := true;
repeat
  j := j + 1;
  if smooth then
  begin
    pix := (32767 div y_pixels) + 10;
    for k:=1 to ((y_pixels+1) div 25) do
    begin
 	    blat(patch[14]-15000,21100-2*pix,17000,2*pix,patch[14]-15000,8000,0);
	    blat(patch[14]-15000,7900,17000,13200-pix,patch[14]-15000,7900+pix,0);
    end;
  end
  else
  begin
    	pix := 1311;
    	blat(patch[14]-14500,8000,13500,11790,patch[14]-14500,8000+pix,0);
    	blat(patch[14]-14500,19790,13500,pix+200,patch[14]-14500,8000,0);
  end;
  i := ord(getchr);
  if i = 19 then
  begin
	repeat
		inchar := getchr;
	until inchar = chr(3);
  end;
until (i=3) ! (inchar=chr(3));
 pause := false;
end;



procedure copy_by_user;
var
	comm_line: string;
	inchar	: char;
	i	: integer;
begin
	if gotcol=1 then
	begin
	      set_attrib(25,colour[0] ! colour[8]);
	      set_attrib(32,1);
	      set_attrib(23,1);
	      set_attrib(24,1);
	      bar(patch[14]-4700,patch[15]-3200,patch[14]+9000,patch[15]+10000);
	end
	else
	blank_area(patch[14]-4700,patch[15]-3200,patch[14]+9000,patch[15]+10000);
	comm_line := '';
	draw_text(patch[14]-4500,8000,'Dos>');
	input_string(patch[14]-2500,8000,30);
	for i:=1 to length(gen_string) do
	begin
	  if (gen_string[i]>chr(32)) & (gen_string[i]<chr(97)) then comm_line := concat(comm_line,gen_string[i]);
	  if gen_string[i] > chr(96) then comm_line:=concat(comm_line,chr(ord(gen_string[i])-32));
	end;
	put_on_dos_line('  ',0);
	if comm_line='COPYPROFIT.85P.BAK' then write(chr(7));
end;


procedure input_string(x_point,y_point,l : integer);
var
	i : integer;
	s : string;
begin
	i := 0;
	s := '                                           ';
	s[0] := chr(0);
	repeat
		inchar:= getchr;
	if ((length(s)>0) & ((inchar=chr(127)) ! (inchar=chr(8)))) then
		begin
			if gotcol=1 then
			begin
				set_attrib(25 ! col_only,colour[1] ! colour[9]);
				set_attrib(32,1);
				bar(x_point+(i*410),7700,x_point+300+(i*410),8900);
				set_attrib(32,2);
				draw_text(x_point+(i*410),y_point,'_  ');
				s[0] := chr(length(s)-1);
				i := i -1;
				set_attrib(32,1);
			end
			else
			blank_area(x_point+(i*410),7700,x_point+300+(i*410),8900);
			set_attrib(32,2);
			draw_text(x_point+(i*410),y_point,'_  ');
			set_attrib(32,1);
			s[0] := chr(length(s)-1);
			i := i -1;
		end
		else
if (inchar<>chr(127))&(inchar<>chr(8))&(inchar<>chr(13))&(inchar<>chr(0))&(s[0]<chr(25)) then
		begin
			if gotcol=1 then
			begin
				set_attrib(32,1);
				set_attrib(25,colour[0] ! colour[8]);
		bar(x_point+(i+1)*410-50,y_point-200,x_point+i*410+820,y_point+1100);
			end
			else
		blank_area(x_point+(i+1)*410-50,y_point-200,x_point+i*410+820,y_point+1100);
			i := i + 1;
			s[i]:= inchar;
			s[0]:= chr(ord(s[0])+1);
			set_attrib(32,2);
			draw_text(x_point+i*410,y_point,concat(inchar,'_ '));
		end;
		set_attrib(32,1);
	until inchar=chr(13);
	gen_string := s;
end;


procedure show_monitor(x_pos: integer; lines : string);
var
	csx,csy : integer;
begin
	set_attrib(32,1);
	set_attrib(17 ! col_only,colour[3] ! colour[11]);
	csx := sx;
	csy := sy;
	sx := 1;
	sy := 1;
	display_icon(x_pos,15000,5,6900);
	sx := csx;
	sy := csy;
	set_attrib(25 ! col_only,colour[1] ! colour[9]);
	draw_text(x_pos-6000,8000,lines);
end;


procedure blank_monitor(x1,y1,x2,y2 : integer);
begin
	if got_col=1 then
	begin
 		set_attrib(25 ! col_only,colour[0] ! colour[8]);
		set_attrib(23,1);
		set_attrib(24,1);
		bar(x1,y1,x2,y2);
	end
	else
	blank_area(x1,y1,x2,y2);
end;



procedure do_next_proc(proc_to_do : integer);
var
 	i,j,pix : integer;
begin
	pix := 32767 div x_pixels;

     case proc_to_do of
	 1 : show_monitor(24300,'A>DIR');
	 2 : begin
		draw_monitor(25000);
	     	draw_sheet_of_paper;
             end;
	 3 : draw_colour_tabs;
	 4 : begin
		draw_direct_icons;
                wait_for_arrows;
		wait_for_arrows;
	     end;
	 5 : begin
		wipe_out;
		show_monitor(16384,'A>');
	     end;
	 6 : begin
		draw_text(11200,8000,'DIR');
		wait_for_arrows;
		blank_monitor(10000,8000,18000,10000);
		draw_text(10384,8000,'A>');
		draw_monitor(16000);
		wait_for_arrows;
	     end;
	 7 : begin
		blank_monitor(10000,8000,18000,10000);
		draw_text(10400,8000,'A>TYPE EXAMPLE.TXT');
	     end;
	 8 : begin
		type_a_file;
		blank_monitor(10000,8000,23000,21000);
		set_attrib(32,1);
		set_attrib(25 ! col_only,colour[3] ! colour[11]);
		draw_text(10400,8000,'A>DIR');
		draw_monitor(16000);
	     end;
	 9 : begin
		blank_monitor(10000,8000,21000,10000);
		draw_text(10400,8000,'A>ERASE EXAMPLE.TXT');
                delete_a_file;
	     end;
	10 : begin
		blank_monitor(10000,8000,21000,10000);
		draw_text(10400,8000,'A>COPY MYFILE YOURFILE');
       		centre_text(16000,patch[15],1000,'YOURFILE            ',2);
		wait_for_arrows;
	     end;
	11 : begin
		blank_monitor(10000,8000,21000,10000);
		set_attrib(32,2);
		draw_text(10400,8000,'A>RENAME OLDNAME NEWNAME');
		centre_text(17500,patch[11],1000,'NEWNAME  ',2);
		i := 3400;
		repeat
			i := i - pix;
			for j:=0 to 1000 do begin end;
    	blat(12020+i,patch[11]-1000,3700,2000,12020+i-pix,patch[11]-1000,0);
		until i<-600;
	     end;
      end;
end;


procedure ovl5;
var
	i,j : integer;
begin
	text_to_show_next := 12;
	assign_icons;
	arrow_up := false;
	arrow_down := true;
	show_arrows;
	show_text(0,true);
	arrow_enable := true;
        for i := 1 to 11 do
	begin
		do_next_proc(i);
		wait_for_arrows;
		if (got_stopped ! active) then exit;
        end;
	clear_arrows;
	repeat
		i := conin;
	until (got_stopped ! active);
end;
modend.


