        IDENTIFICATION DIVISION.
      *         DATE 28-02-89.
      *         AUTHOR Pete Banks (APRICOT csd) VER 1.02
      *          AUTOMATIC RECORD LOCKING VERSION.
      *          This is a dealer database phone logging 
      *          program with multiuser support
      *          this program is to READ DATAFILE AND PRODUCE A LINE
      *          SEQUENTIAL FILE WHICH IS READ BY A PROGRAM WRITTEN BY
      *          Paul Hirons which will go into the new database written
      *          in dBase.
      *          1.01 MODIFIED TO INSERT COMMAS.
      *          1.02 modified to work having lost original source.
         PROGRAM-ID. EXTRACT.
         INSTALLATION.
         DATE-WRITTEN. 27-10-88.
         SECURITY.

         ENVIRONMENT DIVISION.
         CONFIGURATION SECTION.
         SOURCE-COMPUTER. APRICOT.
         OBJECT-COMPUTER. APRICOT.
         SPECIAL-NAMES.
                CONSOLE IS CRT.
         INPUT-OUTPUT SECTION.

         FILE-CONTROL.
           SELECT DEAL-FILE
              ASSIGN TO RANDOM, "DEALER.DAT"
              FILE STATUS IS DEAL-STATUS
              ACCESS MODE IS DYNAMIC
              ORGANIZATION IS INDEXED
                RECORD KEY IS REC-NO
                ALTERNATE RECORD KEY IS ACC-NO WITH DUPLICATES
                ALTERNATE RECORD KEY IS DEALER WITH DUPLICATES
                ALTERNATE RECORD KEY IS COUNTY WITH DUPLICATES
                ALTERNATE RECORD KEY IS TEL-NO WITH DUPLICATES
                ALTERNATE RECORD KEY IS CON-NO WITH DUPLICATES.

                SELECT LI-FILE
                ASSIGN TO OUTPUT, "LIST.TXT"
                FILE STATUS IS LI-STATUS
                ACCESS MODE IS SEQUENTIAL
                ORGANIZATION IS LINE SEQUENTIAL.

       DATA DIVISION.

       FILE SECTION.

        FD  DEAL-FILE
                LABEL RECORDS ARE STANDARD.

        01 DEAL-RECORD.
                05 DEAL-KEY.
	                10 REC-NO     PIC X(4).
                05 ACC-NO       	PIC X(9).
                05 DEALER       	PIC X(41).
                05 COUNTY       	PIC X(21).
                05 TEL-NO       	PIC X(16).
		05 CON-NO		PIC X(10).
                05 CALLS        	PIC 9(2)        COMP.
                05 USERS        	PIC 9(2)        COMP.
                05 PC-DIV       	PIC 9(2)        COMP.
                05 CEN-DIV      	PIC 9(2)        COMP.
		05 NOR-DIV		PIC 9(2)	COMP.
                05 REGION     	PIC X.
		05 CLAAS		PIC X.
		05 COMM-ON		PIC X.
                05 L-DATE.
	                10 L-YY       PIC 9(2).
	                10 L-MM       PIC 9(2).
	                10 L-DD       PIC 9(2).
		05 L-TIME.
               		10 L-HH       PIC 9(2).
	                10 L-MI       PIC 9(2).
                05 CON-DATE.
	                10 CON-YY     PIC 9(2).
	                10 CON-MM     PIC 9(2).
	                10 CON-DD     PIC 9(2).
		05 CONTACT1		PIC X(30).
		05 CONTACT2		PIC X(30).
		05 CONTACT3		PIC X(30).
		05 ADDR1		PIC X(50).
		05 ADDR2		PIC X(50).
		05 ADDR3		PIC X(50).
		05 ADDR4		PIC X(50).
		05 ADDR5		PIC X(50).
		05 TELEX		PIC X(16).
		05 FAX			PIC X(16).
		05 CLAAS1		PIC X(5).
		05 XENIX-SEC		PIC 9(2)	COMP.
                05 FILLER               PIC X(3).

        FD LI-FILE
                LABEL RECORDS ARE STANDARD.
      *
      * Add extra fields in this record so you can get a complete
      * entry for DEAL-RECORD.
      * 

        01 LI-RECORD.
		05 LI-ACC	PIC X(7).
                05 LI-COMMA01   PIC X.
                05 LI-DEALER    PIC X(30).
                05 LI-COMMA02   PIC X.
		05 LI-ADDR1     PIC X(25).
                05 LI-COMMA03   PIC X.
		05 LI-ADDR2     PIC X(25).
                05 LI-COMMA04   PIC X.
		05 LI-ADDR3     PIC X(25).
                05 LI-COMMA05   PIC X.
		05 LI-ADDR4     PIC X(25).
                05 LI-COMMA06   PIC X.
		05 LI-ADDR5     PIC X(25).
                05 LI-COMMA07   PIC X.
                05 LI-CONT1     PIC X(20).
                05 LI-COMMA08   PIC X.
                05 LI-CONT2     PIC X(20).
                05 LI-COMMA09   PIC X.
                05 LI-CONT3     PIC X(20).
                05 LI-COMMA10   PIC X.
               	05 LI-TEL       PIC X(15).
                05 LI-COMMA11   PIC X.
                05 LI-TELEX     PIC X(15).
                05 LI-COMMA12   PIC X.
                05 LI-FAX       PIC X(15).
                05 LI-COMMA13   PIC X.
                05 LI-CON-NO    PIC X(4).
                05 LI-COMMA14   PIC X.
                05 LI-CON-DATE.
	                10 LI-CON-MM     PIC 9(2).
	                10 LI-CON-DD     PIC 9(2).
	                10 LI-CON-YY     PIC 9(2).
                05 LI-COMMA15   PIC X.
 		05 LI-CLAAS1    pic x(5).


       WORKING-STORAGE SECTION.

       01  WORK-FIELDS.
                05 DEAL-STATUS  PIC XX          VALUE SPACE.
		05 INFO-STATUS	PIC XX		VALUE SPACE.
		05 MC-STATUS	PIC XX		VALUE SPACE.
                05 WS-CALLS     PIC 9(2)        VALUE ZERO.
                05 WS-USERS     PIC 9(2)        VALUE ZERO.
                05 ANY-CHAR     PIC X           VALUE SPACE.
                05 DL-STATUS    PIC XX          VALUE SPACE.
                05 NO-STATUS    PIC XX          VALUE SPACE.
                05 LI-STATUS    PIC XX          VALUE SPACE.
                05 SP           PIC X           VALUE "/".
        01 SCRN1.
                02 BANNER               PIC X(28)
                        VALUE "Apricot Phone Logging System".

        PROCEDURE DIVISION.
        DECLARATIVES.
        IO-ERROR SECTION.
                USE AFTER STANDARD ERROR PROCEDURE ON INPUT.
        IO-ERROR-ROUTINE.
        IO-ERROR1 SECTION.
                USE AFTER STANDARD ERROR PROCEDURE ON OUTPUT.
        IO-ERROR-ROUTINE1.
        END DECLARATIVES.

        PROCEDURE-START SECTION.
        OP-FILE.
                MOVE "," TO LI-COMMA01.
                MOVE "," TO LI-COMMA02.
                MOVE "," TO LI-COMMA03.
                MOVE "," TO LI-COMMA04.
                MOVE "," TO LI-COMMA05.
                MOVE "," TO LI-COMMA06.
                MOVE "," TO LI-COMMA07.
                MOVE "," TO LI-COMMA08.
                MOVE "," TO LI-COMMA09.
                MOVE "," TO LI-COMMA10.
                MOVE "," TO LI-COMMA11.
                MOVE "," TO LI-COMMA12.
                MOVE "," TO LI-COMMA13.
                MOVE "," TO LI-COMMA14.
                MOVE "," TO LI-COMMA15.
                OPEN INPUT DEAL-FILE
                IF DEAL-STATUS NOT = "00"
                PERFORM BLANK-SCREEN
                DISPLAY "PROGRAM STOPPED DEAL FILE ERROR." 
                        LINE 10 POSITION 05
                DISPLAY "FILE STATUS IS " LINE 11 POSITION 05
                DISPLAY DEAL-STATUS  LINE 11 POSITION 35
                ACCEPT ANY-CHAR LINE 11 POSITION 50
                CLOSE DEAL-FILE
                STOP RUN.
		GO TO LISTIT.
      *
      * Jump to LISTIT section.
      *

        SHUT-DOWN.
                CLOSE LI-FILE.
                CLOSE DEAL-FILE.
		STOP RUN.
      ****************************************************************
      *                 SCREEN DISPLAY SECTION                       *
      ****************************************************************
        BLANK-SCREEN.
                DISPLAY " " LINE 1 POSITION 1 ERASE.
                DISPLAY SCRN1 LINE 01 POSITION 26 REVERSE LOW.
                DISPLAY "Dealer" LINE 05 POSITION 37 REVERSE LOW.
                DISPLAY "No-Calls" LINE 09 POSITION 36 REVERSE LOW.

        ERROR-TRAP.
                PERFORM BLANK-SCREEN.
                DISPLAY "DEALER.DAT REWRITE GONE WRONG" 
                        LINE 05 POSITION 05.
                DISPLAY "FILE-STATUS IS " LINE 06 POSITION 05.
                DISPLAY  DEAL-STATUS LINE 06 POSITION 35.
                DISPLAY "REC-NO IS " LINE 07 POSITION 05.
                DISPLAY REC-NO LINE 07 POSITION 35.
                ACCEPT ANY-CHAR LINE 07 POSITION 50.
                CLOSE DEAL-FILE.
                STOP RUN.

	LISTIT.
                OPEN OUTPUT LI-FILE WITH LOCK.
                IF LI-STATUS NOT = "00"
                PERFORM BLANK-SCREEN
                DISPLAY "PROGRAM STOPPED NO FILE ERROR." 
                        LINE 10 POSITION 05
                DISPLAY "FILE STATUS IS " LINE 11 POSITION 05
                DISPLAY NO-STATUS  LINE 11 POSITION 35
                ACCEPT ANY-CHAR LINE 11 POSITION 50
                CLOSE DEAL-FILE
		CLOSE LI-FILE
                STOP RUN.

        LI-BIT-BEFORE.
                MOVE SPACES TO ACC-NO.
                START DEAL-FILE KEY IS > ACC-NO
                        INVALID KEY GO TO ERROR-TRAP.

        LI-START-BIT0.
                PERFORM BLANK-SCREEN.

        LI-START-BIT.
                READ DEAL-FILE NEXT RECORD
                        AT END GO TO SHUT-DOWN.
                IF REC-NO = "0000" GO TO LI-START-BIT.
                DISPLAY DEALER LINE 07 POSITION 30.
                MOVE ACC-NO TO LI-ACC.
                MOVE DEALER TO LI-DEALER.
                MOVE ADDR1 TO LI-ADDR1.
                MOVE ADDR2 TO LI-ADDR2.
                MOVE ADDR3 TO LI-ADDR3.
                MOVE ADDR4 TO LI-ADDR4.
                MOVE ADDR5 TO LI-ADDR5.
                MOVE CONTACT1 TO LI-CONT1.
                MOVE CONTACT2 TO LI-CONT2.
                MOVE CONTACT3 TO LI-CONT3.
                MOVE TEL-NO TO LI-TEL.
                MOVE TELEX TO LI-TELEX.
                MOVE FAX TO LI-FAX.
                MOVE CON-NO TO LI-CON-NO.
                MOVE CON-YY TO LI-CON-YY.
                MOVE CON-DD TO LI-CON-DD.
                MOVE CON-MM TO LI-CON-MM.
		MOVE CLAAS1 TO LI-CLAAS1.
      *
      *  Pete you could add extra MOVE statements here for other Fields.
      *  Make sure you extrend LI-RECORD to include all fields out of
      *  DEAL-RECORD !
      *
      *  Add your own routine in for the Site Call out File so it can 
      *  be Written into LI-RECORD.
      *
                WRITE LI-RECORD.
                IF LI-STATUS NOT = "00" GO TO ERROR-TRAP.
                GO TO LI-START-BIT.
