PAGE	50, 132
;************************************************************************
;*									*
;*	EMIBM.ASM							*
;*									*
;*	<C> Apricot Advanced Technology Ltd 1985			*
;*	Initial version  Jonathan Mackenzie 08-06-85			*
;*									*
;*	Version : 1.5.0							*
;*									*
;*	Modification history:						*
;*				15/7/85 num pad + and - keys swapped	*
;*				ver 1.1 issued				*
;*				15/7/85 int F1 and int 29 now not	*
;*				connected. Should be able to run	*
;*				Apricot applications without unload	*
;*				ver 1.2 issued				*
;*				17/7/85 bug in int 17 'report status'	*
;*				fixed. Ver 1.3 issued			*
;*				22/8/85 int 16 func 1 crash fixed	*
;*				ver 1.3.1 issued			*
;*									*
;*		22/9/85							*
;*		Int 14 now correctly sets bit 7 as			*
;*		error code ( bug 318/7 )				*
;*		Also see QA report 318					*
;*		Ver 1.3.2 issued 3/10/85				*
;*		29/10/85						*
;*		Int 16 function 0, return next keypress, now handles	*
;*		the full gem keyboard table for foreign countries	*
;*									*
;*		13/11/85		Afzal Raja                      *
;*		Display NUMLOCK on the microscreen                      *
;*		and toggle the led                                      *
;*                                                                      *
;*		11/12/85		Afzal Raja			*
;*		Changed to run as a SHELL.				*
;*									*
;*		16/12/85						*
;*		added support for 80x25 colour mode			*
;*									*
;*									*
;************************************************************************
;
;==========================================
; SPECIAL SECTION - define linker ordering for .com/exe file
;==========================================
;
PGROUP	GROUP	BASE, PROG, TAIL
DGROUP	GROUP	DATA, STACK
ASSUME	CS:PGROUP
;
;	Force 'pgroup' lower in memory
BASE	SEGMENT	BYTE	PUBLIC	'PROG'
BASE	ENDS
;
;	Define dummy data seg
DATA	SEGMENT	PUBLIC	'DATA'
DATA	ENDS
;
;	Define a noddy stack segment
STACK	SEGMENT	'DATA'
SBASE	DW	128 DUP (?)
STACK	ENDS
;
;	Define noddy prog seg to force tail last in pgroup
PROG	SEGMENT	BYTE	PUBLIC	'PROG'
PROG	ENDS
;
;	Define tail seg to allow calc of end offset
TAIL	SEGMENT	BYTE	'PROG'
LAST	DB	0
TAIL	ENDS
;
;===========================================================================
; END OF SPECIAL SECTION
;===========================================================================
;
;	PROGRAM CODE EQUATES

SCR_DRV		EQU	0ECh
FEATURES	EQU	6
;
PAGE
;===========================================================================
; PROGRAM CODE SECTION
;===========================================================================

PROG	SEGMENT	BYTE	PUBLIC	'PROG'

;=============================================================================
;= emibm
;=============================================================================
;JOB	This is the main EMIBM.EXE routine
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	op-sys calls
;-----------------------------------------------------------------------------
;INPUT		:	CS = code seg
;			DS = psp
;			ES = psp
;			SS = code seg
;OUTPUT		:	'errorlevel' return code is always zero
;ERRORS		:	Displays error messages by screen driver calls.
;REG USE	:	just about everything
;STACK USE	:	SP started at 7FFF if enough room, else memtop
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
ASSUME	CS:PGROUP, DS:DGROUP
PUBLIC	EMIBM
EMIBM	PROC	FAR

	JMP	SHORT	B10			; jump over our signature

		DB	'EMIBM'			; program signature
DS_SAV		DW	0			; saved value of DS
				; Set up the runtime environment
B10:	CLI					; stop interrupts
	MOV	AX, DGROUP
	MOV	DS, AX				; set the DS reg
	MOV	SS, AX				; likewise for SS

	MOV	AX, OFFSET PGROUP:LAST		; offset of last byte
	ADD	AX, 16				; add 16 bytes
	MOV	CL, 4				; round down to paras
	SHR	AX, CL				; no. of paras in pgroup
	MOV	BX, CS				; get ready for the maths
	ADD	AX, BX				; base of dgroup = CS + proglen

	MOV	BX, ES:2			; para size of alloc blk
	SUB	BX, AX				; subtract what we've used
	TEST	BX, 0F700h			; more than 32K avail ?
	JNZ	B20				; yes, jump
	MOV	CL, 4				; no, xlat paras to bytes
	SHL	BX, CL				; highest avail byte for SP
	JMP	SHORT	B30			;
B20:	MOV	BX, 7FF0h			; set a 32 k data seg
B30:	MOV	SP, BX				; init stack pointer
	STI					; .. now we can be stopped
				; place psp address in int 10 handler
	MOV	AX, ES				; es to ax
	MOV	CS:PSPADDR, AX			; and save it
				; save the value of this DS
	MOV	AX, DS				; ds to ax
	MOV	CS:DS_SAV, AX			; .. and save it
				; analyze command line parms
	CALL	CHK_PARMS			; check cmnd line parms
	MOV	DS:COM_PARM, AL			; store result code
	CMP	AL, 1				; no parms ?
	JA	B40				; no, try next option
	JMP	B110				; yes, go do rest of load
B40:	CMP	AL, 3				; or 'verbose' typed ?
	JNZ	B50				; no, try next option
	JMP	B110				; yes, do rest of load
B50:	CMP	AL, 2				; was 'no' typed ?
	JNZ	B60				; no, that's it for now
	JMP	B100				; yes, try and unload
B60:				; arrive here through incorrect usage
	MOV	DX, OFFSET DGROUP: HD$		; version header
	CALL	PRT_MSG				; print it
	MOV	DX, OFFSET DGROUP: US$		; 'wrong usage' message
	CALL	PRT_MSG				; print it
	JMP	B1999				; and exit saving nothing
B100:				; 'no' handler ( unload )
	CALL	UNLOAD				;
	JMP	B1999				; and quit
B110:				; continue here for load / verbose
				; verbose option is for the moment ignored - it
				; is meant to print out the level of support the
				; emulator will give to an IBM application.

				; check to see we are not already loaded
	CALL	CHK_LOAD			; inspect int 10h vector code
	CMP	AX, 0				; is nothing there ?
	JZ	B120				; nothing, continue
	MOV	DX, OFFSET DGROUP: HD$		; else, 'emibm error'
	CALL	PRT_MSG				; print it
	MOV	DX, OFFSET DGROUP: IN$		; 'already here'
	CALL	PRT_MSG				; print it
	JMP	B1999				; terminate completely

B120:				; ... CHECK THE BIOS VERSION NUMBER !!!!!
				; ( early bios's don't support RS232 errs )

				; establish screen format structure pointers
	MOV	CL, 0				; 'format enquiry' code
	MOV	CH, 0				; screen id always 0 ?
	MOV	DL, 2				; extended format request
	INT	SCR_DRV				; call int ECh
	MOV	DS:FTAB_SEG, DX			; seg addr of format struc
	MOV	DS:FTAB_OFFS, SI		; offs addr of format struc
				; reset screen ( for int 10 handler )
	MOV	CL, 1				; 'enable screen' code
	MOV	CH, 0				; screen id
	MOV	BL, 0				; format number
	MOV	BH, 01				; primary font, IBM mono
	MOV	DS:MODE,BH
	INC	DS:MODE
	MOV	DX, 0				; set virtual image address
	MOV	SI, 0				; = 0:0 ( use default )
	INT	SCR_DRV				; do it
	MOV	DS:IMAGE_ID, DX			; save image id
	MOV	DI,DX
	MOV	DX,DS
	MOV	SI,OFFSET DGROUP:PALET
	MOV	AX,0101H
	MOV	CX,0FH
	INT	SCR_DRV
				; print the sign-on message
	MOV	DX, OFFSET DGROUP: HD$		;
	CALL	PRT_MSG				;
	MOV	DX, OFFSET DGROUP: HI$		;
	CALL	PRT_MSG				;
				; kill cursor positioning by the int F1 handler
	MOV	AL, 27				; 'ESC'
	INT	0F1h				;
	MOV	AL, 'x'				; 'x'
	INT	0F1h				;
	MOV	AL, '5'				; '5'
	INT	0F1h				;
				; set bios kbd drvr into mode locking
	MOV	BX, 32h				; 'keyboard' code
	MOV	CX, 10h				; mode locking
	MOV	DX, 1				; turn it on
	INT	0FCh				; call the bios
				; connect the int 10h vector
	MOV	DI, OFFSET PGROUP: INT10_SAV	; point to vector storage
	MOV	AL, 10h				; vector number to get
	MOV	DX, OFFSET PGROUP: INT_10	; DS:DX = addr int_10
	CALL	CON_VEC				;
				; connect the int 14h vector
	MOV	DI, OFFSET PGROUP: INT14_SAV	;
	MOV	AL, 14h				;
	MOV	DX, OFFSET PGROUP: INT_14	;
	CALL	CON_VEC				;
				; connect the int 16h vector
	MOV	DI, OFFSET PGROUP: INT16_SAV	; point to vector storage
	MOV	AL, 16h				; vector number to get
	MOV	DX, OFFSET PGROUP: INT_16	; DS:DX = addr int_16
	CALL	CON_VEC				;
				; connect the int 17h vector
	MOV	DI, OFFSET PGROUP: INT17_SAV	; point to vector storage
	MOV	AL, 17h				; vector number to get
	MOV	DX, OFFSET PGROUP: INT_17	; DS:DX = addr int_17
	CALL	CON_VEC				;
				; connect the int 1Ah vector
	MOV	DI, OFFSET PGROUP: INT1A_SAV	;
	MOV	AL, 1Ah				;
	MOV	DX, OFFSET PGROUP: INT_1A	;
	CALL	CON_VEC				;
				; connect the int 29h routine
	MOV	DI, OFFSET PGROUP: INT29_SAV	;
	MOV	AL, 29h				;
	MOV	DX, OFFSET PGROUP: INT_29	;
;IGC;	CALL	CON_VEC				;
				; connect the int E6 vector
	MOV	DI, OFFSET PGROUP: INTE6_SAV	; point to vector storage
	MOV	AL, 0E6h			; vector number to get
	MOV	DX, OFFSET PGROUP: INT_E6	; DS:DX = addr int_E6
	CALL	CON_VEC				;
				; connect the int F1 routine
	MOV	DI, OFFSET PGROUP: INTF1_SAV	;
	MOV	AL, 0F1h			;
	MOV	DX, OFFSET PGROUP: INT_F1	;
	CALL	CON_VEC				;
				; connect the int F9h vector
	MOV	DI, OFFSET PGROUP: INTF9_SAV	; point to vector storage
	MOV	AL, 0F9h			; vector number to get
	MOV	DX, OFFSET PGROUP: INT_F9	; DS:DX = addr int_F9
	CALL	CON_VEC				;
				; connect the int FCh vector
	MOV	DI, OFFSET PGROUP: INTFC_SAV	; point to vector storage
	MOV	AL, 0FCh			; vector number to get
	MOV	DX, OFFSET PGROUP: INT_FC	; DS:DX = addr int_FC
	CALL	CON_VEC				;
				; connect the int FFh vector
	MOV	DI, OFFSET PGROUP: INTFF_SAV	; point to vector storage
	MOV	AL, 0FFh			; vector number to get
	MOV	DX, OFFSET PGROUP: INT_FF	; DS:DX = addr int_FF
	CALL	CON_VEC				;

	XOR	AX, AX				;
	MOV	ES, AX				; set ES = 0

				; REVECTOR THE KEYBOARD TABLE POINTER
	MOV	AX,ES:[712H]			; GET CURRENT KEYBOARD OFFSET
	MOV	CS:KEY_OFSET,AX
	MOV	AX,ES:[714H]			; GET SEGMENT
	MOV	CS:KEY_SEG,AX
	MOV	AX,OFFSET DGROUP:IBMKEY
	MOV	ES:[712H],AX
	MOV	ES:[714H],DS
				; Checkout the machine type. This is a good point
				; to do machine specific initialisation, so the next
				; bit is the long way round to cope with expasnsion.
	MOV	AL, ES:[401h]			; get the machine type byte
	CMP	AL, 3				; is it a XEN ?
	JNZ	B130				; no, default then
	MOV	WORD PTR DS:[TIMEOUT], 19	; set RS232 timeout counter for XEN
	JMP	SHORT B200			;

B130:
	MOV	WORD PTR DS:[TIMEOUT], 9	; set RS232 timeout couter for lesser beasts

B200:				; Save the CNF_s_bioserr byte ( for serial comms )
	MOV	DI, ES:[700h]			; ptr offs to DI
	MOV	BX, ES:[702h]			; ptr seg to BX
	MOV	ES, BX				; ES:DI -> bios config table
	MOV	AL, ES:[DI+42h]			; AL = CNF_s_bioserr
	MOV	CS:[CNF_S_BIOS], AL		; save it
				; set up the sound driver for int 10 handler
	MOV	BX, 38h				; control device code
	MOV	CX, 0				; init sound driver
	INT	0FCh				; do it
				; set the initial cursor position to 23,0
	MOV	AX, 1700h			;
	MOV	DS:C_ROWY, AH			;
	MOV	DS:C_COLX, AL			;
	MOV	CS:INT16_FLAG,0
	MOV	CS:SCAN_CODE,0
	MOV	CS:SCAN_FLAG,0
				; Display NUMLOCK on the microscreen
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,1BH				; an escape
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,'H'				; an escape H
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,'N'				; 
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,'U'				; 
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,'M'				; 
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,1BH				; an escape
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,89				; an escape Y
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,0				; 
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,48H				; cursor position
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,'L'				; 
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,'O'				; an escape
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,'C'				; 
	INT	0FCH
	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	MOV	DX,'K'				; an escape
	INT	0FCH
					; Light the LED
;	MOV	BX,33H				; microscreen
;	MOV	CX,1				; print char
;	MOV	DX,1BH				; an escape
;	INT	0FCH
;	MOV	BX,33H				; microscreen
;	MOV	CX,1				; print char
;	MOV	DX,'/'				; an escape /
;	INT	0FCH
;	MOV	BX,33H				; microscreen
;	MOV	CX,1				; print char
;	MOV	DX,41H				; 
;	INT	0FCH
				; terminate & stay resident exit point
	MOV	AX, OFFSET DGROUP: ENDBYTE	; highest DS offset
	MOV	CL, 4				; bits to shift
	SHR	AX, CL				; conv to paras
	INC	AX				; plus one for safety
	MOV	DX, DS				; get data segment addr
	ADD	DX, AX				; add length in paras
	MOV	BX, CS:PSPADDR			; lowest seg addr of code
	SUB	DX, BX				; len = end-start ( in paras )
	CMP	DS:COM_PARM,0			; Any parms
	JNE	TERMI_NATE			; No
	PUSH	BX
	PUSH	DX
	MOV	ES,BX
	MOV	BX,DX
	MOV	AH,4AH
	INT	21H
	POP	DX
	POP	BX
	JC	DISP_EROR
	MOV	DX,OFFSET DGROUP:PATH_NAME	; Get path name address
	MOV	DS:SEG1,BX
	MOV	DS:SEG2,BX
	MOV	DS:SEG3,BX
	MOV	BX,DS
	MOV	ES,BX
	MOV	BX,OFFSET DGROUP:PARMS_BLOCK
	MOV	AX,4B00h
	INT	21H
	JNC	DONE_IT
	CMP	AL,2
	JNE	DISP_EROR
				; TRY AN EXE FILE
	MOV	SI,OFFSET DGROUP:PATH_NAME
	MOV	CL,DS:PATH_LENTH
	XOR	CH,CH
	ADD	SI,CX
	MOV	BYTE PTR [SI],'E'
	INC	SI
	MOV	BYTE PTR [SI],'X'
	INC	SI
	MOV	BYTE PTR [SI],'E'
	MOV	BX,DS
	MOV	ES,BX
	MOV	DX,OFFSET DGROUP:PATH_NAME	; Get path name address
	MOV	BX,OFFSET DGROUP:PARMS_BLOCK
	MOV	AX,4B00h
	INT	21H
	JNC	DONE_IT
DISP_EROR:
	MOV	DX,OFFSET DGROUP:FILE_EROR
	CMP	AL,2
	JE	DISPIT
	MOV	DX,OFFSET DGROUP:OTHER_EROR
DISPIT:
	CALL	PRT_MSG
	MOV	DX,OFFSET DGROUP:OTHER_HALF
	CALL	PRT_MSG
DONE_IT:
	CALL	UNLOAD
	JMP	SHORT B1999
TERMI_NATE:
	MOV	AH, 31h				; 'keep process' code
	MOV	AL, 0				; errorlevel = 0
	INT	21h				; au revior........

;======================= debug exit point ========================
; exit leaving binary value in AL as a char on the screen for
; debug purposes. Not normally used.
B999:
	MOV	DL, AL
	ADD	DL, 30h		; conv to printable
	MOV	AH, 2		; temp. print
	INT	21h
;===================  terminate non-resident exit point  ====================
B1999:
	MOV	AL, 0
	MOV	AH, 4Ch				; terminate completely
	INT	21h

EMIBM	ENDP
PAGE
;=============================================================================
;= int_10
;=============================================================================
;JOB		int_10 - interrupt handler for int 10h
;ACTION		
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:
;OUTPUT		:
;ERRORS		:	In this initial implementation, there is no facility
;			to switch active display pages. All calls referencing
;			a display page other than zero ( default ) will
;			be pointed to the default page.
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_10
INT_10	PROC	NEAR
;=========  INT 10H INTERRUPT ROUTINE ENTRY POINT HERE =================

	JMP	SHORT	IT10

		; *** NOTE ***
		; THe following data area is information needed by a second
		; invocation of EMIBM to be able to unload the previous
		; copy from memory. If altering this data structure be
		; sure to check the routines that connect and disconnect
		; the int 10 vector.

		DB	'EMIBM'			; this prog signature
PSPADDR		DW	0			; saved value of psp segment
INT10_SAV	DD	0			; old vector save
CNF_S_BIOS	DB	0			; save value of CNF_s_bioserr
KEY_OFSET	DW	0
KEY_SEG		DW	0
;************** JUMP TABLE  ********************
;
JMP_TAB	DW	IT1400				; set mode
	DW	IT1000				; set cursor
	DW	IT300				; set cursor position
	DW	IT900				; read cursor position
	DW	IT7999				; 
	DW	IT1300				; select page
	DW	IT600				; scroll page up
	DW	IT700				; scroll page down
	DW	IT800				; read attrib/char
	DW	IT500				; write attrib/char
	DW	IT200				; write char
	DW	IT1200				; set pallette
	DW	IT7999				;
	DW	IT7999				;
	DW	IT400				; write tty
	DW	IT1100				; current video state
;************************************************
IT10:				; analyse value in AH ( callers code )
	CMP	AH, 15				; check boundry
	JBE	IT20
	JMP	IT7999
IT20:
				; save registers
	PUSH	ES
	PUSH	DS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	AX
	MOV	AL,AH
	XOR	AH,AH
	SHL	AX,1
	MOV	SI,AX
	POP	AX
	JMP	WORD PTR CS:JMP_TAB[SI]
;================================================
IT200:				; AH = 10, write char at current curpos
				; BH = display page
				; CX = count of chars to write
				; AL = char to write
				; this handler tested 26/6/85 jon
				; first, save all registers
				; recover DS, save int 10 call parms
	MOV	DS, CS:DS_SAV			; address our data segment
	MOV	DS:TEMP1, CX			; save char count in TEMP1
	MOV	DS:TEMP2, AX			; save char to write in TEMP2
				; turn the cursor off
	MOV	CL, 0Eh				; 'cursor off' code
	MOV	CH, 0				; screen i.d.
	MOV	DI, DS:IMAGE_ID			; image i.d. to DI
	INT	SCR_DRV				; and turn the cursor off
				; find & copy the current cursor position
	MOV	AH, DS:C_ROWY			; cursor y co-ord
	MOV	AL, DS:C_COLX			; cursor x co-ord
IT210:	MOV	DS:TEMP3, AX			; save curpos in TEMP3
				; read char & attribs at x,y ( AL,AH )
	MOV	CX, 0006			; CH=0, CL=6 (scrn id, rd char)
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	INT	SCR_DRV				; and read the character
				; write new char with old attribs
	MOV	DX, AX				; DH=attribs, DL=char ( read )
	MOV	AX, DS:TEMP2			; retrive write char
	MOV	DL, AL				; old attribs, new char in DX
	MOV	AX, DS:TEMP3			; cursor position to AX
	MOV	CX, 0004			; CH=0,CL=4 (scrn id, wrt chr )
	MOV	SI, 0				; point to default font
	MOV	DI, DS:IMAGE_ID			; image i.d. to DI
	INT	SCR_DRV				; write the char
				; check for a multi-char call and increase
				; x-y to point to next cell if needed
	DEC	DS:TEMP1			; reduce character count
	JZ	IT230				; if it's zero, we quit
	MOV	AX, TEMP3			; retrive char x-y position
	INC	AL				; bump the column (x)
	CMP	AL, 80				; off the edge ?
	JL	IT220				; no, put next char there
	MOV	AL, 0				; else reset col to zero
	INC	AH				; and bump the row
	CMP	AH, 25				; off the bottom ?
	JL	IT220				; no, next char can go there
	MOV	AH, 0				; else row (y) reset to zero
IT220:	JMP	IT210				; loop back to print next char
IT230:				; all finished, turn the cursor back on at
				; the original position ( this call may have
				; printed a string but will not update the
				; cursor x,y co-ordinates )
	MOV	CL, 0Dh				; 'cursor on' code
	MOV	CH, 0				; screen i.d. is zero
	MOV	AH, DS:C_ROWY			; set ORIGINAL y co-ord
	MOV	AL, DS:C_COLX			; set ORIGINAL x co-ord
	MOV	DI, DS:IMAGE_ID			; DI = image i.d.
	INT	SCR_DRV				; turn the cursor back on
				; dropthru to pop reg's & exit
	JMP	IT7999				;
;================================================
IT300:				; AH = 2, set cursor position
				; DH, DL = row, column ( 0,0 = upper left )
				; BH = display page
				; this handler tested 25/6/85 jon.
	MOV	DS, CS:DS_SAV			; restore our DS
	CMP	DH, 25				; is row 0-24 ?
	JL	IT310				; yes, continue
	MOV	DH, 24				; no, set 24 as max
IT310:	CMP	DL, 80				; is col 0-79 ?
	JL	IT320				; yes, continue
	MOV	DL, 79				; no, set 79 as max
IT320:
	MOV	DS:C_ROWY, DH			; save this as last known ..
	MOV	DS:C_COLX, DL			; .. cursor position
	MOV	CX, 000Eh			; scrn id, cursor off
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	PUSH	DX				; DX trashed by next call !
	PUSH	DI				; save image id
	INT	SCR_DRV				; call int EC to turn curs off
	POP	DI				; recover image id
	POP	AX				; AH,AL = row, col
	MOV	CX, 000Dh			; scrn id, cursor on
	INT	SCR_DRV				; call int EC to turn cursor
	JMP	IT7999				;
;================================================
IT400:				; AH = 14, write tty
				; AL = char to write
				; BH = display page
				; this handler tested 1/7/85 jon
	MOV	DS, CS:DS_SAV			;
				; store the passed vars
	MOV	DS:TEMP1, AX			; save char to write
	MOV	DS:TEMP2, BX			; save the display page
				; check for a bell
	CMP	AL, 7				; was it a bell ?
	JNZ	IT405				; nope, try next
	MOV	BX, 38h				; sound generator code
	MOV	CX, 9				; 'bell'
	INT	0FCh				; sound the bell
	JMP	IT495				; and exit
IT405:				; all others affect cursor, so kill it
	MOV	CX, 000Eh			; 'cursor off' code, scrn i.d.
	MOV	DI, DS:IMAGE_ID			; image i.d.
	INT	SCR_DRV				; turn the cursor off
	MOV	AX, DS:TEMP1			; and recover the char (AL)
				; check for a carriage return
	CMP	AL, 0Dh				; was it a cr ?
	JA	IT435				; above means must be printable
	JNZ	IT410				; no, try next
	MOV	DS:C_COLX, 0			; yep, set cursor to col 0
	JMP	IT490				; & quit through cursor rewrite
IT410:				; check for a backspace
	CMP	AL, 8				; was it a backspace ?
	JNZ	IT425				; nope, try next
	CMP	DS:C_COLX, 0			; already at col zero ?
	JNZ	IT420				; no, do a backspace
	JMP	IT490				; yes, cursor rewrite & quit
IT420:	DEC	DS:C_COLX			; move cursor back 1
	JMP	IT490				; exit thru cursor on
IT425:				; check for a linefeed
	CMP	AL, 0Ah				; was it lf ?
	JNZ	IT435				; no, try next
	INC	DS:C_ROWY			; bump row number
	JMP	IT440				; exit thru scroll check
IT435:				; handle all else as normal chars
	MOV	AH, DS:C_ROWY			; cursor y co-ord
	MOV	AL, DS:C_COLX			; cursor x co-ord
	MOV	CX, 0006			; CH=0, CL=6 (scrn id, rd char)
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	INT	SCR_DRV				; and read the character
				; give old attributes new char
	MOV	BX, DS:TEMP1			; get char to write (BL)
	MOV	AL, BL				; combine with old attribs
				; write out new char at current curpos
	MOV	DX, AX				; DH=attribs, DL=char
	MOV	AH, DS:C_ROWY			; get cursor row
	MOV	AL, DS:C_COLX			; .. and column
	MOV	CX, 0004			; CH=0,CL=4 (scrn id, wrt chr )
	MOV	SI, 0				; point to default font
	MOV	DI, DS:IMAGE_ID			; image i.d. to DI
	INT	SCR_DRV				; write the char
				; update cursor x,y to new position
	INC	DS:C_COLX			; increment column count
	CMP	DS:C_COLX, 80			; off rh edge ?
	JL	IT490				; no, that's it then
	MOV	DS:C_COLX, 0			; else new col is zero
	INC	DS:C_ROWY			; bump the row count
IT440:	CMP	DS:C_ROWY, 24			; off bottom of screen ?
	JL	IT490				; no, exit then
	MOV	DS:C_ROWY, 23			; else new row is 23
				; read attribute for new blank line
	MOV	CX, 0006h			; scrn id, read char
	MOV	AX, 174Fh			; from row 23 col 79
	MOV	DI, DS:IMAGE_ID			; image id
	INT	SCR_DRV				;
				; scroll the screen up
	MOV	CL, 0Ah				; ..and dropthru to scroll
	MOV	CH, 0				; screen up
	MOV	DX, AX				; recover attributes for blank
	MOV	DL, 0				; line
	MOV	SI, 0				;
	MOV	DI, DS:IMAGE_ID			;
	INT	SCR_DRV				; scroll the screen up
IT490:				; print cursor at new position
	MOV	CL, 0Dh				;
	MOV	CH, 0				;
	MOV	AH, DS:C_ROWY			;
	MOV	AL, DS:C_COLX			;
	MOV	DI, DS:IMAGE_ID			;
	INT	SCR_DRV				;
IT495:				; last exit point here
	JMP	IT7999				;
;================================================
IT500:				; AH = 9, write attr/char at cursor pos
				; BH = display page
				; CX = count of chars to write
				; AL = char to write
				; BL = attributes
				; this handler tested 27/6/85 jon
	MOV	DS, CS:DS_SAV			; address our data segment
	MOV	DS:TEMP1, CX			; save char count in TEMP1
	MOV	CH, BL				; attributes to CH
	MOV	CL, AL				; char to CL
	MOV	DS:TEMP2, CX			; save attribs/char in TEMP2
				; turn the cursor off
	MOV	CX, 000Eh			; scrn id, cursor off
	MOV	DI, DS:IMAGE_ID			; image i.d. to DI
	INT	SCR_DRV				; and turn the cursor off
				; find & copy the current cursor position
	MOV	AH, DS:C_ROWY			; cursor y co-ord
	MOV	AL, DS:C_COLX			; cursor x co-ord
IT510:	MOV	DS:TEMP3, AX			; save curpos in TEMP3
				; write out the char/attribs
	MOV	CX, 0004			; scrn id, write char/attribs
	MOV	DX, DS:TEMP2			; recover char/attribs
	MOV	SI, 0				; point to default font
	MOV	DI, DS:IMAGE_ID			; image i.d. to SI
	INT	SCR_DRV				; write char/attributes
				; check for a multi-char call and increase
				; x-y to point to next cell if needed
	DEC	DS:TEMP1			; reduce character count
	JZ	IT530				; if it's zero, we quit
	MOV	AX, TEMP3			; retrive char x-y position
	INC	AL				; bump the column (x)
	CMP	AL, 80				; off the edge ?
	JL	IT520				; no, put next char there
	MOV	AL, 0				; else reset col to zero
	INC	AH				; and bump the row
	CMP	AH, 25				; off the bottom ?
	JL	IT520				; no, next char can go there
	MOV	AH, 0				; else row (y) reset to zero
IT520:	JMP	IT510				; loop back to print next char
IT530:				; all finished, turn the cursor back on at
				; the original position ( this call may have
				; printed a string but will not update the
				; cursor x,y co-ordinates )
	MOV	CX, 000Dh			; scrn id, cursor on
	MOV	AH, DS:C_ROWY			; set ORIGINAL y co-ord
	MOV	AL, DS:C_COLX			; set ORIGINAL x co-ord
	MOV	DI, DS:IMAGE_ID			; DI = image i.d.
	INT	SCR_DRV				; turn the cursor back on
				; dropthru to pop reg's & exit
	JMP	IT7999				;
;================================================
IT600:				; AH = 6, scroll active page up
				; AL = number of lines ( 0 = blank window )
				; CH,CL=row,col upper lh corner of scroll
				; DH,DL=row,col lower rh corner of scroll
				; BH = attribute to be used on blank line
				; this handler tested 1/7/85 jon
	MOV	DS, CS:DS_SAV
				; save caller's parms
	XOR	AH, AH				; set call code to zero
	MOV	DS:TEMP1, AX			; save no. of lines (AL)
	MOV	DS:TEMP2, BX			; save new blank line atr (BH)
				; validate upper l.h. co-ordinates
	CMP	CH, 25				;
	JL	IT601				;
	MOV	CH, 24				;
IT601:	CMP	CL, 80				;
	JL	IT602				;
	JMP	IT7999				; IGC 11/7/86
	MOV	CL, 79				;
IT602:				; validate lower r.h. co-ordinates
	CMP	DH, 25				;
	JL	IT603				;
	MOV	DH, 24				;
IT603:	CMP	DL, 80				;
	JL	IT604				;
	MOV	DL, 79				;
				; save the scroll co-ordinates
IT604:	MOV	DS:TEMP3, CX			; upper l.h. row(CH), col (CL)
	MOV	DS:TEMP4, DX			; lower r.h. row(DH), col (DL)
				; turn the cursor off
	MOV	CL, 0Eh				; 'cursor off' code
	MOV	CH, 0				; screen i.d.
	MOV	DI, DS:IMAGE_ID			; image id to DI
	INT	SCR_DRV				; turn the cursor off
				; decide whether to blank or scroll window
	MOV	AX, DS:TEMP1			; recover no. of lines
	CMP	AL, 0				; clear whole window ?
	JZ	IT610				; yes, just a 'smear' call
	JMP	IT680				; no, do a block move
IT610:				; clear the window with a 'smear'
	MOV	CL, 8				; 'smear block' code
	MOV	CH, 0				; screen i.d. is 0
	MOV	DX, DS:TEMP2			; DH = attribs of area
	MOV	DL, ' '				; DL = fill char ( space )
	MOV	AX, DS:TEMP3			; top lh co-ords
	MOV	BX, DS:TEMP4			; bot rh co-ords
	MOV	SI, 0				; use default font
	MOV	DI, DS:IMAGE_ID			; set the image id
;IGC;	INT	SCR_DRV				; smear that block
	JMP	IT690				; and exit
IT680:				; set up parms for block move call
	MOV	AX, DS:TEMP3			; top left hand col in AL
	MOV	DX, DS:TEMP4			; bottom r.h. col in DL
	SUB	DL, AL				; width = r.h. - l.h.
	INC	DL				; treat int EC x extent as base 1
	SUB	DH, AH				; height = bottom - top
	CMP	DH,0
	JE	SMR_LINE
	MOV	BX, DS:TEMP3			; top l.h. co-ords to BX
	MOV	AX, BX				; .. and to AX
	INC	AH				; source is 1 row below dest
	MOV	CL, 0Bh				; 'move block' code
	MOV	CH, 0				; screen i.d.
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	INT	SCR_DRV				; move that block
SMR_LINE:			; 'smear' the bottom line of block
	MOV	CL, 08h				; 'smear block' code
	MOV	CH, 0				; screen i.d.
	MOV	DX, DS:TEMP2			; retrive attributes
	MOV	DL, ' '				; char is a space
	MOV	AX, DS:TEMP3			; retrive top l.h. co-ords
	MOV	BX, DS:TEMP4			; retrive bot. r.h. co-ords
	MOV	AH, BH				; start row = finish row
	MOV	SI, 0				; point to default font
	MOV	DI, DS:IMAGE_ID			; set the image id
	INT	SCR_DRV				; smear bot line of scrld block
				; try for a loop count
	DEC	DS:TEMP1			; decrement the loop count
	JZ	IT690				; if zero quit
	JMP	IT680				; else loop around
IT690:
				; turn the cursor back on again
	MOV	CL, 0Dh				; 'cursor on' code
	MOV	CH, 0				; screen id
	MOV	AH, DS:C_ROWY			; set 'y' co-ord
	MOV	AL, DS:C_COLX			; set 'x' co-ord
	MOV	DI, DS:IMAGE_ID			; set image i.d.
	INT	SCR_DRV				; turn cusor back on
	JMP	IT7999				;
;================================================
IT700:				; AH = 7, scroll active page down
				; AL = no of lines ( 0 = blank window )
				; CH,CL=row,col upper lh corner of scroll
				; DH,DL=row,col lower rh corner of scroll
				; BH = attribute to be used on blank line
				; this handler tested 1/7/85 jon
	MOV	DS, CS:DS_SAV
				; save caller's parms
	XOR	AH, AH				; set call code to zero
	MOV	DS:TEMP1, AX			; save no. of lines (AL)
	MOV	DS:TEMP2, BX			; save new blank line atr (BH)
				; validate upper l.h. co-ordinates
	CMP	CH, 25				;
	JL	IT701				;
	MOV	CH, 24				;
IT701:	CMP	CL, 80				;
	JL	IT702				;
	MOV	CL, 79				;
IT702:				; validate lower r.h. co-ordinates
	CMP	DH, 25				;
	JL	IT703				;
	MOV	DH, 24				;
IT703:	CMP	DL, 80				;
	JL	IT704				;
	MOV	DL, 79				;
IT704:				; save the scroll co-ordinates
	MOV	DS:TEMP3, CX			; upper l.h. row(CH), col (CL)
	MOV	DS:TEMP4, DX			; lower r.h. row(DH), col (DL)
				; turn the cursor off
	MOV	CL, 0Eh				; 'cursor off' code
	MOV	CH, 0				; screen i.d.
	MOV	DI, DS:IMAGE_ID			; image id to DI
	INT	SCR_DRV				; turn the cursor off
				; decide whether to blank or scroll window
	MOV	AX, DS:TEMP1			; recover no. of lines
	CMP	AL, 0				; clear whole window ?
	JZ	IT710				; yes, just a 'smear' call
	JMP	IT780				; no, do a block move
IT710:				; clear the window with a 'smear'
	MOV	CL, 8				; 'smear block' code
	MOV	CH, 0				; screen i.d. is 0
	MOV	DX, DS:TEMP2			; DH = attribs of area
	MOV	DL, ' '				; DL = fill char ( space )
	MOV	AX, DS:TEMP3			; top lh co-ords
	MOV	BX, DS:TEMP4			; bot rh co-ords
	MOV	SI, 0				; use default font
	MOV	DI, DS:IMAGE_ID			; set the image id
	INT	SCR_DRV				; smear that block
	JMP	IT690				; and exit
IT780:				; set up parms for block move call
	MOV	AX, DS:TEMP3			; top left hand col in AL
	MOV	DX, DS:TEMP4			; bottom r.h. col in DL
	SUB	DL, AL				; width = r.h. - l.h.
	INC	DL				; make int EC x extent base 1
	SUB	DH, AH				; height = bottom - top
	CMP	DH,0
	JE	SMEAR_LINE
	MOV	BX, DS:TEMP3			; top l.h. co-ords to BX
	MOV	AX, BX				; .. and to AX
	INC	BH				; dest is 1 row below source
	MOV	CL, 0Bh				; 'move block' code
	MOV	CH, 0				; screen i.d.
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	INT	SCR_DRV				; move that block
SMEAR_LINE:			; 'smear' the top line of block
	MOV	CL, 08h				; 'smear block' code
	MOV	CH, 0				; screen i.d. is 0
	MOV	DX, DS:TEMP2			; recover attributes
	MOV	DL, ' '				; char is a space
	MOV	AX, DS:TEMP3			; top l.h. co-ords
	MOV	BX, DS:TEMP4			; bot r.h. co-ords
	MOV	BH, AH				; make bot row = top row
	MOV	SI, 0				; use default font
	MOV	DI, DS:IMAGE_ID			; set image i.d.
	INT	SCR_DRV				; smear that block
				; try for a loop count
	DEC	DS:TEMP1			; decrement the loop count
	JZ	IT790				; if zero quit
	JMP	IT780				; else loop around
IT790:				; turn the cursor back on again
	MOV	CL, 0Dh				; 'cursor on' code
	MOV	CH, 0				; screen id
	MOV	AH, DS:C_ROWY			; set 'y' co-ord
	MOV	AL, DS:C_COLX			; set 'x' co-ord
	MOV	DI, DS:IMAGE_ID			; set image i.d.
	INT	SCR_DRV				; turn cusor back on
				; .. and exit popwise
	JMP	IT7999				;
;================================================
IT800:				; AH = 8, read attr/char at curpos
				; BH = display page
				; on exit AL = char, AH = attributes
				; tested 28/6/85 jon
	MOV	DS, CS:DS_SAV			; address our own data segment
				; find current cursor position
	MOV	AH, DS:C_ROWY			; cursor y co-ord
	MOV	AL, DS:C_COLX			; cursor x co-ord
				; read char & attribs at x,y ( AL,AH )
	MOV	CX, 0006			; CH=0, CL=6 (scrn id, rd char)
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	INT	SCR_DRV				; and read the character.
	JMP	IT7999				;
;================================================
IT900:				; AH = 3, read cursor position
				; BH = display page
				; on exit DH,DL=row,col
				; CH = cursor start line
				; CL = cursor stop line
				; tested 27/6/85 ?
	MOV	DS, CS:DS_SAV			; point to our data seg
	MOV	DH, DS:C_ROWY			; 'y' to DH
	MOV	DL, DS:C_COLX			; 'x' to DL
	MOV	CH, 0				; 'fudge' cursor type as
	MOV	CL, 31				; a full block
	JMP	IT7999				;
;================================================
IT1000:				; AH = 1, set cursor type
				; CH, bits 0-4 = start line for cursor
				; CL, bits 0-4 = end line for cursor
				; *** NOTE. Cursor type is not alterable
				; in this implementation
	JMP	IT7999				;
;================================================
IT1100:				; AH = 15, return current video state
				; on exit AL = current mode
				; AH = no of screen cols
				; BH = current active display page
	MOV	DS,CS:DS_SAV
	MOV	AL,DS:MODE
	MOV	AH, 80				; 80 columns
	MOV	BH, 0				; current display page
	JMP	IT7999				;
;================================================
IT1200:				; AH = 11, set colour pallette
				; BH = colour id ( 0-127 )
				; BL = value for that id
	MOV	DS,CS:DS_SAV
	MOV	SI,OFFSET DGROUP:PALET
	MOV	DI,DS:IMAGE_ID
	OR	BH,BH		; changing background ?
	JZ	BACK_GROUND
	TEST	BL,1
	JZ	GREEN1
	MOV	SI,OFFSET DGROUP:PALET1
GREEN1:
	MOV	AX,0101H
	MOV	CX,0FH
	MOV	DX,DS
	INT	SCR_DRV
	JMP	SHORT RET_PALET
BACK_GROUND:
	XOR	DX,DX
	CMP	BL,7
	JB	NO_INTENSITY
	MOV	DX,4040H
NO_INTENSITY:
	MOV	CL,DL
	TEST	BL,4				; IS RED SET
	JZ	NO_RED
	OR	DL,80H				; SET RED
NO_RED:	TEST	BL,2				; IS GREEN SET
	JZ	NO_GREEN
	OR	DH,80H				; SET GREEN
NO_GREEN:
	TEST	BL,1				; IS BLUE SET
	JZ	NO_BLUE
	OR	CL,80H
NO_BLUE:
	MOV	BL,CL
	MOV	[SI],DL
	MOV	15[SI],DL
	INC	SI
	MOV	[SI],DH
	MOV	15[SI],DH
	INC	SI
	MOV	[SI],BL
	MOV	15[SI],BL
	MOV	CX,0FH
	MOV	AX,0100H
	INT	SCR_DRV
RET_PALET:
	JMP	IT7999				;
;================================================
IT1300:				; AH = 5, select active display page
				; AL = new page value
				; *** NOTE. Only supporting page 0 here
	JMP	IT7999				;
;================================================
IT1400:				; AH = 0, set mode
				; AL = mode value
				; *** NOTE. Only supporting mode 2&3 here
	MOV	BH,01		; Assume IBM mode
	CMP	AL,2		; is it mono
	JE	SETMODE		; Yes
	CMP	AL,3		; Is it colour
	JNE	RETNOW		; No - then return to the caller
	MOV	BH,02		; Set colour
SETMODE:
	MOV	DS,CS:DS_SAV	; Get our ds
	MOV	DI,DS:IMAGE_ID	; get image id
	MOV	DS:MODE,BH	; save mode
	MOV	SI,0		; 
	MOV	BL,0
	MOV	CX,0		; Disable screen
	INT	SCR_DRV
	MOV	BH,DS:MODE	; recover mode
	INC	DS:MODE		; set return mode
	MOV	DX,0		; system image
	MOV	SI,0
	MOV	BL,0		; 80x25
	MOV	CX,1		; Enable screen
	INT	SCR_DRV
	MOV	DS:IMAGE_ID,DX	; Save image id
	CMP	DS:MODE,3	; Was it a colour mode
	JNE	setpal		; no - set pallette
	MOV	DI,DS:IMAGE_ID	; get image id
	MOV	DX,0120H	; space with colour index 1
	MOV	CX,08H		; smear spaces
	XOR	AX,AX		; on to the full screen
	MOV	BX,184FH
	INT	SCR_DRV
			; Set the Pallette
setpal:	MOV	DX,DS
	MOV	SI,OFFSET DGROUP:PALET1
	MOV	DI,DS:IMAGE_ID
	MOV	AX,0101H
	MOV	CX,0FH
	INT	SCR_DRV
RETNOW:	JMP	IT7999				;
;================================================
IT7999:
				; dropthru to pop reg's & exit
	POP	SI				;
	POP	DI				;
	POP	DX				;
	POP	CX				;
	POP	BX				;
	POP	DS				;
	POP	ES				;

INT10_RET:
		IRET
INT_10		ENDP
PAGE
;=============================================================================
;= int_14		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		RS232
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	AH = 0	Initialise RS232 port
;				AL = parms as follows :
;		bits 5,6,7 = baud rate
;		000b = 110 baud		100b = 1200 baud
;		001b = 150 baud		101b = 2400 baud
;		010b = 300 baud		110b = 4800 baud
;		011b = 600 baud		111b = 9600 baud
;
;		bits 4,3 = parity
;		X0b = none	01b = odd	11b = even
;
;		bit 2 = no of stopbits
;		0b = 1 stopbit		1b = 2 stopbits
;
;		bits 1,0 = char length
;		10b = 7 bits		11b = 8 bits
;
;			AH = 1	transmit char over serial line
;				char is in AL ( preserved ). On exit bit 7
;				of AH is set if unable to xmit. If bit 7 is
;				clear then rest of bits reflect normal status
;
;			AH = 2	receive char from comms line ( wait )
;				char is returned in AL. On exit AH contains
;				either bit 7 on, which indicates an error,
;				or the current status, except that the only
;				bits left on are the error bits ( 1,2,3,4,7,).
;			AH = 3 return comms line status in AX
;				AH = line status as follows :
;					bit 7 = time out or general err
;					bit 6 = tx reg empty
;					bit 5 = tx buf empty
;					bit 4 = break detect
;					bit 3 = framing error
;					bit 2 = parity error
;					bit 1 = overrun error
;					bit 0 = rx data avail
;				AL ( modem status )
;					bits 4 & 5 supported
;OUTPUT		:
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_14
INT_14	PROC	NEAR

	JMP	SHORT	IS10
INT14_SAV	DD	0
IS10:
	PUSH	BX				;
	PUSH	CX				;
	PUSH	DX				;
	PUSH	DS				;
	PUSH	ES				;
	PUSH	DI				;
	MOV	DS, CS:DS_SAV			;
	CMP	AH, 0				; initialise port ?
	JZ	IS20				; yes, do that
	JMP	IS100				; no, try next
 IS20:				; initialise the serial port
	MOV	DS:TEMP1, AX			; save call parms
	MOV	BX, 34h				; 'serial' code
	MOV	CX, 0				;
	INT	0FCh				; init the serial driver
				; xlat IBM baud code to Apricot baud code
	MOV	AX, DS:TEMP1			; retrieve call parms
	XOR	AH, AH				; ensure AH is 0
	MOV	CL, 5				; bits to lose
	SHR	AL, CL				; now in range 0-7
	MOV	BX, OFFSET DGROUP: BAUD_TAB	; start of xlat table
	ADD	BX, AX				; add offs for our rate
	XOR	DX, DX				; DH = 0
	MOV	DL, DS:[BX]			; get the value
				; set transmit baud rate ( in DX )
	MOV	BX, 34h				; 'serial' code
	MOV	CX, 4				; set xmit baud rate
	INT	0FCh				; do it
				; set receive baud rate ( still in DX )
	INC	CX				; CX = 5 ( set rx baud )
	INT	0FCh				; do it
				; set bits per character
	MOV	AX, DS:TEMP1			; retrive call parms
	AND	AL, 3				; lose all but bits 0,1
	MOV	DX, 8				; set default of 8 bits
	CMP	AL, 2				; 7 bit chars ?
	JNZ	IS30				; no, as you were
	MOV	DX, 7				; else set seven
IS30:	MOV	BX, 34h				; 'serial' code
	MOV	CX, 6				; set xmit bits per char
	INT	0FCh				; do it
	MOV	CX, 7				; set rx bits per char
	INT	0FCh				; do it
				; set number of stop bits
	MOV	AX, DS:TEMP1			; retrive parms
	AND	AL, 04h				; lose all but bit 2
	MOV	CL, 2				; bits to shift
	SHR	AL, CL				; 0=1, 1 = 2 stopbits
	MOV	DX, 1				; set 1 stopbit as default
	CMP	AL, 0				; do we need 2 stopbits ?
	JZ	IS40				; no, that's it
	MOV	DX, 3				; else set 2 stopbits
IS40:	MOV	BX, 34h				; 'serial' code
	MOV	CX, 8				; 'set stopbits' code
	INT	0FCh				; do it
				; set parity
	MOV	AX, DS:TEMP1			; retrive parms
	AND	AL, 18h				; get bits 3,4
	MOV	CL, 3				; bits to shift
	SHR	AL, CL				; AX = 0-3
	MOV	DX, 2				; set even parity initially
	CMP	AL, 2				; AL is 0,1 or 3
	JA	IS50				; it was 3, so quit
	MOV	DL, AL				; else parity is direct xlat
IS50:	MOV	BX, 34h				; 'serial' code
	MOV	CX, 9				; 'set parity' code
	INT	0FCh				; do it
				; update the sio
	MOV	CX, 3				; 'update' code
	INT	0FCh				; do it
				; Set the CNF_s_bioserr byte to 1 ( disable bios retries )
	XOR	BX, BX				;
	MOV	ES, BX				; set ES = 0
	MOV	DI, WORD PTR ES:[700h]		; ptr offs to DI
	MOV	BX, WORD PTR ES:[702h]		; ptr seg to BX
	MOV	ES, BX				; ES:DI -> bios config table
	MOV	BH, 1				;
	MOV	ES:[DI+42h], BH			; CNF_s_bioserr = 1

	JMP	IS500				;

IS100:
	CMP	AH, 1				; transmit a char ?
	JZ	IS110				; yes, do that
	JMP	IS200				; no, try next
IS110:				; transmit a character
	MOV	DL, AL				; swap char to DL
	XOR	AH, AH				; start with zero retcode
	MOV	BX, 34h				; 'serial' code
	MOV	CX, 1				; 'xmit char' code
	INT	0FCh				; do it
	CMP	AX, 0				; did it go ?
	JZ	IS120				; yes, it did
	MOV	AH, 80h				; else set bit 7 of AH ( err )
IS120:	MOV	AL, DL				; replace xmit char
	JMP	IS500

IS200:
	CMP	AH, 2				; receive a character ?
	JZ	IS210				; yes, do that
	JMP	IS300				; no, try next
IS210:				; receive a character
	MOV	AX, DS:[TIMEOUT]		; get the timeout counter
	MOV	DS:TEMP4, AX			; and set it as outer loop
IS215:	MOV	DS:TEMP3, 1999h			; set inner loop timeout
	MOV	BX, 34h				; 'serial' code
	MOV	CX, 2				; 'rx char' code
IS220:	INT	0FCh				; do it
	CMP	AH, 0				; did we get one ?
	JNZ	IS230				; no, try for timeout
	JMP	IS500				; yes, just quit
IS230:	DEC	DS:TEMP3			; reduce timeout inner loop
	JNZ	IS220				; loop back if not zero
	DEC	DS:TEMP4			; dec outer loop counter
	JNZ	IS215				; loop back if not zero
	MOV	AH, 80h				; set error code
	JMP	IS500				; .. and quit

IS300:
	CMP	AH, 3				; return comms line status ?
	JZ	IS310				; yes, do that
	JMP	IS500				; just quit then
IS310:				; return comms line status
	XOR	DX, DX				; start retcode at zero
	MOV	BX, 34h				; 'serial' code
	MOV	CX, 01Bh			; 'lookahead' code
	INT	0FCh				; do it
	CMP	AH, 0				; anything there ?
	JNZ	IS320				; no, skip
	OR	DX, 0100h			; set 'rx avail' bit
IS320:	MOV	CX, 12h				; 'dsr status' code
	INT	0FCh				; do it
	CMP	AX, 0				; dsr bit = 1 ?
	JZ	IS330				; no, skip
	OR	DX, 0020h			; set dsr bit in retcode
IS330:	MOV	CX, 10h				; 'cts status' code
	INT	0FCh				; do it
	CMP	AX, 0				; cts bit = 1 ?
	JZ	IS340				; no, skip
	OR	DX, 0010h			; set cts bit in retcode
IS340:
	MOV	AX, DX				; swap to true retcode
				; dropthru to quit
;
IS500:				; common exit point here
	POP	DI
	POP	ES
	POP	DS				;
	POP	DX				;
	POP	CX				;
	POP	BX				;
	IRET

INT_14	ENDP
PAGE
;=============================================================================
;= int_16		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		keyboard
;ACTION		This handler modified 29/10/85 to perform foreign language
;		support. It is designed to use the GEM keyboard tables which
;		prefix characters with escape if it is desired to add 80h
;		to the key code.
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	AH = 0	read next ascii char struck from kbd.
;				result in AL, scan code in AH
;			AH = 1	set Z flag to indicate if an ascii char
;				is available to be read.
;				ZF = 1 no code available
;				ZF = 0 code is available
;			AH = 2	return current shift status in AL
;				bit 7 = ins state
;				bit 6 = caps state
;				bit 5 = num state
;				bit 4 = scroll state
;				bit 3 = alt_shift
;				bit 2 = ctrl_shift
;				bit 1 = left_shift
;				bit 0 = right_shift
;OUTPUT		:
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_16
INT_16	PROC	NEAR

	JMP	SHORT	IK10
INT16_SAV	DD	0
IK10:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	CMP	AH, 2				; is it status enquiry ?
	JZ	IK20				; yes, do that
	JMP	IK100				; else try next
				; return current shift status in AL
IK20:	MOV	BX, 32h				; point to keyboard
	MOV	CX, 0Fh				; 'get status' code
	MOV	DX, 0FF00h			; return it unaffected
	INT	0FCh				; get that status
	MOV	BL, 0				; target status byte
	TEST	AX, 0800h			; was right shift on ?
	JZ	IK25				; no
	OR	BL, 1				; set right shift bit
IK25:	TEST	AX, 0100h			; was left shift key on ?
	JZ	IK30				; no
	OR	BL, 2				; set left shift bit
IK30:	TEST	AX, 0200h			; was ctrl key on ?
	JZ	IK35				; no
	OR	BL, 4				; set ctrl bit
IK35:	TEST	AX, 0400h			; was alt key on ?
	JZ	IK40				; no
	OR	BL, 8				; set alt key bit
IK40:	TEST	AX, 2				; was stop key on ?
	JZ	IK45				; no
	OR	BL, 16				; set stop bit
IK45:	TEST	AX, 0080h			; was caps lock on ?
	JZ	IK50				; no
	OR	BL, 64				; set caps lock bit
IK50:	MOV	AH, 2				; replace the call code
	MOV	AL, BL				; return status in AL
	JMP	IK300				; .. and quit

IK100:
	CMP	AH, 1		; set Z flag if char is available
	JNZ	IK200				;
	PUSH	BP				; save BP
	MOV	BP, SP				;
	MOV	BX, 32h				; 'keyboard' code
	MOV	CX, 0Ch				; look ahead
	MOV	CS:INT16_FLAG,0FFH
	MOV	CS:SCAN_FLAG,0
	INT	0FCh				;
	CMP	AH, 0				; anything there ?
	JZ	IK110				; yes, got one
	OR	WORD PTR [BP+12], 0040h		; turn ZF to 1 on stack
	POP	BP				; restore caller's BP
	JMP	IK300				; and quit
IK110:	AND	WORD PTR [BP+12], 0FFBFh	; turn ZF to 0 on stack
	POP	BP				; restore caller's BP
	JMP	IK250				; quit through xlat routine
IK200:
	CMP	AH, 0				;
	JNZ	IK300				; call code no good
				; return next char in AL ( wait if needed ). This
				; now has foreign lang. support. Here are the rules.
				; If the key is alone then xlat, quit.
				; If the key is preceeded by esc then substitute 'A'
				; scancode in AH, leave AL unchanged.

				; poll int FC until we get a key
	MOV	BX, 32h				; 'keyboard' code
	MOV	CX, 0Ah				; return no of keys in buffer
IK210:	INT	0FCh				; 
	OR	AX, AX				; any keys in buffer ?
	JZ	IK210				; nope, wait in a loop
				; dropthru if at least 1 key in buffer
	MOV	CS:INT16_FLAG,0FFH
	MOV	CS:SCAN_FLAG,0
	CMP	AX, 1				; just one key ?
	JZ	IK240				; yes, go get it
				; more that one key, check for esc-n combinations
	MOV	CX, 0Bh				; get key from buffer
	INT	0FCh				;
	CMP	AL, 27				; esc ?
	JNZ	IK250				; no, xlat normally
	INT	0FCh				; yes, get next key
	CMP	AL, 27				; another 'esc' ?
	JZ	IK250				; yes, eat the first esc & treat the second normally
	MOV	AH, 1Eh				; else give the char an innocuous scan code
	JMP	SHORT IK300			; and return the untranslated ascii

IK240:	MOV	CX, 0Bh				; get key from buffer
	INT	0FCh				;
IK250:				; dropthru here to xlat a 'normal' key
	PUSH	DS				; save orig DS
	MOV	DS, CS:DS_SAV			; .. and make it ours
	MOV	BX, OFFSET DGROUP:KEY_XLAT_TAB	; get start of table
	XOR	AH, AH				; clear the high byte
	SHL	AX, 1				; *2 for words
	ADD	BX, AX				; add to offset
	MOV	AX, [BX]			; get scan code & ascii
	POP	DS				; restore caller's DS

IK300:
	POP	DX
	POP	CX
	POP	BX
	MOV	CS:INT16_FLAG,0
	IRET

INT_16	ENDP
PAGE
;=============================================================================
;= int_17		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		INT 17 interrupt service routine.
;ACTION		Responsible for IBM type printer i-o
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:	Uses int FC
;-----------------------------------------------------------------------------
;INPUT		:	AH = 0 ( print char )
;			AL = char to print.
;OUTPUT		:	status and/or error code in AH. AL preserved
;INPUT		:	AH = 1 ( initialise printer port )
;OUTPUT		:	AH returns printer status
;INPUT		:	AH = 2 ( read printer status )
;OUTPUT		:	AH returns printer status
;ERRORS		:	None.
;REG USE	:	AX, BX
;STACK USE	:	2 words.
;RAM USE	:	None.
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_17
INT_17	PROC	NEAR

	JMP	SHORT	IP10
INT17_SAV	DD	0
IP10:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	CMP	AH, 0				; print char ?
	JNZ	IP30				; no, try next
	MOV	BX, 35h				; control device - printer
	MOV	CX, 7				; print char code
	MOV	DL, AL				; move char to DL
	INT	0FCh				; print that char
	CMP	AX, 0				; any errors ?
	JZ	IP20				; no, continue
	MOV	AH, 19h				; set error code for caller
	JMP	IP25				; skip the ack set
IP20:	MOV	AH, 10h				; set 'ack' code for caller
IP25:	MOV	AL, DL				; replace print char
	JMP	IP100				; and quit
	
IP30:	CMP	AH, 1				; initialize port ?
	JNZ	IP60				; no, try next
IP35:	MOV	BX, 35h				; printer code
	MOV	CX, 0				; init driver
	INT	0FCh				; do it
	MOV	CX, 6				; set device par/ser
	MOV	DX, 0				; set to parallel
	INT	0FCh				; do it
	MOV	CX, 5				; set auto lf after cr
	MOV	DX, 0				; disable it
	INT	0FCh				; do it
	MOV	CX, 0Ah				; return output status
	INT	0FCh				; do it
	CMP	AX, 0				; any errors ?
	JZ	IP40				; no, continue
	MOV	AH, 18h				; set 'no paper' code
	JMP	IP100				; and quit
IP40:	MOV	AH, 90h				; not busy, selected
	JMP	IP100				; and quit

IP60:	CMP	AH, 2				; report status ?
	JNZ	IP100				; no, just quit
	MOV	BX, 35h				; printer code
	MOV	CX, 0Ah				; 'get status' code
	INT	0FCh				; do it
	CMP	AX, 0				; any errors ?
	JNZ	IP65				; yes, check them
	MOV	AH, 90h				; set not busy, selected
	JMP	IP100				; .. and quit
IP65:	MOV	AL, 18h				; set error code
						; and dropthru
IP100:	POP	DX
	POP	CX
	POP	BX
	IRET
INT_17	ENDP
PAGE
;=============================================================================
;= int_1A		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Service clock requests
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	AH = 0	read current clock setting
;OUTPUT		:	CX = high portion of count
;			DX = low portion of count
;			AL = 0 if timer has not passed 24 hours
;			since it was last read.
;			AL <> 0 if timer has passed 24 hours since
;			it was last read.
;
;INPUT		:	AH = 1 set the timer counts
;OUTPUT		:	CX = high portion of count
;			DX = low portion of count
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_1A
INT_1A	PROC	NEAR

	JMP	SHORT	IC10
INT1A_SAV	DD	0
IC10:
	CMP	AH, 0				; read the time ?
	JNZ	IC20				; no, try next
				; reading the timer
	MOV	CX, CS:TOD_HI			; put high portion in CX
	MOV	DX, CS:TOD_LO			; put low portion in DX
	MOV	AL, CS:TOD_FLG			; put oflo flag in AL
	MOV	CS:TOD_FLG, 0			; reset oflo flag
	JMP	IC100				; .. and quit
IC20:				; setting the timer
	CMP	AH, 1				; set the time ?
	JNZ	IC100				; no, quit then
	MOV	CS:TOD_HI, CX			; set high portion = CX
	MOV	CS:TOD_LO, DX			; set low portion = DX
	MOV	CS:TOD_FLG, 0			; reset oflo flag
IC100:						; dropthru to quit
	IRET

INT_1A	ENDP
;=========================================================
;	CLOCK VARIABLE STORAGE - saved in pgroup for speed
;=========================================================
TOD_FLG		DB	0
TOD_HI		DW	0
TOD_LO		DW	0
TOD_TICKS	DW	0
;=============================
PAGE
;=============================================================================
;= int 29		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Dummy int 29 handler
;ACTION		Jump immediately to int F9 handler
;-----------------------------------------------------------------------------
PUBLIC	INT_29
INT_29	PROC	NEAR

	JMP	SHORT	IX10
INT29_SAV	DD	0
IX10:	JMP	INT_F1

INT_29	ENDP
PAGE
;=============================================================================
;= int_e6		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Toggle the state of DS:NUM_LOCK
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:
;OUTPUT		:
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_E6
INT_E6	PROC	NEAR

	JMP	SHORT	IE5
INTE6_SAV	DD	0
IE5:	CMP	AL, 12				; is it for us ?
	JNZ	IE100				; nope
IE10:				; toggle the state of num_lock
	PUSH	DS				; save caller's DS
	MOV	DS, CS:DS_SAV			; address our DS
	NOT	BYTE PTR DS:NUM_LOCK		; toggle num lock state
	MOV	BX,33H				; micriscreen code
	MOV	CX,1				; print character
	MOV	DX,1BH				; escape code
	INT	0FCH
	MOV	BX,33H				; micriscreen code
	MOV	CX,1				; print character
	MOV	DX,2FH				; char "/"
	INT	0FCH
	MOV	BX,33H				; micriscreen code
	MOV	CX,1				; print character
	MOV	DX,41H				; escape code
	AND	DL,NUM_LOCK			; get numlock state
	INT	0FCH
	POP	DS				; recover caller's DS
	MOV	AL, 0				; alter key code to null
						; .. and dropthru for exit
IE100:
	JMP	CS:DWORD PTR [INTE6_SAV]		; jump to orig address

INT_E6	ENDP
PAGE
;=============================================================================
;= int_f1		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Int F1 interrupt service routine. *** NOTE This routine
;		is also connected to int 29h
;ACTION		Pipe all esc.seq. handler calls through int 10h, write tty
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	AL = char to print
;OUTPUT		:	None. All registers preserved
;ERRORS		:	None
;REG USE	:	AX, BX
;STACK USE	:	2 words
;RAM USE	:	None
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_F1
INT_F1 PROC	NEAR
	JMP	SHORT	IV10
INTF1_SAV	DD	0
IV10:
	PUSH	AX
	PUSH	BX
	MOV	AH, 14
	MOV	BH, 0
	INT	10h
	POP	BX
	POP	AX
	IRET
INT_F1	ENDP
PAGE
;=============================================================================
;= int_f9		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Catch numeric keys while num_lock on
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:
;OUTPUT		:
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_F9
INT_F9	PROC	NEAR

	JMP	SHORT	IF5
INTF9_SAV	DD	0
IF5:	CLI					; disable interrupts
	PUSH	DS				; save caller's DS
	MOV	DS, CS:DS_SAV			; address our DS
	CMP	BYTE PTR DS:NUM_LOCK, 0		; is num lock on ?
	JNZ	IF05				; Yes, translate char
	CMP	AL,0DDH				; WAS IT 5
	JNE	IF100				; no, exit now
	MOV	BL,0				; NULL IT
	MOV	AX,0
	JMP	IF100
IF05:	CMP	AL, 0CBh			; was it naughty '9' ?
	JNZ	IF10				; no, keep going
	MOV	BL, 0CCH			; xlat to proper '9'
	JMP	IF95				; .. and exit
IF10:	CMP	AL, 0E4h			; was it naughty '1' ?
	JNZ	IF20				; no, keep going
	MOV	BL, 0E5H			; xlat to proper '1'
	JMP	IF95				; .. and quit
IF20:	CMP	AL, 0C8h			; was it naughty '3' ?
	JNZ	IF30				; no, just quit then
	MOV	BL, 0C9H			; xlat to proper '3'
	JMP	IF95				; and exit
IF30:	CMP	AL, 0BBh			; was it naughty '2' ?
	JNZ	IF40				; no, keep going
	MOV	BL, 0C5H			; xlat to proper '2'
	JMP	IF95				; .. and exit
IF40:	CMP	AL, 0BCh			; was it naughty '4' ?
	JNZ	IF50				; no, keep going
	MOV	BL, 0E3H			; xlat to proper '4'
	JMP	IF95				; .. and quit
IF50:	CMP	AL, 0BDh			; was it naughty '6' ?
	JNZ	IF60				; no, just quit then
	MOV	BL, 0C2H			; xlat to proper '6'
	JMP	IF95				; and quit
IF60:	CMP	AL, 0BEh			; was it naughty '7' ?
	JNZ	IF70				; no, keep going
	MOV	BL, 0D0H			; xlat to proper '7'
	JMP	IF95				; .. and exit
IF70:	CMP	AL, 0BFh			; was it naughty '8' ?
	JNZ	IF80				; no, keep going
	MOV	BL, 0C7H			; xlat to proper '8'
	JMP	IF95				; .. and quit
IF80:	CMP	AL, 0D9h			; was it naughty '0' ?
	JNZ	IF90				; no, just quit then
	MOV	BL, 0D2H			; xlat to proper '0'
	JMP	IF95
IF90:	CMP	AL, 0DAh			; was it naughty '.' ?
	JNZ	IF100				; no, just quit then
	MOV	BL, 0D4H			; xlat to proper '.'
IF95:	MOV	AX, 0FFFFh			; set 'pass to dos' code
IF100:
	POP	DS				; recover caller's DS
	STI					; enable interrupts
	iret
;	JMP	CS:DWORD PTR [INTF9_SAV]	; jump to orig address

INT_F9	ENDP
PAGE
;=============================================================================
;= int_fc		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Translate keys before returning to caller
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:
;OUTPUT		:
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_FC
INT_FC	PROC	NEAR

	JMP	SHORT	IF5C
INTFC_SAV	DD	0
INT16_FLAG	DB	0
SCAN_FLAG	DB	0
SCAN_CODE	DB	0
IF5C:	CLI					; disable interrupts
	CMP	BX,32H
	JNE	JMP_OLDFC
	CMP	CX,0BH
	JE	IFC1
	CMP	CX,0CH
	JE	IFC1
	CMP	CX,0EH
	JE	GET_STRING
JMP_OLDFC:
	JMP	CS:DWORD PTR [INTFC_SAV]	; jump to orig address
GET_STRING:
	PUSH	ES
	MOV	ES,DX
	MOV	CX,ES:[SI]
	INC	SI
	INC	SI
	LES	SI,ES:[SI]
GET_LOOP:
	PUSH	ES
	PUSH	SI
	PUSH	CX
	MOV	BX,32H
	MOV	CX,0BH
	CALL	GET_CHAR
	POP	CX
	POP	SI
	POP	ES
	MOV	ES:[SI],AL
	INC	SI
	LOOP	GET_LOOP
	POP	ES
	JMP	SHORT NOW_IRET
IFC1:
	CALL	GET_CHAR
NOW_IRET:
	IRET
GET_CHAR:
	CMP	CS:SCAN_FLAG,0FFH
	JNE	IFC05
	MOV	AL,CS:SCAN_CODE
	cmp	cx,0ch
	je	skip_1
	MOV	CS:SCAN_FLAG,0
SKIP_1:	XOR	AH,AH
	JMP	SHORT	IFC60
IFC05:
	PUSH	DS				; save caller's DS
	push	cx
	PUSHF
	CALL	CS:DWORD PTR [INTFC_SAV]	; jump to orig address
	pop	cx
	MOV	DS, CS:DS_SAV			; address our DS
IFC10:	CMP	CS:INT16_FLAG,0
	JNE	IFC50
	cmp	cx,0ch
	jne	ifc12
	TEST	AH,0FFH
	JNZ	IFC50
IFC12:	MOV	BX, OFFSET DGROUP:KEY_XLAT_TAB	; get start of table
	XOR	AH, AH				; clear the high byte
	SHL	AX, 1				; *2 for words
	ADD	BX, AX				; add to offset
	MOV	AX, [BX]			; get scan code & ascii
	CMP	AL,0
	JNE	IFC40
	CMP	CX,0CH
	JE	IFC40
	MOV	CS:SCAN_CODE,AH
	MOV	CS:SCAN_FLAG,0FFH
IFC40:	XOR	AH,AH
IFC50:	POP	DS
IFC60:	STI
	RET
INT_FC	ENDP
PAGE
;=============================================================================
;= int_ff		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		System timer pipe
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:
;OUTPUT		:
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_FF
INT_FF	PROC	NEAR

	JMP	SHORT	IA10
INTFF_SAV	DD	0
IA10:
	PUSH	AX				; save AX for the moment
	MOV	AX, CS:TOD_TICKS		; get 'ticks' word
	INC	AL				; bump the 'ticks' count
	ADD	AL, AH				; add the flag ( 1 or 0 )
	CMP	AL, 3				; ticks count reached ?
	JZ	IA20				; yes, handle it
	SUB	AL, AH				; else take flag away again
	JMP	IA100				; and quit
IA20:	INT	01Ch				; cause 'user' interrupt
	XOR	AH, 1				; toggle ticks count flag
	XOR	AL, AL				; zeroise ticks count
	INC	CS:TOD_LO			; bump low count
	JNO	IA30				; no oflo, skip hi bump
	INC	CS:TOD_HI			; bump hi count
IA30:	CMP	CS:TOD_HI, 17h			; close to 24 hours ?
	JNZ	IA100				; not close enough
	CMP	CS:TOD_LO, 0FE80h		; on the button ?
	JNZ	IA100				; no, not quite
				; 24 'hours' elapsed, reset clock
	MOV	CS:TOD_LO, 0			;
	MOV	CS:TOD_HI, 0			;
	MOV	CS:TOD_FLG, 1			; toggle oflo flag
IA100:
	MOV	CS:TOD_TICKS, AX		; replace ticks count
	POP	AX				;
	JMP	CS:DWORD PTR [INTFF_SAV]	; quit thru bios

INT_FF	ENDP
PAGE
;=============================================================================
;= con_vec
;=============================================================================
;JOB		Connect an interrupt routine
;ACTION		Save the old vector in pos provided by caller
;		Connect new routine
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	dos func int 21h codes 35h ( get vector )
;					       25h ( set vector )
;-----------------------------------------------------------------------------
;INPUT		:	DI = CS offset of vector save area ( 4 bytes )
;			AL = interrupt number
;			DX = offset from current CS of interrupt routine
;OUTPUT		:	none
;ERRORS		:	none
;REG USE	:	all preserved
;STACK USE	:	10 words including int calls
;RAM USE	:	leaves old vector in save area
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	CON_VEC
CON_VEC	PROC	NEAR

	PUSH	AX				; general sort of
	PUSH	BX				; register save thingy
	PUSH	DX				; here
	PUSH	DI				;
	PUSH	ES				;
				; get the vector. DI already set to vector
				; save offset. AL already set to interrupt
				; number
	PUSH	AX				; save AL for later
	MOV	AH, 35h				; 'get vector' code
	INT	21h				; ES:BX will contain vector
	MOV	CS:[DI], BX			; store offset
	MOV	AX, ES				; swap ES to AX for store
	MOV	CS:[DI+2], AX			; and store segment word
	POP	AX				; recover trashed AL reg
				; now set the new vector ( which is assumed
				; to be CS:DX )
	PUSH	DS				; save orig DS
	PUSH	CS				; and make it a copy
	POP	DS				; of current CS
	MOV	AH, 25h				; 'set vector' code
	INT	21h				; set AL int number = DS:DX
	POP	DS				; recover orig DS

	POP	ES				;
	POP	DI				;
	POP	DX				;
	POP	BX				;
	POP	AX				;
	RET

CON_VEC	ENDP
PAGE
;=============================================================================
;= dis_vec
;=============================================================================
;JOB		disconnect an interrupt routine
;ACTION		Get old vector from routine address + 2
;		Connect old vector
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	dos func int 21h codes 35h ( get vector )
;					       25h ( set vector )
;-----------------------------------------------------------------------------
;INPUT		:	AL = interrupt number
;OUTPUT		:	none
;ERRORS		:	*** Note. Relies on old vector being saved +2 bytes
;			away from current vector address
;REG USE	:	AX trashed
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	DIS_VEC
DIS_VEC	PROC	NEAR

	PUSH	BX				;
	PUSH	DX				;
	PUSH	ES				;
	PUSH	DS				;
				; get the vector pointed to by AL
	PUSH	AX				; save AL for later
	MOV	AH, 35h				; 'get vector' code
	INT	21h				; ES:BX will contain vector
				; retrive the old vector address
	MOV	AX, ES:[BX+4]			; segment to AX
	MOV	DX, ES:[BX+2]			; offset to DX
	MOV	DS, AX				; DS:DX = old vector now
	POP	AX				; recover trashed AL reg
	MOV	AH, 25h				; 'set vector' code
	INT	21h				; set AL int number = DS:DX

	POP	DS				;
	POP	ES				;
	POP	DX				;
	POP	BX				;
	RET

DIS_VEC	ENDP
PAGE
;=============================================================================
;= unload
;=============================================================================
;JOB		Remove original copy of emibm from memory, free up arena
;ACTION		Check that we actually have something to unload
;		find start of orig emibm psp through int 10h vector
;		recover original vectors and replace them
;		deallocate mem from psp
;		deallocate mem from arena header
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	int 21h funcs 49h, 25h
;		calls	chk_load
;-----------------------------------------------------------------------------
;INPUT		:	none
;OUTPUT		:	none
;ERRORS		:	produces its own error messages ( assumption is that
;			caller will terminate after this call, errors or not )
;REG USE	:	AX, DX, ES, BX, SI, DS.
;STACK USE	:	2 words max
;RAM USE	:	frees previous emibm arena if found
;LENGTH		:	83h
;CYCLES		:
;=============================================================================
PUBLIC	UNLOAD
UNLOAD		PROC	NEAR
				; check for something to unload
	CALL	CHK_LOAD			; look for emibm code
	CMP	AX, 1				; was it there ?
	JZ	U20				; yes, continue
U10:	MOV	DX, OFFSET DGROUP: HD$		; 'emibm ver x.x -'
	CALL	PRT_MSG				; print it
	MOV	DX, OFFSET DGROUP: CF$		; 'can't find orig copy'
	CALL	PRT_MSG				; print it
	JMP	U100				; and quit
U20:				; find start address of the int 10 routine
	MOV	AH, 35h				; 'get vector' code
	MOV	AL, 10h				; vector number
	INT	21h				; get that vector (in ES:BX)
	MOV	DS:TEMP1, BX			; save offset
	MOV	DS:TEMP2, ES			; save segment
				;REVECTOR THE ORIGINAL KEYBOARD TABLE
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	MOV	AX,ES:[BX+14]
	MOV	DS:[712H],AX
	MOV	AX,ES:[BX+16]
	MOV	DS:[714H],AX
	POP	DS
				; find and save orig psp seg address
	MOV	AX, ES:[BX+7]			;
	MOV	DS:TEMP3, AX			;
				; Replace the CNF_s_bioserr byte ( for serial comms )
	MOV	DH, ES:[BX+13]			; saved val to DH
	XOR	AX, AX				;
	MOV	ES, AX				; set ES = 0
	MOV	DI, ES:[700h]			; ptr offs to DI
	MOV	BX, ES:[702h]			; ptr seg to BX
	MOV	ES, BX				; ES:DI -> bios config table
	MOV	ES:[DI+42h], DH			; replace CNF_s_bioserr with saved value
				; replace orig int 10 vector ( as a special )
	MOV	BX,DS:TEMP2			; get original segment
	MOV	ES,BX				; into es
	MOV	BX,DS:TEMP1			; and offset in to bx
	PUSH	DS				; save DS
	MOV	DX, ES:[BX+9]			; offset
	MOV	DS, ES:[BX+11]			; seg
	MOV	AH, 25h				; set vector ( in DS:DX )
	MOV	AL, 10h				; vector number
	INT	21h				; do it
	POP	DS				;
				; replace the normal vectors
	MOV	AL, 14h				;
	CALL	DIS_VEC				;
	MOV	AL, 16h				;
	CALL	DIS_VEC				;
	MOV	AL, 17h				;
	CALL	DIS_VEC				;
	MOV	AL, 1Ah				;
	CALL	DIS_VEC				;
	MOV	AL, 29h
	CALL	DIS_VEC
	MOV	AL, 0E6h			;
	CALL	DIS_VEC				;
	MOV	AL, 0F1h
	CALL	DIS_VEC
	MOV	AL, 0F9h			;
	CALL	DIS_VEC				;
	MOV	AL, 0FCh			;
	CALL	DIS_VEC				;
	MOV	AL, 0FFh			;
	CALL	DIS_VEC				;
				; deallocate orig mem requirement
	MOV	AX, DS:TEMP3
	MOV	ES, AX
	PUSH	ES				; save ES for call ( j.i.c.)
	MOV	AH, 49h				; 'free up memory' code
	INT	21h				; do it
	POP	ES				; recover ES
				; deallocate environment requirement
	MOV	SI, 02Ch			; point to environ seg
	MOV	AX, ES:[SI]			; get environment seg addr
	MOV	ES, AX				; and switch it to ES
	MOV	AH, 49h				; 'free up memory' code
	INT	21h				; do it
				; re-enable the esc handler
	MOV	AL, 27
	INT	0F1h
	MOV	AL, 'z'
	INT	0F1h
				; clear mscreen but leave time&date
	MOV	BX,33H
	MOV	CX,1
	MOV	DX,27
	INT	0FCH
	MOV	BX,33H
	MOV	CX,1
	MOV	DX,'E'
	INT	0FCH
	MOV	BX,33H
	MOV	CX,1
	MOV	DX,27
	INT	0FCH
	MOV	BX,33H
	MOV	CX,1
	MOV	DX,'/'
	INT	0FCH
	MOV	BX,33H
	MOV	CX,1
	MOV	DX,40H
	INT	0FCH
	MOV	AL, 27
	INT	0F1h
	MOV	AL, '<'				; display time on mscreen
	INT	0F1h
				; print the 'unloaded' message
	MOV	DX, OFFSET DGROUP: HD$		; 'emibm ver x.x'
	CALL	PRT_MSG				; print it
	MOV	DX, OFFSET DGROUP: TATA$	; 'unloaded, etc'
	CALL	PRT_MSG				; print it
U100:				; proc exit point
	RET					; and quit

UNLOAD		ENDP
PAGE
;=============================================================================
;= chk_parms
;=============================================================================
;JOB		Check parms in psp against known strings
;ACTION		
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	ES points to start of psp
;OUTPUT		:	AX = 1 means no parms typed
;			AX = 2 means NO typed
;			AX = 3 means VERBOSE typed
;ERRORS		:	AX = 0 is invalid parms code
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC		CHK_PARMS
CHK_PARMS	PROC	NEAR
				;point at psp text area & examine for chars
	CALL	CONV_CHRS			; convert a-z to A-Z
C10:	XOR	CX, CX				; CX = 0
	MOV	DI, 80h				; address no of chars typed
	MOV	CL, ES:[DI]			; chars typed count to CX
	CMP	CL, 0				; anything typed ?
	JNZ	C20				; got parms, go test 'em
	MOV	AX, 1				; nothing there retcode
	JMP	C100				; quit already
C20:				;strip leading spaces
	MOV	DL,CL
	INC	DI				; point to next parm char
	MOV	AL, ES:[DI]			; stick it in acc
	CMP	AL, ' '				; is it a space ?
	JNE	C30				; no, exit this loop
	JMP	SHORT	C20			; .. and loop round
C30:				;arrive here with DI -> first real char
				; try for NO
	MOV	BX, DI				; save the DI value for later
	MOV	SI, OFFSET DGROUP:PARM1		; get the first parm
	MOV	CX, 3				; parm length +1 ?
	REPZ	CMPS BYTE PTR [DI], [SI]	; compare it
	JCXZ	C42				; we found 'NO'
				; try for VERBOSE
	MOV	DI, BX				; restore DI
	MOV	SI, OFFSET DGROUP:PARM2
	MOV	CX, 8
	REPZ	CMPS BYTE PTR [DI], [SI]
	JCXZ	C44				; we found 'VERBOSE'

;
;				 Some other parameter
;
	MOV	DI,BX
	MOV	SI,OFFSET DGROUP:PATH_NAME
	MOV	CX,01
PATH_LOOP:
	MOV	AL,ES:[DI]			; GET NEXT CHAR
	CMP	AL,' '				; IS IT A SPACE
	JE	END_LOOP			; YES - EXIT LOOP
	CMP	AL,'.'				; IS IT A '.'
	JE	PATH_EROR
	MOV	[SI],AL
	INC	SI
	INC	DI
	INC	CL
	CMP	DL,CL
	JNE	PATH_LOOP
END_LOOP:
	MOV	BYTE PTR [SI],'.'
	MOV	DS:PATH_LENTH,CL
	INC	SI
	MOV	BYTE PTR [SI],'C'
	INC	SI
	MOV	BYTE PTR [SI],'O'
	INC	SI
	MOV	BYTE PTR [SI],'M'
	INC	SI
	CMP	CL,8
	JE	FIL_LENTH
	MOV	BYTE PTR [SI],0
FIL_LENTH:
	MOV	BX,80H
	MOV	AL,ES:[BX]
	XCHG	AL,CL
	SUB	CL,AL
	MOV	ES:[BX],CL
	JZ	NO_PARMS
	XOR	CH,CH
	INC	BX
	INC	BX
PARM_LOOP:
	INC	DI
	MOV	AL,ES:[DI]
	MOV	ES:[BX],AL
	INC	BX
	LOOP	PARM_LOOP
NO_PARMS:
	JMP	C99				; error exit if dropthru
PATH_EROR:
	MOV	AX,0FFH
	JMP	SHORT C100

C42:	MOV	AX, 2				; set NO
	JMP	C50				;
C44:	MOV	AX, 3				; set VERBOSE
						; dropthru ...

C50: 				; check next char after valid parm match
	MOV	CL, ES:[DI-1]			; get the char into CL
	CMP	CL, ' '				; compare with space
	JB	C56				; below is O.K.
	JMP	C99				; above or equal is error
C56:	JMP	C100				; .. and exit

C99:	XOR	AX, AX				; error exit point
C100:	RET

CHK_PARMS	ENDP
PAGE
;=============================================================================
;= conv_chrs
;=============================================================================
;JOB		Convert lowercase to uppercase chars in psp text area
;ACTION		
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		: ES points to start of psp
;OUTPUT		: none
;ERRORS		: none
;REG USE	: BX, AL ( not preserved )
;STACK USE	: none
;RAM USE	: affects last 100h bytes of psp
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	CONV_CHRS
CONV_CHRS	PROC	NEAR

	MOV	BX, 81h				; point to first char in psp
D10:	MOV	AL, ES:[BX]			; pull it into al
	CMP	AL, 'Z'				; is is > 'Z' ?
	JB	D20				; no, skip it
	SUB	AL, 20h				; yes, conv to upper case
	MOV	ES:[BX], AL			; stick it back in psp
D20:	INC	BX				; bump the pointer
	CMP	BX, 0FFh			; end of buffer ?
	JNZ	D10				; no, loop back
	RET					; yes, quit

CONV_CHRS	ENDP
PAGE
;===========================================================================
;= chk_load
;=============================================================================
;JOB		Check for EMIBM already connected to int 10h
;ACTION		
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	none
;-----------------------------------------------------------------------------
;INPUT		: none
;OUTPUT		:	AX = 0 if nothing in mem
;ERRORS		:	AX = 1 if emulator already there
;REG USE	:	DS ( preserved )
;			SI, AX, BX ( destroyed )
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	CHK_LOAD
CHK_LOAD	PROC	NEAR

	PUSH	DS
				; obtain the interrupt 10h vector
	MOV	AH, 35h				; 'get vector' code
	MOV	AL, 10h				; get the int 10h vector
	INT	21h				; ES:BX point to int handler
	PUSH	ES				; make DS = ES
	POP	DS				; so DS = segment
	MOV	SI, BX				; and SI = offset
	ADD	SI, 2				; skip the short jump
				; now inspect the bytes pointed to by DS:SI
	LODSB					; get a byte from DS:[SI]
	CMP	AL, 'E'				; was it 'E' ?
	JNZ	E10				; no, quit now
	LODSB					; get next byte
	CMP	AL, 'M'				; was it 'M' ?
	JNZ	E10				; no, quit now
	LODSB					; etc, etc
	CMP	AL, 'I'				;
	JNZ	E10				;
	LODSB					;
	CMP	AL, 'B'				;
	JNZ	E10				;
	LODSB					;
	CMP	AL, 'M'				;
	JNZ	E10				;
	MOV	AX, 1				; yes, set 'sig found' code
	JMP	E20				; and return
E10:
	XOR	AX, AX				; set 'no sig found' code
E20:						; .. and dropthru
	POP	DS
	RET

CHK_LOAD	ENDP
PAGE
;=============================================================================
;= prt_msg
;=============================================================================
;JOB		Print a text string on screen
;ACTION		
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	int 21 call
;-----------------------------------------------------------------------------
;INPUT		: 	DS:DX point to start of message
;			message should end with '$'
;OUTPUT		: none
;ERRORS		: none
;REG USE	: AX ( preserved )
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	PRT_MSG
PRT_MSG		PROC	NEAR

	PUSH	AX
	MOV	AH, 9
	INT	21h
	POP	AX
	RET

PRT_MSG		ENDP
PAGE
;==========================
; - END OF PROGRAM SEGMENT
;==========================
PROG		ENDS
PAGE
;=============================================================================
;================
; - DATA SEGMENT
;================
DATA	SEGMENT	WORD	PUBLIC	'DATA'
	ASSUME	DS:DGROUP
;
COM_PARM	DB	0			; command line parameter code
PARM1		DB	'NO',0			; allowable command line
PARM2		DB	'VERBOSE',0		; parms
FTAB_SEG	DW	0			; ptr to format struc segment
FTAB_OFFS	DW	0			; ptr to format struc offset
C_ROWY		DB	0			; cursor position storage
C_COLX		DB	0			;
IMAGE_ID	DW	0			;
TEMP1		DW	0			; These four locations are
TEMP2		DW	0			; used as temporary storage
TEMP3		DW	0			; because the int EC calls
TEMP4		DW	0			; kill so many reg's
NUM_LOCK	DB	0			; num lock key state (1 or 0)
TIMEOUT		DW	0			; RS232 timeout delay
MODE		DB	0
PATH_LENTH	DB	0
PATH_NAME	DB	'            '		; PATH NAME
PARMS_BLOCK	DW	0			; PARAMETER BLOCK
		DW	80H
SEG1		DW	00
		DW	5CH
SEG2		DW	00H
		DW	6CH
SEG3		DW	00

FILE_EROR	DB	'File Not Found - $'
other_eror	db	'Unable to RUN specified Program - $'
other_half	db	'Apricot IBM Emulator Terminated',13,10,'$'
;
; ===========================================;
;	PALLETTE ENTRIES FOR COLOUR
; ===========================================;
PALET		DB	0,0,0,64,220,64,220,64,64,220,220,64,220,220,220
PALET1		DB	0,0,0,64,64,250,64,250,250,250,64,250,220,220,220
;
; ===========================================;
;	BAUD RATE TRANSLATION TABLE
; ===========================================;
BAUD_TAB	DB	3,5,6,7,8,10,12,14
;
; ========================================== ;
; 	KEYBOARD TRANSLATION TABLE	     ;
; ========================================== ;
KEY_XLAT_TAB	DB	00H,03H
	DB	01H,1EH		; AL, AH
	DB	02H,30H		;
	DB	03H,2EH		;
	DB	04H,20H
	DB	05H,12H
	DB	06H,21H
	DB	07H,22H
	DB	08H,0eH		; ?
	DB	09H,0fH		;
	DB	0AH,24H
	DB	0BH,25H
	DB	0CH,26H
	DB	0DH,1cH		; AL, AH
	DB	0EH,31H
	DB	0FH,18H
	DB	10H,19H
	DB	11H,10H
	DB	12H,13H
	DB	13H,1FH
	DB	14H,14H
	DB	15H,16H
	DB	16H,2FH
	DB	17H,11H
	DB	18H,2DH
	DB	19H,15H
	DB	1AH,2CH
	DB	1BH,01H
	DB	1CH,2BH
	DB	1DH,1BH
	DB	1EH,07H
	DB	1FH,0CH
	DB	20H,39H
	DB	21H,02H
	DB	22H,28H
	DB	23H,04H
	DB	24H,05H
	DB	25H,06H
	DB	26H,08H
	DB	27H,28H
	DB	28H,0AH
	DB	29H,0BH
	DB	2AH,09H
	DB	2BH,0DH
	DB	2CH,33H
	DB	2DH,0CH
	DB	2EH,34H
	DB	2FH,35H
	DB	30H,0BH
	DB	31H,02H
	DB	32H,03H
	DB	33H,04H
	DB	34H,05H
	DB	35H,06H
	DB	36H,07H
	DB	37H,08H
	DB	38H,09H
	DB	39H,0AH
	DB	3AH,27H
	DB	3BH,27H
	DB	3CH,33H
	DB	3DH,0DH
	DB	3EH,34H
	DB	3FH,35H
	DB	40H,03H
	DB	41H,1EH
	DB	42H,30H
	DB	43H,2EH
	DB	44H,20H
	DB	45H,12H
	DB	46H,21H
	DB	47H,22H
	DB	48H,23H
	DB	49H,17H
	DB	4AH,24H
	DB	4BH,25H
	DB	4CH,26H
	DB	4DH,32H
	DB	4EH,31H
	DB	4FH,18H
	DB	50H,19H
	DB	51H,10H
	DB	52H,13H
	DB	53H,1FH
	DB	54H,14H
	DB	55H,16H
	DB	56H,2FH
	DB	57H,11H
	DB	58H,2DH
	DB	59H,15H
	DB	5AH,2CH
	DB	5BH,1AH
	DB	5CH,2BH
	DB	5DH,1BH
	DB	5EH,07H
	DB	5FH,0CH
	DB	60H,29H
	DB	61H,1EH
	DB	62H,30H
	DB	63H,2EH
	DB	64H,20H
	DB	65H,12H
	DB	66H,21H
	DB	67H,22H
	DB	68H,23H
	DB	69H,17H
	DB	6AH,24H
	DB	6BH,25H
	DB	6CH,26H
	DB	6DH,32H
	DB	6EH,31H
	DB	6FH,18H
	DB	70H,19H
	DB	71H,10H
	DB	72H,13H
	DB	73H,1FH
	DB	74H,14H
	DB	75H,16H
	DB	76H,2FH
	DB	77H,11H
	DB	78H,2DH
	DB	79H,15H
	DB	7AH,2CH
	DB	7BH,1AH
	DB	7CH,2BH
	DB	7DH,1BH
	DB	7EH,29H
	DB	7FH,0EH
;	RB	98
;	alt keys 0..9 , - = ,A..Z
	DB	00,81h
	db	00,78h
	db	00,79h
	db	00,7ah
	db	00,7bh
	db	00,7ch
	db	00,7dh
	db	00,7eh
	db	00,7fh
	db	00,80h
	db	00,82h
	db	00,83h
	db	00,1eh
	db	00,30h
	db	00,2eh
	db	00,20h
	db	00,12h
	db	00,21h
	db	00,22h
	db	00,23h
	db	00,17h
	db	00,24h
	db	00,25h
	db	00,26h
	db	00,32h
	db	00,31h
	db	00,18h
	db	00,19h
	db	00,10h
	db	00,13h
	db	00,1fh
	db	00,14h
	db	00,16h
	db	00,2fh
	db	00,11h
	db	00,2dh
	db	00,15h
	db	00,2ch
;RB	22
; alt f1 - f10
	db	00,68h
	db      00,69h
	db	00,6ah
	db	00,6bh
	db	00,6ch
	db	00,6dh
	db	00,6eh
	db	00,6fh
	db	00,70h
	db	00,71h
	db	00,00	
	DB	000H,3BH
	DB	000H,3CH
	DB	00H,3DH
	DB	00H,3EH
	DB	00H,3FH
	DB	000H,40H
	DB	0H,41H
	DB	0H,42H
	DB	0H,43H
	DB	0H,44H
	DB	0H,50H
	DB	0H,4BH
	DB	0H,4DH
	DB	0H,47H
	DB	0H,48H
;	DB	10	DUP (?)
	DB	00H,73H
	DB	0H,4DH
	DB	36H,4DH
	DB	0H,74H
	DB	0H,50H
	DB	032H,50H
	DB	0H,48H
	DB	038H,48H
	DB	0H,51H
	DB	033H,51H
	DB	000H,76H
	DB	0H,49H
	DB	039H,49H
	DB	000H,84H
	DB	000H,77H
	DB	0H,47H
	DB	037H,47H
	DB	0H,52H
	DB	030H,52H
	DB	0H,53H
	DB	02eH,53H
	DB	0H,72H
	DB	02aH,37H
	DB	01bH,1aH
	DB	08H,23H
	DB	0H,52H
	DB	0H,53H
;	DB	4	DUP (?)
	DB	0dH,32H
	DB	00aH,1CH
	DB	035H,4CH
	DB	02Dh,4AH	; num pad -
	DB	02Bh,4EH
	DB	09H,017H
	DB	00H,0FH
	DB	0H,4BH
	DB	034H,4BH
	DB	000H,4FH
	DB	031H,4FH
	DB	00H,75H
; 0e7 shift f1 - f10
	db	00,54h
	db	00,55h
	db	00,56h
	db	00,57h
	db	00,58h
	db	00,59h
	db	00,5ah
	db	00,5bh
	db	00,5ch
	db	00,5dh
; 
; f1	contrl f1 - f10
	db	00,5eh
	db	00,5fh
	db	00,60h	
	db	00,61h	
	db	00,62h	
	db	00,63h	
	db	00,64h	
	db	00,65h	
	db	00,66h	
	db	00,67h	
; fb
	db      00,00
	db	00,00
	db	00,00
	db	00,00
	db	00,00

;
WHAT_SIGN	DB	'@(#)'
HD$		DB	'EMIBM ver 1.5.0 (17.12.85 prelim) - $'
HI$		DB	'Apricot IBM Emulator active',13,10,'$'
IN$		DB	'error, emulator already in memory',13,10,'$'
CF$		DB	'error, unable to find original copy in memory',13,10,'$'
US$		DB	'error in usage: type EMIBM or EMIBM NO',13,10,'$'
TATA$		DB	'emulator terminated and removed from memory',13,10,'$'
;

;********************************************************
;							*
;		KEYBOARD TABLE				*
;							*
;********************************************************

;****************************************************************************
;*									    *
;*  File name:				[bios.candy.rom]keytab.asm	    *
;*  Programmer:				G. KURTH			    *
;*  Original implementation date:	29th March 1983			    *
;*  Language:				Intel 286 assembler.		    *
;*  Project name:		        Candyfloss BIOS			    *
;*  Revision history:			First Version 17-dec-1984	    *
;*									    *
;*			Edited the table for the IBM Emulator   19/11/85    *
;*                                                            Afzal Raja    *
;*                                                                          *
;****************************************************************************
;
;
;************************************************************************
;*									*
;*      KEYTABLES - This module contains the basic keyboard look-up     *
;*      tables for the generic BIOS.					*
;*      The main table consists of 416 WORDS, corresponding to the 104  *
;*	possible keyboard downcodes.					*
;*      The first 104 words contain the data for the normal (unshifted) *
;*      key codes, the next 104 words contain the data for the shifted  *
;*      key codes, and the next 104 words give the data for the CONTROL *
;*      codes, and the next 104 words give the data for the ALT codes.  *
;*									*
;*									*
;*      Each word provides the following information;-		        *
;*									*
;*   String Output		    15 bit String Offset from KT_tables *
;*     |						  |		*
;*     |   ---------------------------------------------------------    *
;*     |   |							   |    *
;*    (0) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X)   *
;*									*
;*   -----------------------------------------------------------------  *
;*   | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |  *
;*   -----------------------------------------------------------------  *
;*									*
;*    (1) (1) (1) (1) (1) (1) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X)   *
;*     |   |   |   |   |   |   |   |   |			   |    *
;*     |   |   |   |   |   |   -----   -----------------------------    *
;*     |   |   |   |   |   |     |		         |	        *
;*     |   |   |   |   |   |     |      ASCII Key Data or Special Key   *
;*     |   |   |   |   |   |     |      type - see note below.		*
;*     |   |   |   |   |   |     |				        *
;*     |   |   |   |   |   |     ------ Key Prefix type:-		*
;*     |   |   |   |   |   |		  00 - No Prefix		*
;*     |   |   |   |   |   |		  01 - 'ESC' Prefix		*
;*     |   |   |   |   |   |		  10 - 'ESC','[' Prefix		*
;*     |   |   |   |   |   |		  11 - 'ESC','0' Prefix		*
;*     |   |   |   |   |   |						*
;*     |   |   |   |   |   ------------ Local Key (Data to Screen)      *
;*     |   |   |   |   ---------------- Affected by Caps. Lock		*
;*     |   |   |   -------------------- Affected by Shift Lock		*
;*     |   |   ------------------------ Auto-Repeat Allowed		*
;*     |   ---------------------------- Special Key (Type given by lsb) *
;*     -------------------------------- Non-String Key		        *
;*									*
;************************************************************************
;
;
;************************************************************************
;*									*
;*      The special key types are defined as follows:-		        *
;*									*
;*      00 - Null Key (no data output)					*
;*	01 - Caps lock key						*
;*	02 - Right hand shift						*
;*	03 - Left hand shift						*
;*	04 - Control key						*
;*	05 - stop key							*
;*	06 - calculator key						*
;*	07 - LCD echo key						*
;*	08 - voice key							*
;*      09 - ALT key							*
;*	0A - Print Key						        *
;*	0B - SYS REQ							*
;*									*
;*	F0-F9H - ALT mode specific numeric key				*
;*									*
;*      String keys reside in a string table situated at the end        *
;*      of the second keyboard table, which may be up to 32k long,      *
;*      and is pointed to by the 15-bit string pointer, and consists    *
;*      of the following data format:					*
;*									*
;*      Length  Type  Char1  Char2 ....... CharN			*
;*       byte	byte  byte   byte          byte				*
;*									*
;*      Where 'Type' is similar in format to the upper 8 bits of the    *
;*      normal key table word entry - the top two bits, however will    *
;*      not be significant.						*
;*      'Length' is the count, in words, of the ASCII string (Char1..   *
;*      ..CharN), if length = 0 then it is a null string, and will      *
;*      not produce an output.						*
;*      The 'Type' and 'Length' bytes can be treated as a word having   *
;*      a similar format to the normal lookup table entry, with the     *
;*      ASCII character bits being replaced by a length of string       *
;*      count, and the 'String' and 'Special' key bits not being        *
;*      significant.							*
;*      Default string table length is 192 words.			*
;*									*
;************************************************************************

;
        
;       data for unshifted (normal) keys
;	================================
;
;	     data    type		  key number
;
IBMKEY	DB	0B1H ,10000000B		;1      F1/HELP
	DB	0B2H ,10000000B		;2      F2/UNDO
	DB	0B3H ,10000000B		;3      F3/REPEAT
	DB	0B4H ,10000000B		;4      F4/CALC
	DB	0B6H ,10000000B		;5      F6/PRINT
	DB	0B7H ,10000000B		;6      F7/INTR
	DB	0B8H ,10000000B		;7      F8/MENU
	DB	0B9H ,10000000B		;8      F9/FINISH
	DB	00CH ,11000000B		;9      MB1
	DB	000H ,10100000B		;11     MB2
	DB	000H ,10100000B		;11     MB3
	DB	000H ,10100000B		;12     MB4
	DB	000H ,10100000B		;13     MB5
	DB	000H ,10100000B		;14     MB6
	DB	'\'  ,10110000B		;15     \ uparrow
	DB	'1'  ,10110000B		;16     1!
	DB	'2'  ,10110000B		;17     2@
	DB	'3'  ,10110000B		;18     3#
	DB	'4'  ,10110000B		;19     4
	DB	'5'  ,10110000B		;20     5 (PERCENT)
	DB	'6'  ,10110000B		;21     6$
	DB	'7'  ,10110000B		;22     7&
	DB	'8'  ,10110000B		;23     8*
	DB	'9'  ,10110000B		;24     9(
	DB	'0'  ,10110000B		;25     0)
	DB	'-'  ,10110000B		;26     -_
	DB	'='  ,10110000B		;27     =+
	DB	008H ,10100000B		;28     BS
	DB	025h ,10100000B		;29     percent
	DB	'*'  ,10100000B		;30     *
	DB	'/'  ,10100000B		;31     DIVIDE
	DB	0DEH ,10100000B		;32     -
	DB	0DFH ,10100000B		;33     +
	DB	009H ,10100000B		;34     TAB/BACKTAB
	DB	'q'  ,10111000B		;35     Q
	DB	'w'  ,10111000B		;36     W
	DB	'e'  ,10111000B		;37     E
	DB	'r'  ,10111000B		;38     R
	DB	't'  ,10111000B		;39     T
	DB	'y'  ,10111000B		;40     Y
	DB	'u'  ,10111000B		;41     U
	DB	'i'  ,10111000B		;42     I
	DB	'o'  ,10111000B		;43     O
	DB	'p'  ,10111000B		;44     P
	DB	'['  ,10110000B		;45     [{
	DB	']'  ,10110000B		;46     ]}
	DB	0CFH ,10000000B		;47     HOME - ESC 'H'
	DB	000h ,10100000B		;48     CLEAR- ESC 'E'
	DB	0beh ,10111000B		;49     7
	DB	0bfh ,10111000B		;50     8
	DB	0CBH ,10111000B		;51     9
	DB	001H ,11000000B		;52     CAPS LOCK
	DB	'a'  ,10111000B		;53     A
	DB	's'  ,10111000B		;54     S
	DB	'd'  ,10111000B		;55     D
	DB	'f'  ,10111000B		;56     F
	DB	'g'  ,10111000B		;57     G
	DB	'h'  ,10111000B		;58     H
	DB	'j'  ,10111000B		;59     J
	DB	'k'  ,10111000B		;60     K
	DB	'l'  ,10111000B		;61     L
	DB	';'  ,10110000B		;62     ;:
	DB	027H ,10110000B		;63     quote/double quote
	DB	00DH ,10100000B		;64     RETURN
	DB	0D1H ,10100000B		;65     line/insert/char
	DB	0D3H ,10100000B		;66     line/delete/char
	DB	0bch ,10111000B		;67     4
	DB	0DDH ,10111000B		;68     5
	DB	0bdh ,10111000B		;69     6
	DB	003H ,11000000B		;70     Left-hand shift
	DB	'z'  ,10111000B		;71     Z
	DB	'x'  ,10111000B		;72     X
	DB	'c'  ,10111000B		;73     C
	DB	'v'  ,10111000B		;74     V
	DB	'b'  ,10111000B		;75     B
	DB	'n'  ,10111000B		;76     N
	DB	'm'  ,10111000B		;77     M
	DB	','  ,10110000B		;78     ,<
	DB	'.'  ,10110000B		;79     .>
	DB	'/'  ,10110000B		;80     /?
	DB	002H ,11000000B		;81     Right-hand shift
	DB	0C6H ,10100000B		;82     Up-Arrow
	DB	006H ,11000000B         ;83     Scroll Up-Down
	DB	0E4H ,10111000B		;84     1
	DB	0bbh ,10111000B		;85     2
	DB	0C8H ,10111000B		;86     3
	DB	01BH ,10100000B		;87     ESC
	DB	004H ,11000000B		;88     CONTROL
	DB	020H ,10100000B		;89     space
	DB	005H ,11000000B		;90     STOP
	DB	0E2H ,10100000B		;91     Left-Arrow
	DB	0C4H ,10100000B		;92     Down-Arrow
	DB	0C1H ,10100000B		;93     Right-Arrow
	DB	0d9h ,10100000B		;94     0
	DB	0dah ,10100000B		;95     .
	DB	0baH ,10000000B		;96     ENTER (f10)
	DB	0B5H ,10000000B		;97     F5 - VOICE/send
	DB	0BAH ,10000000B		;98     F10
	DB	009H ,11000000B		;99     ALT
	DB	'|'  ,10110000B		;100    pipe/tilde
	DB	00BH ,11000000B		;101    SYS REQ
	DB	00AH ,11000000B		;102    PRINT
	DB	000H ,11111000B		;103    spare7
	DB	000H ,11111000B		;104    spare8


        
;       shift values for keys
;	=====================        
        
	DB	0e7H ,10000000B		;1      F1/HELP
	DB	0e8H ,10000000B		;2      F2/UNDO
	DB	0e9H ,10000000B		;3      F3/REPEAT
	DB	0eaH ,10000000B		;4      F4/CALC
	DB	0ecH ,10000000B		;5      F6/PRINT
	DB	0edH ,10000000B		;6      F7/INTR
	DB	0eeH ,10000000B		;7      F8/MENU
	DB	0efH ,10000000B		;8      F9/FINISH
	DB	000H ,10100000B		;9      MB1
	DB	000H ,10100000B		;11     MB2
	DB	007  ,10100000B		;11     MB3
	DB	008  ,10100000B		;12     MB4
	DB	009  ,10100000B		;13     MB5
	DB	000  ,10100000B		;14     MB6
	DB	05EH ,10110000B		;15     \ uparrow
	DB	'!'  ,10110000B		;16     1!
	DB	'@'  ,10110000B		;17     2@
	DB	'#'  ,10110000B		;18     3#
	DB	156  ,10110000B		;19     4
	DB	25h  ,10110000B		;20     5 (percent)
	DB	'$'  ,10110000B		;21     6$
	DB	'&'  ,10110000B		;22     7&
	DB	'*'  ,10110000B		;23     8*
	DB	'('  ,10110000B		;24     9(
	DB	')'  ,10110000B		;25     0)
	DB	'_'  ,10110000B		;26     -_
	DB	'+'  ,10110000B		;27     =+
	DB	008H ,10100000B		;28     BS
	DB	'%'  ,10100000B		;29     percent 
	DB	0ah  ,11000000B		;30     * (print !!!! c.f. IBM)
	DB	'/'  ,10100000B		;31     DIVIDE
	DB	0DEH ,10100000B		;32     -
	DB	0DFH ,10100000B		;33     +
	DB	0e1H ,10100000B		;34     tab/backtab
	DB	'Q'  ,10111000B		;35     Q
	DB	'W'  ,10111000B		;36     W
	DB	'E'  ,10111000B		;37     E
	DB	'R'  ,10111000B		;38     R
	DB	'T'  ,10111000B		;39     T
	DB	'Y'  ,10111000B		;40     Y
	DB	'U'  ,10111000B		;41     U
	DB	'I'  ,10111000B		;42     I
	DB	'O'  ,10111000B		;43     O
	DB	'P'  ,10111000B		;44     P
	DB	'{'  ,10110000B		;45     [{
	DB	'}'  ,10110000B		;46     ]}
	DB	0D0H ,10000000B		;47     HOME - ESC 'H'
	DB	00cH ,11000000B		;48     CLEAR- ESC 'E'
	DB	'7'  ,10111000B		;49     7
	DB	'8'  ,10111000B		;50     8
	DB	0CCH ,10111000B		;51     9
	DB	001H ,11000000B		;52     CAPS LOCK
	DB	'A'  ,10111000B		;53     A
	DB	'S'  ,10111000B		;54     S
	DB	'D'  ,10111000B		;55     D
	DB	'F'  ,10111000B		;56     F
	DB	'G'  ,10111000B		;57     G
	DB	'H'  ,10111000B		;58     H
	DB	'J'  ,10111000B		;59     J
	DB	'K'  ,10111000B		;60     K
	DB	'L'  ,10111000B		;61     L
	DB	':'  ,10110000B		;62     ;:
	DB	022H ,10110000B		;63     quote/double quote
	DB	00DH ,10100000B		;64     RETURN
	DB	0D2H ,10100000B		;65     line/insert/char
	DB	0D4H ,10100000B		;66     line/delete/char
	DB	'4'  ,10111000B		;67     4
	DB	0DDH ,10111000B		;68     5
	DB	'6'  ,10111000B		;69     6
	DB	003H ,11111000B		;70     left-hand shift
	DB	'Z'  ,10111000B		;71     Z
	DB	'X'  ,10111000B		;72     X
	DB	'C'  ,10111000B		;73     C
	DB	'V'  ,10111000B		;74     V
	DB	'B'  ,10111000B		;75     B
	DB	'N'  ,10111000B		;76     N
	DB	'M'  ,10111000B		;77     M
	DB	'<'  ,10110000B		;78     ,<
	DB	'>'  ,10110000B		;79     .>
	DB	'?'  ,10110000B		;80     /?
	DB	002H ,11000000B		;81     right hand shift
        DB	0C7H ,10100000B		;82     Up-Arrow
	DB	006H ,11000000B		;83     Scroll Up-Down
	DB	0E5H ,10111000B		;84     1
	DB	'2'  ,10111000B		;85     2
	DB	0C9H ,10111000B		;86     3
	DB	01BH ,10100000B		;87     ESC
	DB	004H ,11000000B		;88     CONTROL
	DB	020H ,10100000B		;89     space
	DB	005H ,11000000B		;90     STOP
	DB	0E3H ,10100000B		;91     Left-Arrow
        Db	0C5H ,10100000B		;92     Down-Arrow
	DB	0C2H ,10100000B		;93     Right-Arrow
	DB	'0'  ,10100000B		;94     0
	DB	'.'  ,10100000B		;95     .
	DB	0f0H ,10000000B		;96     ENTER
	DB	0ebH ,10000000B		;97     F5 - VOICE/send
	DB	000H ,10000000B		;98     F10
	DB	009H ,11000000B		;99     ALT
	DB	'~'  ,10110000B		;100    pipe/tilde
	DB	00BH ,11000000B		;101    SYS REQ
	DB	00AH ,11000000B		;102    PRINT
	DB	000H ,11111000B		;103    spare7
	DB	000H ,11111000B		;104    spare8
        


;       Control values for keys
;	=======================        


	DB	0f1H ,10000000B		;1      F1/HELP
        DB	0f2H ,10000000B	        ;2      F2/UNDO
        DB	0f3H ,10000000B		;3      F3/REPEAT
        DB	0f4H ,10000000B		;4      F4/CALC
	DB	0f6H ,10000000B		;5      F6/PRINT
	DB	0f7H ,10000000B		;6      F7/INTR
	DB	0f8H ,10000000B		;7      F8/MENU
	DB	0f9H ,10000000B		;8      F9/FINISH
	DB	0H   ,10100000B		;9      MB1
	DB	00H  ,10100000B		;11     MB2
	DB	00H  ,10100000B		;11     MB3
	DB	00H  ,10100000B		;12     MB4
	DB	00H  ,10100000B		;13     MB5
	DB	00H  ,10100000B		;14     MB6
	DB	'\'  ,10110000B		;15     \ uparrow
	DB	172  ,10000000B		;16     1!
	DB	00H  ,10000000B		;17     2@
	DB	000H ,10000000B		;18     3#
	DB	157  ,10000000B		;19     4
	DB	248  ,10000000B		;20     5 percent
	DB	1EH  ,10000000B		;21     6$
	DB	'`'  ,10000000B		;22     7&
	DB	241  ,10000000B		;23     8*
	DB	'~'  ,10110000B		;24     9(
	DB	'|'  ,10110000B		;25     0)
	DB	'-'  ,10110000B		;26     -_
	DB	'='  ,10110000B		;27     =+
	DB	7FH  ,10100000B		;28     BS
	DB	25h  ,10100000B		;29     percent
	DB	'*'  ,10100000B		;30     *
	DB	'/'  ,10100000B		;31     DIVIDE
	DB	0DEH ,10100000B		;32     -
	DB	0DFH ,10100000B		;33     +
	DB	009H ,10100000B		;34     tab/backtab
	DB	011H ,10111000B         ;35     Q
	DB	017H ,10111000B         ;36     W
	DB	005H ,10111000B         ;37     E
	DB	012H ,10111000B         ;38     R
	DB	014H ,10111000B         ;39     T
	DB	019H ,10111000B         ;40     Y
	DB	015H ,10111000B         ;41     U
	DB	0e0H ,10111000B         ;42     I
	DB	00FH ,10111000B         ;43     O
	DB	010H ,10111000B         ;44     P
	DB	0d7H ,10110000B	 	;45     [{
	DB	01DH ,10110000B		;46     ]}
	DB	0ceH ,10000000B		;47     HOME - LOCAL ESC 'H'
	DB	000H ,10000100B		;48     CLEAR- LOCAL ESC 'z'
	DB	'7'  ,10100000B		;49     7
	DB	'8'  ,10100000B		;50     8
	DB	0CDH ,10100000B		;51     9
	DB	001H ,11000000B		;52     CAPS LOCK
	DB	01H  ,10111000B         ;53     A
	DB	13H  ,10111000B         ;54     S
	DB	04H  ,10111000B         ;55     D
	DB	06H  ,10111000B         ;56     F
	DB	07H  ,10111000B         ;57     G
	DB	0d8H ,10111000B         ;58     H
	DB	0AH  ,10111000B         ;59     J
	DB	0BH  ,10111000B         ;60     K
	DB	0CH  ,10111000B         ;61     L
	DB	';'  ,10110000B		;62     ;:
	DB	027H ,10110000B		;63     quote/double quote
	DB	00aH ,10100000B		;64     RETURN
	DB	00H  ,10100000B		;65     line/insert/char
	DB	00H  ,10100000B		;66     line/delete/char
	DB	'4'  ,10100000B		;67     4
	DB	'5'  ,10100000B		;68     5
	DB	1EH  ,10100000B		;69     6
	DB	003H ,11000000B		;70     left hand shift
	DB	01AH ,10111000B         ;71     Z
	DB	018H ,10111000B         ;72     X
	DB	003H ,10111000B         ;73     C
	DB	016H ,10111000B         ;74     V
	DB	002H ,10111000B         ;75     B
	DB	00EH ,10111000B         ;76     N
	DB	0dbH ,10111000B         ;77     M
	DB	','  ,10110000B		;78     ,<
	DB	'.'  ,10110000B		;79     .>
	DB	'/'  ,10110000B		;80     /?
	DB	002H ,11000000B		;81     right hand shift
        DW	CON_UP			;82     Up-Arrow
	DB	000H ,10000000B		;83     Scroll Up-Down
	DB	0e6h ,10100000B		;84     1
	DB	'2'  ,10100000B		;85     2
	DB	0CAH ,10100000B		;86     3
	DB	01BH ,10100000B		;87     ESC
	DB	004H ,11000000B		;88     CONTROL
	DB	020H ,10100000B		;89     space
	DB	005H ,11000000B		;90     STOP
        DB	0C0H ,10100000B		;91     Left-Arrow
        DW	CON_DN			;92     Down-Arrow
        DB	0C3H ,10100000B		;93     Right-Arrow
	DB	'0'  ,10100000B		;94     0
	DB	'.'  ,10100000B		;95     
	DB	0faH ,10000000B		;96     ENTER
	DB	0f5H ,10000000B		;97      F5 - VOICE/send
	DB	0baH ,10000000B		;98     F10
	DB	009H ,11000000B		;99     ALT
	DB	'~'  ,10110000B		;100    pipe/tilde
	DB	00BH ,11000000B		;101    SYS REQ
	DB	00AH ,11000000B		;102    PRINT
	DB	000H ,11111000B		;103    spare7
	DB	000H ,11111000B		;104    spare8
        

;       ALT values for keys
;	===================
       


	DB	0a6H ,10000000B		;1      F1/HELP
        DB	0a7H ,10000000B	        ;2      F2/UNDO
        DB	0a8H ,10000000B		;3      F3/REPEAT
        DB	0a9H ,10000000B		;4      F4/CALC
	DB	0abH ,10000000B		;5      F6/PRINT
	DB	0acH ,10000000B		;6      F7/INTR
	DB	0adH ,10000000B		;7      F8/MENU
	DB	0aeH ,10000000B		;8      F9/FINISH
	DB	0H   ,10100000B		;9      MB1
	DB	00H  ,10100000B		;11     MB2
	DB	00H  ,10100000B		;11     MB3
	DB	00H  ,10100000B		;12     MB4
	DB	00H  ,10100000B		;13     MB5
	DB	00H  ,10100000B		;14     MB6
	DB	'\'  ,10110000B		;15     \ uparrow
	DB	80h  ,10000000B		;16     1!
	DB	81H  ,10000000B		;17     2@
	DB	82H  ,10000000B		;18     3#
	DB	83h  ,10000000B		;19     4
	DB	84h  ,10000000B		;20     5 percent
	DB	85h  ,10000000B		;21     6$
	DB	86h  ,10000000B		;22     7&
	DB	87h  ,10000000B		;23     8*
	DB	88h  ,10110000B		;24     9(
	DB	89h  ,10110000B		;25     0)
	DB	8ah  ,10110000B		;26     -_
	DB	8bh  ,10110000B		;27     =+
	DB	7FH  ,10100000B		;28     BS
	DB	25h  ,10100000B		;29     percent
	DB	'*'  ,10100000B		;30     *
	DB	'/'  ,10100000B		;31     DIVIDE
	DB	0DEH ,10100000B		;32     -
	DB	0DFH ,10100000B		;33     +
	DB	00H  ,10100000B		;34     tab/backtab
	DB	'Q'+4BH ,10111000B      ;35     Q
	DB	'W'+4BH ,10111000B      ;36     W
	DB	'E'+4BH ,10111000B      ;37     E
	DB	'R'+4BH ,10111000B      ;38     R
	DB	'T'+4BH ,10111000B      ;39     T
	DB	'Y'+4BH ,10111000B      ;40     Y
	DB	'U'+4BH ,10111000B      ;41     U
	DB	'I'+4BH ,10111000B      ;42     I
	DB	'O'+4BH ,10111000B      ;43     O
	DB	'P'+4BH ,10111000B      ;44     P
	DB	0D7H ,10110000B		;45     [{
	DB	01DH ,10110000B		;46     ]}
	DB	00H  ,10000100B		;47     HOME - LOCAL ESC 'H'
	DB	00H  ,10000100B		;48     CLEAR- LOCAL ESC 'z'
	DB	0f7h ,11000000B		;49     7
	DB	0f8h ,11000000B		;50     8
	DB	0f9h ,11000000B		;51     9
	DB	001H ,11000000B		;52     CAPS LOCK
	DB	'A'+4BH ,10111000B      ;53     A
	DB	'S'+4BH ,10111000B      ;54     S
	DB	'D'+4BH ,10111000B      ;55     D
	DB	'F'+4BH ,10111000B      ;56     F
	DB	'G'+4BH ,10111000B      ;57     G
	DB	'H'+4BH ,10111000B      ;58     H
	DB	'J'+4BH ,10111000B      ;59     J
	DB	'K'+4BH ,10111000B      ;60     K
	DB	'L'+4BH ,10111000B      ;61     L
	DB	';'  ,10110000B		;62     ;:
	DB	027H ,10110000B		;63     quote/double quote
	DB	00DH ,10100000B		;64     RETURN
	DB	00H  ,10100000B		;65     line/insert/char
	DB	00H  ,10100000B		;66     line/delete/char
	DB	0f4h ,11000000B		;67     4
	DB	0f5h ,11000000B		;68     5
	DB	0f6h ,11000000B		;69     6
	DB	003H ,11000000B		;70     left hand shift
	DB	'Z'+4BH ,10111000B      ;71     Z
	DB	'X'+4BH ,10111000B      ;72     X
	DB	'C'+4BH ,10111000B      ;73     C
	DB	'V'+4BH ,10111000B      ;74     V
	DB	'B'+4BH ,10111000B      ;75     B
	DB	'N'+4BH ,10111000B      ;76     N
	DB	'M'+4BH ,10111000B      ;77     M
	DB	','  ,10110000B		;78     ,<
	DB	'.'  ,10110000B		;79     .>
	DB	'/'  ,10110000B		;80     /?
	DB	002H ,11000000B		;81     right hand shift
        DB	00H  ,10000000B		;82     Up-Arrow
	DB	000H ,10000000B		;83     Scroll Up-Down
	DB	0f1h ,11000000B		;84     1
	DB	0f2h ,11000000B		;85     2
	DB	0f3h ,11000000B		;86     3
	DB	01BH ,10100000B		;87     ESC
	DB	004H ,11000000B		;88     CONTROL
	DB	020H ,10100000B		;89     space
	DB	005H ,11000000B		;90     STOP
        DB	0C0H ,10100000B		;91     Left-Arrow
        DB	0H   ,10100000B		;92     Down-Arrow
        DB	0C3H ,10100000B		;93     Right-Arrow
	DB	0f0h ,11000000B		;94     0
	DB	'.'  ,10100000B		;95     
	DB	0afH ,10000000B		;96     ENTER
	DB	0aaH ,10000000B		;97      F5 - VOICE/send
	DB	0baH ,10000000B		;98     F10
	DB	009H ,11000000B		;99     ALT
	DB	'~'  ,10110000B		;100    pipe/tilde
	DB	00BH ,11000000B		;101    SYS REQ
	DB	00AH ,11000000B		;102    PRINT
	DB	000H ,11111000B		;103    spare7
	DB	000H ,11111000B		;104    spare8
        


;	0Block reserved for Default String tables. (192 BYTES)
;	=====================================================

CON_UP	DB	3,10100100B,27,'y','E'
CON_DN	DB	3,10100100B,27,'x','E'
SCR_UP	DB	3,10000100B,27,'y','D'
SCR_DN	DB	3,10000100B,27,'x','D'
SND_UP	DB	3,10100100B,27,'y','F'
SND_DN	DB	3,10100100B,27,'x','F'

lcd	DB	3,10100100b,27,'7','L'
col	DB	3,10100100b,27,'7','C'
c40	DB	3,10100100b,27,'7','F'
bth	DB	3,10100100b,27,'7','B'
 
	DB	(192-50) dup (0)

;***********	KEYBOARD TABLE ENDS		*********

ENDBYTE	DB	'THE END'		; THIS MUST BE LAST BIT
;					  OF DATA YOU WISH TO KEEP
DATA	ENDS
;
;*****************************************************************************
; - END OF SAUCE FILE EMIBM.ASM
;*****************************************************************************
		END
;****************************************
