PAGE	50, 132
;************************************************************************
;*									*
;*	EMIBM.ASM							*
;*									*
;*	<C> Apricot Advanced Technology Ltd 1985			*
;*	Initial version  Jonathan Mackenzie 08-06-85			*
;*									*
;*	Version : 1.5.0							*
;*									*
;*	Modification history:						*
;*				15/7/85 num pad + and - keys swapped	*
;*				ver 1.1 issued				*
;*				15/7/85 int F1 and int 29 now not	*
;*				connected. Should be able to run	*
;*				Apricot applications without unload	*
;*				ver 1.2 issued				*
;*				17/7/85 bug in int 17 'report status'	*
;*				fixed. Ver 1.3 issued			*
;*				22/8/85 int 16 func 1 crash fixed	*
;*				ver 1.3.1 issued			*
;*									*
;*		22/9/85							*
;*		Int 14 now correctly sets bit 7 as			*
;*		error code ( bug 318/7 )				*
;*		Also see QA report 318					*
;*		Ver 1.3.2 issued 3/10/85				*
;*		29/10/85						*
;*		Int 16 function 0, return next keypress, now handles	*
;*		the full gem keyboard table for foreign countries	*
;*									*
;*		13/11/85		Afzal Raja                      *
;*		Display NUMLOCK on the microscreen                      *
;*		and toggle the led                                      *
;*                                                                      *
;*		11/12/85		Afzal Raja			*
;*		Changed to run as a SHELL.				*
;*									*
;*		16/12/85						*
;*		added support for 80x25 colour mode			*
;*									*
;*		27/08/86						*
;*		File split into three and tidied up			*
;*									*
;************************************************************************
;
;========================================================================
; SPECIAL SECTION - define linker ordering for .com/exe file
;========================================================================

PGROUP	GROUP	BASE, PROG, TAIL
DGROUP	GROUP	DATA, STACK
ASSUME	CS:PGROUP

;	Force 'pgroup' lower in memory
BASE	SEGMENT	BYTE	PUBLIC	'PROG'
BASE	ENDS

;	Define dummy data seg
DATA	SEGMENT	PUBLIC	'DATA'
DATA	ENDS

;	Define a noddy stack segment
STACK	SEGMENT	'DATA'
SBASE	DW	128 DUP (?)
STACK	ENDS

;	Define noddy prog seg to force tail last in pgroup
PROG	SEGMENT	BYTE	PUBLIC	'PROG'
PROG	ENDS

;	Define tail seg to allow calc of end offset
TAIL	SEGMENT	BYTE	'STACK'
LAST	DB	0
TAIL	ENDS
;
;===========================================================================
; END OF SPECIAL SECTION
;===========================================================================

;******************** PROGRAM CODE EQUATES ****************

SCR_DRV		EQU	0ECh
FEATURES	EQU	6

PAGE

;===========================================================================
; PROGRAM CODE SECTION
;===========================================================================

PROG	SEGMENT	BYTE	PUBLIC	'PROG'

EXTRN		PSPADDR:WORD,CNF_S_BIOS:BYTE,KEY_SEG:WORD,KEY_OFSET:WORD
EXTRN		INT_10:NEAR,INT10_SAV:DWORD

;=============================================================================
;= emibm
;=============================================================================
;JOB	This is the main EMIBM.EXE routine
;ACTION
;-----------------------------------------------------------------------------
;INPUT		:	CS = code seg
;			DS = psp
;			ES = psp
;			SS = code seg
;OUTPUT		:	'errorlevel' return code is always zero
;ERRORS		:	Displays error messages by screen driver calls.
;REG USE	:	just about everything
;STACK USE	:	SP started at 7FFF if enough room, else memtop
;=============================================================================

ASSUME	CS:PGROUP, DS:DGROUP

EMIBM	PROC	FAR
	PUBLIC	EMIBM
	JMP	SHORT	B10			; jump over our signature

	DB	'EMIBM'				; program signature
DS_SAV	DW	0				; saved value of DS
PUBLIC	DS_SAV
						; Set the runtime environment
B10:	CLI					; stop interrupts
	MOV	AX, DGROUP
	MOV	DS, AX				; set the DS reg
	MOV	SS, AX				; likewise for SS

	MOV	AX, OFFSET PGROUP:LAST		; offset of last byte
	ADD	AX, 16				; add 16 bytes
	MOV	CL, 4				; round down to paras
	SHR	AX, CL				; no. of paras in pgroup
	MOV	BX, CS				; get ready for the maths
	ADD	AX, BX				; base of dgroup = CS + proglen

	MOV	BX, ES:2			; para size of alloc blk
	SUB	BX, AX				; subtract what we've used
	TEST	BX, 0F700h			; more than 32K avail ?
	JNZ	B20				; yes, jump
	MOV	CL, 4				; no, xlat paras to bytes
	SHL	BX, CL				; highest avail byte for SP
	JMP	SHORT	B30			;
B20:	MOV	BX, 7FF0h			; set a 32 k data seg
B30:	MOV	SP, BX				; init stack pointer
	STI					; .. now we can be stopped
				; place psp address in int 10 handler
	MOV	AX, ES				; es to ax
	MOV	CS:PSPADDR, AX			; and save it
				; save the value of this DS
	MOV	AX, DS				; ds to ax
	MOV	CS:DS_SAV, AX			; .. and save it
				; analyze command line parms
	CALL	CHK_PARMS			; check cmnd line parms
	MOV	DS:COM_PARM, AL			; store result code
	CMP	AL, 1				; no parms ?
	JBE	B110				; yes, go do rest of load
B40:	CMP	AL, 3				; or 'verbose' typed ?
	JE	B110				; yes, do rest of load
B50:	CMP	AL, 2				; was 'no' typed ?
	JE	B100				; yes, try and unload
B60:	MOV	DX, OFFSET DGROUP: HD$		; version header
	CALL	PRT_MSG				; print it
	MOV	DX, OFFSET DGROUP: US$		; 'wrong usage' message
	CALL	PRT_MSG				; print it
	JMP	B1999				; and exit saving nothing
B100:				; 'no' handler ( unload )
	CALL	UNLOAD				;
	JMP	B1999				; and quit
B110:				; continue here for load / verbose
				; verbose option is for the moment ignored - it
				; is meant to print out the level of support the
				; emulator will give to an IBM application.
				; check to see we are not already loaded
	CALL	CHK_LOAD			; inspect int 10h vector code
	CMP	AX, 0				; is nothing there ?
	JZ	B120				; nothing, continue
	MOV	DX, OFFSET DGROUP: HD$		; else, 'emibm error'
	CALL	PRT_MSG				; print it
	MOV	DX, OFFSET DGROUP: IN$		; 'already here'
	CALL	PRT_MSG				; print it
	JMP	B1999				; terminate completely
B120:				; ... CHECK THE BIOS VERSION NUMBER !!!!!
				; ( early bios's don't support RS232 errs )
				; establish screen format structure pointers
	MOV	CL, 0				; 'format enquiry' code
	MOV	CH, 0				; screen id always 0 ?
	MOV	DL, 2				; extended format request
	INT	SCR_DRV				; call int ECh
	MOV	DS:FTAB_SEG, DX			; seg addr of format struc
	MOV	DS:FTAB_OFFS, SI		; offs addr of format struc
				; reset screen ( for int 10 handler )
	MOV	CL, 1				; 'enable screen' code
	MOV	CH, 0				; screen id
	MOV	BL, 0				; format number
	MOV	BH, 01				; primary font, IBM mono
	MOV	DS:MODE,BH
	INC	DS:MODE
	MOV	DX, 0				; set virtual image address
	MOV	SI, 0				; = 0:0 ( use default )
	INT	SCR_DRV				; do it
	MOV	DS:IMAGE_ID, DX			; save image id
	MOV	DI,DX
	MOV	DX,DS
	MOV	SI,OFFSET DGROUP:PALET
	MOV	AX,0101H
	MOV	CX,0FH
	INT	SCR_DRV
				; print the sign-on message
	MOV	DX, OFFSET DGROUP: HD$		;
	CALL	PRT_MSG				;
	MOV	DX, OFFSET DGROUP: HI$		;
	CALL	PRT_MSG				;
				; kill cursor positioning by the int F1 handler
	MOV	AL, 27				; 'ESC'
	INT	0F1h				;
	MOV	AL, 'x'				; 'x'
	INT	0F1h				;
	MOV	AL, '5'				; '5'
	INT	0F1h				;
				; set bios kbd drvr into mode locking
	MOV	BX, 32h				; 'keyboard' code
	MOV	CX, 10h				; mode locking
	MOV	DX, 1				; turn it on
	INT	0FCh				; call the bios
				; connect the int 10h vector
	MOV	DI, OFFSET PGROUP: INT10_SAV	; point to vector storage
	MOV	AL, 10h				; vector number to get
	MOV	DX, OFFSET PGROUP: INT_10	; DS:DX = addr int_10
	CALL	CON_VEC				;
				; connect the int 14h vector
	MOV	DI, OFFSET PGROUP: INT14_SAV	;
	MOV	AL, 14h				;
	MOV	DX, OFFSET PGROUP: INT_14	;
	CALL	CON_VEC				;
				; connect the int 16h vector
	MOV	DI, OFFSET PGROUP: INT16_SAV	; point to vector storage
	MOV	AL, 16h				; vector number to get
	MOV	DX, OFFSET PGROUP: INT_16	; DS:DX = addr int_16
	CALL	CON_VEC				;
				; connect the int 17h vector
	MOV	DI, OFFSET PGROUP: INT17_SAV	; point to vector storage
	MOV	AL, 17h				; vector number to get
	MOV	DX, OFFSET PGROUP: INT_17	; DS:DX = addr int_17
	CALL	CON_VEC				;
				; connect the int 1Ah vector
	MOV	DI, OFFSET PGROUP: INT1A_SAV	;
	MOV	AL, 1Ah				;
	MOV	DX, OFFSET PGROUP: INT_1A	;
	CALL	CON_VEC				;
				; connect the int 29h routine
	MOV	DI, OFFSET PGROUP: INT29_SAV	;
	MOV	AL, 29h				;
	MOV	DX, OFFSET PGROUP: INT_29	;
	CALL	CON_VEC				;
				; connect the int E6 vector
	MOV	DI, OFFSET PGROUP: INTE6_SAV	; point to vector storage
	MOV	AL, 0E6h			; vector number to get
	MOV	DX, OFFSET PGROUP: INT_E6	; DS:DX = addr int_E6
	CALL	CON_VEC				;
				; connect the int F1 routine
	MOV	DI, OFFSET PGROUP: INTF1_SAV	;
	MOV	AL, 0F1h			;
	MOV	DX, OFFSET PGROUP: INT_F1	;
	CALL	CON_VEC				;
				; connect the int F9h vector
	MOV	DI, OFFSET PGROUP: INTF9_SAV	; point to vector storage
	MOV	AL, 0F9h			; vector number to get
	MOV	DX, OFFSET PGROUP: INT_F9	; DS:DX = addr int_F9
	CALL	CON_VEC				;
				; connect the int FCh vector
	MOV	DI, OFFSET PGROUP: INTFC_SAV	; point to vector storage
	MOV	AL, 0FCh			; vector number to get
	MOV	DX, OFFSET PGROUP: INT_FC	; DS:DX = addr int_FC
	CALL	CON_VEC				;
				; connect the int FFh vector
	MOV	DI, OFFSET PGROUP: INTFF_SAV	; point to vector storage
	MOV	AL, 0FFh			; vector number to get
	MOV	DX, OFFSET PGROUP: INT_FF	; DS:DX = addr int_FF
	CALL	CON_VEC				;

	XOR	AX, AX				;
	MOV	ES, AX				; set ES = 0
	MOV	AX,ES:[712H]			; GET CURRENT KEYBOARD OFFSET
	MOV	CS:KEY_OFSET,AX
	MOV	AX,ES:[714H]			; GET SEGMENT
	MOV	CS:KEY_SEG,AX
	MOV	AX,OFFSET DGROUP:IBMKEY
	MOV	ES:[712H],AX
	MOV	ES:[714H],DS
				; Checkout the machine type. This is a good point
				; to do machine specific initialisation, so the next
				; bit is the long way round to cope with expasnsion.
	MOV	AL, ES:[401h]			; get the machine type byte
	CMP	AL, 3				; is it a XEN ?
	JNZ	B130				; no, default then
	MOV	WORD PTR DS:[TIMEOUT], 19	; set RS232 timeout counter for XEN
	JMP	SHORT B200			;
B130:
	MOV	WORD PTR DS:[TIMEOUT], 9	; set RS232 timeout couter for lesser beasts
B200:				; Save the CNF_s_bioserr byte ( for serial comms )
	MOV	DI, ES:[700h]			; ptr offs to DI
	MOV	BX, ES:[702h]			; ptr seg to BX
	MOV	ES, BX				; ES:DI -> bios config table
	MOV	AL, ES:[DI+42h]			; AL = CNF_s_bioserr
	MOV	CS:[CNF_S_BIOS], AL		; save it
				; set up the sound driver for int 10 handler
	MOV	BX, 38h				; control device code
	MOV	CX, 0				; init sound driver
	INT	0FCh				; do it
				; set the initial cursor position to 23,0
	MOV	AX, 1700h			;
	MOV	DS:C_ROWY, AH			;
	MOV	DS:C_COLX, AL			;
	MOV	CS:INT16_FLAG,0
	MOV	CS:SCAN_CODE,0
	MOV	CS:SCAN_FLAG,0
;patch the keyboard table if PC/XI
	push	es
	push	si
	mov	si,offset numesc2		;not xi default
	xor	ax,ax
	mov	es,ax
	cmp	es:[401h],al			;is it an XI
	jne	not_xi				;no......
				; Display F9 F10 NUMLOCK on the microscreen
	mov	ax,ds
	mov	es,ax
	mov	si,offset xisp			; xi source patch
	mov	di,offset xidp			; xi patch destination
	lodsw					; get count at start of source
	mov	cx,ax				; count to cx
	rep	movsw				; patch 
	mov	si,offset numesc
	inc	xiflag				; say on PC/XI
not_xi:	MOV	BX,33H				; microscreen
	MOV	CX,1				; print char
	CALL	FC_ESC
	POP	SI
	pop	es
					; terminate & stay resident exit point
	MOV	DX,TAIL				; *MP*
	INC	DX				; *MP*
	MOV	BX, CS:PSPADDR			; lowest seg addr of code
	SUB	DX, BX				; len = end-start ( in paras )
	CMP	DS:COM_PARM,0			; Any parms
	JNE	TERMI_NATE			; No
	PUSH	BX
	PUSH	DX
	MOV	ES,BX
	MOV	BX,DX
	MOV	AH,4AH
	INT	21H
	POP	DX
	POP	BX
	JC	DISP_EROR
	MOV	DX,OFFSET DGROUP:PATH_NAME	; Get path name address
	MOV	DS:SEG1,BX
	MOV	DS:SEG2,BX
	MOV	DS:SEG3,BX
	MOV	BX,DS
	MOV	ES,BX
	MOV	BX,OFFSET DGROUP:PARMS_BLOCK
	MOV	AX,4B00h
	INT	21H
	JNC	DONE_IT
	CMP	AL,2
	JNE	DISP_EROR
	MOV	SI,OFFSET DGROUP:PATH_NAME
	MOV	CL,DS:PATH_LENTH
	XOR	CH,CH
	ADD	SI,CX
	MOV	BYTE PTR [SI],'E'
	INC	SI
	MOV	BYTE PTR [SI],'X'
	INC	SI
	MOV	BYTE PTR [SI],'E'
	MOV	BX,DS
	MOV	ES,BX
	MOV	DX,OFFSET DGROUP:PATH_NAME	; Get path name address
	MOV	BX,OFFSET DGROUP:PARMS_BLOCK
	MOV	AX,4B00h
	INT	21H
	JNC	DONE_IT
DISP_EROR:
	MOV	DX,OFFSET DGROUP:FILE_EROR
	CMP	AL,2
	JE	DISPIT
	MOV	DX,OFFSET DGROUP:OTHER_EROR
DISPIT:
	CALL	PRT_MSG
	MOV	DX,OFFSET DGROUP:OTHER_HALF
	CALL	PRT_MSG
DONE_IT:
	CALL	UNLOAD
	JMP	SHORT B1999
TERMI_NATE:
	MOV	AH, 31h				; 'keep process' code
	MOV	AL, 0				; errorlevel = 0
	INT	21h				; au revior........

;======================= debug exit point ========================
; exit leaving binary value in AL as a char on the screen for
; debug purposes. Not normally used.
B999:
	MOV	DL, AL
	ADD	DL, 30h		; conv to printable
	MOV	AH, 2		; temp. print
	INT	21h
;===================  terminate non-resident exit point  ====================
B1999:
	MOV	AL, 0
	MOV	AH, 4Ch				; terminate completely
	INT	21h
EMIBM	ENDP

PAGE

;=============================================================================
;= int_14		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;INPUT		:	AH = 0	Initialise RS232 port
;				AL = parms as follows :
;		bits 5,6,7 = baud rate
;		000b = 110 baud		100b = 1200 baud
;		001b = 150 baud		101b = 2400 baud
;		010b = 300 baud		110b = 4800 baud
;		011b = 600 baud		111b = 9600 baud
;
;		bits 4,3 = parity
;		X0b = none	01b = odd	11b = even
;
;		bit 2 = no of stopbits
;		0b = 1 stopbit		1b = 2 stopbits
;
;		bits 1,0 = char length
;		10b = 7 bits		11b = 8 bits
;
;			AH = 1	transmit char over serial line
;				char is in AL ( preserved ). On exit bit 7
;				of AH is set if unable to xmit. If bit 7 is
;				clear then rest of bits reflect normal status
;
;			AH = 2	receive char from comms line ( wait )
;				char is returned in AL. On exit AH contains
;				either bit 7 on, which indicates an error,
;				or the current status, except that the only
;				bits left on are the error bits ( 1,2,3,4,7,).
;			AH = 3 return comms line status in AX
;				AH = line status as follows :
;					bit 7 = time out or general err
;					bit 6 = tx reg empty
;					bit 5 = tx buf empty
;					bit 4 = break detect
;					bit 3 = framing error
;					bit 2 = parity error
;					bit 1 = overrun error
;					bit 0 = rx data avail
;				AL ( modem status )
;					bits 4 & 5 supported
;=============================================================================
INT_14	PROC	NEAR
	PUBLIC	INT_14
	JMP	SHORT	IS10
INT14_SAV	DD	0
IS10:	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DS
	PUSH	ES
	PUSH	DI
	MOV	DS, CS:DS_SAV			;
	CMP	AH, 0				; initialise port ?
	JZ	IS20				; yes, do that
	JMP	IS100				; no, try next
 IS20:				; initialise the serial port
	MOV	DS:TEMP1, AX			; save call parms
	MOV	BX, 34h				; 'serial' code
	MOV	CX, 0				;
	INT	0FCh				; init the serial driver
				; xlat IBM baud code to Apricot baud code
	MOV	AX, DS:TEMP1			; retrieve call parms
	XOR	AH, AH				; ensure AH is 0
	MOV	CL, 5				; bits to lose
	SHR	AL, CL				; now in range 0-7
	MOV	BX, OFFSET DGROUP: BAUD_TAB	; start of xlat table
	ADD	BX, AX				; add offs for our rate
	XOR	DX, DX				; DH = 0
	MOV	DL, DS:[BX]			; get the value
				; set transmit baud rate ( in DX )
	MOV	BX, 34h				; 'serial' code
	MOV	CX, 4				; set xmit baud rate
	INT	0FCh				; do it
				; set receive baud rate ( still in DX )
	INC	CX				; CX = 5 ( set rx baud )
	INT	0FCh				; do it
				; set bits per character
	MOV	AX, DS:TEMP1			; retrive call parms
	AND	AL, 3				; lose all but bits 0,1
	MOV	DX, 8				; set default of 8 bits
	CMP	AL, 2				; 7 bit chars ?
	JNZ	IS30				; no, as you were
	MOV	DX, 7				; else set seven
IS30:	MOV	BX, 34h				; 'serial' code
	MOV	CX, 6				; set xmit bits per char
	INT	0FCh				; do it
	MOV	CX, 7				; set rx bits per char
	INT	0FCh				; do it
				; set number of stop bits
	MOV	AX, DS:TEMP1			; retrive parms
	AND	AL, 04h				; lose all but bit 2
	MOV	CL, 2				; bits to shift
	SHR	AL, CL				; 0=1, 1 = 2 stopbits
	MOV	DX, 1				; set 1 stopbit as default
	CMP	AL, 0				; do we need 2 stopbits ?
	JZ	IS40				; no, that's it
	MOV	DX, 3				; else set 2 stopbits
IS40:	MOV	BX, 34h				; 'serial' code
	MOV	CX, 8				; 'set stopbits' code
	INT	0FCh				; do it
				; set parity
	MOV	AX, DS:TEMP1			; retrive parms
	AND	AL, 18h				; get bits 3,4
	MOV	CL, 3				; bits to shift
	SHR	AL, CL				; AX = 0-3
	MOV	DX, 2				; set even parity initially
	CMP	AL, 2				; AL is 0,1 or 3
	JA	IS50				; it was 3, so quit
	MOV	DL, AL				; else parity is direct xlat
IS50:	MOV	BX, 34h				; 'serial' code
	MOV	CX, 9				; 'set parity' code
	INT	0FCh				; do it
				; update the sio
	MOV	CX, 3				; 'update' code
	INT	0FCh				; do it
				; Set the CNF_s_bioserr byte to 1 ( disable bios retries )
	XOR	BX, BX				;
	MOV	ES, BX				; set ES = 0
	MOV	DI, WORD PTR ES:[700h]		; ptr offs to DI
	MOV	BX, WORD PTR ES:[702h]		; ptr seg to BX
	MOV	ES, BX				; ES:DI -> bios config table
	MOV	BH, 1				;
	MOV	ES:[DI+42h], BH			; CNF_s_bioserr = 1
	JMP	IS500				;
IS100:
	CMP	AH, 1				; transmit a char ?
	JZ	IS110				; yes, do that
	JMP	IS200				; no, try next
IS110:				; transmit a character
	MOV	DL, AL				; swap char to DL
	XOR	AH, AH				; start with zero retcode
	MOV	BX, 34h				; 'serial' code
	MOV	CX, 1				; 'xmit char' code
	INT	0FCh				; do it
	CMP	AX, 0				; did it go ?
	JZ	IS120				; yes, it did
	MOV	AH, 80h				; else set bit 7 of AH ( err )
IS120:	MOV	AL, DL				; replace xmit char
	JMP	IS500
IS200:
	CMP	AH, 2				; receive a character ?
	JZ	IS210				; yes, do that
	JMP	IS300				; no, try next
IS210:				; receive a character
	MOV	AX, DS:[TIMEOUT]		; get the timeout counter
	MOV	DS:TEMP4, AX			; and set it as outer loop
IS215:	MOV	DS:TEMP3, 1999h			; set inner loop timeout
	MOV	BX, 34h				; 'serial' code
	MOV	CX, 2				; 'rx char' code
IS220:	INT	0FCh				; do it
	CMP	AH, 0				; did we get one ?
	JNZ	IS230				; no, try for timeout
	JMP	IS500				; yes, just quit
IS230:	DEC	DS:TEMP3			; reduce timeout inner loop
	JNZ	IS220				; loop back if not zero
	DEC	DS:TEMP4			; dec outer loop counter
	JNZ	IS215				; loop back if not zero
	MOV	AH, 80h				; set error code
	JMP	IS500				; .. and quit
IS300:
	CMP	AH, 3				; return comms line status ?
	JZ	IS310				; yes, do that
	JMP	IS500				; just quit then
IS310:				; return comms line status
	XOR	DX, DX				; start retcode at zero
	MOV	BX, 34h				; 'serial' code
	MOV	CX, 01Bh			; 'lookahead' code
	INT	0FCh				; do it
	CMP	AH, 0				; anything there ?
	JNZ	IS320				; no, skip
	OR	DX, 0100h			; set 'rx avail' bit
IS320:	MOV	CX, 12h				; 'dsr status' code
	INT	0FCh				; do it
	CMP	AX, 0				; dsr bit = 1 ?
	JZ	IS330				; no, skip
	OR	DX, 0020h			; set dsr bit in retcode
IS330:	MOV	CX, 10h				; 'cts status' code
	INT	0FCh				; do it
	CMP	AX, 0				; cts bit = 1 ?
	JZ	IS340				; no, skip
	OR	DX, 0010h			; set cts bit in retcode
IS340:
	MOV	AX, DX				; swap to true retcode
IS500:				; common exit point here
	POP	DI
	POP	ES
	POP	DS
	POP	DX
	POP	CX
	POP	BX
	IRET
INT_14	ENDP

PAGE

;=============================================================================
;= int_16		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		keyboard
;ACTION		This handler modified 29/10/85 to perform foreign language
;		support. It is designed to use the GEM keyboard tables which
;		prefix characters with escape if it is desired to add 80h
;		to the key code.
;-----------------------------------------------------------------------------
;INPUT		:	AH = 0	read next ascii char struck from kbd.
;				result in AL, scan code in AH
;			AH = 1	set Z flag to indicate if an ascii char
;				is available to be read.
;				ZF = 1 no code available
;				ZF = 0 code is available
;			AH = 2	return current shift status in AL
;				bit 7 = ins state
;				bit 6 = caps state
;				bit 5 = num state
;				bit 4 = scroll state
;				bit 3 = alt_shift
;				bit 2 = ctrl_shift
;				bit 1 = left_shift
;				bit 0 = right_shift
;=============================================================================

INT_16	PROC	NEAR
	PUBLIC	INT_16
	JMP	SHORT	IK10
INT16_SAV	DD	0
IK10:	PUSH	BX
	PUSH	CX
	PUSH	DX
	CMP	AH, 2				; is it status enquiry ?
	JZ	IK20				; yes, do that
	JMP	IK100				; else try next
				; return current shift status in AL
IK20:	MOV	BX, 32h				; point to keyboard
	MOV	CX, 0Fh				; 'get status' code
	MOV	DX, 0FF00h			; return it unaffected
	INT	0FCh				; get that status
	MOV	BL, 0				; target status byte
	TEST	AX, 0800h			; was right shift on ?
	JZ	IK25				; no
	OR	BL, 1				; set right shift bit
IK25:	TEST	AX, 0100h			; was left shift key on ?
	JZ	IK30				; no
	OR	BL, 2				; set left shift bit
IK30:	TEST	AX, 0200h			; was ctrl key on ?
	JZ	IK35				; no
	OR	BL, 4				; set ctrl bit
IK35:	TEST	AX, 0400h			; was alt key on ?
	JZ	IK40				; no
	OR	BL, 8				; set alt key bit
IK40:	TEST	AX, 2				; was stop key on ?
	JZ	IK45				; no
	OR	BL, 16				; set stop bit
IK45:	TEST	AX, 0080h			; was caps lock on ?
	JZ	IK50				; no
	OR	BL, 64				; set caps lock bit
IK50:	MOV	AH, 2				; replace the call code
	MOV	AL, BL				; return status in AL
	JMP	IK300				; .. and quit

IK100:	CMP	AH, 1		; set Z flag if char is available
	JNZ	IK200				;
	PUSH	BP				; save BP
	MOV	BP, SP				;
	MOV	BX, 32h				; 'keyboard' code
	MOV	CX, 0Ch				; look ahead
	MOV	CS:INT16_FLAG,0FFH
	MOV	CS:SCAN_FLAG,0
	INT	0FCh				;
	CMP	AH, 0				; anything there ?
	JZ	IK110				; yes, got one
	OR	WORD PTR [BP+12], 0040h		; turn ZF to 1 on stack
	POP	BP				; restore caller's BP
	JMP	IK300				; and quit
IK110:	AND	WORD PTR [BP+12], 0FFBFh	; turn ZF to 0 on stack
	POP	BP				; restore caller's BP
	JMP	IK250				; quit through xlat routine

IK200:	CMP	AH, 0				;
	JNZ	IK300				; call code no good
			; return next char in AL ( wait if needed ). This
			; now has foreign lang. support. Here are the rules.
			; If the key is alone then xlat, quit.
			; If the key is preceeded by esc then substitute 'A'
			; scancode in AH, leave AL unchanged.	
			; poll int FC until we get a key
	MOV	BX, 32h				; 'keyboard' code
	MOV	CX, 0Ah				; return no of keys in buffer
IK210:	INT	0FCh				; 
	OR	AX, AX				; any keys in buffer ?
	JZ	IK210				; nope, wait in a loop
				; dropthru if at least 1 key in buffer
	MOV	CS:INT16_FLAG,0FFH
	MOV	CS:SCAN_FLAG,0
	CMP	AX, 1				; just one key ?
	JZ	IK240				; yes, go get it
				; more that one key, check for esc-n combinations
	MOV	CX, 0Bh				; get key from buffer
	INT	0FCh				;
	CMP	AL, 27				; esc ?
	JNZ	IK250				; no, xlat normally
	INT	0FCh				; yes, get next key
	CMP	AL, 27				; another 'esc' ?
	JZ	IK250				; yes, eat the first esc & treat the second normally
	MOV	AH, 1Eh				; else give the char an innocuous scan code
	JMP	SHORT IK300			; and return the untranslated ascii
IK240:	MOV	CX, 0Bh				; get key from buffer
	INT	0FCh				;
IK250:				; dropthru here to xlat a 'normal' key
	PUSH	DS				; save orig DS
	MOV	DS, CS:DS_SAV			; .. and make it ours
	MOV	BX, OFFSET DGROUP:KEY_XLAT_TAB	; get start of table
	XOR	AH, AH				; clear the high byte
	SHL	AX, 1				; *2 for words
	ADD	BX, AX				; add to offset
	MOV	AX, [BX]			; get scan code & ascii
	POP	DS				; restore caller's DS
IK300:
	POP	DX
	POP	CX
	POP	BX
	MOV	CS:INT16_FLAG,0
	IRET
INT_16	ENDP

PAGE

;=============================================================================
;= int_17		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;INPUT		:	AH = 0 ( print char )
;			AL = char to print.
;OUTPUT		:	status and/or error code in AH. AL preserved
;INPUT		:	AH = 1 ( initialise printer port )
;OUTPUT		:	AH returns printer status
;INPUT		:	AH = 2 ( read printer status )
;OUTPUT		:	AH returns printer status
;=============================================================================

INT_17	PROC	NEAR
	PUBLIC	INT_17
	JMP	SHORT	IP10
INT17_SAV	DD	0
IP10:	PUSH	BX
	PUSH	CX
	PUSH	DX
	CMP	AH, 0				; print char ?
	JNZ	IP30				; no, try next
	MOV	BX, 35h				; control device - printer
	MOV	CX, 7				; print char code
	MOV	DL, AL				; move char to DL
	INT	0FCh				; print that char
	CMP	AX, 0				; any errors ?
	JZ	IP20				; no, continue
	MOV	AH, 19h				; set error code for caller
	JMP	IP25				; skip the ack set
IP20:	MOV	AH, 10h				; set 'ack' code for caller
IP25:	MOV	AL, DL				; replace print char
	JMP	IP100				; and quit
IP30:	CMP	AH, 1				; initialize port ?
	JNZ	IP60				; no, try next
IP35:	MOV	BX, 35h				; printer code
	MOV	CX, 0				; init driver
	INT	0FCh				; do it
	MOV	CX, 6				; set device par/ser
	MOV	DX, 0				; set to parallel
	INT	0FCh				; do it
	MOV	CX, 5				; set auto lf after cr
	MOV	DX, 0				; disable it
	INT	0FCh				; do it
	MOV	CX, 0Ah				; return output status
	INT	0FCh				; do it
	CMP	AX, 0				; any errors ?
	JZ	IP40				; no, continue
	MOV	AH, 18h				; set 'no paper' code
	JMP	IP100				; and quit
IP40:	MOV	AH, 90h				; not busy, selected
	JMP	IP100				; and quit
IP60:	CMP	AH, 2				; report status ?
	JNZ	IP100				; no, just quit
	MOV	BX, 35h				; printer code
	MOV	CX, 0Ah				; 'get status' code
	INT	0FCh				; do it
	CMP	AX, 0				; any errors ?
	JNZ	IP65				; yes, check them
	MOV	AH, 90h				; set not busy, selected
	JMP	IP100				; .. and quit
IP65:	MOV	AL, 18h				; set error code
						; and dropthru
IP100:	POP	DX
	POP	CX
	POP	BX
	IRET
INT_17	ENDP

PAGE

;=============================================================================
;= int_1A		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;INPUT		:	AH = 0	read current clock setting
;OUTPUT		:	CX = high portion of count
;			DX = low portion of count
;			AL = 0 if timer has not passed 24 hours
;			since it was last read.
;			AL <> 0 if timer has passed 24 hours since
;			it was last read.
;
;INPUT		:	AH = 1 set the timer counts
;OUTPUT		:	CX = high portion of count
;			DX = low portion of count
;=============================================================================

INT_1A	PROC	NEAR
	PUBLIC	INT_1A
	JMP	SHORT	IC10
INT1A_SAV	DD	0
IC10:	CMP	AH, 0				; read the time ?
	JNZ	IC20				; no, try next
				; reading the timer
	MOV	CX, CS:TOD_HI			; put high portion in CX
	MOV	DX, CS:TOD_LO			; put low portion in DX
	MOV	AL, CS:TOD_FLG			; put oflo flag in AL
	MOV	CS:TOD_FLG, 0			; reset oflo flag
	JMP	IC100				; .. and quit
IC20:				; setting the timer
	CMP	AH, 1				; set the time ?
	JNZ	IC100				; no, quit then
	MOV	CS:TOD_HI, CX			; set high portion = CX
	MOV	CS:TOD_LO, DX			; set low portion = DX
	MOV	CS:TOD_FLG, 0			; reset oflo flag
IC100:	IRET
INT_1A	ENDP

TOD_FLG		DB	0
TOD_HI		DW	0
TOD_LO		DW	0
TOD_TICKS	DW	0

PAGE

;=============================================================================
;= int 29		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Dummy int 29 handler
;ACTION		Jump immediately to int F9 handler
;-----------------------------------------------------------------------------

INT_29		PROC	NEAR
		PUBLIC	INT_29
		JMP	SHORT	IX10
INT29_SAV	DD	0
IX10:		JMP	INT_F1
INT_29		ENDP

PAGE

;=============================================================================
;= int_e6		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Toggle the state of DS:NUM_LOCK
;=============================================================================

INT_E6	PROC	NEAR
	PUBLIC	INT_E6
	JMP	SHORT	IE5
INTE6_SAV	DD	0
IE5:	CMP	AL,12				; is it for us ?
	JZ	IE10				; yes....
	cmp	xiflag,0			; not XI
	je	IE3				; no......
	cmp	al,5				; STOP KEY ?
	jne	IE3				; no.....
	mov	al,9				; make alt key.
IE3:	jmp	short IE100			; done....
IE10:				; toggle the state of num_lock
	PUSH	DS				; save caller's DS
	MOV	DS, CS:DS_SAV			; address our DS
	NOT	BYTE PTR DS:NUM_LOCK		; toggle num lock state
	MOV	BX,33H				; micriscreen code
	MOV	CX,1				; print character
	MOV	DX,1BH				; escape code
	INT	0FCH
	MOV	DX,2FH				; char "/"
	INT	0FCH
	mov	dl,num_lock
	and	dl,1
	or	dl,10h				;top bits must be 01xxxxxxB
	shl	dl,1
	shl	dl,1
	INT	0FCH
	POP	DS				; recover caller's DS
	MOV	AL, 0				; alter key code to null
IE100:	JMP	CS:DWORD PTR [INTE6_SAV]	; jump to orig address
INT_E6	ENDP

PAGE

;=============================================================================
;= int_f1		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Int F1 interrupt service routine. *** NOTE This routine
;		is also connected to int 29h
;ACTION		Pipe all esc.seq. handler calls through int 10h, write tty
;-----------------------------------------------------------------------------
;INPUT		:	AL = char to print
;OUTPUT		:	None. All registers preserved
;ERRORS		:	None
;=============================================================================

INT_F1 		PROC	NEAR
		PUBLIC	INT_F1
		JMP	SHORT	IV10
INTF1_SAV	DD	0
IV10:		PUSH	AX
		PUSH	BX
		MOV	AH, 14
		MOV	BH, 0
		INT	10h
		POP	BX
		POP	AX
		IRET
INT_F1		ENDP

PAGE

;=============================================================================
;= int_f9		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Catch numeric keys while num_lock on
;=============================================================================

INT_F9	PROC	NEAR
	PUBLIC	INT_F9
	JMP	SHORT	IF5
INTF9_SAV	DD	0
IF5:	CLI					; disable interrupts
	PUSH	DS				; save caller's DS
	MOV	DS, CS:DS_SAV			; address our DS
	CMP	BYTE PTR DS:NUM_LOCK, 0		; is num lock on ?
	JNZ	IF05				; Yes, translate char
	CMP	AL,0DDH				; WAS IT 5
	JNE	IF100				; no, exit now
	MOV	BL,0				; NULL IT
	MOV	AX,0
	JMP	IF100
IF05:	CMP	AL, 0CBh			; was it naughty '9' ?
	JNZ	IF10				; no, keep going
	MOV	BL, 0CCH			; xlat to proper '9'
	JMP	IF95				; .. and exit
IF10:	CMP	AL, 0E4h			; was it naughty '1' ?
	JNZ	IF20				; no, keep going
	MOV	BL, 0E5H			; xlat to proper '1'
	JMP	IF95				; .. and quit
IF20:	CMP	AL, 0C8h			; was it naughty '3' ?
	JNZ	IF30				; no, just quit then
	MOV	BL, 0C9H			; xlat to proper '3'
	JMP	IF95				; and exit
IF30:	CMP	AL, 0BBh			; was it naughty '2' ?
	JNZ	IF40				; no, keep going
	MOV	BL, 0C5H			; xlat to proper '2'
	JMP	IF95				; .. and exit
IF40:	CMP	AL, 0BCh			; was it naughty '4' ?
	JNZ	IF50				; no, keep going
	MOV	BL, 0E3H			; xlat to proper '4'
	JMP	IF95				; .. and quit
IF50:	CMP	AL, 0BDh			; was it naughty '6' ?
	JNZ	IF60				; no, just quit then
	MOV	BL, 0C2H			; xlat to proper '6'
	JMP	IF95				; and quit
IF60:	CMP	AL, 0BEh			; was it naughty '7' ?
	JNZ	IF70				; no, keep going
	MOV	BL, 0D0H			; xlat to proper '7'
	JMP	IF95				; .. and exit
IF70:	CMP	AL, 0BFh			; was it naughty '8' ?
	JNZ	IF80				; no, keep going
	MOV	BL, 0C7H			; xlat to proper '8'
	JMP	IF95				; .. and quit
IF80:	CMP	AL, 0D9h			; was it naughty '0' ?
	JNZ	IF90				; no, just quit then
	MOV	BL, 0D2H			; xlat to proper '0'
	JMP	IF95
IF90:	CMP	AL, 0DAh			; was it naughty '.' ?
	JNZ	IF100				; no, just quit then
	MOV	BL, 0D4H			; xlat to proper '.'
IF95:	MOV	AX, 0FFFFh			; set 'pass to dos' code
IF100:	POP	DS				; recover caller's DS
	STI					; enable interrupts
	iret
INT_F9	ENDP

PAGE

;=============================================================================
;= int_fc		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Translate keys before returning to caller
;=============================================================================

INT_FC	PROC	NEAR
	PUBLIC	INT_FC
	JMP	SHORT	IF5C

INTFC_SAV	DD	0
INT16_FLAG	DB	0
SCAN_FLAG	DB	0
SCAN_CODE	DB	0

IF5C:		CLI					; disable interrupts
		CMP	BX,32H				; keyboard device
		JNE	JMP_OLDFC			; no.......
		CMP	CX,0BH				; get byte from queue
		JE	IFC1				; yes......
		CMP	CX,0CH				; look ahead
		JE	IFC1				; yes......
		CMP	CX,0EH				; get string 
		JE	GET_STRING			; yes......
JMP_OLDFC:	JMP	CS:DWORD PTR [INTFC_SAV]	; jump to orig address

GET_STRING:	PUSH	ES
		MOV	ES,DX
		MOV	CX,ES:[SI]			; get count wanted
		INC	SI				; move to buffer
		INC	SI				; address
		LES	SI,ES:[SI]			; get buffer address
GET_LOOP:	PUSH	ES
		PUSH	SI
		PUSH	CX
		MOV	BX,32H				; keyboard
		MOV	CX,0BH				; get byte from queue
		CALL	GET_CHAR
		POP	CX
		POP	SI
		POP	ES
		MOV	ES:[SI],AL			; put char in buffer
		INC	SI
		LOOP	GET_LOOP			; until count got
		POP	ES
		IRET

IFC1:		CALL	GET_CHAR
		IRET



GET_CHAR	proc	near
		CMP	CS:SCAN_FLAG,0FFH		; got byte ?
		JNE	IFC05				; no.......
		MOV	AL,CS:SCAN_CODE			
		cmp	cx,0ch				; is it look ahead
		je	skip_1
		MOV	CS:SCAN_FLAG,0	
SKIP_1:		XOR	AH,AH
		JMP	SHORT	IFC60

IFC05:		PUSH	DS				; save caller's DS
		push	cx				; caller not int16
		PUSHF
		CALL	CS:DWORD PTR [INTFC_SAV]	; jump to orig address
		pop	cx
		MOV	DS, CS:DS_SAV			; address our DS
IFC10:		CMP	CS:INT16_FLAG,0
		JNE	IFC50
		cmp	cx,0ch				; is it look ahead ?
		jne	ifc12				; no......
		TEST	AH,0FFH	
		JNZ	IFC50
IFC12:		MOV	BX, OFFSET DGROUP:KEY_XLAT_TAB	; get start of table
		XOR	AH, AH				; clear the high byte
		SHL	AX, 1				; *2 for words
		ADD	BX, AX				; add to offset
		MOV	AX, [BX]			; get scan code & ascii
		CMP	AL,0
		JNE	IFC40
		CMP	CX,0CH
		JE	IFC40
		MOV	CS:SCAN_CODE,AH
		MOV	CS:SCAN_FLAG,0FFH
IFC40:		XOR	AH,AH
IFC50:		POP	DS
IFC60:		STI
		RET
GET_CHAR	ENDP

INT_FC		ENDP

PAGE

;=============================================================================
;= int_ff		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		System timer pipe
;=============================================================================

INT_FF	PROC	NEAR
	PUBLIC	INT_FF
	JMP	SHORT	IA10
INTFF_SAV	DD	0
IA10:	PUSH	AX				; save AX for the moment
	MOV	AX, CS:TOD_TICKS		; get 'ticks' word
	INC	AL				; bump the 'ticks' count
	ADD	AL, AH				; add the flag ( 1 or 0 )
	CMP	AL, 3				; ticks count reached ?
	JZ	IA20				; yes, handle it
	SUB	AL, AH				; else take flag away again
	JMP	IA100				; and quit
IA20:	INT	01Ch				; cause 'user' interrupt
	XOR	AH, 1				; toggle ticks count flag
	XOR	AL, AL				; zeroise ticks count
	INC	CS:TOD_LO			; bump low count
	JNO	IA30				; no oflo, skip hi bump
	INC	CS:TOD_HI			; bump hi count
IA30:	CMP	CS:TOD_HI, 17h			; close to 24 hours ?
	JNZ	IA100				; not close enough
	CMP	CS:TOD_LO, 0FE80h		; on the button ?
	JNZ	IA100				; no, not quite
				; 24 'hours' elapsed, reset clock
	MOV	CS:TOD_LO, 0			;
	MOV	CS:TOD_HI, 0			;
	MOV	CS:TOD_FLG, 1			; toggle oflo flag
IA100:	MOV	CS:TOD_TICKS, AX		; replace ticks count
	POP	AX				;
	JMP	CS:DWORD PTR [INTFF_SAV]	; quit thru bios
INT_FF	ENDP

PAGE

;=============================================================================
;= con_vec
;=============================================================================
;JOB		Connect an interrupt routine
;ACTION		Save the old vector in pos provided by caller
;		Connect new routine
;-----------------------------------------------------------------------------
;SOFTWARE	:	dos func int 21h codes 35h ( get vector )
;					       25h ( set vector )
;-----------------------------------------------------------------------------
;INPUT		:	DI = CS offset of vector save area ( 4 bytes )
;			AL = interrupt number
;			DX = offset from current CS of interrupt routine
;STACK USE	:	10 words including int calls
;=============================================================================

CON_VEC	PROC	NEAR
	PUSH	AX				; general sort of
	PUSH	BX				; register save thingy
	PUSH	DX				; here
	PUSH	DI				;
	PUSH	ES				;
				; get the vector. DI already set to vector
				; save offset. AL already set to interrupt
				; number
	PUSH	AX				; save AL for later
	MOV	AH, 35h				; 'get vector' code
	INT	21h				; ES:BX will contain vector
	MOV	CS:[DI], BX			; store offset
	MOV	AX, ES				; swap ES to AX for store
	MOV	CS:[DI+2], AX			; and store segment word
	POP	AX				; recover trashed AL reg
				; now set the new vector ( which is assumed
				; to be CS:DX )
	PUSH	DS				; save orig DS
	PUSH	CS				; and make it a copy
	POP	DS				; of current CS
	MOV	AH, 25h				; 'set vector' code
	INT	21h				; set AL int number = DS:DX
	POP	DS				; recover orig DS
	POP	ES
	POP	DI
	POP	DX
	POP	BX
	POP	AX
	RET
CON_VEC	ENDP

PAGE

;=============================================================================
;= dis_vec
;=============================================================================
;JOB		disconnect an interrupt routine
;ACTION		Get old vector from routine address + 2
;		Connect old vector
;-----------------------------------------------------------------------------
;SOFTWARE	:	dos func int 21h codes 35h ( get vector )
;					       25h ( set vector )
;-----------------------------------------------------------------------------
;INPUT		:	AL = interrupt number
;ERRORS		:	*** Note. Relies on old vector being saved +2 bytes
;			away from current vector address
;=============================================================================

DIS_VEC	PROC	NEAR
	PUSH	BX
	PUSH	DX
	PUSH	ES
	PUSH	DS
				; get the vector pointed to by AL
	PUSH	AX				; save AL for later
	MOV	AH, 35h				; 'get vector' code
	INT	21h				; ES:BX will contain vector
				; retrive the old vector address
	MOV	AX, ES:[BX+4]			; segment to AX
	MOV	DX, ES:[BX+2]			; offset to DX
	MOV	DS, AX				; DS:DX = old vector now
	POP	AX				; recover trashed AL reg
	MOV	AH, 25h				; 'set vector' code
	INT	21h				; set AL int number = DS:DX

	POP	DS
	POP	ES
	POP	DX
	POP	BX
	RET
DIS_VEC	ENDP

PAGE

;=============================================================================
;= unload
;=============================================================================
;JOB		Remove original copy of emibm from memory, free up arena
;ACTION		Check that we actually have something to unload
;		find start of orig emibm psp through int 10h vector
;		recover original vectors and replace them
;		deallocate mem from psp
;		deallocate mem from arena header
;-----------------------------------------------------------------------------
;SOFTWARE	:	int 21h funcs 49h, 25h
;		calls	chk_load
;-----------------------------------------------------------------------------
;INPUT		:	none
;OUTPUT		:	none
;ERRORS		:	produces its own error messages ( assumption is that
;			caller will terminate after this call, errors or not )
;REG USE	:	AX, DX, ES, BX, SI, DS.
;STACK USE	:	2 words max
;RAM USE	:	frees previous emibm arena if found
;=============================================================================

UNLOAD	PROC	NEAR
	CALL	CHK_LOAD			; look for emibm code
	CMP	AX, 1				; was it there ?
	JZ	U20				; yes, continue
U10:
;;	MOV	DX, OFFSET DGROUP: HD$		; 'emibm ver x.x -'
;;	CALL	PRT_MSG				; print it
	MOV	DX, OFFSET DGROUP: CF$		; 'can't find orig copy'
	CALL	PRT_MSG				; print it
	JMP	U100				; and quit
U20:				; find start address of the int 10 routine
	MOV	AH, 35h				; 'get vector' code
	MOV	AL, 10h				; vector number
	INT	21h				; get that vector (in ES:BX)
	MOV	DS:TEMP1, BX			; save offset
	MOV	DS:TEMP2, ES			; save segment
				;REVECTOR THE ORIGINAL KEYBOARD TABLE
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	MOV	AX,ES:[BX+14]
	MOV	DS:[712H],AX
	MOV	AX,ES:[BX+16]
	MOV	DS:[714H],AX
	POP	DS
				; find and save orig psp seg address
	MOV	AX, ES:[BX+7]			;
	MOV	DS:TEMP3, AX			;
				; Replace the CNF_s_bioserr byte ( for serial comms )
	MOV	DH, ES:[BX+13]			; saved val to DH
	XOR	AX, AX				;
	MOV	ES, AX				; set ES = 0
	MOV	DI, ES:[700h]			; ptr offs to DI
	MOV	BX, ES:[702h]			; ptr seg to BX
	MOV	ES, BX				; ES:DI -> bios config table
	MOV	ES:[DI+42h], DH			; replace CNF_s_bioserr with saved value
				; replace orig int 10 vector ( as a special )
	MOV	BX,DS:TEMP2			; get original segment
	MOV	ES,BX				; into es
	MOV	BX,DS:TEMP1			; and offset in to bx
	PUSH	DS				; save DS
	MOV	DX, ES:[BX+9]			; offset
	MOV	DS, ES:[BX+11]			; seg
	MOV	AH, 25h				; set vector ( in DS:DX )
	MOV	AL, 10h				; vector number
	INT	21h				; do it
	POP	DS				;
				; replace the normal vectors
	MOV	AL, 14h				;
	CALL	DIS_VEC				;
	MOV	AL, 16h				;
	CALL	DIS_VEC				;
	MOV	AL, 17h				;
	CALL	DIS_VEC				;
	MOV	AL, 1Ah				;
	CALL	DIS_VEC				;
	MOV	AL, 29h
	CALL	DIS_VEC
	MOV	AL, 0E6h			;
	CALL	DIS_VEC				;
	MOV	AL, 0F1h
	CALL	DIS_VEC
	MOV	AL, 0F9h			;
	CALL	DIS_VEC				;
	MOV	AL, 0FCh			;
	CALL	DIS_VEC				;
	MOV	AL, 0FFh			;
	CALL	DIS_VEC				;
				; deallocate orig mem requirement
	MOV	AX, DS:TEMP3
	MOV	ES, AX
	PUSH	ES				; save ES for call ( j.i.c.)
	MOV	AH, 49h				; 'free up memory' code
	INT	21h				; do it
	POP	ES				; recover ES
				; deallocate environment requirement
	MOV	SI, 02Ch			; point to environ seg
	MOV	AX, ES:[SI]			; get environment seg addr
	MOV	ES, AX				; and switch it to ES
	MOV	AH, 49h				; 'free up memory' code
	INT	21h				; do it
				; re-enable the esc handler
	MOV	AL, 27
	INT	0F1h
	MOV	AL, 'z'
	INT	0F1h
				; clear mscreen but leave time&date
	MOV	BX,33H
	MOV	CX,1
	PUSH	SI
	MOV	SI,OFFSET FC2
	CALL	FC_ESC
	POP	SI

	MOV	AL, 27
	INT	0F1h
	MOV	AL, '<'				; display time on mscreen
	INT	0F1h
				; print the 'unloaded' message
;;	MOV	DX, OFFSET DGROUP: HD$		; 'emibm ver x.x'
;;	CALL	PRT_MSG				; print it
	MOV	DX, OFFSET DGROUP: TATA$	; 'unloaded, etc'
	CALL	PRT_MSG				; print it
U100:	RET					; and quit
UNLOAD	ENDP

PAGE

;=============================================================================
;= chk_parms
;=============================================================================
;JOB		Check parms in psp against known strings
;-----------------------------------------------------------------------------
;INPUT		:	ES points to start of psp
;OUTPUT		:	AX = 1 means no parms typed
;			AX = 2 means NO typed
;			AX = 3 means VERBOSE typed
;ERRORS		:	AX = 0 is invalid parms code
;=============================================================================

CHK_PARMS	PROC	NEAR
				;point at psp text area & examine for chars
	CALL	CONV_CHRS			; convert a-z to A-Z
C10:	XOR	CX, CX				; CX = 0
	MOV	DI, 80h				; address no of chars typed
	MOV	CL, ES:[DI]			; chars typed count to CX
	AND	CL, CL				; anything typed ?
	JNZ	C20				; got parms, go test 'em
	MOV	AX, 1				; nothing there retcode
	JMP	C100				; quit already
C20:				;strip leading spaces
	MOV	DL,CL
	INC	DI				; point to next parm char
	MOV	AL, ES:[DI]			; stick it in acc
	CMP	AL, ' '				; is it a space ?
	JE	C20				; YES.......
C30:				;arrive here with DI -> first real char
				; try for NO
	MOV	BX, DI				; save the DI value for later
	MOV	SI, OFFSET DGROUP:PARM1		; get the first parm
	MOV	CX, 3				; parm length +1 ?
	REPZ	CMPS BYTE PTR [DI], [SI]	; compare it
	JCXZ	C42				; we found 'NO'
				; try for VERBOSE
	MOV	DI, BX				; restore DI
	MOV	SI, OFFSET DGROUP:PARM2
	MOV	CX, 8
	REPZ	CMPS BYTE PTR [DI], [SI]
	JCXZ	C44				; we found 'VERBOSE'

	MOV	DI,BX
	MOV	SI,OFFSET DGROUP:PATH_NAME
	MOV	CX,01
PATH_LOOP:
	MOV	AL,ES:[DI]			; GET NEXT CHAR
	CMP	AL,' '				; IS IT A SPACE
	JE	END_LOOP			; YES - EXIT LOOP
	CMP	AL,'.'				; IS IT A '.'
	JE	PATH_EROR
	MOV	[SI],AL
	INC	SI
	INC	DI
	INC	CL
	CMP	DL,CL
	JNE	PATH_LOOP
END_LOOP:
	MOV	BYTE PTR [SI],'.'
	MOV	DS:PATH_LENTH,CL
	INC	SI
	MOV	BYTE PTR [SI],'C'
	INC	SI
	MOV	BYTE PTR [SI],'O'
	INC	SI
	MOV	BYTE PTR [SI],'M'
	INC	SI
	CMP	CL,8
	JE	FIL_LENTH
	MOV	BYTE PTR [SI],0
FIL_LENTH:
	MOV	BX,80H
	MOV	AL,ES:[BX]
	XCHG	AL,CL
	SUB	CL,AL
	MOV	ES:[BX],CL
	JZ	NO_PARMS
	XOR	CH,CH
	INC	BX
	INC	BX
PARM_LOOP:
	INC	DI
	MOV	AL,ES:[DI]
	MOV	ES:[BX],AL
	INC	BX
	LOOP	PARM_LOOP
NO_PARMS:
	JMP	C99				; error exit if dropthru

PATH_EROR:
	MOV	AX,0FFH
	JMP	SHORT C100
C42:	MOV	AX, 2				; set NO
	JMP	C50				;
C44:	MOV	AX, 3				; set VERBOSE
C50:	MOV	CL, ES:[DI-1]			; get the char into CL
	CMP	CL, ' '				; compare with space
	JB	C100				; below is O.K.
C99:	XOR	AX, AX				; error exit point
C100:	RET
CHK_PARMS	ENDP

PAGE

;=============================================================================
;= conv_chrs
;=============================================================================
;JOB		Convert lowercase to uppercase chars in psp text area
;-----------------------------------------------------------------------------
;INPUT		: ES points to start of psp
;OUTPUT		: none
;ERRORS		: none
;REG USE	: BX, AL ( not preserved )
;STACK USE	: none
;RAM USE	: affects last 100h bytes of psp
;=============================================================================

CONV_CHRS	PROC	NEAR
	MOV	BX, 81h				; point to first char in psp
D10:	MOV	AL, ES:[BX]			; pull it into al
	CMP	AL, 'Z'				; is is > 'Z' ?
	JB	D20				; no, skip it
	SUB	AL, 20h				; yes, conv to upper case
	MOV	ES:[BX], AL			; stick it back in psp
D20:	INC	BX				; bump the pointer
	CMP	BX, 0FFh			; end of buffer ?
	JNZ	D10				; no, loop back
	RET					; yes, quit
CONV_CHRS	ENDP

PAGE

;===========================================================================
;= chk_load
;=============================================================================
;JOB		Check for EMIBM already connected to int 10h
;OUTPUT		:	AX = 0 if nothing in mem
;ERRORS		:	AX = 1 if emulator already there
;REG USE	:	DS ( preserved )
;			SI, AX, BX ( destroyed )
;=============================================================================

CHK_LOAD	PROC	NEAR
	PUSH	DS
				; obtain the interrupt 10h vector
	MOV	AH, 35h				; 'get vector' code
	MOV	AL, 10h				; get the int 10h vector
	INT	21h				; ES:BX point to int handler
	PUSH	ES				; make DS = ES
	POP	DS				; so DS = segment
	MOV	SI, BX				; and SI = offset
	ADD	SI, 2				; skip the short jump
				; now inspect the bytes pointed to by DS:SI
	PUSH	ES				;check sign behind int 10
	MOV	AX,DGROUP			;entry point.
	MOV	ES,AX
	MOV	CX,5
	MOV	DI,OFFSET DGROUP:OURNAME
	REP	CMPSB
	POP	ES
	MOV	AX,1				; say found sig on default
	JCXZ	E20
	XOR	AX,AX				; no, not found and return
E20:	POP	DS
	RET
CHK_LOAD	ENDP

PAGE

PRT_MSG	PROC	NEAR
	PUSH	AX
	MOV	AH, 9
	INT	21h
	POP	AX
	RET
PRT_MSG	ENDP

FC_ESC	PROC	NEAR
NEXTESC:XOR	AX,AX
	LODSB
	CMP	AL,0FFH
	JE	DONEESC
	MOV	DX,AX
	INT	0FCH
	JMP	SHORT NEXTESC
DONEESC:RET
FC_ESC	ENDP

PROG		ENDS

PAGE

DATA	SEGMENT	WORD	PUBLIC	'DATA'
	ASSUME	DS:DGROUP

extrn	c_colx:byte,c_ROWy:byte,image_id:WORD
extrn	MODE:BYTE,PALET:BYTE,KEY_XLAT_TAB:BYTE,IBMKEY:BYTE
extrn 	CON_UP:byte,con_dn:byte,scr_up:byte,scr_dn:byte
extrn 	snd_up:byte,snd_dn:byte,lcd:byte,col:byte,c40:byte,bth:byte
extrn	xisp:byte,xidp:byte

COM_PARM	DB	0			; command line parameter code
PARM1		DB	'NO',0			; allowable command line
PARM2		DB	'VERBOSE',0		; parms
OURNAME		DB	'EMIBM',0		; 
FTAB_SEG	DW	0			; ptr to format struc segment
FTAB_OFFS	DW	0			; ptr to format struc offset
TEMP1		DW	0			; These four locations are
TEMP2		DW	0			; used as temporary storage
TEMP3		DW	0			; because the int EC calls
TEMP4		DW	0			; kill so many reg's
NUM_LOCK	DB	0			; num lock key state (1 or 0)
TIMEOUT		DW	0			; RS232 timeout delay
PATH_LENTH	DB	0
PATH_NAME	DB	'            '		; PATH NAME
PARMS_BLOCK	DW	0			; PARAMETER BLOCK
		DW	80H
SEG1		DW	00
		DW	5CH
SEG2		DW	00H
		DW	6CH
SEG3		DW	00

FILE_EROR	DB	'File Not Found - $'
other_eror	db	'Unable to RUN specified Program - $'
other_half	db	'Apricot IBM Emulator Terminated',13,10,'$'
BAUD_TAB	DB	3,5,6,7,8,10,12,14
XIFLAG		DB	0			;set to 1 if XI

WHAT_SIGN	DB	'@(#)'
HD$		DB	'Apricot IBM Emulator Va 1.6.0 09th Sept 86',13,10,'$'
HI$		DB	'Emulator loaded and running.',13,10,'$'
IN$		DB	'error, emulator already loaded.',13,10,'$'
CF$		DB	'error, emulator not present.',13,10,'$'
US$		DB	'error in usage: type EMIBM or EMIBM NO.',13,10,'$'
TATA$		DB	'Emulation Terminated',13,10,'$'
NUMESC		DB	1BH,'H              NUM',1BH,89,0,48H,' F9    F10    LOCK',0FFH
NUMESC2		DB	1BH,'H              NUM',1BH,89,0,48H,'              LOCK',0FFH
FC2		DB	1BH,'E',1BH,'/',40H,0FFH

DATA		ENDS

		END
