PAGE 66,132
TITLE	Int_10
INCLUDE LEGAL.INC
;*****************************************************************************
;*
;*			PROGRAM Interrupt 10 handler
;*
;*	AUTHOR		M.Pendlebury
;*
;*	DATE		18/8/86
;*
;*	MODIFICATIONS
;*
;*****************************************************************************

SCR_DRV		EQU	0ECH

PGROUP	GROUP	PROG
DGROUP	GROUP	DATA

DATA	SEGMENT	WORD	PUBLIC	'DATA'
	ASSUME	DS:DGROUP

C_ROWY		DB	0			; cursor position storage
C_COLX		DB	0			;
IMAGE_ID	DW	0			;
TEMP1		DW	0			; These four locations are
TEMP2		DW	0			; used as temporary storage
TEMP3		DW	0			; because the int EC calls
TEMP4		DW	0			; kill so many reg's
MODE		DB	0
PALET		DB	0,0,0,64,220,64,220,64,64,220,220,64,220,220,220
PALET1		DB	0,0,0,64,64,250,64,250,250,250,64,250,220,220,220

PUBLIC		C_ROWY,C_COLX,PALET,MODE,IMAGE_ID

DATA	ENDS

PROG	SEGMENT BYTE	PUBLIC	'PROG'

ASSUME	CS:PGROUP,DS:DGROUP

;=============================================================================
;JOB		int_10 - interrupt handler for int 10h
;ERRORS		:	In this initial implementation, there is no facility
;			to switch active display pages. All calls referencing
;			a display page other than zero ( default ) will
;			be pointed to the default page.
;=============================================================================

PUBLIC	INT_10
INT_10	PROC	NEAR

EXTRN	DS_SAV:WORD

;=========  INT 10H INTERRUPT ROUTINE ENTRY POINT HERE =================

	JMP	SHORT	IT10

		; *** NOTE ***
		; The following data area is information needed by a second
		; invocation of EMIBM to be able to unload the previous
		; copy from memory. If altering this data structure be
		; sure to check the routines that connect and disconnect
		; the int 10 vector.

		DB	'EMIBM'			; this prog signature
PSPADDR		DW	0			; saved value of psp segment
INT10_SAV	DD	0			; old vector save
CNF_S_BIOS	DB	0			; save value of CNF_s_bioserr
KEY_OFSET	DW	0
KEY_SEG		DW	0

PUBLIC		PSPADDR,INT10_SAV,CNF_S_BIOS,KEY_OFSET,KEY_SEG

;************** JUMP TABLE  ********************

JMP_TAB	DW	IT1400				;0 set mode
	DW	IT1000				;1 set cursor
	DW	IT300				;2 set cursor position
	DW	IT900				;3 read cursor position
	DW	IT7999				;4 
	DW	IT1300				;5 select page
	DW	IT600				;6 scroll page up
	DW	IT700				;7 scroll page down
	DW	IT800				;8 read attrib/char
	DW	IT500				;9 write attrib/char
	DW	IT200				;a write char
	DW	IT1200				;b set pallette
	DW	IT7999				;c
	DW	IT7999				;d
	DW	IT400				;e write tty
	DW	IT1100				;f current video state

;************************************************
IT10:				; analyse value in AH ( callers code )
	CMP	AH, 15				; check boundry
	JBE	IT20
	JMP	Int10_ret
IT20:				; save registers
	PUSH	ES
	PUSH	DS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	AX
	MOV	AL,AH
	XOR	AH,AH
	SHL	AX,1
	MOV	SI,AX
	POP	AX
	JMP	WORD PTR CS:JMP_TAB[SI]
;================================================
IT200:				; AH = 10, write char at current curpos
				; BH = display page
				; CX = count of chars to write
				; AL = char to write
				; this handler tested 26/6/85 jon
				; first, save all registers
				; recover DS, save int 10 call parms
	MOV	DS, CS:DS_SAV			; address our data segment
	MOV	DS:TEMP1, CX			; save char count in TEMP1
	MOV	DS:TEMP2, AX			; save char to write in TEMP2
				; turn the cursor off
	MOV	CL, 0Eh				; 'cursor off' code
	MOV	CH, 0				; screen i.d.
	MOV	DI, DS:IMAGE_ID			; image i.d. to DI
	INT	SCR_DRV				; and turn the cursor off
				; find & copy the current cursor position
	MOV	AH, DS:C_ROWY			; cursor y co-ord
	MOV	AL, DS:C_COLX			; cursor x co-ord
IT210:	MOV	DS:TEMP3, AX			; save curpos in TEMP3
				; read char & attribs at x,y ( AL,AH )
	MOV	CX, 0006			; CH=0, CL=6 (scrn id, rd char)
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	INT	SCR_DRV				; and read the character
				; write new char with old attribs
	MOV	DX, AX				; DH=attribs, DL=char ( read )
	MOV	AX, DS:TEMP2			; retrive write char
	MOV	DL, AL				; old attribs, new char in DX
	MOV	AX, DS:TEMP3			; cursor position to AX
	MOV	CX, 0004			; CH=0,CL=4 (scrn id, wrt chr )
	MOV	SI, 0				; point to default font
	MOV	DI, DS:IMAGE_ID			; image i.d. to DI
	INT	SCR_DRV				; write the char
				; check for a multi-char call and increase
				; x-y to point to next cell if needed
	DEC	DS:TEMP1			; reduce character count
	JZ	IT230				; if it's zero, we quit
	MOV	AX, TEMP3			; retrive char x-y position
	INC	AL				; bump the column (x)
	CMP	AL, 80				; off the edge ?
	JL	IT220				; no, put next char there
	MOV	AL, 0				; else reset col to zero
	INC	AH				; and bump the row
	CMP	AH, 25				; off the bottom ?
	JL	IT220				; no, next char can go there
	MOV	AH, 0				; else row (y) reset to zero
IT220:	JMP	IT210				; loop back to print next char
IT230:				; all finished, turn the cursor back on at
				; the original position ( this call may have
				; printed a string but will not update the
				; cursor x,y co-ordinates )
	MOV	CL, 0Dh				; 'cursor on' code
	MOV	CH, 0				; screen i.d. is zero
	MOV	AH, DS:C_ROWY			; set ORIGINAL y co-ord
	MOV	AL, DS:C_COLX			; set ORIGINAL x co-ord
	MOV	DI, DS:IMAGE_ID			; DI = image i.d.
	INT	SCR_DRV				; turn the cursor back on
				; dropthru to pop reg's & exit
	JMP	IT7999				;
;================================================
IT300:				; AH = 2, set cursor position
				; DH, DL = row, column ( 0,0 = upper left )
				; BH = display page
				; this handler tested 25/6/85 jon.
	MOV	DS, CS:DS_SAV			; restore our DS
	CMP	DH, 25				; is row 0-24 ?
	JL	IT310				; yes, continue
	MOV	DH, 24				; no, set 24 as max
IT310:	CMP	DL, 80				; is col 0-79 ?
	JL	IT320				; yes, continue
	MOV	DL, 79				; no, set 79 as max
IT320:
	MOV	DS:C_ROWY, DH			; save this as last known ..
	MOV	DS:C_COLX, DL			; .. cursor position
	MOV	CX, 000Eh			; scrn id, cursor off
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	PUSH	DX				; DX trashed by next call !
	PUSH	DI				; save image id
	INT	SCR_DRV				; call int EC to turn curs off
	POP	DI				; recover image id
	POP	AX				; AH,AL = row, col
	MOV	CX, 000Dh			; scrn id, cursor on
	INT	SCR_DRV				; call int EC to turn cursor
	JMP	IT7999				;
;================================================
IT400:				; AH = 14, write tty
				; AL = char to write
				; BH = display page
				; this handler tested 1/7/85 jon
	MOV	DS, CS:DS_SAV			;
				; store the passed vars
	MOV	DS:TEMP1, AX			; save char to write
	MOV	DS:TEMP2, BX			; save the display page
				; check for a bell
	CMP	AL, 7				; was it a bell ?
	JNZ	IT405				; nope, try next
	MOV	BX, 38h				; sound generator code
	MOV	CX, 9				; 'bell'
	INT	0FCh				; sound the bell
	JMP	IT495				; and exit
IT405:				; all others affect cursor, so kill it
	MOV	CX, 000Eh			; 'cursor off' code, scrn i.d.
	MOV	DI, DS:IMAGE_ID			; image i.d.
	INT	SCR_DRV				; turn the cursor off
	MOV	AX, DS:TEMP1			; and recover the char (AL)
				; check for a carriage return
	CMP	AL, 0Dh				; was it a cr ?
	JA	IT435				; above means must be printable
	JNZ	IT410				; no, try next
	MOV	DS:C_COLX, 0			; yep, set cursor to col 0
	JMP	IT490				; & quit through cursor rewrite
IT410:				; check for a backspace
	CMP	AL, 8				; was it a backspace ?
	JNZ	IT425				; nope, try next
	CMP	DS:C_COLX, 0			; already at col zero ?
	JNZ	IT420				; no, do a backspace
	JMP	IT490				; yes, cursor rewrite & quit
IT420:	DEC	DS:C_COLX			; move cursor back 1
	JMP	IT490				; exit thru cursor on
IT425:				; check for a linefeed
	CMP	AL, 0Ah				; was it lf ?
	JNZ	IT435				; no, try next
	INC	DS:C_ROWY			; bump row number
	JMP	IT440				; exit thru scroll check
IT435:				; handle all else as normal chars
	MOV	AH, DS:C_ROWY			; cursor y co-ord
	MOV	AL, DS:C_COLX			; cursor x co-ord
	push	ax
	MOV	CX, 0006			; CH=0, CL=6 (scrn id, rd char)
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	INT	SCR_DRV				; and read the character
				; give old attributes new char
	MOV	BX, DS:TEMP1			; get char to write (BL)
	MOV	AL, BL				; combine with old attribs
				; write out new char at current curpos
	MOV	DX, AX				; DH=attribs, DL=char
	pop	ax				; get position
	MOV	CX, 0004			; CH=0,CL=4 (scrn id, wrt chr )
	MOV	SI, 0				; point to default font
	MOV	DI, DS:IMAGE_ID			; image i.d. to DI
	INT	SCR_DRV				; write the char
				; update cursor x,y to new position
	INC	DS:C_COLX			; increment column count
	CMP	DS:C_COLX, 80			; off rh edge ?
	JL	IT490				; no, that's it then
	MOV	DS:C_COLX, 0			; else new col is zero
	INC	DS:C_ROWY			; bump the row count
IT440:	CMP	DS:C_ROWY, 24			; off bottom of screen ?
	JL	IT490				; no, exit then
	MOV	DS:C_ROWY, 23			; else new row is 23
				; read attribute for new blank line
	MOV	CX, 0006h			; scrn id, read char
	MOV	AX, 174Fh			; from row 23 col 79
	MOV	DI, DS:IMAGE_ID			; image id
	INT	SCR_DRV				;
				; scroll the screen up
	MOV	CL, 0Ah				; ..and dropthru to scroll
	MOV	CH, 0				; screen up
	MOV	DX, AX				; recover attributes for blank
	MOV	DL, 0				; line
	MOV	SI, 0				;
	MOV	DI, DS:IMAGE_ID			;
	INT	SCR_DRV				; scroll the screen up
IT490:				; print cursor at new position
	MOV	CL, 0Dh				;
	MOV	CH, 0				;
	MOV	AH, DS:C_ROWY			;
	MOV	AL, DS:C_COLX			;
	MOV	DI, DS:IMAGE_ID			;
	INT	SCR_DRV				;
IT495:				; last exit point here
	JMP	IT7999				;
;================================================
IT500:				; AH = 9, write attr/char at cursor pos
				; BH = display page
				; CX = count of chars to write
				; AL = char to write
				; BL = attributes
				; this handler tested 27/6/85 jon
	MOV	DS, CS:DS_SAV			; address our data segment
	MOV	DS:TEMP1, CX			; save char count in TEMP1
	MOV	CH, BL				; attributes to CH
	MOV	CL, AL				; char to CL
	MOV	DS:TEMP2, CX			; save attribs/char in TEMP2
				; turn the cursor off
	MOV	CX, 000Eh			; scrn id, cursor off
	MOV	DI, DS:IMAGE_ID			; image i.d. to DI
	INT	SCR_DRV				; and turn the cursor off
				; find & copy the current cursor position
	MOV	AH, DS:C_ROWY			; cursor y co-ord
	MOV	AL, DS:C_COLX			; cursor x co-ord
IT510:	MOV	DS:TEMP3, AX			; save curpos in TEMP3
				; write out the char/attribs
	MOV	CX, 0004			; scrn id, write char/attribs
	MOV	DX, DS:TEMP2			; recover char/attribs
	MOV	SI, 0				; point to default font
	MOV	DI, DS:IMAGE_ID			; image i.d. to SI
	INT	SCR_DRV				; write char/attributes
				; check for a multi-char call and increase
				; x-y to point to next cell if needed
	DEC	DS:TEMP1			; reduce character count
	JZ	IT530				; if it's zero, we quit
	MOV	AX, TEMP3			; retrive char x-y position
	INC	AL				; bump the column (x)
	CMP	AL, 80				; off the edge ?
	JL	IT520				; no, put next char there
	MOV	AL, 0				; else reset col to zero
	INC	AH				; and bump the row
	CMP	AH, 25				; off the bottom ?
	JL	IT520				; no, next char can go there
	MOV	AH, 0				; else row (y) reset to zero
IT520:	JMP	IT510				; loop back to print next char
IT530:				; all finished, turn the cursor back on at
				; the original position ( this call may have
				; printed a string but will not update the
				; cursor x,y co-ordinates )
	MOV	CX, 000Dh			; scrn id, cursor on
	MOV	AH, DS:C_ROWY			; set ORIGINAL y co-ord
	MOV	AL, DS:C_COLX			; set ORIGINAL x co-ord
	MOV	DI, DS:IMAGE_ID			; DI = image i.d.
	INT	SCR_DRV				; turn the cursor back on
				; dropthru to pop reg's & exit
	JMP	IT7999				;
;================================================
IT600:				; AH = 6, scroll active page up
				; AL = number of lines ( 0 = blank window )
				; CH,CL=row,col upper lh corner of scroll
				; DH,DL=row,col lower rh corner of scroll
				; BH = attribute to be used on blank line
				; this handler tested 1/7/85 jon
	MOV	DS, CS:DS_SAV
				; save caller's parms
	XOR	AH, AH				; set call code to zero
	MOV	DS:TEMP1, AX			; save no. of lines (AL)
	MOV	DS:TEMP2, BX			; save new blank line atr (BH)
				; validate upper l.h. co-ordinates
	CMP	CH, 25				;
	JL	IT601				;
	MOV	CH, 24				;
IT601:	CMP	CL, 80				;
	JL	IT602				;
;;	JMP	IT7999				; IGC 11/7/86
	MOV	CL, 79				;
IT602:				; validate lower r.h. co-ordinates
	CMP	DH, 25				;
	JL	IT603				;
	MOV	DH, 24				;
IT603:	CMP	DL, 80				;
	JL	IT604				;
	MOV	DL, 79				;
				; save the scroll co-ordinates
IT604:	MOV	DS:TEMP3, CX			; upper l.h. row(CH), col (CL)
	MOV	DS:TEMP4, DX			; lower r.h. row(DH), col (DL)
				; turn the cursor off
	MOV	CL, 0Eh				; 'cursor off' code
	MOV	CH, 0				; screen i.d.
	MOV	DI, DS:IMAGE_ID			; image id to DI
	INT	SCR_DRV				; turn the cursor off
				; decide whether to blank or scroll window
	MOV	AX, DS:TEMP1			; recover no. of lines
	CMP	AL, 0				; clear whole window ?
	JZ	IT610				; yes, just a 'smear' call
	JMP	IT680				; no, do a block move
IT610:				; clear the window with a 'smear'
	MOV	CL, 8				; 'smear block' code
	MOV	CH, 0				; screen i.d. is 0
	MOV	DX, DS:TEMP2			; DH = attribs of area
	MOV	DL, ' '				; DL = fill char ( space )
	MOV	AX, DS:TEMP3			; top lh co-ords
	MOV	BX, DS:TEMP4			; bot rh co-ords
	MOV	SI, 0				; use default font
	MOV	DI, DS:IMAGE_ID			; set the image id
	INT	SCR_DRV				; smear that block
	JMP	IT690				; and exit
IT680:				; set up parms for block move call
	MOV	AX, DS:TEMP3			; top left hand col in AL
	MOV	DX, DS:TEMP4			; bottom r.h. col in DL
	SUB	DL, AL				; width = r.h. - l.h.
	INC	DL				; treat int EC x extent as base 1
	SUB	DH, AH				; height = bottom - top
	CMP	DH,0
	JE	SMR_LINE
	MOV	BX, DS:TEMP3			; top l.h. co-ords to BX
	MOV	AX, BX				; .. and to AX
	INC	AH				; source is 1 row below dest
	MOV	CL, 0Bh				; 'move block' code
	MOV	CH, 0				; screen i.d.
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	INT	SCR_DRV				; move that block
SMR_LINE:			; 'smear' the bottom line of block
	MOV	CL, 08h				; 'smear block' code
	MOV	CH, 0				; screen i.d.
	MOV	DX, DS:TEMP2			; retrive attributes
	MOV	DL, ' '				; char is a space
	MOV	AX, DS:TEMP3			; retrive top l.h. co-ords
	MOV	BX, DS:TEMP4			; retrive bot. r.h. co-ords
	MOV	AH, BH				; start row = finish row
	MOV	SI, 0				; point to default font
	MOV	DI, DS:IMAGE_ID			; set the image id
	INT	SCR_DRV				; smear bot line of scrld block
				; try for a loop count
	DEC	DS:TEMP1			; decrement the loop count
	JZ	IT690				; if zero quit
	JMP	IT680				; else loop around
IT690:
				; turn the cursor back on again
	MOV	CL, 0Dh				; 'cursor on' code
	MOV	CH, 0				; screen id
	MOV	AH, DS:C_ROWY			; set 'y' co-ord
	MOV	AL, DS:C_COLX			; set 'x' co-ord
	MOV	DI, DS:IMAGE_ID			; set image i.d.
	INT	SCR_DRV				; turn cusor back on
	JMP	IT7999				;
;================================================
IT700:				; AH = 7, scroll active page down
				; AL = no of lines ( 0 = blank window )
				; CH,CL=row,col upper lh corner of scroll
				; DH,DL=row,col lower rh corner of scroll
				; BH = attribute to be used on blank line
				; this handler tested 1/7/85 jon
	MOV	DS, CS:DS_SAV
				; save caller's parms
	XOR	AH, AH				; set call code to zero
	MOV	DS:TEMP1, AX			; save no. of lines (AL)
	MOV	DS:TEMP2, BX			; save new blank line atr (BH)
				; validate upper l.h. co-ordinates
	CMP	CH, 25				;
	JL	IT701				;
	MOV	CH, 24				;
IT701:	CMP	CL, 80				;
	JL	IT702				;
	MOV	CL, 79				;
IT702:				; validate lower r.h. co-ordinates
	CMP	DH, 25				;
	JL	IT703				;
	MOV	DH, 24				;
IT703:	CMP	DL, 80				;
	JL	IT704				;
	MOV	DL, 79				;
IT704:				; save the scroll co-ordinates
	MOV	DS:TEMP3, CX			; upper l.h. row(CH), col (CL)
	MOV	DS:TEMP4, DX			; lower r.h. row(DH), col (DL)
				; turn the cursor off
	MOV	CL, 0Eh				; 'cursor off' code
	MOV	CH, 0				; screen i.d.
	MOV	DI, DS:IMAGE_ID			; image id to DI
	INT	SCR_DRV				; turn the cursor off
				; decide whether to blank or scroll window
	MOV	AX, DS:TEMP1			; recover no. of lines
	CMP	AL, 0				; clear whole window ?
	JZ	IT710				; yes, just a 'smear' call
	JMP	IT780				; no, do a block move
IT710:				; clear the window with a 'smear'
	MOV	CL, 8				; 'smear block' code
	MOV	CH, 0				; screen i.d. is 0
	MOV	DX, DS:TEMP2			; DH = attribs of area
	MOV	DL, ' '				; DL = fill char ( space )
	MOV	AX, DS:TEMP3			; top lh co-ords
	MOV	BX, DS:TEMP4			; bot rh co-ords
	MOV	SI, 0				; use default font
	MOV	DI, DS:IMAGE_ID			; set the image id
	INT	SCR_DRV				; smear that block
	JMP	IT690				; and exit
IT780:				; set up parms for block move call
	MOV	AX, DS:TEMP3			; top left hand col in AL
	MOV	DX, DS:TEMP4			; bottom r.h. col in DL
	SUB	DL, AL				; width = r.h. - l.h.
	INC	DL				; make int EC x extent base 1
	SUB	DH, AH				; height = bottom - top
	CMP	DH,0
	JE	SMEAR_LINE
	MOV	BX, DS:TEMP3			; top l.h. co-ords to BX
	MOV	AX, BX				; .. and to AX
	INC	BH				; dest is 1 row below source
	MOV	CL, 0Bh				; 'move block' code
	MOV	CH, 0				; screen i.d.
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	INT	SCR_DRV				; move that block
SMEAR_LINE:			; 'smear' the top line of block
	MOV	CL, 08h				; 'smear block' code
	MOV	CH, 0				; screen i.d. is 0
	MOV	DX, DS:TEMP2			; recover attributes
	MOV	DL, ' '				; char is a space
	MOV	AX, DS:TEMP3			; top l.h. co-ords
	MOV	BX, DS:TEMP4			; bot r.h. co-ords
	MOV	BH, AH				; make bot row = top row
	MOV	SI, 0				; use default font
	MOV	DI, DS:IMAGE_ID			; set image i.d.
	INT	SCR_DRV				; smear that block
				; try for a loop count
	DEC	DS:TEMP1			; decrement the loop count
	JZ	IT790				; if zero quit
	JMP	IT780				; else loop around
IT790:				; turn the cursor back on again
	MOV	CL, 0Dh				; 'cursor on' code
	MOV	CH, 0				; screen id
	MOV	AH, DS:C_ROWY			; set 'y' co-ord
	MOV	AL, DS:C_COLX			; set 'x' co-ord
	MOV	DI, DS:IMAGE_ID			; set image i.d.
	INT	SCR_DRV				; turn cusor back on
				; .. and exit popwise
	JMP	IT7999				;
;================================================
IT800:				; AH = 8, read attr/char at curpos
				; BH = display page
				; on exit AL = char, AH = attributes
				; tested 28/6/85 jon
	MOV	DS, CS:DS_SAV			; address our own data segment
				; find current cursor position
	MOV	AH, DS:C_ROWY			; cursor y co-ord
	MOV	AL, DS:C_COLX			; cursor x co-ord
				; read char & attribs at x,y ( AL,AH )
	MOV	CX, 0006			; CH=0, CL=6 (scrn id, rd char)
	MOV	DI, DS:IMAGE_ID			; set the image i.d.
	INT	SCR_DRV				; and read the character.
	JMP	IT7999				;
;================================================
IT900:				; AH = 3, read cursor position
				; BH = display page
				; on exit DH,DL=row,col
				; CH = cursor start line
				; CL = cursor stop line
				; tested 27/6/85 ?
	MOV	DS, CS:DS_SAV			; point to our data seg
	MOV	DH, DS:C_ROWY			; 'y' to DH
	MOV	DL, DS:C_COLX			; 'x' to DL
	MOV	CH, 0				; 'fudge' cursor type as
	MOV	CL, 31				; a full block
	JMP	IT8999				;
;================================================
IT1000:				; AH = 1, set cursor type
				; CH, bits 0-4 = start line for cursor
				; CL, bits 0-4 = end line for cursor
				; *** NOTE. Cursor type is not alterable
				; in this implementation
	JMP	IT7999				;
;================================================
IT1100:				; AH = 15, return current video state
				; on exit AL = current mode
				; AH = no of screen cols
				; BH = current active display page
	MOV	DS,CS:DS_SAV
	MOV	AL,DS:MODE
	MOV	AH, 80				; 80 columns
	MOV	BH, 0				; current display page
	JMP	IT7999				;
;================================================
IT1200:				; AH = 11, set colour pallette
				; BH = colour id ( 0-127 )
				; BL = value for that id
	MOV	DS,CS:DS_SAV
	MOV	SI,OFFSET DGROUP:PALET
	MOV	DI,DS:IMAGE_ID
	OR	BH,BH		; changing background ?
	JZ	BACK_GROUND
	TEST	BL,1
	JZ	GREEN1
	MOV	SI,OFFSET DGROUP:PALET1
GREEN1:
	MOV	AX,0101H
	MOV	CX,0FH
	MOV	DX,DS
	INT	SCR_DRV
	JMP	SHORT RET_PALET
BACK_GROUND:
	XOR	DX,DX
	CMP	BL,7
	JB	NO_INTENSITY
	MOV	DX,4040H
NO_INTENSITY:
	MOV	CL,DL
	TEST	BL,4				; IS RED SET
	JZ	NO_RED
	OR	DL,80H				; SET RED
NO_RED:	TEST	BL,2				; IS GREEN SET
	JZ	NO_GREEN
	OR	DH,80H				; SET GREEN
NO_GREEN:
	TEST	BL,1				; IS BLUE SET
	JZ	NO_BLUE
	OR	CL,80H
NO_BLUE:
	MOV	BL,CL
	MOV	[SI],DL
	MOV	15[SI],DL
	INC	SI
	MOV	[SI],DH
	MOV	15[SI],DH
	INC	SI
	MOV	[SI],BL
	MOV	15[SI],BL
	MOV	CX,0FH
	MOV	AX,0100H
	INT	SCR_DRV
RET_PALET:
	JMP	IT7999				;
;================================================
IT1300:				; AH = 5, select active display page
				; AL = new page value
				; *** NOTE. Only supporting page 0 here
	JMP	IT7999				;
;================================================
IT1400:				; AH = 0, set mode
				; AL = mode value
				; *** NOTE. Only supporting mode 2&3 here
	MOV	BH,01		; Assume IBM mode
	CMP	AL,2		; is it mono
	JE	SETMODE		; Yes
	CMP	AL,3		; Is it colour
	JNE	RETNOW		; No - then return to the caller
	MOV	BH,02		; Set colour
SETMODE:
	MOV	DS,CS:DS_SAV	; Get our ds
	MOV	DI,DS:IMAGE_ID	; get image id
	MOV	DS:MODE,BH	; save mode
	MOV	SI,0		; 
	MOV	BL,0
	MOV	CX,0		; Disable screen
	INT	SCR_DRV
	MOV	BH,DS:MODE	; recover mode
	INC	DS:MODE		; set return mode
	MOV	DX,0		; system image
	MOV	SI,0
	MOV	BL,0		; 80x25
	MOV	CX,1		; Enable screen
	INT	SCR_DRV
	MOV	DS:IMAGE_ID,DX	; Save image id
	CMP	DS:MODE,3	; Was it a colour mode
	JNE	setpal		; no - set pallette
	MOV	DI,DS:IMAGE_ID	; get image id
	MOV	DX,0120H	; space with colour index 1
	MOV	CX,08H		; smear spaces
	XOR	AX,AX		; on to the full screen
	MOV	BX,184FH
	INT	SCR_DRV
			; Set the Pallette
setpal:	MOV	DX,DS
	MOV	SI,OFFSET DGROUP:PALET1
	MOV	DI,DS:IMAGE_ID
	MOV	AX,0101H
	MOV	CX,0FH
	INT	SCR_DRV
RETNOW:;	JMP	IT7999				;
;================================================

IT7999:		POP	SI
		POP	DI
		POP	DX
		POP	CX
		POP	BX
		POP	DS
		POP	ES
INT10_RET:	IRET
INT_10		ENDP

IT8999:		POP	SI
		POP	DI
		POP	BX
		POP	BX
		POP	BX
		POP	DS
		POP	ES
		IRET

PROG		ENDS

		END
