
PAGE 66,132
TITLE IBM_EM_KEYTABLES
INCLUDE LEGAL.INC
;*****************************************************************************
;*
;*			PROGRAM IBM EMULATOR KEYBOARD TABLES
;*
;*	AUTHOR		M.Pendlebury
;*
;*	DATE		26/08/86
;*
;*	MODIFICATIONS
;*
;*****************************************************************************

DGROUP	GROUP DATA

DATA	SEGMENT	WORD	PUBLIC	'DATA'
	ASSUME	DS:DGROUP

PUBLIC	KEY_XLAT_TAB,IBMKEY
public	xisp,xidp

; ========================================== ;
; 	KEYBOARD TRANSLATION TABLE	     ;
; ========================================== ;
KEY_XLAT_TAB	label	byte
;-------------------------------------------------------------------
;	     ASCII | SCAN  |  APR TAB OP 
;-------------------------------------------------------------------
	DB	00H,03H		;00
	DB	01H,1EH		;01
	DB	02H,30H		;02
	DB	03H,2EH		;03
	DB	04H,20H		;04
	DB	05H,12H		;05
	DB	06H,21H		;06
	DB	07H,22H		;07
	DB	08H,0eH		;08
	DB	09H,0fH		;09
	DB	0AH,24H		;0a
	DB	0BH,25H		;0b
	DB	0CH,26H		;0c
	DB	0DH,1cH		;0d
	DB	0EH,31H		;0e
	DB	0FH,18H		;0f
	DB	10H,19H		;10
	DB	11H,10H		;11
	DB	12H,13H		;12
	DB	13H,1FH		;13
	DB	14H,14H		;14
	DB	15H,16H		;15
	DB	16H,2FH		;16
	DB	17H,11H		;17
	DB	18H,2DH		;18
	DB	19H,15H		;19
	DB	1AH,2CH		;1a
	DB	1BH,01H		;1b
	DB	1CH,2BH		;1c
	DB	1DH,1BH		;1d
	DB	1EH,07H		;1e
	DB	1FH,0CH		;1f
	DB	20H,39H		;20
	DB	21H,02H		;21
	DB	22H,28H		;22
	DB	23H,04H		;23
	DB	24H,05H		;24
	DB	25H,06H		;25
	DB	26H,08H		;26
	DB	27H,28H		;27
	DB	28H,0AH		;28
	DB	29H,0BH		;29
	DB	2AH,09H		;2a
	DB	2BH,0DH		;2b
	DB	2CH,33H		;2c
	DB	2DH,0CH		;2d
	DB	2EH,34H		;2e
	DB	2FH,35H		;2f
	DB	30H,0BH		;30
	DB	31H,02H		;31
	DB	32H,03H		;32
	DB	33H,04H		;33
	DB	34H,05H		;34
	DB	35H,06H		;35
	DB	36H,07H		;36
	DB	37H,08H		;37
	DB	38H,09H		;38
	DB	39H,0AH		;39
	DB	3AH,27H		;3a
	DB	3BH,27H		;3b
	DB	3CH,33H		;3c
	DB	3DH,0DH		;3d
	DB	3EH,34H		;3e
	DB	3FH,35H		;3f
	DB	40H,03H		;40
	DB	41H,1EH		;41
	DB	42H,30H		;42
	DB	43H,2EH		;43
	DB	44H,20H		;44
	DB	45H,12H		;45
	DB	46H,21H		;46
	DB	47H,22H		;47
	DB	48H,23H		;48
	DB	49H,17H		;49
	DB	4AH,24H		;4a
	DB	4BH,25H		;4b
	DB	4CH,26H		;4c
	DB	4DH,32H		;4d
	DB	4EH,31H		;4e
	DB	4FH,18H		;4f
	DB	50H,19H		;50
	DB	51H,10H		;51
	DB	52H,13H		;52
	DB	53H,1FH		;53
	DB	54H,14H		;54
	DB	55H,16H		;55
	DB	56H,2FH		;56
	DB	57H,11H		;57
	DB	58H,2DH		;58
	DB	59H,15H		;59
	DB	5AH,2CH		;5a
	DB	5BH,1AH		;5b
	DB	5CH,2BH		;5c
	DB	5DH,1BH		;5d
	DB	5EH,07H		;5e
	DB	5FH,0CH		;5f
	DB	60H,29H		;60
	DB	61H,1EH		;61
	DB	62H,30H		;62
	DB	63H,2EH		;63
	DB	64H,20H		;64
	DB	65H,12H		;65
	DB	66H,21H		;66
	DB	67H,22H		;67
	DB	68H,23H		;68
	DB	69H,17H		;69
	DB	6AH,24H		;6a
	DB	6BH,25H		;6b
	DB	6CH,26H		;6c
	DB	6DH,32H		;6d
	DB	6EH,31H		;6e
	DB	6FH,18H		;6f
	DB	70H,19H		;70
	DB	71H,10H		;71
	DB	72H,13H		;72
	DB	73H,1FH		;73
	DB	74H,14H		;74
	DB	75H,16H		;75
	DB	76H,2FH		;76
	DB	77H,11H		;77
	DB	78H,2DH		;78
	DB	79H,15H		;79
	DB	7AH,2CH		;7a
	DB	7BH,1AH		;7b
	DB	7CH,2BH		;7c
	DB	7DH,1BH		;7d
	DB	7EH,29H		;7e
	DB	7FH,0EH		;7f
;	alt keys 0..9 , - = ,A..Z
	DB	00,81h		;80
	db	00,78h		;81
	db	00,79h		;82
	db	00,7ah		;83
	db	00,7bh		;84
	db	00,7ch		;85
	db	00,7dh		;86
	db	00,7eh		;87
	db	00,7fh		;88
	db	00,80h		;89
	db	00,82h		;8a
	db	00,83h		;8b
	db	00,1eh		;8c
	db	00,30h		;8d
	db	00,2eh		;8e
	db	00,20h		;8f
	db	00,12h		;90
	db	00,21h		;91
	db	00,22h		;92
	db	00,23h		;93
	db	00,17h		;94
	db	00,24h		;95
	db	00,25h		;96
	db	00,26h		;97
	db	00,32h		;98
	db	00,31h		;99
	db	00,18h		;9a
	db	00,19h		;9b
	db	00,10h		;9c
	db	00,13h		;9d
	db	00,1fh		;9e
	db	00,14h		;9f
	db	00,16h		;a0
	db	00,2fh		;a1
	db	00,11h		;a2
	db	00,2dh		;a3
	db	00,15h		;a4
	db	00,2ch		;a5
; alt f1 - f10
	db	00,68h		;a6
	db      00,69h		;a7
	db	00,6ah		;a8
	db	00,6bh		;a9
	db	00,6ch		;aa
	db	00,6dh		;ab
	db	00,6eh		;ac
	db	00,6fh		;ad
	db	00,70h		;ae
	db	00,71h		;af
	db	00,00		;b0
; normal f1 - f10
	DB	00H,3BH		;b1
	DB	00H,3CH		;b2
	DB	00H,3DH		;b3
	DB	00H,3EH		;b4
	DB	00H,3FH		;b5
	DB	00H,40H		;b6
	DB	00H,41H		;b7
	DB	00H,42H		;b8
	DB	00H,43H		;b9
	DB	00H,44H		;ba

	DB	00H,50H		;bb
	DB	00H,4BH		;bc
	DB	00H,4DH		;bd
	DB	00H,47H		;be
	DB	00H,48H		;bf
	DB	00H,73H		;c0
	DB	00H,4DH		;c1
	DB	36H,4DH		;c2
	DB	00H,74H		;c3
	DB	00H,50H		;c4
	DB	32H,50H		;c5
	DB	00H,48H		;c6
	DB	38H,48H		;c7
	DB	00H,51H		;c8
	DB	33H,51H		;c9
	DB	00H,76H		;ca
	DB	00H,49H		;cb
	DB	39H,49H		;cc
	DB	00H,84H		;cd
	DB	00H,77H		;ce
	DB	00H,47H		;cf
	DB	37H,47H		;d0
	DB	00H,52H		;d1
	DB	30H,52H		;d2
	DB	00H,53H		;d3
	DB	2eH,53H		;d4
	DB	00H,72H		;d5
	DB	2aH,37H		;d6
	DB	1bH,1aH		;d7
	DB	08H,23H		;d8
	DB	00H,52H		;d9
	DB	00H,53H		;da
	DB	0dH,32H		;db
	DB	0aH,1CH		;dc
	DB	35H,4CH		;dd
	DB	2Dh,4AH		;de num pad -
	DB	2Bh,4EH		;df
	DB	09H,17H		;e0
	DB	00H,0FH		;e1
	DB	00H,4BH		;e2
	DB	34H,4BH		;e3
	DB	00H,4FH		;e4
	DB	31H,4FH		;e5
	DB	00H,75H		;e6
; shift f1 - f10
	db	00,54h		;e7
	db	00,55h		;e8
	db	00,56h		;e9
	db	00,57h		;ea
	db	00,58h		;eb
	db	00,59h		;ec
	db	00,5ah		;ed
	db	00,5bh		;ee
	db	00,5ch		;ef
	db	00,5dh		;f0
; f1	contrl f1 - f10
	db	00,5eh		;f1
	db	00,5fh		;f2
	db	00,60h		;f3
	db	00,61h		;f4
	db	00,62h		;f5
	db	00,63h		;f6
	db	00,64h		;f7
	db	00,65h		;f8
	db	00,66h		;f9
	db	00,67h		;fa
; fb
	db      00,00		;fb
	db	00,00		;fc
	db	00,00		;fd
	db	00,00		;fe
	db	00,00		;ff


;********************************************************
;							*
;		KEYBOARD TABLE				*
;							*
;********************************************************

;****************************************************************************
;*									    *
;*  File name:				[bios.candy.rom]keytab.asm	    *
;*  Programmer:				G. KURTH			    *
;*  Original implementation date:	29th March 1983			    *
;*  Language:				Intel 286 assembler.		    *
;*  Project name:		        Candyfloss BIOS			    *
;*  Revision history:			First Version 17-dec-1984	    *
;*									    *
;*			Edited the table for the IBM Emulator   19/11/85    *
;*                                                            Afzal Raja    *
;*                                                                          *
;****************************************************************************
;
;
;************************************************************************
;*									*
;*      KEYTABLES - This module contains the basic keyboard look-up     *
;*      tables for the generic BIOS.					*
;*      The main table consists of 416 WORDS, corresponding to the 104  *
;*	possible keyboard downcodes.					*
;*      The first 104 words contain the data for the normal (unshifted) *
;*      key codes, the next 104 words contain the data for the shifted  *
;*      key codes, and the next 104 words give the data for the CONTROL *
;*      codes, and the next 104 words give the data for the ALT codes.  *
;*									*
;*									*
;*      Each word provides the following information;-		        *
;*									*
;*   String Output		    15 bit String Offset from KT_tables *
;*     |						  |		*
;*     |   ---------------------------------------------------------    *
;*     |   |							   |    *
;*    (0) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X)   *
;*									*
;*   -----------------------------------------------------------------  *
;*   | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |  *
;*   -----------------------------------------------------------------  *
;*									*
;*    (1) (1) (1) (1) (1) (1) (X) (X) (X) (X) (X) (X) (X) (X) (X) (X)   *
;*     |   |   |   |   |   |   |   |   |			   |    *
;*     |   |   |   |   |   |   -----   -----------------------------    *
;*     |   |   |   |   |   |     |		         |	        *
;*     |   |   |   |   |   |     |      ASCII Key Data or Special Key   *
;*     |   |   |   |   |   |     |      type - see note below.		*
;*     |   |   |   |   |   |     |				        *
;*     |   |   |   |   |   |     ------ Key Prefix type:-		*
;*     |   |   |   |   |   |		  00 - No Prefix		*
;*     |   |   |   |   |   |		  01 - 'ESC' Prefix		*
;*     |   |   |   |   |   |		  10 - 'ESC','[' Prefix		*
;*     |   |   |   |   |   |		  11 - 'ESC','0' Prefix		*
;*     |   |   |   |   |   |						*
;*     |   |   |   |   |   ------------ Local Key (Data to Screen)      *
;*     |   |   |   |   ---------------- Affected by Caps. Lock		*
;*     |   |   |   -------------------- Affected by Shift Lock		*
;*     |   |   ------------------------ Auto-Repeat Allowed		*
;*     |   ---------------------------- Special Key (Type given by lsb) *
;*     -------------------------------- Non-String Key		        *
;*									*
;************************************************************************
;
;
;************************************************************************
;*									*
;*      The special key types are defined as follows:-		        *
;*									*
;*      00 - Null Key (no data output)					*
;*	01 - Caps lock key						*
;*	02 - Right hand shift						*
;*	03 - Left hand shift						*
;*	04 - Control key						*
;*	05 - stop key							*
;*	06 - calculator key						*
;*	07 - LCD echo key						*
;*	08 - voice key							*
;*      09 - ALT key							*
;*	0A - Print Key						        *
;*	0B - SYS REQ							*
;*									*
;*	F0-F9H - ALT mode specific numeric key				*
;*									*
;*      String keys reside in a string table situated at the end        *
;*      of the second keyboard table, which may be up to 32k long,      *
;*      and is pointed to by the 15-bit string pointer, and consists    *
;*      of the following data format:					*
;*									*
;*      Length  Type  Char1  Char2 ....... CharN			*
;*       byte	byte  byte   byte          byte				*
;*									*
;*      Where 'Type' is similar in format to the upper 8 bits of the    *
;*      normal key table word entry - the top two bits, however will    *
;*      not be significant.						*
;*      'Length' is the count, in words, of the ASCII string (Char1..   *
;*      ..CharN), if length = 0 then it is a null string, and will      *
;*      not produce an output.						*
;*      The 'Type' and 'Length' bytes can be treated as a word having   *
;*      a similar format to the normal lookup table entry, with the     *
;*      ASCII character bits being replaced by a length of string       *
;*      count, and the 'String' and 'Special' key bits not being        *
;*      significant.							*
;*      Default string table length is 192 words.			*
;*									*
;************************************************************************

;       data for unshifted (normal) keys
;	================================

;	     data    type		  key number
xisp	dw	7		;words to patch
	db	0b5h,10000000b
	db	0b6h,10000000b
	db	0b7h,10000000b
	db	0b8h,10000000b
	db	0b9h,10000000b
	db	0bah,10000000b
	db	00ch,11000000b

IBMKEY	DB	0B1H ,10000000B		;1      F1/HELP
	DB	0B2H ,10000000B		;2      F2/UNDO
	DB	0B3H ,10000000B		;3      F3/REPEAT
	DB	0B4H ,10000000B		;4      F4/CALC
xidp	DB	0B6H ,10000000B		;5      F6/PRINT
	DB	0B7h ,10000000B		;6      F7/INTR
	DB	0B8H ,10000000B		;7      F8/MENU
	DB	0B9H ,10000000B		;8      F9/FINISH
	DB	000H ,10100000B		;9      MB1	
	DB	000H ,10100000B		;11     MB2
	DB	00cH ,11000000B		;11     MB3     (new num lock)
	DB	000H ,10100000B		;12     MB4
	DB	000H ,10100000B		;13     MB5
	DB	000H ,10100000B		;14     MB6
	DB	'\'  ,10110000B		;15     \ uparrow
	DB	'1'  ,10110000B		;16     1!
	DB	'2'  ,10110000B		;17     2@
	DB	'3'  ,10110000B		;18     3#
	DB	'4'  ,10110000B		;19     4
	DB	'5'  ,10110000B		;20     5 (PERCENT)
	DB	'6'  ,10110000B		;21     6$
	DB	'7'  ,10110000B		;22     7&
	DB	'8'  ,10110000B		;23     8*
	DB	'9'  ,10110000B		;24     9(
	DB	'0'  ,10110000B		;25     0)
	DB	'-'  ,10110000B		;26     -_
	DB	'='  ,10110000B		;27     =+
	DB	008H ,10100000B		;28     BS
	DB	025h ,10100000B		;29     percent
	DB	'*'  ,10100000B		;30     *
	DB	'/'  ,10100000B		;31     DIVIDE
	DB	0DEH ,10100000B		;32     -
	DB	0DFH ,10100000B		;33     +
	DB	009H ,10100000B		;34     TAB/BACKTAB
	DB	'q'  ,10111000B		;35     Q
	DB	'w'  ,10111000B		;36     W
	DB	'e'  ,10111000B		;37     E
	DB	'r'  ,10111000B		;38     R
	DB	't'  ,10111000B		;39     T
	DB	'y'  ,10111000B		;40     Y
	DB	'u'  ,10111000B		;41     U
	DB	'i'  ,10111000B		;42     I
	DB	'o'  ,10111000B		;43     O
	DB	'p'  ,10111000B		;44     P
	DB	'['  ,10110000B		;45     [{
	DB	']'  ,10110000B		;46     ]}
	DB	0CFH ,10000000B		;47     HOME - ESC 'H'
	DB	000h ,10100000B		;48     CLEAR- ESC 'E'
	DB	0beh ,10111000B		;49     7
	DB	0bfh ,10111000B		;50     8
	DB	0CBH ,10111000B		;51     9
	DB	001H ,11000000B		;52     CAPS LOCK
	DB	'a'  ,10111000B		;53     A
	DB	's'  ,10111000B		;54     S
	DB	'd'  ,10111000B		;55     D
	DB	'f'  ,10111000B		;56     F
	DB	'g'  ,10111000B		;57     G
	DB	'h'  ,10111000B		;58     H
	DB	'j'  ,10111000B		;59     J
	DB	'k'  ,10111000B		;60     K
	DB	'l'  ,10111000B		;61     L
	DB	';'  ,10110000B		;62     ;:
	DB	027H ,10110000B		;63     quote/double quote
	DB	00DH ,10100000B		;64     RETURN
	DB	0D1H ,10100000B		;65     line/insert/char
	DB	0D3H ,10100000B		;66     line/delete/char
	DB	0bch ,10111000B		;67     4
	DB	0DDH ,10111000B		;68     5
	DB	0bdh ,10111000B		;69     6
	DB	003H ,11000000B		;70     Left-hand shift
	DB	'z'  ,10111000B		;71     Z
	DB	'x'  ,10111000B		;72     X
	DB	'c'  ,10111000B		;73     C
	DB	'v'  ,10111000B		;74     V
	DB	'b'  ,10111000B		;75     B
	DB	'n'  ,10111000B		;76     N
	DB	'm'  ,10111000B		;77     M
	DB	','  ,10110000B		;78     ,<
	DB	'.'  ,10110000B		;79     .>
	DB	'/'  ,10110000B		;80     /?
	DB	002H ,11000000B		;81     Right-hand shift
	DB	0C6H ,10100000B		;82     Up-Arrow
	DB	006H ,11000000B         ;83     Scroll Up-Down
	DB	0E4H ,10111000B		;84     1
	DB	0bbh ,10111000B		;85     2
	DB	0C8H ,10111000B		;86     3
	DB	01BH ,10100000B		;87     ESC
	DB	004H ,11000000B		;88     CONTROL
	DB	020H ,10100000B		;89     space
	DB	005H ,11000000B		;90     STOP
	DB	0E2H ,10100000B		;91     Left-Arrow
	DB	0C4H ,10100000B		;92     Down-Arrow
	DB	0C1H ,10100000B		;93     Right-Arrow
	DB	0d9h ,10100000B		;94     0
	DB	0dah ,10100000B		;95     .

	DB	0baH ,10000000B		;96     ENTER (f10)
	DB	0B5H ,10000000B		;97     F5 - VOICE/send
	DB	0BAH ,10000000B		;98     F10

	DB	009H ,11000000B		;99     ALT
	DB	'|'  ,10110000B		;100    pipe/tilde
	DB	00BH ,11000000B		;101    SYS REQ
	DB	00AH ,11000000B		;102    PRINT
	DB	000H ,11111000B		;103    spare7
	DB	000H ,11111000B		;104    spare8


        
;       shift values for keys
;	=====================        
        
	DB	0e7H ,10000000B		;1      F1/HELP
	DB	0e8H ,10000000B		;2      F2/UNDO
	DB	0e9H ,10000000B		;3      F3/REPEAT
	DB	0eaH ,10000000B		;4      F4/CALC
	DB	0ecH ,10000000B		;5      F6/PRINT
	DB	0edH ,10000000B		;6      F7/INTR
	DB	0eeH ,10000000B		;7      F8/MENU
	DB	0efH ,10000000B		;8      F9/FINISH
	DB	000H ,10100000B		;9      MB1
	DB	000H ,10100000B		;11     MB2
	DB	007  ,10100000B		;11     MB3
	DB	008  ,10100000B		;12     MB4
	DB	009  ,10100000B		;13     MB5
	DB	000  ,10100000B		;14     MB6
	DB	05EH ,10110000B		;15     \ uparrow
	DB	'!'  ,10110000B		;16     1!
	DB	'@'  ,10110000B		;17     2@
	DB	'#'  ,10110000B		;18     3#
	DB	156  ,10110000B		;19     4
	DB	25h  ,10110000B		;20     5 (percent)
	DB	'$'  ,10110000B		;21     6$
	DB	'&'  ,10110000B		;22     7&
	DB	'*'  ,10110000B		;23     8*
	DB	'('  ,10110000B		;24     9(
	DB	')'  ,10110000B		;25     0)
	DB	'_'  ,10110000B		;26     -_
	DB	'+'  ,10110000B		;27     =+
	DB	008H ,10100000B		;28     BS
	DB	'%'  ,10100000B		;29     percent 
	DB	0ah  ,11000000B		;30     * (print !!!! c.f. IBM)
	DB	'/'  ,10100000B		;31     DIVIDE
	DB	0DEH ,10100000B		;32     -
	DB	0DFH ,10100000B		;33     +
	DB	0e1H ,10100000B		;34     tab/backtab
	DB	'Q'  ,10111000B		;35     Q
	DB	'W'  ,10111000B		;36     W
	DB	'E'  ,10111000B		;37     E
	DB	'R'  ,10111000B		;38     R
	DB	'T'  ,10111000B		;39     T
	DB	'Y'  ,10111000B		;40     Y
	DB	'U'  ,10111000B		;41     U
	DB	'I'  ,10111000B		;42     I
	DB	'O'  ,10111000B		;43     O
	DB	'P'  ,10111000B		;44     P
	DB	'{'  ,10110000B		;45     [{
	DB	'}'  ,10110000B		;46     ]}
	DB	0D0H ,10000000B		;47     HOME - ESC 'H'
	DB	00cH ,11000000B		;48     CLEAR- ESC 'E'
	DB	'7'  ,10111000B		;49     7
	DB	'8'  ,10111000B		;50     8
	DB	0CCH ,10111000B		;51     9
	DB	001H ,11000000B		;52     CAPS LOCK
	DB	'A'  ,10111000B		;53     A
	DB	'S'  ,10111000B		;54     S
	DB	'D'  ,10111000B		;55     D
	DB	'F'  ,10111000B		;56     F
	DB	'G'  ,10111000B		;57     G
	DB	'H'  ,10111000B		;58     H
	DB	'J'  ,10111000B		;59     J
	DB	'K'  ,10111000B		;60     K
	DB	'L'  ,10111000B		;61     L
	DB	':'  ,10110000B		;62     ;:
	DB	022H ,10110000B		;63     quote/double quote
	DB	00DH ,10100000B		;64     RETURN
	DB	0D2H ,10100000B		;65     line/insert/char
	DB	0D4H ,10100000B		;66     line/delete/char
	DB	'4'  ,10111000B		;67     4
	DB	0DDH ,10111000B		;68     5
	DB	'6'  ,10111000B		;69     6
	DB	003H ,11111000B		;70     left-hand shift
	DB	'Z'  ,10111000B		;71     Z
	DB	'X'  ,10111000B		;72     X
	DB	'C'  ,10111000B		;73     C
	DB	'V'  ,10111000B		;74     V
	DB	'B'  ,10111000B		;75     B
	DB	'N'  ,10111000B		;76     N
	DB	'M'  ,10111000B		;77     M
	DB	'<'  ,10110000B		;78     ,<
	DB	'>'  ,10110000B		;79     .>
	DB	'?'  ,10110000B		;80     /?
	DB	002H ,11000000B		;81     right hand shift
        DB	0C7H ,10100000B		;82     Up-Arrow
	DB	006H ,11000000B		;83     Scroll Up-Down
	DB	0E5H ,10111000B		;84     1
	DB	'2'  ,10111000B		;85     2
	DB	0C9H ,10111000B		;86     3
	DB	01BH ,10100000B		;87     ESC
	DB	004H ,11000000B		;88     CONTROL
	DB	020H ,10100000B		;89     space
	DB	005H ,11000000B		;90     STOP
	DB	0E3H ,10100000B		;91     Left-Arrow
        Db	0C5H ,10100000B		;92     Down-Arrow
	DB	0C2H ,10100000B		;93     Right-Arrow
	DB	'0'  ,10100000B		;94     0
	DB	'.'  ,10100000B		;95     .
	DB	0f0H ,10000000B		;96     ENTER
	DB	0ebH ,10000000B		;97     F5 - VOICE/send
	DB	000H ,10000000B		;98     F10
	DB	009H ,11000000B		;99     ALT
	DB	'~'  ,10110000B		;100    pipe/tilde
	DB	00BH ,11000000B		;101    SYS REQ
	DB	00AH ,11000000B		;102    PRINT
	DB	000H ,11111000B		;103    spare7
	DB	000H ,11111000B		;104    spare8
        


;       Control values for keys
;	=======================        


	DB	0f1H ,10000000B		;1      F1/HELP
        DB	0f2H ,10000000B	        ;2      F2/UNDO
        DB	0f3H ,10000000B		;3      F3/REPEAT
        DB	0f4H ,10000000B		;4      F4/CALC
	DB	0f6H ,10000000B		;5      F6/PRINT
	DB	0f7H ,10000000B		;6      F7/INTR
	DB	0f8H ,10000000B		;7      F8/MENU
	DB	0f9H ,10000000B		;8      F9/FINISH
	DB	0H   ,10100000B		;9      MB1
	DB	00H  ,10100000B		;11     MB2
	DB	00H  ,10100000B		;11     MB3
	DB	00H  ,10100000B		;12     MB4
	DB	00H  ,10100000B		;13     MB5
	DB	00H  ,10100000B		;14     MB6
	DB	'\'  ,10110000B		;15     \ uparrow
	DB	172  ,10000000B		;16     1!
	DB	00H  ,10000000B		;17     2@
	DB	000H ,10000000B		;18     3#
	DB	157  ,10000000B		;19     4
	DB	248  ,10000000B		;20     5 percent
	DB	1EH  ,10000000B		;21     6$
	DB	'`'  ,10000000B		;22     7&
	DB	241  ,10000000B		;23     8*
	DB	'~'  ,10110000B		;24     9(
	DB	'|'  ,10110000B		;25     0)
	DB	'-'  ,10110000B		;26     -_
	DB	'='  ,10110000B		;27     =+
	DB	7FH  ,10100000B		;28     BS
	DB	25h  ,10100000B		;29     percent
	DB	'*'  ,10100000B		;30     *
	DB	'/'  ,10100000B		;31     DIVIDE
	DB	0DEH ,10100000B		;32     -
	DB	0DFH ,10100000B		;33     +
	DB	009H ,10100000B		;34     tab/backtab
	DB	011H ,10111000B         ;35     Q
	DB	017H ,10111000B         ;36     W
	DB	005H ,10111000B         ;37     E
	DB	012H ,10111000B         ;38     R
	DB	014H ,10111000B         ;39     T
	DB	019H ,10111000B         ;40     Y
	DB	015H ,10111000B         ;41     U
	DB	0e0H ,10111000B         ;42     I
	DB	00FH ,10111000B         ;43     O
	DB	010H ,10111000B         ;44     P
	DB	0d7H ,10110000B	 	;45     [{
	DB	01DH ,10110000B		;46     ]}
	DB	0ceH ,10000000B		;47     HOME - LOCAL ESC 'H'
	DB	000H ,10000100B		;48     CLEAR- LOCAL ESC 'z'
	DB	'7'  ,10100000B		;49     7
	DB	'8'  ,10100000B		;50     8
	DB	0CDH ,10100000B		;51     9
	DB	001H ,11000000B		;52     CAPS LOCK
	DB	01H  ,10111000B         ;53     A
	DB	13H  ,10111000B         ;54     S
	DB	04H  ,10111000B         ;55     D
	DB	06H  ,10111000B         ;56     F
	DB	07H  ,10111000B         ;57     G
	DB	0d8H ,10111000B         ;58     H
	DB	0AH  ,10111000B         ;59     J
	DB	0BH  ,10111000B         ;60     K
	DB	0CH  ,10111000B         ;61     L
	DB	';'  ,10110000B		;62     ;:
	DB	027H ,10110000B		;63     quote/double quote
	DB	00aH ,10100000B		;64     RETURN
	DB	00H  ,10100000B		;65     line/insert/char
	DB	00H  ,10100000B		;66     line/delete/char
	DB	'4'  ,10100000B		;67     4
	DB	'5'  ,10100000B		;68     5
	DB	1EH  ,10100000B		;69     6
	DB	003H ,11000000B		;70     left hand shift
	DB	01AH ,10111000B         ;71     Z
	DB	018H ,10111000B         ;72     X
	DB	003H ,10111000B         ;73     C
	DB	016H ,10111000B         ;74     V
	DB	002H ,10111000B         ;75     B
	DB	00EH ,10111000B         ;76     N
	DB	0dbH ,10111000B         ;77     M
	DB	','  ,10110000B		;78     ,<
	DB	'.'  ,10110000B		;79     .>
	DB	'/'  ,10110000B		;80     /?
	DB	002H ,11000000B		;81     right hand shift
        DW	CON_UP			;82     Up-Arrow
	DB	000H ,10000000B		;83     Scroll Up-Down
	DB	0e6h ,10100000B		;84     1
	DB	'2'  ,10100000B		;85     2
	DB	0CAH ,10100000B		;86     3
	DB	01BH ,10100000B		;87     ESC
	DB	004H ,11000000B		;88     CONTROL
	DB	020H ,10100000B		;89     space
	DB	005H ,11000000B		;90     STOP
        DB	0C0H ,10100000B		;91     Left-Arrow
        DW	CON_DN			;92     Down-Arrow
        DB	0C3H ,10100000B		;93     Right-Arrow
	DB	'0'  ,10100000B		;94     0
	DB	'.'  ,10100000B		;95     
	DB	0faH ,10000000B		;96     ENTER
	DB	0f5H ,10000000B		;97      F5 - VOICE/send
	DB	0baH ,10000000B		;98     F10
	DB	009H ,11000000B		;99     ALT
	DB	'~'  ,10110000B		;100    pipe/tilde
	DB	00BH ,11000000B		;101    SYS REQ
	DB	00AH ,11000000B		;102    PRINT
	DB	000H ,11111000B		;103    spare7
	DB	000H ,11111000B		;104    spare8
        

;       ALT values for keys
;	===================
       


	DB	0a6H ,10000000B		;1      F1/HELP
        DB	0a7H ,10000000B	        ;2      F2/UNDO
        DB	0a8H ,10000000B		;3      F3/REPEAT
        DB	0a9H ,10000000B		;4      F4/CALC
	DB	0abH ,10000000B		;5      F6/PRINT
	DB	0acH ,10000000B		;6      F7/INTR
	DB	0adH ,10000000B		;7      F8/MENU
	DB	0aeH ,10000000B		;8      F9/FINISH
	DB	0H   ,10100000B		;9      MB1
	DB	00H  ,10100000B		;11     MB2
	DB	00H  ,10100000B		;11     MB3
	DB	00H  ,10100000B		;12     MB4
	DB	00H  ,10100000B		;13     MB5
	DB	00H  ,10100000B		;14     MB6
	DB	'\'  ,10110000B		;15     \ uparrow
	DB	80h  ,10000000B		;16     1!
	DB	81H  ,10000000B		;17     2@
	DB	82H  ,10000000B		;18     3#
	DB	83h  ,10000000B		;19     4
	DB	84h  ,10000000B		;20     5 percent
	DB	85h  ,10000000B		;21     6$
	DB	86h  ,10000000B		;22     7&
	DB	87h  ,10000000B		;23     8*
	DB	88h  ,10110000B		;24     9(
	DB	89h  ,10110000B		;25     0)
	DB	8ah  ,10110000B		;26     -_
	DB	8bh  ,10110000B		;27     =+
	DB	7FH  ,10100000B		;28     BS
	DB	25h  ,10100000B		;29     percent
	DB	'*'  ,10100000B		;30     *
	DB	'/'  ,10100000B		;31     DIVIDE
	DB	0DEH ,10100000B		;32     -
	DB	0DFH ,10100000B		;33     +
	DB	00H  ,10100000B		;34     tab/backtab
	DB	'Q'+4BH ,10111000B      ;35     Q
	DB	'W'+4BH ,10111000B      ;36     W
	DB	'E'+4BH ,10111000B      ;37     E
	DB	'R'+4BH ,10111000B      ;38     R
	DB	'T'+4BH ,10111000B      ;39     T
	DB	'Y'+4BH ,10111000B      ;40     Y
	DB	'U'+4BH ,10111000B      ;41     U
	DB	'I'+4BH ,10111000B      ;42     I
	DB	'O'+4BH ,10111000B      ;43     O
	DB	'P'+4BH ,10111000B      ;44     P
	DB	0D7H ,10110000B		;45     [{
	DB	01DH ,10110000B		;46     ]}
	DB	00H  ,10000100B		;47     HOME - LOCAL ESC 'H'
	DB	00H  ,10000100B		;48     CLEAR- LOCAL ESC 'z'
	DB	0f7h ,11000000B		;49     7
	DB	0f8h ,11000000B		;50     8
	DB	0f9h ,11000000B		;51     9
	DB	001H ,11000000B		;52     CAPS LOCK
	DB	'A'+4BH ,10111000B      ;53     A
	DB	'S'+4BH ,10111000B      ;54     S
	DB	'D'+4BH ,10111000B      ;55     D
	DB	'F'+4BH ,10111000B      ;56     F
	DB	'G'+4BH ,10111000B      ;57     G
	DB	'H'+4BH ,10111000B      ;58     H
	DB	'J'+4BH ,10111000B      ;59     J
	DB	'K'+4BH ,10111000B      ;60     K
	DB	'L'+4BH ,10111000B      ;61     L
	DB	';'  ,10110000B		;62     ;:
	DB	027H ,10110000B		;63     quote/double quote
	DB	00DH ,10100000B		;64     RETURN
	DB	00H  ,10100000B		;65     line/insert/char
	DB	00H  ,10100000B		;66     line/delete/char
	DB	0f4h ,11000000B		;67     4
	DB	0f5h ,11000000B		;68     5
	DB	0f6h ,11000000B		;69     6
	DB	003H ,11000000B		;70     left hand shift
	DB	'Z'+4BH ,10111000B      ;71     Z
	DB	'X'+4BH ,10111000B      ;72     X
	DB	'C'+4BH ,10111000B      ;73     C
	DB	'V'+4BH ,10111000B      ;74     V
	DB	'B'+4BH ,10111000B      ;75     B
	DB	'N'+4BH ,10111000B      ;76     N
	DB	'M'+4BH ,10111000B      ;77     M
	DB	','  ,10110000B		;78     ,<
	DB	'.'  ,10110000B		;79     .>
	DB	'/'  ,10110000B		;80     /?
	DB	002H ,11000000B		;81     right hand shift
        DB	00H  ,10000000B		;82     Up-Arrow
	DB	000H ,10000000B		;83     Scroll Up-Down
	DB	0f1h ,11000000B		;84     1
	DB	0f2h ,11000000B		;85     2
	DB	0f3h ,11000000B		;86     3
	DB	01BH ,10100000B		;87     ESC
	DB	004H ,11000000B		;88     CONTROL
	DB	020H ,10100000B		;89     space
	DB	005H ,11000000B		;90     STOP
        DB	0C0H ,10100000B		;91     Left-Arrow
        DB	0H   ,10100000B		;92     Down-Arrow
        DB	0C3H ,10100000B		;93     Right-Arrow
	DB	0f0h ,11000000B		;94     0
	DB	'.'  ,10100000B		;95     
	DB	0afH ,10000000B		;96     ENTER
	DB	0aaH ,10000000B		;97      F5 - VOICE/send
	DB	0baH ,10000000B		;98     F10
	DB	009H ,11000000B		;99     ALT
	DB	'~'  ,10110000B		;100    pipe/tilde
	DB	00BH ,11000000B		;101    SYS REQ
	DB	00AH ,11000000B		;102    PRINT
	DB	000H ,11111000B		;103    spare7
	DB	000H ,11111000B		;104    spare8

;	0Block reserved for Default String tables. (192 BYTES)
;	=====================================================

CON_UP	DB	3,10100100B,27,'y','E'
CON_DN	DB	3,10100100B,27,'x','E'
SCR_UP	DB	3,10000100B,27,'y','D'
SCR_DN	DB	3,10000100B,27,'x','D'
SND_UP	DB	3,10100100B,27,'y','F'
SND_DN	DB	3,10100100B,27,'x','F'

lcd	DB	3,10100100b,27,'7','L'
col	DB	3,10100100b,27,'7','C'
c40	DB	3,10100100b,27,'7','F'
bth	DB	3,10100100b,27,'7','B'
 
	DB	(192-50) dup (0)

PUBLIC	con_up,con_dn,scr_up,scr_dn,snd_up,snd_dn,lcd,col,c40,bth

;***********	KEYBOARD TABLE ENDS		*********

DATA		ENDS

		END
