MODULE ADD_NEW_RESULTS; (*$DEBUG+*)

const

	DEBUG=0;	(* equal to  : 	        			*)
			(* 1 - add-result prints result inputted	*)
			(* 2 - odds_cnvrt debug 			*)
			(* 4 - 						*)
			(* 8 -						*)

(*$INCLUDE:'SCREEN.H'*)
(*$INCLUDE:'DEFS.H'*)
(*$INCLUDE:'GEN-ROUT.H'*)

	    
PROCEDURE limit_stop(var finish : boolean);				(* Alerts user that no more new results can be added & *)
									(* forces finish to be true on return. *)
var  dummy : char;
begin
	printmid(12,'ERROR - Too many new results have been added without updating');
	printmid(14,'        the file; You must select the option;                ');
	printmid(15,'                                                             ');
	printmid(16,'              "Process New Results & Queries"                ');
	printmid(17,'                               				    ');
	printmid(18,'        in order to add any more new results.                ');
	printmid(19,'                               				    ');
	printmid(20,' (Note. you may set up a query first.)                       ');
	perror(null);
	finish:=true;
end;
	

FUNCTION odds_cnvrt(temp_odds : str;					(* Converts 2-1 or 2/1 to 0.5 : rets false if not valid *)
		    var cnvrted_odds : real) : boolean;
var
	loop,odd1,odd2		: integer;
	notvalid		: boolean;
begin
    notvalid:=false;
    odd1:=0;
    odd2:=0;
    loop:=1;
    IF (DEBUG=2) THEN writeln('odds_cnvrt: temp_odds=',temp_odds);
    while (loop<ord(temp_odds.len)) and (temp_odds[loop]>='0') and
	 (temp_odds[loop]<='9') do
      begin
	odd1:=(odd1*10)+(ord(temp_odds[loop])-ord('0'));
	loop:=loop+1;
      end;
    IF (DEBUG=2) THEN writeln('odds_cnvrt: odd1=',odd1,'notvalid=',notvalid);
    if (odd1=0) or (loop=ord(temp_odds.len)) then notvalid:=true;
    case temp_odds[loop] of
        '-','/' : loop:=loop+1;
        otherwise notvalid:=true;
    end; (*case*)
    while (loop<=ord(temp_odds.len)) and (temp_odds[loop]>='0') and
	 (temp_odds[loop]<='9') do
      begin
	odd2:=(odd2*10)+(ord(temp_odds[loop])-ord('0'));
	loop:=loop+1;
      end;
    IF (DEBUG=2) THEN writeln('odds_cnvrt: odd2=',odd2,'notvalid=',notvalid);
    if (odd2=0) then notvalid:=true;
    if not notvalid then cnvrted_odds:=odd2/odd1;
    odds_cnvrt:=(not notvalid);
end;

PROCEDURE read_new_result(var new_result	: result;
			  var ending 		: boolean);                 (* reads a result, if user aborts ending set true*)
VAR
	temp_str				: str;
	ok,temp_yn				: boolean;
   	temp_month 				: month_type;
   	months     				: array [1..12] of month_type;
   	month_num 				: integer;
   	temp_age  				: integer;
begin
	months[1]:='JAN';
	months[2]:='FEB';
	months[3]:='MAR';
	months[4]:='APR';
	months[5]:='MAY';
	months[6]:='JUN';
	months[7]:='JUL';
	months[8]:='AUG';
	months[9]:='SEP';
	months[10]:='OCT';
	months[11]:='NOV';
	months[12]:='DEC';
	write(clearscrn);

        write(clearscrn,boldon);
        printmid(1,'Add new racing results to computer.');
        write(attriboff);
        ending:=false;
	printat(03,1,'Race Details.');
	printat(04,1,'-------------');
	printat(05,1,'              Press ESC to quit screen at any time.');
	printat(06,1,' ');
	printat(07,1,'Month of race (Jan,Feb etc)  : [   ]');
	printat(08,1,'No. of Runners : [  ]');
	printat(09,1,'Name of Course : [          ]');
	printat(10,1,'Age of horses (0 - not restricted) : [ ]');
	printat(11,1,'Handicapped (Yes/No) : [ ]');
	printat(12,1,'Type of course (Flat/Hurdles) : [ ]');
	printat(13,1,' ');
	printat(14,1,'Horse/Jockey Details.');
	printat(15,1,'---------------------');
	printat(16,1,' ');
	printat(17,1,'Horse name  : [                    ]');
	printat(18,1,'Jockey name : [                    ]');
	printat(19,1,'Odds to win : [       ]');
	printat(20,1,'Favourite / 2nd Fav/ X=other : [ ]');

	ok:=false;
	while (not ok) and (not ending) do
	  begin
	    temp_month:=sinput(07,33,3,ending);
	    if not ending then
		begin
		  month_num:=0;
		  repeat
		    begin
		      month_num:=month_num+1;
		      if temp_month=months[month_num] then ok:=true;
		    end;
                  until (ok or (month_num=12));
		  if not ok then perror('Error - invalid month : enter JAN,FEB etc')
	        end
	  end;
	if not ending then new_result.month:=chr(ord('A')+month_num-1);
	ok:=false;
	while (not ending) and (not ok) do
	  begin
 	    new_result.runners:=ninput(08,19,2,ending);
	    if ((not ending) and ((new_result.runners<2) or (new_result.runners>50))) then
	      perror('Error - invalid no. of runners (2-50) : re-enter')
	    else ok:=true;
	  end;
	if not ending then new_result.course:=sinput(09,19,10,ending);
	if not ending then temp_age:=ninput(10,39,1,ending);
	if not ending then new_result.age:=chr(ord('0')+temp_age);
	if not ending then temp_yn:=binput(11,25,1,ending);
	if (temp_yn=true) then new_result.handicap:='Y'
		 else new_result.handicap:='N';
	ok:=false;
	while (not ok) and (not ending) do
	  begin
	    temp_str:=sinput(12,34,1,ending);
	    if not ending then
	      case temp_str[1] of
		  'F','H' : begin
				ok:=true;
				new_result.crse_type:=temp_str[1];
			    end;
	         otherwise perror('Error - invalid course type : enter F or H')
	      end
	  end;
	if not ending then new_result.horse:=sinput(17,16,20,ending);
	if not ending then new_result.jockey:=sinput(18,16,20,ending);
	ok:=false;
	while (not ok) and (not ending) do
	  begin
	    temp_str:=sinput(19,16,7,ending);
	    if not ending then
	      begin
		ok:=odds_cnvrt(temp_str,new_result.odds);			(* rets ok as true/false & rets odds as real *)
		if not ok then perror('Error - invalid odds : enter as 5-1 etc');
	      end;
	  end;
	ok:=false;
	while (not ok) and (not ending) do
	  begin
	    temp_str:=sinput(20,33,1,ending);
	    if not ending then
		case temp_str[1] of
		   'F','2','X' : begin
				   ok:=true;
				   new_result.grade:=temp_str[1];
				 end;
	          otherwise perror('Error - invalid choice : enter F, 2 or X')
	        end
	  end;

 IF (DEBUG =3) THEN
  BEGIN
  with new_result do
    begin
      printat(24,1,null);
      writeln('month : ',month);
      writeln('runners : ',runners);
      writeln('odds : ',odds);	
      writeln('grade : ',grade);
      writeln('jockey : ',jockey);
      writeln('horse : ',horse);	 
      writeln('course : ',course); 
      writeln('age : ',age);	  
      writeln('handicap : ',handicap);
      writeln('crse_type : ',crse_type);
    end;
  END;
end;

PROCEDURE alert_no_switchoff;				(* just tells user to exit by sw not switch off *)
begin
     write(clearscrn,boldon);
     printmid(1,'CBPS -  HORSE RACING SYSTEM.');
     write(attriboff);
     printat(13,10,'NOTE. You have now entered new data into memory.');
     printat(15,15,'You must NOT switch off the computer without exitting this');
     printat(16,15,'program first. (failure to do this may result in losing data.)');
     perror('Please acknowledge');
end;

PROCEDURE add_results(var new_results 		: result_buf;
		      var num_new_results       : num_result_add_range) [PUBLIC];

var
	finish,ok,ending			: boolean;
	tempstr					: str;
begin
  if (DEBUG>0) then writeln('add-res: num_new_results=',num_new_results);
  if (DEBUG>0) then perror('continue');
  finish:=false;
  while (not finish) do
   begin
     write(clearscrn,boldon);
     printmid(1,'Add new racing results to computer.');
     write(attriboff);
     if num_new_results=maxnum_new then limit_stop(finish)		(* forces finish true after limit message *)
     else
       begin
	 ending:=false;
         read_new_result(new_results[num_new_results],ending);  (* reads a result, or quits with ending true*)

         if ending then
	    perror('Entries on this screen have been cancelled. Acknowledge ...')
	 else
	   begin
		 ok:=false;
		 while (not ok) do
		  begin
			printat(22,20,'Confirm the above is correct  (Y/N) : ');
			tempstr:=sinput(22,58,1,ending);
                        if ending then tempstr[1]:='N';
                        case tempstr[1] of
			   'Y' : begin num_new_results:=num_new_results+1;
				       ok:=true; end;
			   'N' : ok:=true;
			  otherwise perror('Error - invalid character : enter Y or N');
			end;
		  end;
		 printat(22,1,delline);
            end;

	 ok:=false;
	 while (not ok) do
		  begin
			printat(22,20,'Do you wish to add another result (Y/N) : ');
			tempstr:=sinput(22,62,1,ending);
                        if ending then tempstr[1]:='N';
			case tempstr[1] of
			   'N' : begin finish:=true; ok:=true; end;
			   'Y' : ok:=true;
			  otherwise perror('Error - invalid character : enter Y or N');
			end;
		   end;
	 printat(22,1,delline);
       end;
   end;
   if (num_new_results>0) then alert_no_switchoff;
   if (DEBUG>0) then writeln('add-res: num_new_results=',num_new_results);
   if (DEBUG>0) then perror('continue');
end;

end.
