MODULE addpersonal_bets; (*$DEBUG+*)

const

	DEBUG=0;	(* divisible by :         			*)
			(* 1 -                                    	*)
			(* 2 -                   			*)
			(* 4 - 						*)
			(* 8 -						*)

(*$INCLUDE:'SCREEN.H'*)
(*$INCLUDE:'DEFS.H'*)
(*$INCLUDE:'GEN-ROUT.H'*)


PROCEDURE op_new_file(var fp : text; var old_filename : str); 	(* open an original file *)
									(* This should be a simple matter of opening a filename *)
									(* unfortunately in Pascals wisdom there is no rename   *)
									(* so once the file is opened & used, it can not be     *)
									(* renamed to the proper data file & so next time this *)
									(* procedure is used a new filename has to be used  *)
									(* A bracketed vers of this proc follows which uses an *)
									(* imaginary rename procedure. *)
begin
(* **************** IGNORE THIS CODE (see note above) ********************* *)
(*	fp.mode:=SEQUENTIAL;                                                *)
(*	fp.trap:=true;                                                      *)
(*	assign(fp,'NEW-P.DAT');                                             *)
(*	rewrite(fp);                                                        *)
(*	if fp.errs<>wrd(0) then						    *)	(* got problems with re-write - abort *)
(*	  begin                                                             *)
(*		perror('ERROR - data file creation error (Press return for more info)');        *)
(*		write(clearscrn);                                                               *)
(*		printmid(1,'Data file creation error. - error no. A2');                         *)
(*		printat(3,10,'The program cannot continue. The data file NEW-P.DAT could not ');*)
(*		printat(4,10,'be successfully created.');                                       *)
(*		printat(8,10,'Your course of action should be :');                              *)
(*		printat(10,15,'Notify CBPS of the circumstances of this event.');               *)
(*		printat(11,15,'Try running the system again.');                                 *)
(*		closedown('A2');                                                                *)
(*	  end;                                                                                  *)
(*	old_filename:='RACE-P.DAT';								*)
			 (* for compatibility reasons - leave it *)
(*end;                                                                                          *)
(*									      *)
(* ************************************************************************** *)


	fp.mode:=SEQUENTIAL;
	fp.trap:=true;
	assign(fp,'RACE-P.DAT');
	reset(fp);
	if fp.errs=wrd(0) then 		(* want to find original file - if reset ok then file exists *)
	  begin				(* so try another *)
	    close(fp);
	    fp.mode:=SEQUENTIAL;
	    fp.trap:=true;
	    fp.errs:=wrd(0);
	    assign(fp,'RACE2-P.DAT');
	    reset(fp);
	    if fp.errs=wrd(0) then 	(* Oh dear, both files exist but which is data file ?? *)
	     begin			(* How about telling user to delete smallest file ..*)
					(* The only way to get this situ is if system crashes so *)
					(* largest would be best *)
		perror('ERROR - data file contention (Press return for more info)');
		write(clearscrn);
		printmid(1,'Data file contention.- error no. A01');
		printat(3,10,'The program cannot continue. Two files were found to ');
		printat(4,10,'exist when only one should have done.');
		printat(8,10,'Your course of action should be :');
		printat(10,15,'Notify CBPS of the circumstances of this event.');
		printat(11,15,'Delete the smaller sized file of either RACE-P.DAT or RACE2-P.DAT');
		printmid(15,'You should then be able to successfully continue running the system.');
		closedown('A1');
	     end;
            if fp.errs<>wrd(10) then	(* got unnormal file error *)
	       begin
	    	perror('ERROR - data file open error (Press return for more info)');
	    	write(clearscrn);
	    	printmid(1,'Data file open error. - error no. A02');
	    	printat(3,10,'The program cannot continue. The data file RACE2-P.DAT could not ');
	    	printat(4,10,'be successfully opened.');
	    	printat(5,10,'A file error number of ');
	    	write(fp.errs,' was obtained.');
	    	printat(8,10,'Your course of action should be :');
	    	printat(10,15,'Notify CBPS of the circumstances of this event.');
	    	printat(11,15,'Try running the system again.');
	    	closedown('A2');
	       end;
	    fp.errs:=wrd(0);	(* reset pascal to use files *)
	    rewrite(fp);		(* good, file didn;t exist so now create it *)
	    if fp.errs<>wrd(0) then	(* Oh dear dear, got a nasty from rewrite - got to abort *)
	     begin
		perror('ERROR - data file creation error (Press return for more info)');
		write(clearscrn);
		printmid(1,'Data file creation error. - error no. A03');
		printat(3,10,'The program cannot continue. The data file RACE2-P.DAT could not ');
		printat(4,10,'be successfully created.');
	    	printat(5,10,'A file error number of ');
	    	write(fp.errs,' was obtained.');
		printat(8,10,'Your course of action should be :');
		printat(10,15,'Notify CBPS of the circumstances of this event.');
		printat(11,15,'Try running the system again.');
		closedown('A3');
	     end;
	    old_filename:='RACE-P.DAT';
	  end
	else
	 begin
	  if fp.errs<>wrd(10) then	(* Oh. wasn't file not found error no - more serious *)
	    begin
	    	perror('ERROR - data file open error (Press return for more info)');
	    	write(clearscrn);
	    	printmid(1,'Data file open error. - error no. A04');
	    	printat(3,10,'The program cannot continue. The data file RACE-P.DAT could not ');
	    	printat(4,10,'be successfully opened.');
	    	printat(5,10,'A file error number of ');
	    	write(fp.errs,' was obtained.');
	    	printat(8,10,'Your course of action should be :');
	    	printat(10,15,'Notify CBPS of the circumstances of this event.');
	    	printat(11,15,'Try running the system again.');
	    	closedown('A4');
	    end
	  else
	   begin
	    fp.errs:=wrd(0);	(* reset pascal files *)
	    rewrite(fp);		(* good, file didn't exist so now create it *)
	    if fp.errs<>wrd(0) then	(* Oh dear dear, got a nasty from rewrite - got to abort *)
	     begin
		perror('ERROR - data file creation error (Press return for more info)');
		write(clearscrn);
		printmid(1,'Data file creation error. - error no. A05');
		printat(3,10,'The program cannot continue. The data file RACE-P.DAT could not ');
		printat(4,10,'be successfully created.');
		printat(5,10,'A file error number of ');
		write(fp.errs,' was obtained.');
		printat(8,10,'Your course of action should be :');
		printat(10,15,'Notify CBPS of the circumstances of this event.');
		printat(11,15,'Try running the system again.');
		closedown('A5');
	     end;
	    old_filename:='RACE2-P.DAT';
	  end;
	 end;
    if (DEBUG>2) then writeln('op_new_file: old_filename=',old_filename);
end;

PROCEDURE op_old_file(var fp : text; old_filename : str;
		      var not_exist : boolean);
begin
	fp.mode:=SEQUENTIAL;
	fp.trap:=true;
	assign(fp,old_filename);
	reset(fp);
	if ((fp.errs<>wrd(0)) and (fp.errs<>wrd(10))) then
	  begin
	    perror('ERROR - data file open error (Press return for more info)');
	    write(clearscrn);
	    printmid(1,'Data file open error. - error no. A06');
	    printat(3,10,'The program cannot continue. The data file ');
	    write(old_filename,' could not ');
	    printat(4,10,'be successfully opened.');
	    printat(5,10,'A file error number of ');
	    write(fp.errs,' was obtained.');
	    printat(8,10,'Your course of action should be :');
	    printat(10,15,'Notify CBPS of the circumstances of this event.');
	    printat(11,15,'Try running the system again.');
	    closedown('A6');
	  end;
	if (fp.errs=wrd(0)) then  (* to get here either got errs=0 or 10 *)
	   not_exist:=false
	else
	 begin
	   perror('Warning - No personal betting data file was found. Acknowledge ...');
	   not_exist:=true;
	 end;
end;

PROCEDURE debug_print(rd_rec : bookresult);
begin
   writeln('DEBUG print record :');
   with rd_rec do
    begin
      writeln(date);
      writeln(bet_pounds);
      writeln(bet_pence);
      writeln(odds);
      writeln(won_pounds);
      writeln(won_pence);
    end;
end;

PROCEDURE wrte_rec(var fp : text; rd_rec : bookresult);
begin
   with rd_rec do
    begin
      writeln(fp,date);
      writeln(fp,bet_pounds);
      writeln(fp,bet_pence);
      writeln(fp,odds);
      writeln(fp,won_pounds);
      writeln(fp,won_pence);
    end;
end;

PROCEDURE rd_rec(var fp : text; var rd_rec : bookresult; var at_eof : boolean);
begin
  with rd_rec do
    begin
      readln(fp,date);
      readln(fp,bet_pounds);
      readln(fp,bet_pence);
      readln(fp,odds);
      readln(fp,won_pounds);
      readln(fp,won_pence);
    end;
  if (eof(fp)) then at_eof:=true;
end;

PROCEDURE clse_file(var fp : text);
begin
  	if (DEBUG>2) then writeln('clse_file');
	close(fp);
	if fp.errs<>wrd(0) then
	  begin
	    perror('ERROR - data file close error (Press return for more info)');
	    write(clearscrn);
	    printmid(1,'Data file close error. - error no. A07');
	    printat(3,10,'The program cannot continue. A data file could not ');
	    printat(4,10,'be successfully closed.');
	    printat(5,10,'A file error number of ');
	    write(fp.errs,' was obtained.');
	    printat(8,10,'Your course of action should be :');
	    printat(10,15,'Notify CBPS of the circumstances of this event.');
	    printat(11,15,'Try running the system again.');
	    closedown('A7');
	  end;
end;

PROCEDURE delet_file(var fp : text);
begin
  	if (DEBUG>2) then writeln('delete file');
	discard(fp);
	if fp.errs<>wrd(0) then
	  begin
	    perror('ERROR - data file delete error (Press return for more info)');
	    write(clearscrn);
	    printmid(1,'Data file delete error. - error no. A08');
	    printat(3,10,'The program cannot continue. A data file could not ');
	    printat(4,10,'be successfully deleted.');
	    printat(5,10,'A file error number of ');
	    write(fp.errs,' was obtained.');
	    printat(8,10,'Your course of action should be :');
	    printat(10,15,'Notify CBPS of the circumstances of this event.');
	    printat(11,15,'Try running the system again.');
	    closedown('A8');
	  end;
end;

PROCEDURE add_new_to_file(var newfile,oldfile : text;
			  new_bets : new_bet_buf;
                          num_new_bets : num_bet_add_range) [PUBLIC];
var
	loop				:	integer;
	old_filename			:	str;
	at_eof,carry_on,not_exist	:	boolean;
	temp_rec			:	bookresult;
begin
   	carry_on:=true;
   	write(clearscrn,boldon);
   	printmid(1,'Add new personal betting records to computer.');
   	write(attriboff);

	write(clearscrn,boldon);
        printmid(1,'Add new personal betting records to computer.');
   	write(attriboff);
	printmid(15,'Processing, please wait ....');

	at_eof:=false;
	op_new_file(newfile,old_filename);	(* creates newfile & rets filename of data file *)
        not_exist:=false;
	op_old_file(oldfile,old_filename,not_exist);
	at_eof:=not_exist;	(* if data file did not exist then no copying done *)
	while (not at_eof) do
	 begin
	   rd_rec(oldfile,temp_rec,at_eof);
	   if (DEBUG>1) then debug_print(temp_rec);
	   wrte_rec(newfile,temp_rec);
	 end;
	for loop:=0 to (num_new_bets-1) do
	 begin
 	   if (DEBUG>1) then debug_print(new_bets[loop]);
 	   wrte_rec(newfile,new_bets[loop]);
	 end;
	clse_file(newfile);
	if (not not_exist) then delet_file(oldfile);
    (*	rename('NEW-P.DAT','RACE-P.DAT');	*)    (* if rename available then remove these brackets & those of op_new_file *)
					      (* as it is is ok as well. *)
end;


PROCEDURE lim_stop(var finish : boolean);				(* Alerts user that no more new results can be added & *)
									(* forces finish to be true on return. *)
begin
	printmid(12,'NOTE - Too many new bets have been added without updating');
	printmid(14,'        the file;                                        ');
	printmid(15,'                                                         ');
	printmid(16,'              File will now being updated		      ');
	printmid(17,'                               			      ');
	printmid(18,'When the file is updated you may select to add more new bets.');
	printmid(19,'                               			      ');
	perror('Please acknowledge ..');
	finish:=true;
end;
	

FUNCTION odds_cvert(temp_odds : str;					(* Converts 2-1 or 2/1 to 0.5 : rets false if not valid *)
		    var cnvrted_odds : real) : boolean;
var
	loop,odd1,odd2		: integer;
	notvalid		: boolean;
begin
    notvalid:=false;
    odd1:=0;
    odd2:=0;
    loop:=1;
    IF (DEBUG=2) THEN writeln('odds_cvert: temp_odds=',temp_odds);
    while (loop<ord(temp_odds.len)) and (temp_odds[loop]>='0') and
	 (temp_odds[loop]<='9') do
      begin
	odd1:=(odd1*10)+(ord(temp_odds[loop])-ord('0'));
	loop:=loop+1;
      end;
    IF (DEBUG=2) THEN writeln('odds_cvert: odd1=',odd1,'notvalid=',notvalid);
    if (odd1=0) or (loop=ord(temp_odds.len)) then notvalid:=true;
    case temp_odds[loop] of
        '-','/' : loop:=loop+1;
        otherwise notvalid:=true;
    end; (*case*)
    while (loop<=ord(temp_odds.len)) and (temp_odds[loop]>='0') and
	 (temp_odds[loop]<='9') do
      begin
	odd2:=(odd2*10)+(ord(temp_odds[loop])-ord('0'));
	loop:=loop+1;
      end;
    IF (DEBUG=2) THEN writeln('odds_cvert: odd2=',odd2,'notvalid=',notvalid);
    if (odd2=0) then notvalid:=true;
    if not notvalid then cnvrted_odds:=odd2/odd1;
    odds_cvert:=(not notvalid);
end;

FUNCTION is_digit(ch : char) : boolean;
begin
    if ((ch>='0') and (ch<='9')) then is_digit:=true else is_digit:=false;
end;

FUNCTION valid_date(date : str) : boolean;
var
   day,month,year	: integer;
   loop,pos		: integer;
   error		: boolean;
begin
   error:=false;
   day:=0;
   month:=0;
   year:=0;
   pos:=1;
   loop:=0;
   while ((loop<2) and (not error)) do
    begin
	if (not is_digit(date[pos])) then error:=true;
	if not error then
	 begin
	  day:=(day*10)+(ord(date[pos])-ord('0'));
	  loop:=loop+1;
	  pos:=pos+1;
	 end;
    end;
   if date[pos]<>'/' then error:=true
   else pos:=pos+1;
   loop:=0;
   while ((loop<2) and (not error)) do
    begin
	if (not is_digit(date[pos])) then
	  if (date[pos]<>'/') then error:=true
	  else loop:=2
	else
	  begin
	    month:=(month*10)+(ord(date[pos])-ord('0'));
	    loop:=loop+1;
	    pos:=pos+1;
	  end;
    end;
   if date[pos]<>'/' then error:=true
   else pos:=pos+1;
   loop:=0;
   while ((loop<2) and (not error)) do
    begin
	if (not is_digit(date[pos])) then
	  if (date[pos]<>'/') then error:=true
	  else loop:=2
	else
	  begin
	    year:=(year*10)+(ord(date[pos])-ord('0'));
	    loop:=loop+1;
	    pos:=pos+1;
	  end;
    end;
   if (pos<>(ord(date.len)+1)) then error:=true;
   if (year<86) or (month<1) or (month>12) or (day<1) or (day>31) then error:=true;
   if ((month=4) or (month=6) or (month=9) or (month=11)) and (day>30) then error:=true;
   if (month=2) and (year mod 4<>0) and (day>28) then error:=true;

   if (DEBUG>=4) then writeln('valid_date: ret ',not error);
   if (DEBUG>=4) then writeln('valid_date: day,month,year =',day:4,month:4,year:4);
   valid_date:=not error;
end;


FUNCTION cvnum(const in_str : string) : integer;			(* takes a string & produces an int from it *)
var
	loop,num : integer;
begin
	num:=0;
	for loop:=1 to upper(in_str) do
	   num:=(num*10)+(ord(in_str[loop])-ord('0'));
	cvnum:=num;
end;

FUNCTION cnvrt_to_amount(temp_str : str; var pounds,pence : integer) : boolean;  (* converts str into integer if can eg 167.23 = 16723 *)
var
	pos,count,count2		: integer;
	num1,num2			: integer;
	error,part2			: boolean;
begin
	if (DEBUG>=4) then writeln('cnvrt_to_amount: temp_str=',temp_str);
	pos:=1;
	count:=0;
	count2:=0;
	num1:=0;
	num2:=0;
	error:=false;
	part2:=false;
	while ((pos<=ord(temp_str.len)) and (not part2) and (not error)) do
	  begin
	    if ((not (is_digit(temp_str[pos]))) and (temp_str[pos]<>'.')) then
	     begin
		perror('Error - invalid character found. enter again (eg.16.72)'); 
		error:=true;
	     end
	    else
	      if is_digit(temp_str[pos]) then
		begin
		   count:=count+1;
		   if count>3 then
		     begin
			perror('Error - too high amount, limit 300 enter again (eg.16.72)');
			error:=true;
		     end
		   else
			num1:=(10*num1)+(ord(temp_str[pos])-ord('0'));
		end
	      else		(* can assume '.' so next bit *)
		part2:=true;
	    pos:=pos+1;
	   end;
      if (part2) then
	while ((pos<=ord(temp_str.len)) and (not error)) do
	  begin
	    if (not (is_digit(temp_str[pos]))) then
	      begin
		perror('Error - Invalid character found. enter again (eg.16.72)');
		error:=true;
	      end;
	    count2:=count2+1;
	    if count2>2 then
	     begin
		perror('Error - Pence must be limited to 2 digits. enter again (eg.16.72)');
		error:=true;
	     end
	    else
		num2:=(10*num2)+(ord(temp_str[pos])-ord('0'));
	    pos:=pos+1;
	  end;
      if ((part2) and (count2<>2)) then
	     begin
		perror('Error - Pence must be 2 digits. enter again (eg.16.72)');
		error:=true;
	     end;
      pounds:=num1;
      pence:=num2;
      if (pounds>300) then
       begin
	 perror('Error - too high amount, limit 300 enter again (eg.16.72)');
	 error:=true;
       end;
      if (DEBUG>=4) then writeln('cnvrt_to_amount: pounds,pence=',pounds,pence);
      if (DEBUG>=4) then writeln('cnvrt_to_amount: returning=',not error);
      cnvrt_to_amount:=not error;	(* if error ret false *)
end;

PROCEDURE read_new_bet(var new_bet : bookresult;
			  var ending 		: boolean);                 (* reads a result, if user aborts ending set true*)
VAR
	temp_str				: str;
	ok,temp_yn				: boolean;
begin
	
        write(clearscrn,boldon);
        printmid(1,'Add new personal betting records to computer.');
        write(attriboff);
        ending:=false;
	printat(05,1,'Betting Details.');
	printat(06,1,'----------------');
	printat(08,4,'              Press ESC to quit screen at any time.');
	printat(11,8,'Date of bet (dd/mm/yy) : ');
	printat(13,8,'Amount bet (pounds) : ');
	printat(15,8,'Odds to win : ');
	printat(17,8,'Amount won (or 0 if lost) : ');

	ok:=false;
	while (not ok) and (not ending) do
	  begin
	    new_bet.date:=sinput(11,33,8,ending);
	    if not ending then
	     if valid_date(new_bet.date) then
		ok:=true
	     else 
		perror('Error - invalid date enter (dd/mm/yy) eg.11/02/86 ')
	  end;

	ok:=false;
	while (not ok) and (not ending) do
	  begin
	    temp_str:=sinput(13,30,6,ending);
	    if not ending then
	     if cnvrt_to_amount(temp_str,new_bet.bet_pounds,new_bet.bet_pence) then
		ok:=true
	  end;

	ok:=false;
	while (not ok) and (not ending) do
	  begin
	    temp_str:=sinput(15,22,7,ending);
	    if not ending then
	      begin
		ok:=odds_cvert(temp_str,new_bet.odds);			(* rets ok as true/false & rets odds as real *)
		if not ok then perror('Error - invalid odds : enter as 5-1 etc');
	      end;
	  end;


	ok:=false;
	while (not ok) and (not ending) do
	  begin
	    temp_str:=sinput(17,36,6,ending);
	    if not ending then
	     if cnvrt_to_amount(temp_str,new_bet.won_pounds,new_bet.won_pence) then
		ok:=true
	  end;

 IF (DEBUG =3) THEN
  BEGIN
  with new_bet do
    begin
      printat(24,1,null);
      writeln('date : ',date);
      writeln('bet  : ',bet_pounds);
      writeln('bet  : ',bet_pence);
      writeln('odds : ',odds);	
      writeln('won_pounds : ',won_pounds);
      writeln('won_pence : ',won_pence);
    end;
  END;
end;

PROCEDURE add_pers(var newfile,oldfile : text) [PUBLIC];
var
	new_bets 				: new_bet_buf;
	num_new_bets				: num_bet_add_range;
	finish,ok,ending			: boolean;
	tempstr					: str;
begin
  num_new_bets:=0;
  finish:=false;
  while (not finish) do
   begin
     write(clearscrn,boldon);
     printmid(1,'Add new personal betting records to computer.');
     write(attriboff);
     if num_new_bets=max_new_bets then lim_stop(finish)		(* forces finish true after limit message *)
     else
       begin
	 ending:=false;
         read_new_bet(new_bets[num_new_bets],ending);  (* reads a bet , or quits with ending true*)

         if ending then
	    perror('Entries on this screen have been cancelled. Acknowledge ...')
	 else
	   begin
		 ok:=false;
		 while (not ok) do
		  begin
			printat(22,20,'Confirm the above is correct  (Y/N) : ');
			tempstr:=sinput(22,58,1,ending);
			if ending then tempstr[1]:='N';
                        case tempstr[1] of
			   'Y' : begin num_new_bets:=num_new_bets+1;
				       ok:=true; end;
			   'N' : ok:=true;
			  otherwise perror('Error - invalid character : enter Y or N');
			end;
		  end;
		 printat(22,1,delline);
            end;

	 ok:=false;
	 while (not ok) do
		  begin
			printat(22,20,'Do you wish to add another betting result (Y/N) : ');
			tempstr:=sinput(22,70,1,ending);
			if ending then tempstr[1]:='N';
                        case tempstr[1] of
			   'N' : begin finish:=true; ok:=true; end;
			   'Y' : ok:=true;
			  otherwise perror('Error - invalid character : enter Y or N');
			end;
		   end;
	 printat(22,1,delline);
       end;
   end;
   if (num_new_bets>0) then add_new_to_file(newfile,oldfile,new_bets,num_new_bets);
end;

END.
