MODULE display_pers_bets; (*$DEBUG+*)

const

	DEBUG=0;	(* divisible by :         			*)
			(* 1 -                                    	*)
			(* 2 -                   			*)
			(* 4 - 						*)
			(* 8 -						*)

(*$INCLUDE:'SCREEN.H'*)
(*$INCLUDE:'DEFS.H'*)
(*$INCLUDE:'GEN-ROUT.H'*)

PROCEDURE cvtoodds(odds : real; var odd1,odd2 : integer);		(* given 'odds' rets odd1,odd2  eg 0.5= 2/1 *)
var
  times : integer;
  temp : real;
begin
   temp:=1 / odds;
   times:=1;
   while (abs(round(temp)-temp) > setaccuracy) do
     begin
	temp:=temp+(1/odds);
	times:=times+1;
     end;
   odd1:=round(temp);
   odd2:=times;
   if (DEBUG>=2) then writeln('cvtoodds: odds=',odds:7,'odd1-odd2=',odd1:5,odd2:5);
end;


PROCEDURE revse(var f_str : str);
var
   b_str	: str;
   loop		: integer;
begin
   b_str:=null;
   for loop:=ord(f_str.len) downto 1 do
     concat(b_str,f_str[loop]);
   f_str:=b_str;
end;
   
FUNCTION i_to_asc(num : integer) : str;
var
   temp_str : str;
   int_sign : boolean;
begin
   temp_str:=null;
   int_sign:=false;
   if num<0 then begin int_sign:=true; num:=-num; end;
   repeat
     concat(temp_str,chr(ord('0')+ (num mod 10)));
     num:=num div 10;
   until num<=0;
   if int_sign then concat(temp_str,'-');
   revse(temp_str);
   i_to_asc:=temp_str;
end;

PROCEDURE prt_odds(odds : real);
var
	odd1,odd2	: integer;
	oddstr,odd2str	: str;
begin
   cvtoodds(odds,odd1,odd2);
   oddstr:=i_to_asc(odd1);
   if (DEBUG>=2) then writeln('prt_odds: oddstr=',oddstr);
   concat(oddstr,'-');
   odd2str:=i_to_asc(odd2);
   concat(oddstr,odd2str);
   if (DEBUG>=2) then writeln('prt_odds: oddstr=',oddstr);
   write(oddstr);
end;

PROCEDURE open_oldfile(var fp : text);
begin
	fp.errs:=wrd(0);
	fp.mode:=SEQUENTIAL;
	fp.trap:=true;
	assign(fp,'RACE-P.DAT');
	reset(fp);
	if fp.errs<>wrd(0) then 
	  begin
            if fp.errs<>wrd(10) then	(* got unnormal file error *)
	       begin
	    	perror('ERROR - data file open error (Press return for more info)');
	    	write(clearscrn);
	    	printmid(1,'Data file open error. - error no. D01');
	    	printat(3,10,'The program cannot continue. The data file RACE-P.DAT could not ');
	    	printat(4,10,'be successfully opened.');
	    	printat(5,10,'A file error number of ');
	    	write(fp.errs,' was obtained.');
	    	printat(8,10,'Your course of action should be :');
	    	printat(10,15,'Notify CBPS of the circumstances of this event.');
	    	printat(11,15,'Try running the system again.');
	    	closedown('D1');
	       end;
	    fp.errs:=wrd(0);	(* reset pascal to use files *)
	    fp.mode:=SEQUENTIAL;
	    fp.trap:=true;
	    assign(fp,'RACE2-P.DAT');
	    reset(fp);
	    if fp.errs<>wrd(0) then	(* Oh dear dear, got a nasty from rewrite - got to abort *)
	    begin
	     if fp.errs<>wrd(10) then	(* Oh. wasn't file not found error no - more serious *)
	       begin
	    	perror('ERROR - data file open error (Press return for more info)');
	    	write(clearscrn);
	    	printmid(1,'Data file open error. - error no. D2');
	    	printat(3,10,'The program cannot continue. The data file RACE2-P.DAT could not ');
	    	printat(4,10,'be successfully opened.');
	    	printat(5,10,'A file error number of ');
	    	write(fp.errs,' was obtained.');
	    	printat(8,10,'Your course of action should be :');
	    	printat(10,15,'Notify CBPS of the circumstances of this event.');
	    	printat(11,15,'Try running the system again.');
	    	closedown('D2');
	       end
	      else
	       begin
		perror('ERROR - data files incomplete.');
		write(clearscrn);
		printmid(1,'Data files incomplete error. - error no. D03');
		printat(3,10,'The program cannot continue. The data files RACE2-P.DAT & RACE-P.DAT');
		printat(4,10,'were not found. Atleat one should have been.');
	    	printat(5,10,'A file error number of ');
	    	write(fp.errs,' was obtained.');
		printat(8,10,'Your course of action should be :');
		printat(10,15,'Notify CBPS of the circumstances of this event.');
		printat(11,15,'Try running the start system utility & then try again.');
		closedown('D3');
	       end;
	    end;
	  end;
end;

PROCEDURE read_from_file(var fp : text; var rd_rec : bookresult;
			 var at_eof : boolean);
begin
  with rd_rec do
    begin
      readln(fp,date);
      readln(fp,bet_pounds);
      readln(fp,bet_pence);
      readln(fp,odds);
      readln(fp,won_pounds);
      readln(fp,won_pence);
    end;
  if (eof(fp)) then at_eof:=true else at_eof:=false;
end;

FUNCTION cnv_to_num(var x1,x2 : integer) : real;
var
	temp : real;
	temp2 : real;
	minus : boolean;
begin
        if (DEBUG>=6) then writeln('cnv_to_num:1');
	if ((x1<0) or (x2<0)) then
	  begin
	    minus:=true;
	    x1:=abs(x1);
	    x2:=abs(x2);
	  end
	else
	   minus:=false;
        if (DEBUG>=6) then writeln('cnv_to_num:2');
        temp2:=x1;
	temp:=(temp2*100)+x2;
        if (DEBUG>=6) then writeln('cnv_to_num:3');
	if minus then temp:=-temp;
	cnv_to_num:=temp;
        if (DEBUG>=6) then writeln('cnv_to_num:4');
end;

PROCEDURE cnv_to_ints(var x : real; var pounds,pence : integer);
var
	minus : boolean;
begin
	if x<0 then
	  begin
	     x:=abs(x);
	     minus:=true;
	  end
	else
	   minus:=false;
        if (DEBUG>=6) then writeln('cnv_to_ints:1');
	pounds:=trunc(x/100);
        if (DEBUG>=6) then writeln('cnv_to_ints:2');
	pence:=round(((x/100)-trunc(x/100))*100);
        if (DEBUG>=6) then writeln('cnv_to_ints:3');
	if minus then
	  begin
	     pounds:=-pounds;
	     pence:=-pence;
	  end;
end;

PROCEDURE add(var tot_pounds,tot_pence : integer;
		   val_pounds,val_pence     : integer);
var
	add1,add2			: real;
begin
	if (DEBUG>=2) then writeln('add: ',tot_pounds:4,tot_pence:4,' + ');
	if (DEBUG>=2) then writeln('add: ',val_pounds:4,val_pence:4);

	add1:=cnv_to_num(tot_pounds,tot_pence)+cnv_to_num(val_pounds,val_pence);
	cnv_to_ints(add1,tot_pounds,tot_pence);

	if (DEBUG>=2) then writeln('add: =',tot_pounds:4,tot_pence:4);
end;


PROCEDURE subtract(var tot_pounds,tot_pence : integer;
		   val_pounds,val_pence     : integer);
var
	add1				: real;
begin
	if (DEBUG>=2) then writeln('subtract: ',tot_pounds:4,tot_pence:4,' - ');
	if (DEBUG>=2) then writeln('subtract: ',val_pounds:4,val_pence:4);

	add1:=cnv_to_num(tot_pounds,tot_pence)-cnv_to_num(val_pounds,val_pence);
	cnv_to_ints(add1,tot_pounds,tot_pence);

	if (DEBUG>=2) then writeln('subtract: =',tot_pounds:4,tot_pence:4);
end;

PROCEDURE disp_line(lineno : integer; dat_rec : bookresult;
		    tot_pounds,tot_pence : integer);
var
	t_str1,t_str2		: str;
	minus			: boolean;
begin
  with dat_rec do
    begin
	printat(7+lineno,2,null);
	write(date:8);
	printat(7+lineno,18,null);
        prt_odds(odds);
	printat(7+lineno,26,null);
	t_str1:=i_to_asc(bet_pounds);
	concat(t_str1,'.');
	t_str2:=i_to_asc(bet_pence);
	if (t_str2.len=wrd(1)) then insert('0',t_str2,1);
	write(t_str1:5,t_str2);
	printat(7+lineno,40,null);
	t_str1:=i_to_asc(won_pounds);
	concat(t_str1,'.');
	t_str2:=i_to_asc(won_pence);
	if (t_str2.len=wrd(1)) then insert('0',t_str2,1);
	write(t_str1:5,t_str2);
	printat(7+lineno,60,null);
	if ((tot_pounds<0) and (tot_pence<0)) then
	   begin
	     minus:=true;
	     if (tot_pounds<0) then tot_pounds:=abs(tot_pounds);
	     if (tot_pence<0) then tot_pence:=abs(tot_pence);
	   end
	else minus:=false;
	if (tot_pounds>999) then
	  write('***':5,'**')
	else
	  begin
		t_str1:=i_to_asc(tot_pounds);
		if minus then insert('-',t_str1,1);
		concat(t_str1,'.');
		t_str2:=i_to_asc(tot_pence);
		if (t_str2.len=wrd(1)) then insert('0',t_str2,1);
		write(t_str1:5,t_str2);
	  end;
    end;
end;

PROCEDURE close_in_file(var fp : text);
begin
	close(fp);
	if fp.errs<>wrd(0) then
	  begin
	    perror('ERROR - data file close error (Press return for more info)');
	    write(clearscrn);
	    printmid(1,'Data file close error. - error no. D4');
	    printat(3,10,'The program cannot continue. A data file could not ');
	    printat(4,10,'be successfully closed.');
	    printat(5,10,'A file error number of ');
	    write(fp.errs,' was obtained.');
	    printat(8,10,'Your course of action should be :');
	    printat(10,15,'Notify CBPS of the circumstances of this event.');
	    printat(11,15,'Try running the system again.');
	    closedown('D4');
	  end;
end;

PROCEDURE disp_heading;
var
	loop			: integer;
begin
	write(clearscrn,boldon);
	printmid(1,'Display previous personal bets.');
	write(attriboff);
	printat(5,4,'Date.');
	printat(5,18,'Odds.');
	printat(5,28,'Bet.');
	printat(5,39,'Amount won.');
	printat(5,61,'Balance.');
	writeln;
	for loop:=0 to 70 do write('-');
	writeln;
end;

PROCEDURE page_full(var ending : boolean);
var
    dummy	: char;
begin
    printat(22,8,'Page full ... (press any key for next page, (ESC to quit)) : ');
    dummy:=cinput(ending);
    if not ending then disp_heading;
end;

PROCEDURE d_p_pers(var oldfile : text) [PUBLIC];
var
	lineno,loop				: integer;
	tot_pounds,tot_pence  			: integer;
	at_eof,ending				: boolean;
	dat_rec					: bookresult;
begin
	disp_heading;
	lineno:=0;
	tot_pounds:=0;
	tot_pence:=0;
	at_eof:=false;
	open_oldfile(oldfile);
	ending:=false;
	while ((not at_eof) and (not ending)) do
	  begin
	     read_from_file(oldfile,dat_rec,at_eof);
	     if (tot_pounds<999) and (tot_pounds>-999) then
	      if ((dat_rec.won_pounds=0) and (dat_rec.won_pence=0)) then
	       subtract(tot_pounds,tot_pence,dat_rec.bet_pounds,dat_rec.bet_pence)
	      else
	       add(tot_pounds,tot_pence,dat_rec.won_pounds,dat_rec.won_pence);
	     lineno:=lineno+1;
	     if lineno=14 then
		begin
		   lineno:=0;
		   page_full(ending);
		end;
	     if not ending then disp_line(lineno,dat_rec,tot_pounds,tot_pence);
	  end;
	close_in_file(oldfile);
	if ending then
	   perror('Listing aborted - acknowledge ...')
	else
	   perror('End of list.');
end;

END.
