MODULE genrout [PUBLIC]; (*$DEBUG+*)

const
(*$INCLUDE:'SCREEN.H'*)
(*$INCLUDE:'defs.h'*)

PROCEDURE printat(x,y : integer; const msg : string);	(* ANSI ?????? *)
begin
   write(ansi);
   if (x div 10)>0 then write(chr(ord('0')+(x div 10)));
   write(chr(ord('0')+(x mod 10)));
   write(';');
   if (y div 10)>0 then write(chr(ord('0')+(y div 10)));
   write(chr(ord('0')+(y mod 10)),gotoxy);
   write(msg);   
end;

PROCEDURE printmid(line : integer; const msg : string);
begin
   printat(line,40-(upper(msg) div 2),msg);
end;

FUNCTION DOSXQQ(command,param : word) : byte; extern;
PROCEDURE ENDXQQ; extern;

FUNCTION dosgetkey : char;  (* MSDOS get direct key press from kbrd *)
var
   ch : char;
begin
   ch:=chr(DOSXQQ(wrd(6),wrd(255)));
   while (ord(ch)=0) do
      ch:=chr(DOSXQQ(wrd(6),wrd(255)));
   dosgetkey:=ch;
end;


PROCEDURE perror(const errmsg : string);
var
   loop : integer;
begin
   write(savecurs);
   write(revon);
   printmid(23,errmsg);
   write(attriboff);
   printat(24,50,'Press RETURN to continue ..');
   while (dosgetkey<>endofline) do write(null);
   printat(23,1,delline);
   printat(24,1,delline);
   write(restcurs);
end;

PROCEDURE closedown(const msg : string);
begin
	writeln;
	writeln('CLOSING DOWN SYSTEM : ABORT CODE : ',msg);
	writeln;
	ENDXQQ;	(* sudden death for program (after shutting things ofcourse) *)
end;

PROCEDURE convupper(var ch : char);					     (* converts a char to upper case *)
begin
	if ((ch>='a') and (ch<='z')) then
		ch:=chr(ord(ch)-(ord('a')-ord('A')));
end;

PROCEDURE hi_entry(entry_len : integer);          	 (* Sets [  ] to reverse video *)
							 (* This is used by cinput,binput,sinput & ninput *)
							 (* Assumes cursor at start of entry *)
var
     loop     : integer;
begin
     write(savecurs);						(* save cursor - good idea ! *)
(*     write(revon,backspace,'[',attriboff);  *)
     write(backspace,'[');
     for loop:=1 to entry_len do write(' ');
(*     write(revon,']',attriboff);    *)
     write(']');
     write(restcurs);
end;

PROCEDURE fin_entry(entry_len : integer);          	 (* RE-Sets [  ] to normal video *)
							 (* This is used by cinput,binput,sinput & ninput *)
							 (* Assumes cursor at start of entry *)
var
     loop     : integer;
begin
     write(savecurs);						(* save cursor - good idea ! *)
(*     write(attriboff,backspace,'[');
     for loop:=1 to entry_len do write(cursright);
     write(']');
*)     write(restcurs);
end;

FUNCTION cinput(var ending : boolean) : char;	      		(* gets char (del & cr are valid keys) *)
var
	ch : char;
begin
	ch:=dosgetkey;
        convupper(ch);
	while not ( ((ch=' ')) or ((ch>='A') and (ch<='Z'))
		or ((ch>='0') and (ch<='9')) or ((ch='-'))
		or ((ch='/')) or ((ch='.')) or (ch=delchar) or (ch=endofline)
		or (ch=endchar) ) do
	  begin
		perror('Error - invalid character.');
		ch:=dosgetkey;
                convupper(ch);
	  end;
	if (ch=endchar) then ending:=true else ending:=false;
	cinput:=ch;
end;

FUNCTION sinput(x,y,str_len : integer; var ending : boolean) : str;	    (* reads in a string of chars - ending is user abort *)
									    (* any lowercase chars are converted *)

var
	ch 		: char;
	tempstr 	: lstring(80);
begin
	printat(x,y,null);
	hi_entry(str_len);
	tempstr:=null;
	ch:=cinput(ending);
	while (((ch=endofline) or (ch=' ')) and (not ending)) do
          begin
	      perror('Error - You must input something (not space)');
	      ch:=cinput(ending);
	  end;
	while ( (ch<>endofline) and (not ending) ) do
	  begin
	    if (not ending) then
	      begin
		if (ch=delchar) then
		   begin
		     if (tempstr.len=0) then
			perror('Error - Beginning of input.')
		     else
		       begin
			write(delchar,' ',delchar);
			delete(tempstr,ord(tempstr.len),1)
		       end;
		   end
	        else
		  begin
		    if (tempstr.len=wrd(str_len)) and (ch<>endofline) then
			perror('Error - String length limit reached (press return).')
 		    else
			if (ch<>endofline) then
			  begin
			   concat(tempstr,ch);
			   write(ch);
			  end
	          end;
	      end;
	    ch:=cinput(ending);
	    while (((ch=endofline) or (ch=' ')) and (not ending)
		     and (ord(tempstr.len)=0)) do
	      begin
	        perror('Error - You must input something (not space)');
	        ch:=cinput(ending);
	      end;
	  end;

	printat(x,y,null);
	fin_entry(str_len);
	sinput:=tempstr;
end;


FUNCTION binput(x,y,dummy : integer; var ending:boolean) : boolean;         (* rets a boolean - Y=true N=false *)

var
	temp_str : str;
begin
	temp_str:=sinput(x,y,1,ending);
	while not ( ((temp_str[1]='Y')) or ((temp_str[1]='N')) 
		or ((ending)) ) do
	  begin
		perror('Error - invalid character : enter Y or N.');
		temp_str:=sinput(x,y,1,ending);
	  end;
	if (temp_str[1]='Y') then binput:=true else binput:=false;
end;

FUNCTION convnum(const in_str : string) : integer;			(* takes a string & produces an int from it *)
var
	loop,num : integer;
begin
	num:=0;
	for loop:=1 to upper(in_str) do
	   num:=(num*10)+(ord(in_str[loop])-ord('0'));
	convnum:=num;
end;

FUNCTION ninput(x,y,num_digits : integer; var ending : boolean) : integer; (* rets an integer read in -ending if abort *)
                                                                           (* takes del & endofline chars ok *)
var
	ch : char;
	tempstr : lstring(80);
begin
	printat(x,y,null);
	hi_entry(num_digits);
	tempstr:=null;
	ch:=cinput(ending);
	while ((ch=endofline) and (not ending)) do
          begin
	      perror('Error - You must input something ');
	      ch:=cinput(ending);
	  end;
	while ( (ch<>endofline) and (not ending) ) do
	  begin
	    if (not ending) then
	      begin
		if (ch=delchar) then
		   begin
		     if (tempstr.len=0) then
			perror('Error - Beginning of input.')
		     else
		       begin
			write(delchar,' ',delchar);
			delete(tempstr,ord(tempstr.len),1)
		       end;
		   end
	        else
		  begin
		    if (tempstr.len=wrd(num_digits)) and (ch<>endofline) then
			perror('Error - Digits length limit reached (press return).')
 		    else
		      if (ch<>endofline) then
			begin
			   if ((ch>='0') and (ch<='9'))	then
			     begin
			   	concat(tempstr,ch);
			   	write(ch);
			     end
			   else
			     perror('Error - Invalid character : enter 0-9 only.');
			end;
	          end;
	      end;
	    ch:=cinput(ending);
	  end;

	printat(x,y,null);
	fin_entry(num_digits);
	ninput:=convnum(tempstr);
end;

END.
