MODULE query_do; (*$DEBUG+*)

const

	DEBUG=0;	(* greater than  :         			*)
			(* 0 - print unique or not,generals           	*)
			(* 1 - basic stuff       			*)
			(* 2 - rd/wr sequ files  			*)
			(* 3 - all mem,random access query rec matching *)
			(* 8 -						*)

(*$INCLUDE:'SCREEN.H'*)
(*$INCLUDE:'DEFS.H'*)
(*$INCLUDE:'GEN-ROUT.H'*)

var
	overflow_file [EXTERN]		: file of plusresult;


PROCEDURE dprint_rec(rd_rec : result);
begin
   writeln('dprint_rec: ');
   with rd_rec do
    begin
      writeln('month=',month);
      writeln('runners=',runners);
      writeln('odds=',odds);
      writeln('grade=',grade);
      writeln('jockey=',jockey);
      writeln('horse=',horse);
      writeln('course=',course);
      writeln('age=',age);
      writeln('handicap=',handicap);
      writeln('crse=',crse_type);
    end;
end;

FUNCTION rd_r_file(rec_no : integer; var cnt_matches : integer) : result;  (* This function reads record rec_no from the random *)
var
	temp				: result;
begin                                                                   (* access overflow file of unique recs. It also reads    *)
	                                                                (* cnt_matches which it sets *)
	if (DEBUG>=1) then writeln('Called rd_r_file - param : rec_no=',rec_no:6);
	seek(overflow_file,rec_no);
	get(overflow_file);
	temp.month:=overflow_file^.month; 		(* 'A' = 1 = Jan, 'B' = Feb etc *)
	temp.runners:=overflow_file^.runners;
	temp.odds:=overflow_file^.odds; 		(* 0.5 = 2/1 *)
	temp.grade:=overflow_file^.grade; 		(* F=favourite, 2=2nd F, X=other *)
	temp.jockey:=overflow_file^.jockey;
	temp.horse:=overflow_file^.horse;
	temp.course:=overflow_file^.course;
	temp.age:=overflow_file^.age; 			(* 2=2yr old, 0=unrestricted*)
	temp.handicap:=overflow_file^.handicap; 	(* Y=yes N=no *)
	temp.crse_type:=overflow_file^.crse_type; 	(* F=flat, H=hurdles *)
	cnt_matches:=overflow_file^.cnt_matches;  (* number of matches *)
	if (DEBUG>=1) then writeln('rd_r_file: read ',temp.horse);
	if (DEBUG>=4) then dprint_rec(temp);
	rd_r_file:=temp;
end;

PROCEDURE wr_r_file(rd_rec : result; rec_no, cnt_matches : integer);	(* Adds rd_rec to r.access file at rec_no *)
									(* complication as above with result not record format *)
									(* writes cnt_matches to file as well *)
begin
	if (DEBUG>=1) then writeln('Called wr_r_file - param : rec_no=',rec_no:6);
	if (DEBUG>=4) then dprint_rec(rd_rec);
	seek(overflow_file,rec_no);
	overflow_file^.month:=rd_rec.month; 		(* 'A' = 1 = Jan, 'B' = Feb etc *)
	overflow_file^.runners:=rd_rec.runners;
	overflow_file^.odds:=rd_rec.odds; 		(* 0.5 = 2/1 *)
	overflow_file^.grade:=rd_rec.grade; 		(* F=favourite, 2=2nd F, X=other *)
	overflow_file^.jockey:=rd_rec.jockey;
	overflow_file^.horse:=rd_rec.horse;
       	overflow_file^.course:=rd_rec.course;
	overflow_file^.age:=rd_rec.age; 		(* 2=2yr old, 0=unrestricted*)
	overflow_file^.handicap:=rd_rec.handicap; 	(* Y=yes N=no *)
	overflow_file^.crse_type:=rd_rec.crse_type; 	(* F=flat, H=hurdles *)
	overflow_file^.cnt_matches:=cnt_matches;  (* number of matches *)
	if (DEBUG>=1) then writeln('wr_r_file: written ',rd_rec.horse);
	put(overflow_file);
end;


FUNCTION get_qbuf_rec(rec_no : integer; var cnt_matches : integer;
		      quest_buf : q_buf; num_match : n_match_buf) : result [PUBLIC];
							 		(* This gets a result record from the list of uniques*)
                                                                        (* stored. The function is needed & it is not just an *)
                                                                        (* array index, due to memory constraints the rec_no  *)
                                                                        (* can be out of memory range & so then the overflow  *)
                                                                        (* random access file is used (transparently)         *)
begin
        if (DEBUG>4) then
	  writeln('get_qbuf_rec: looking for rec_no - ',rec_no:6);

	if (rec_no<q_buf_range) then
	 begin
	   cnt_matches:=num_match[rec_no];
	   get_qbuf_rec:=quest_buf[rec_no]
	 end
	else
	   get_qbuf_rec:=rd_r_file((rec_no-q_buf_range)+1,cnt_matches)       (* If boundary at 1000 then rec 1001 is 1001-1000 = 1 *)
									  (* so read rand access file rec 1 *)
end;


PROCEDURE add_unique(rd_rec : result; var num_uniques : integer;
		     var quest_buf : q_buf; var num_match : n_match_buf);	(* adds a unique record rd_rec, to list of uniques. *)
									(* complication due to r.access overflow file *)
begin
        if (DEBUG>3) then writeln('add_unique:start. horse record = ',rd_rec.horse);
	if (num_uniques<q_buf_range) then
	  begin
            if (DEBUG>3) then writeln('add_unique: adding in memory');
	    quest_buf[num_uniques]:=rd_rec;
	    num_match[num_uniques]:=1;
	  end
	else
         begin
	   if (DEBUG>3) then writeln('add_unique: adding in memory');
	   wr_r_file(rd_rec,(num_uniques-q_buf_range)+1,1);              (* add record rd_rec, rec.no. (numuniq...), cnt_matches=1*)
	end;

	num_uniques:=num_uniques+1;
	if (DEBUG>3) then writeln('add_unique: end. num_uniques=',num_uniques);
end;

PROCEDURE inccount(rd_rec : result; rec_no,cnt_matches : integer;
		   var num_match : n_match_buf);	(* incs the count of no. matches found of unique rec at *)
									(* rec_no *)
begin
   	if (DEBUG>3) then writeln('inccount: querybuf, matches no., at rec_no,',rec_no);
	if (rec_no<q_buf_range) then
	 begin
	    num_match[rec_no]:=cnt_matches+1;
   	    if (DEBUG>3) then writeln('inccount: is in memory & raised to ',num_match[rec_no]);
	 end
	else
	 begin
   	    if (DEBUG>3) then writeln('inccount: is in rand. file.');
	    wr_r_file(rd_rec,rec_no,cnt_matches+1);
	 end;
end;


FUNCTION match(r,b,t : result) : boolean;		(* compares rd_rec (r) to buf_rec (b) on keys marked in template (t) *)
							(* The template t, contains either a '*' or -1 (string/numeric) if the *)
							(* field is to be used as a key. The no. keys for this routine is *)
							(* irrelevant. (assumed atleast one) *)
var
	matching	:	boolean;
begin
	matching:=true;

	if (t.month='*') and (r.month<>b.month) then matching:=false;
	if (t.runners=-1) and (r.runners<>b.runners) then matching:=false;
	if (t.odds=-1) and (r.odds<>b.odds) then matching:=false;
	if (t.grade='*') and (r.grade<>b.grade) then matching:=false;
	if (t.jockey='*') and (r.jockey<>b.jockey) then matching:=false;
	if (t.horse='*') and (r.horse<>b.horse) then matching:=false;
	if (t.course='*') and (r.course<>b.course) then matching:=false;
	if (t.age='*') and (r.age<>b.age) then matching:=false;
	if (t.handicap='*') and (r.handicap<>b.handicap) then matching:=false;
	if (t.crse_type='*') and (r.crse_type<>b.crse_type) then matching:=false;
 
	match:=matching;
end;

FUNCTION unique(rd_rec,template : result; var rec_no,cnt_matches
		,num_uniques : integer;	quest_buf : q_buf;
		 num_match : n_match_buf) 			: boolean;   						     (* rets true/false if rd_rec crossed with template is*)
									     (* unique in matches buf. Rec_no is assigned :       *)	
                                                                             (* If unique : rec_no= undefined                     *)
                                                                             (* Not unique : rec_no= rec_no of match rec in buf   *)
var
	temp_rec_no	:	integer;
	buf_rec		:	result;
	found		: 	boolean;
begin
	temp_rec_no:=0;
	found:=false;
	while (temp_rec_no<num_uniques) and (not found) do
	  begin
	   buf_rec:=get_qbuf_rec(temp_rec_no,cnt_matches,quest_buf,num_match);
	   if match(rd_rec,buf_rec,template) then
	     begin
		found:=true;
		rec_no:=temp_rec_no;
	     end;
	   temp_rec_no:=temp_rec_no+1;
	  end;
	if (not found) then
	    unique:=true
	else
	  unique:=false;
   if (DEBUG>3) then
     begin    
       if found then writeln('Record was NOT UNIQUE.')
	else writeln('Record was UNIQUE');
     end;
end;


PROCEDURE query_proc(rd_rec, template : result; var num_uniques : integer;
		     var quest_buf : q_buf; var num_match : n_match_buf); (* given a real record in rd_rec, this proc will check if the rec*)
								(* matched with templated keys, has been come across before. ie  *)	
								(* Is it unique ?. If not unique it incs count of that match.    *)
								(* If unique it adds that rec to answer buffer.		         *)	             
var
	rec_no,cnt_matches	: integer;				(* unique() rets rec_no as rec no. matched (or next free rec) *)
begin
   if (DEBUG>1) then writeln('query_proc: start');
	if unique(rd_rec,template,rec_no,cnt_matches,num_uniques,quest_buf,num_match)
	 then add_unique(rd_rec,num_uniques,quest_buf,num_match)        (* unique() rets true/false. rec_no is assigned *)
	else inccount(rd_rec,rec_no,cnt_matches,num_match);
   if (DEBUG>1) then writeln('query_proc: end. num_uniques =',num_uniques);
end;

PROCEDURE open_new_file(var fp : text; var old_filename : str); 	(* open an original file *)
									(* This should be a simple matter of opening a filename *)
									(* unfortunately in Pascals wisdom there is no rename   *)
									(* so once the file is opened & used, it can not be     *)
									(* renamed to the proper data file & so next time this *)
									(* procedure is used a new filename has to be used  *)
									(* A bracketed vers of this proc follows which uses an *)
									(* imaginary rename procedure. *)
begin
(* **************** IGNORE THIS CODE (see note above) ********************* *)
(*	fp.mode:=SEQUENTIAL;                                                *)
(*	fp.trap:=true;                                                      *)
(*	assign(fp,'NEW.DAT');                                               *)
(*	rewrite(fp);                                                        *)
(*	if fp.errs<>wrd(0) then						    *)	(* got problems with re-write - abort *)
(*	  begin                                                             *)
(*		perror('ERROR - data file creation error (Press return for more info)');        *)
(*		write(clearscrn);                                                               *)
(*		printmid(1,'Data file creation error. - error no. X2');                         *)
(*		printat(3,10,'The program cannot continue. The data file RACE2.DAT could not ');*)
(*		printat(4,10,'be successfully created.');                                       *)
(*		printat(8,10,'Your course of action should be :');                              *)
(*		printat(10,15,'Notify CBPS of the circumstances of this event.');               *)
(*		printat(11,15,'Try running the system again.');                                 *)
(*		closedown('X2');                                                                *)
(*	  end;                                                                                  *)
(*	old_filename:='RACE.DAT';								*)
			 (* for compatibility reasons - leave it *)
(*end;                                                                                          *)
(*									      *)
(* ************************************************************************** *)


	fp.errs:=wrd(0);
	fp.mode:=SEQUENTIAL;
	fp.trap:=true;
	assign(fp,'RACE.DAT');
	reset(fp);
	if fp.errs=wrd(0) then 		(* want to find original file - if reset ok then file exists *)
	  begin				(* so try another *)
	    close(fp);
	    fp.mode:=SEQUENTIAL;
	    fp.trap:=true;
	    fp.errs:=wrd(0);
	    assign(fp,'RACE2.DAT');
	    reset(fp);
	    if fp.errs=wrd(0) then 	(* Oh dear, both files exist but which is data file ?? *)
	     begin			(* How about telling user to delete smallest file ..*)
					(* The only way to get this situ is if system crashes so *)
					(* largest would be best *)
		perror('ERROR - data file contention (Press return for more info)');
		write(clearscrn);
		printmid(1,'Data file contention.- error no. 01');
		printat(3,10,'The program cannot continue. Two files were found to ');
		printat(4,10,'exist when only one should have done.');
		printat(8,10,'Your course of action should be :');
		printat(10,15,'Notify CBPS of the circumstances of this event.');
		printat(11,15,'Delete the smaller sized file of either RACE.DAT or RACE2.DAT');
		printmid(15,'You should then be able to successfully continue running the system.');
		closedown('1');
	     end;
            if fp.errs<>wrd(10) then	(* got unnormal file error *)
	       begin
	    	perror('ERROR - data file open error (Press return for more info)');
	    	write(clearscrn);
	    	printmid(1,'Data file open error. - error no. 02');
	    	printat(3,10,'The program cannot continue. The data file RACE2.DAT could not ');
	    	printat(4,10,'be successfully opened.');
	    	printat(5,10,'A file error number of ');
	    	write(fp.errs,' was obtained.');
	    	printat(8,10,'Your course of action should be :');
	    	printat(10,15,'Notify CBPS of the circumstances of this event.');
	    	printat(11,15,'Try running the system again.');
	    	closedown('2');
	       end;
	    fp.errs:=wrd(0);	(* reset pascal to use files *)
	    rewrite(fp);		(* good, file didn;t exist so now create it *)
	    if fp.errs<>wrd(0) then	(* Oh dear dear, got a nasty from rewrite - got to abort *)
	     begin
		perror('ERROR - data file creation error (Press return for more info)');
		write(clearscrn);
		printmid(1,'Data file creation error. - error no. 03');
		printat(3,10,'The program cannot continue. The data file RACE2.DAT could not ');
		printat(4,10,'be successfully created.');
	    	printat(5,10,'A file error number of ');
	    	write(fp.errs,' was obtained.');
		printat(8,10,'Your course of action should be :');
		printat(10,15,'Notify CBPS of the circumstances of this event.');
		printat(11,15,'Try running the system again.');
		closedown('3');
	     end;
	    old_filename:='RACE.DAT';
	  end
	else
	 begin
	  if fp.errs<>wrd(10) then	(* Oh. wasn't file not found error no - more serious *)
	    begin
	    	perror('ERROR - data file open error (Press return for more info)');
	    	write(clearscrn);
	    	printmid(1,'Data file open error. - error no. 04');
	    	printat(3,10,'The program cannot continue. The data file RACE.DAT could not ');
	    	printat(4,10,'be successfully opened.');
	    	printat(5,10,'A file error number of ');
	    	write(fp.errs,' was obtained.');
	    	printat(8,10,'Your course of action should be :');
	    	printat(10,15,'Notify CBPS of the circumstances of this event.');
	    	printat(11,15,'Try running the system again.');
	    	closedown('4');
	    end
	  else
	   begin
	    fp.errs:=wrd(0);	(* reset pascal files *)
	    rewrite(fp);		(* good, file didn't exist so now create it *)
	    if fp.errs<>wrd(0) then	(* Oh dear dear, got a nasty from rewrite - got to abort *)
	     begin
		perror('ERROR - data file creation error (Press return for more info)');
		write(clearscrn);
		printmid(1,'Data file creation error. - error no. 05');
		printat(3,10,'The program cannot continue. The data file RACE.DAT could not ');
		printat(4,10,'be successfully created.');
		printat(5,10,'A file error number of ');
		write(fp.errs,' was obtained.');
		printat(8,10,'Your course of action should be :');
		printat(10,15,'Notify CBPS of the circumstances of this event.');
		printat(11,15,'Try running the system again.');
		closedown('5');
	     end;
	    old_filename:='RACE2.DAT';
	  end;
	 end;
    if (DEBUG>2) then writeln('open_new_file: old_filename=',old_filename);
end;

PROCEDURE open_old_file(var fp : text; old_filename : str;
			var not_exist : boolean);
begin
	fp.errs:=wrd(0);
	fp.mode:=SEQUENTIAL;
	fp.trap:=true;
	assign(fp,old_filename);
	reset(fp);
	if ((fp.errs<>wrd(0)) and (fp.errs<>wrd(10))) then
	  begin		       
	    perror('ERROR - data file open error (Press return for more info)');
	    write(clearscrn);
	    printmid(1,'Data file open error. - error no. 06');
	    printat(3,10,'The program cannot continue. The data file ');
	    write(old_filename,' could not ');
	    printat(4,10,'be successfully opened.');
	    printat(5,10,'A file error number of ');
	    write(fp.errs,' was obtained.');
	    printat(8,10,'Your course of action should be :');
	    printat(10,15,'Notify CBPS of the circumstances of this event.');
	    printat(11,15,'Try running the system again.');
	    closedown('5');
	  end;
	if (fp.errs=wrd(0)) then  (* to get here either got errs=0 or 10 *)
	   not_exist:=false
	else
	 begin
	   perror('Warning - No Results data file was found. Acknowledge ...');
	   not_exist:=true;
	 end;
end;


PROCEDURE write_rec(var fp : text; rd_rec : result);
begin
   if (DEBUG>2) then writeln('write_rec: writing record with horse = ',rd_rec.horse);
   with rd_rec do
    begin
      writeln(fp,month);
      writeln(fp,runners);
      writeln(fp,odds);
      writeln(fp,grade);
      writeln(fp,jockey);
      writeln(fp,horse);
      writeln(fp,course);
      writeln(fp,age);
      writeln(fp,handicap);
      writeln(fp,crse_type);
    end;
end;

PROCEDURE read_rec(var fp : text; var rd_rec : result; var at_eof : boolean);
begin
  with rd_rec do
    begin
      readln(fp,month);
      readln(fp,runners);
      readln(fp,odds);
      readln(fp,grade);
      readln(fp,jockey);
      readln(fp,horse);
      readln(fp,course);
      readln(fp,age);
      readln(fp,handicap);
      readln(fp,crse_type);
    end;
  if (eof(fp)) then at_eof:=true;
  if (DEBUG>2) then writeln('read_rec: read record with horse = ',rd_rec.horse);
  if (DEBUG>2) then writeln('read_rec: at_eof = ',at_eof);
end;

PROCEDURE close_file(var fp : text);
begin
  	if (DEBUG>2) then writeln('close_file');
	close(fp);
	if fp.errs<>wrd(0) then
	  begin
	    perror('ERROR - data file close error (Press return for more info)');
	    write(clearscrn);
	    printmid(1,'Data file close error. - error no. 07');
	    printat(3,10,'The program cannot continue. A data file could not ');
	    printat(4,10,'be successfully closed.');
	    printat(5,10,'A file error number of ');
	    write(fp.errs,' was obtained.');
	    printat(8,10,'Your course of action should be :');
	    printat(10,15,'Notify CBPS of the circumstances of this event.');
	    printat(11,15,'Try running the system again.');
	    closedown('7');
	  end;
end;

PROCEDURE del_file(var fp : text);
begin
  	if (DEBUG>2) then writeln('delete file');
	discard(fp);
	if fp.errs<>wrd(0) then
	  begin
	    perror('ERROR - data file delete error (Press return for more info)');
	    write(clearscrn);
	    printmid(1,'Data file delete error. - error no. 08');
	    printat(3,10,'The program cannot continue. A data file could not ');
	    printat(4,10,'be successfully deleted.');
	    printat(5,10,'A file error number of ');
	    write(fp.errs,' was obtained.');
	    printat(8,10,'Your course of action should be :');
	    printat(10,15,'Notify CBPS of the circumstances of this event.');
	    printat(11,15,'Try running the system again.');
	    closedown('8');
	  end;
end;

PROCEDURE alert_no_point;	(* tell user no new results, no template - so quitting option *)
begin
	printat(11,10,'NOTE. There is No Query Template Set up & there are No');
	printat(12,16,'New Results to Save so there is no point in executing');
	printat(13,16,'this routine');
	perror('Exitting this option.');
end;

PROCEDURE alert_no_template(var carry_on : boolean);	(* alerts user that no template is setup, ask continue anyway *)
var
	ending	: boolean;
begin
	printat(11,10,'NOTE. No Query Template has been Setup so this option');
	printat(12,16,'will just save the new results added.');
	printat(16,8,'Please confirm you still want to run this option : ');
	carry_on:=binput(16,59,1,ending);
	if (ending) then carry_on:=false;
end;

PROCEDURE process_r_q(var newfile,oldfile : text;
		      added_results : result_buf;
		      var num_added : num_result_add_range;
		      quest_template : result; var quest_buf : q_buf;
		      temp_defined : boolean; var num_match : n_match_buf;
		      var num_uniques : integer) [PUBLIC];
								(* Given the new added results buffer & count the proc opens a *)
								(* new file. The new results are processed for query matches   *)
								(* & written to the new file. Then the old data file is opened,*)
								(* each record is query match processed & appended to the new  *)
								(* file. The proc rets with all file processing done, & the    *)
								(* quest_buf & n_match_buf filled in.			       *)

var
	loop				:	integer;
	old_filename			:	str;
	at_eof,carry_on,not_exist	:	boolean;
	temp_rec			:	result;
begin
   if (DEBUG>1) then writeln('process_r_q: num_added = ',num_added);
   if (DEBUG>1) then writeln('process_r_q: Quest_template is ');
   if ((DEBUG>1) and temp_defined) then dprint_rec(quest_template);
   if (DEBUG>1) then writeln('process_r_q: temp_defined = ',temp_defined);
   if (DEBUG>1) then perror('continue');
   carry_on:=true;
   write(clearscrn,boldon);
   printmid(1,'Process Queries & Save New Results.');
   write(attriboff);

   if (num_added=0) and (not temp_defined) then  (* No template & no new results to save - what am I doing here !! *)
     begin
       alert_no_point;
       carry_on:=false;
     end;
   if ((not temp_defined) and (carry_on)) then			(* No Template setup - might as well setup *)
       alert_no_template(carry_on);			(* asks user if still want to process file anyway *)
   if carry_on then
    begin
	write(clearscrn,boldon);
   	printmid(1,'Process Queries & Save New Results.');
   	write(attriboff);
	printmid(15,'Processing, please wait ....');

	at_eof:=false;
	num_uniques:=0;
	open_new_file(newfile,old_filename);	(* creates newfile & rets filename of data file *)
   	if (DEBUG>1) then writeln('process_r_q: opening newfile');
   	if (DEBUG>1) then writeln('process_r_q: starting to q_proc result buf, len=',num_added);
	for loop:=0 to (num_added-1) do
	 begin
	   if temp_defined then
		query_proc(added_results[loop],quest_template,num_uniques,
		      quest_buf,num_match);
 	   write_rec(newfile,added_results[loop]);
	 end;
   	if (DEBUG>1) then writeln('process_r_q: fini q_proc');
   	if (DEBUG>1) then writeln('process_r_q: opening old_file');
	open_old_file(oldfile,old_filename,not_exist);
	at_eof:=not_exist;
	while (not at_eof) do
	 begin
	   read_rec(oldfile,temp_rec,at_eof);
	   if temp_defined then
	      query_proc(temp_rec,quest_template,num_uniques,quest_buf
			,num_match);
	   write_rec(newfile,temp_rec);
	 end;
	close_file(newfile);
	if (not not_exist) then del_file(oldfile);
    (*	rename('NEW.DAT','RACE.DAT');	*)    (* if rename available then remove these brackets & those of open_new_file *)
					      (* as it is is ok as well. *)
	num_added:=0;				(* since saved results can clear buffer *)
    end;
   if (DEBUG>0) then writeln('Num_uniques = ',num_uniques);
   if (DEBUG>0) then perror('continue');
end;

END.
