Program racing(input,output);  (*$DEBUG+*)

(* Date written  : 22/07/86
   Date updated  : 23/11/86
   Author 	 : A.Hausser

   Vers		 : 3.0a
   Update History:
      23/11/86 : the set of modules were modified in structure so that the user
		has two sections that are totally serparate menus. ie. past
		results & personal bets.

*)
const

(*$INCLUDE:'screen.h'*)
(*$INCLUDE:'defs.h'*)
									  (* that matched (ie.no. of winners that matched)      *)
var

	quit					: boolean;
	option					: char;
	loop					: integer;
	printer	[PUBLIC]			: text;
	overflow_file [PUBLIC]			: file of plusresult;

(*$INCLUDE:'GEN-ROUT.H'*)

PROCEDURE past_results; EXTERN;  (* anything to do with past results *)
PROCEDURE personal_bets; EXTERN; (* anything to do with personal bets done *)
PROCEDURE pers_bets_section; EXTERN; (* file init for personal bets modules *)
PROCEDURE past_res_section; EXTERN; (* file init for past results modules *)
   
PROCEDURE print_heading;
begin
	write(clearscrn,boldon);
	printmid(8,'C.B.P.S presents        HORSE RACING.                   ');
	write(attriboff);
	perror('Ready to start.');
end;


PROCEDURE print_menu;
begin
	write(clearscrn,boldon);
	printmid(1,'C.B.P.S  Horse Racing System.');
	write(attriboff);
	printat(7,12,'Please select  : ');
	printat(10,20,'1... Past winning results section.');
	printat(12,20,'2... Personal bets section.');

	printat(17,20,'3... Exit.');
	printat(20,30,'Enter option : ');
end;

PROCEDURE get_option(var option : char);
var
	ending,ok : boolean;
	temp	: str;
begin
  ok:=false;
  while (not ok) do
    begin
	temp:=sinput(20,45,1,ending);
	if ending then perror('You must enter 1-3 (3 to exit)')
	else
           if ((temp[1]<'1') or (temp[1]>'3')) then
	      perror('Error - Enter 1 to 3 only.')
	   else
	      ok:=true;
    end;
  option:=temp[1];
end;

PROCEDURE ov_file_bad( errno : integer);
begin
    	perror('ERROR - overflow data file open error (Press return for more info)');
    	write(clearscrn);
    	printmid(1,'Data file open error. - error no. R01');
    	printat(3,10,'The program cannot continue. The data file RACE.OVE could not ');
    	printat(4,10,'be successfully opened.');
    	printat(5,10,'A file error number of ');
    	write(errno,' was obtained.');
    	printat(8,10,'Your course of action should be :');
    	printat(10,15,'Notify CBPS of the circumstances of this event.');
    	printat(11,15,'Try running the system again.');
    	closedown('R1');
end;
 
BEGIN       (* main program *)
  printer.mode:=SEQUENTIAL;	(* reset printer for whole system *)
  assign(printer,'PRN');
  rewrite(printer);

  overflow_file.mode:=DIRECT;	(* if memory exhausted use this file as array *)
  overflow_file.trap:=true;	(* file used by query.			      *)
  assign(overflow_file,'RACE.OVE'); (* needs to be globally open *)
  rewrite(overflow_file);
  if (overflow_file.errs<>wrd(0)) then ov_file_bad(ord(overflow_file.errs));

  past_res_section;	  (* initialises module past_res_section (for files) *)
  pers_bets_section;	  (* same again but for other files initialise *)

  quit:=false;
  print_heading;
  while (not quit) do
   begin
     print_menu;
     get_option(option);
     case option of
	'1' : past_results;
	'2' : personal_bets;
	'3' : quit:=true;
	otherwise perror('invalid option somehow')
     end;
   end;
end.
