MODULE get_template; (*$DEBUG+*)

const

	DEBUG=0;	(* equal to                  			*)
			(* 1 -                                         	*)
			(* 2 -                   			*)
			(* 3 - 						*)
			(* 4 -						*)

(*$INCLUDE:'SCREEN.H'*)
(*$INCLUDE:'DEFS.H'*)
(*$INCLUDE:'GEN-ROUT.H'*)

PROCEDURE blank_rec(var rec : result);
begin
   with rec do
    begin
	month:=' ';
	runners:=0;
	odds:=0;
	grade:=' ';
	jockey:=' ';
	horse:=' ';
	course:=' ';
	age:=' ';
	handicap:=' ';
	crse_type:=' ';
    end;
end;

PROCEDURE set_field(key_num : integer; var t : result;
		    var f_name : str);
begin
   with t do
    case key_num of
	1 : begin month:='*'; f_name:='Month of race.'; end;
	2 : begin runners:=-1; f_name:='No. of runners.'; end;
	3 : begin course:='*'; f_name:='Name of course.'; end;
	4 : begin age:='*'; f_name:='Horse Age.(0=mixed)'; end;
	5 : begin handicap:='*'; f_name:='Handicapped/not.'; end;
	6 : begin crse_type:='*'; f_name:='Flat/Hurdle course.'; end;
	7 : begin horse:='*'; f_name:='Horse Name.'; end;
	8 : begin jockey:='*'; f_name:='Jockey Name.'; end;
	9 : begin odds:=-1; f_name:='Odds to win.'; end;
	10 : begin grade:='*'; f_name:='Betting Place.'; end;
	otherwise
	   begin
		perror('program error in get_template module, set_field');
		printat(24,1,'key_num was ');
		write(key_num:6);
		closedown('Can not continue');
	   end
     end; (* end case *)
end;

PROCEDURE get_q_template(var quest_template : result;
			 var temp_defined : boolean;
			 var field_1_name,field_2_name : str;
			 var field_1,field_2 : integer) [PUBLIC];
var
	key1,key2		: integer;
	ok,once,ending		: boolean;
begin
	once:=false;
	write(clearscrn,boldon);
	printmid(1,'Setup Query Template.');
	write(attriboff);
	printat(5,5,'Enter ESC to quit option.');
	printat(07,15,' 1. Month of race');
	printat(08,15,' 2. No. of Runners');
	printat(09,15,' 3. Names of Courses');
	printat(10,15,' 4. Ages of horses');
	printat(11,15,' 5. Handicapped or not classification');
	printat(12,15,' 6. Types of courses (Flat/Hurdles)');
	printat(13,15,' 7. Horses names');
	printat(14,15,' 8. Jockeys names');
	printat(15,15,' 9. Odds to win');
	printat(16,15,'10. Placings in betting (Favourite etc)');
	printat(19,20,'Enter the first field to search on (1-10) : ');
        ending:=false;
	ok:=false;
	while ((not ok) and (not ending)) do
	  begin
	    key1:=ninput(19,64,2,ending);
	    if (not ending) then
	     begin
	      if ((key1>=1) and (key1<=10)) then
		ok:=true            
              else
		perror('Error - invalid field no. - enter 1-10, re-enter');
	     end;
	  end;
	if (not ending) then
	   printat(20,20,'Enter the next field to search on (1-10)  : ');
	ok:=false;
	while ((not ok) and (not ending)) do
	  begin
	    key2:=ninput(20,64,2,ending);
	    if (not ending) then
 	     begin
	      if ((key2>=1) and (key2<=10)) then
	       begin
		if (key2<>key1) then
		   ok:=true
	    	else
	    	  begin
		    if ((key2=key1) and once) then
			ok:=true
		    else
		      begin
			perror('Warning - two fields chosen are the same - re-enter once more to confirm ');
			once:=true;
		      end;
		   end;
	       end
	      else
	        perror('Error - invalid field no. - enter 1-10, re-enter');
	     end;
	  end;
	if (not ending) then temp_defined:=true else temp_defined:=false;
	if (not ending) then
	   begin
		blank_rec(quest_template);
		set_field(key1,quest_template,field_1_name);
		set_field(key2,quest_template,field_2_name);
		field_1:=key1;
		field_2:=key2;
	   end
	else perror('Setup Template Option aborted.');
end;

END.
