  [?3h
$ TYPE bios26.asm

; [bios.apricot.ram]bios26.asm
        INCLUDE 'legal.asi'
;************************************************************************
;*                                                                      *
;* MODULE:      [bios.apricot.ram]bios26.asm                            *
;* PROGRAMMER:  G. Kurth                                                *
;* IMPLEMENTED: 30-jan-84                                               *
;* MODIFICATIONS:       apricot RAM version 5/984 G.K.                  *
;*			BIOS 2.4 compatible version 19/10/84		*
;*			Error status returned on get BPB 3/12/84 RJW.	*
;*			TEST 20M SUPPORT VERSION  15/1/85 GK		*
;*			Optional signon 8/2/85 GK			*
;*			FOREIGN DISK SUPPORT 13/3/85 GK			*
;*			new disk protection stuff - int E5		*
;*			Large winchester support 25/3/85 IGC		*
;*			Use MSDOS length as per label sector		*
;*			Calculate sectors to load for FONT and ,KEYTAB  *	*
;*			from disk sector size;				*
;*                                                                      *
;************************************************************************
;
; BIOS.ASM      -       Main BIOS entry point for RAM BIOS
;               Sets up the BIOS environment
;               Initialises the Hardware
;               Loads FONT KEYTAB & MS-DOS from disk
;               Jumps to SYSINIT
;------------------------------------------------------------------------

        NAME    bios

        GLOBAL  CodebaseQQ, DatabaseQQ, StkbaseQQ

        ASSUME  CS:CodebaseQQ, DS:DatabaseQQ, ES:DatabaseQQ, SS:DatabaseQQ

        INCLUDE 'mserror.asi'
        INCLUDE 'ioregs.asi'
        INCLUDE 'Genequ.asi'
        INCLUDE 'copyregs.asi'

BIOSVER	EQU	2		; 2 - BIOS version 2.xx
				; 3 - BIOS version 3.xx
BIOSLOW	EQU	FALSE		; TRUE  - Low loading server BIOS
				; FALSE - Standard BIOS
DOSVER	EQU	2		; 2 - MS-DOS 2.xx signon
				; 3 - MS-DOS 3.xx signon

	page

        SECTION Bios.code, ALIGN(1), CLASS=InstrQQ

; Constants declared at link time
        
        Global	IMG_SEG		;Screen image segment address
	GLOBAL	KEYSEG		;KEYBOARD TABLE SEGMENT ADDRESS	
	GLOBAL	FONTSEG		;FONT SEGMENT ADDRESS
	GLOBAL	DOSSEG		;DOS SEGMENT ADDRESS
	GLOBAL	SYSISEG		;SYSINIT SEGMENT ADDRESS
	GLOBAL	DOSLEN		;DOS LENGTH IN SECTORS
        
; Global internal Data
	Global	B_ROM_VER		; rom version (word)
	Global	B_RAM_SIZ		; ram size (word)
	Global	B_WATERMK, B_WATERMK1	; watermark (dword)
	Global	B_BT_DRIV		; drive booted from (word)
	Global	B_BT_HDR		; pointer to loaded header sector
	Global	B_WIN_BRD,WID_BOARD	; Winchester board type
	Global	B_WIN_TYP,WID_type	; winchester type (byte)
	Global	B_FLP_TYP		; floppy type (byte)        
	Global	B_FLP_NUM		; number of floppies (byte)	
	Global	B_WIN_NUM		; number of winchesters (byte)
	Global	B_FLP_BPB		; pointer to BPB array table (dword)
	Global	B_WIN_BPB		; pointer to BPB array table (dword)
	Global	B_DIAGRES		; diagnostic results (word)
	Global	B_USR_RAM		; paragraph address of user ram
	Global	B_WIN0_NUM		; winchesters on board 0
	Global	B_WIN1_NUM		; winchesters on board 1
;
; Global external data

	GLOBAL	MSDDEV			;DISK DEVICE HEADER
	GLOBAL	CLKDEV			;CLOCK DEVICE HEADER
	GLOBAL	DRVMAX			;FLOPPY DRIVE COUNT
	GLOBAL	WINMAX			;WINCHESTER DRIVE COUNT
	GLOBAL	SI_SYSINIT		;SYSINIT ENTRY POINT
	GLOBAL	SI_MEMORY_SIZE		;SYSINIT RAM SIZE
	GLOBAL	SI_DEFAULT_DRIVE	;SYSINIT BOOT DRIVE
	GLOBAL	PRN_queue		;printer buffer - used as temporary
					; label sector store
        Global  CNFtab_base             ; start of config table
	GLOBAL	CNF_DOS_SEC		; START SECTOR OF MS-DOS
	GLOBAL	CNF_FONT_SEC		; START SECTOR OF FONT
	GLOBAL	CNF_KEYS_SEC		; START SECTOR OF KEYBOARD TABLE
	global	CNF_DOS_SIZ		; length of MS-DOS
	global	CNF_FONT_SIZ		; length of FONT
	global	CNF_KEYS_SIZ		; length of KEYTAB
	GLOBAL	CNF_signon		; sign on disable flag
	Global	COPY_BASE        	;register copy table base
	GLOBAL	Finit_table		;floppy BPB init table
	GLOBAL	Winit_table		;winchester BPB init table
	GLOBAL	LCDXLAT			;built-in LCD translate table
	Global	FS_logtab		;floppy logging table

; Global external routines
        GLOBAL  BI_Init_Vect            ;Initialise vectors & hardware
        GLOBAL  sound_init              ;Initialise sound
        GLOBAL  auxset                  ;Setup of side-A of SIO for aux device
	GLOBAL	KBD_init		;initialise the keyboard handler
        GLOBAL  TMR_init                ;Initialise Timer
        GLOBAL  DIO_init                ;Disk initialisation routine
        GLOBAL  PRN_init                ;Printer driver initialisation
        GLOBAL  SER_init                ;AUX driver initialisation
        GLOBAL  WINI_init               ;Winchester initialisation routine
        GLOBAL  RESET_ALL		;screen initialise
;
; Global internal routines
	GLOBAL	BI_RE_INIT		;BIOS RE-ENTRY
        GLOBAL  BIOS_START              ;Bios entry point

;--------------------------------------------------------------------
;	FONT lengths for different BIOS versions
;--------------------------------------------------------------------
	IF	BIOSVER = 3 & BIOSLOW = FALSE
FONTLEN		EQU	12*1024+512		; 12.5k
	ENDIF

	IF	BIOSVER = 3 & BIOSLOW = TRUE
FONTLEN		EQU 	8*1024			; 8k
	ENDIF

	IF	BIOSVER = 2 & BIOSLOW = FALSE
FONTLEN		EQU	10*1024			; 10k
	ENDIF

	IF	BIOSVER = 2 & BIOSLOW = TRUE
FONTLEN		EQU 	8*1024			; 8k
	ENDIF

;--------------------------------------------------------------------------
;
; BIOS_START    - Entry point from boot diagnostics
;
BIOS_START

	cli
	mov	ax,#bits(databaseQQ,4,16)
	mov	ds,ax
	mov	es,ax
	mov	ss,ax
	mov	sp,#(stkbaseqq-Databaseqq)

;GET FIRST 12 WORDS FROM 400H TABLE INTO INTERNAL COPY
	LEA	DI,B_ROM_VER		;DEST
	XOR	SI,SI
	MOV	DS,SI
	MOV	SI,#400H		;DS:SI -> 400H
	MOV	CX,#12			;12 WORDS
	CLD
	REP	MOVW			;GRABBEM
	MOV	DS,AX			;RESTORE DS
	cmpb	B_ROM_VER,#3		;prom's capable of handling wini etc?
	ja	LCONF1			;yes skip
	movb	B_FLP_TYP,#0		;set up 70 track type
	movb	B_FLP_NUM,#2		;two of them
	jmpsh	LCONF2			;and skip
LCONF1	cmpb	B_ROM_VER,#5		;can it handle one ore two floppies?
	ja	LCONF2			;yes skip
	movb	B_FLP_NUM,#2		;say two floppies
	cmpb	B_WIN_TYP,#0		;but had it a winchester?
	je	LCONF2			;no - skip
	movb	B_FLP_NUM,#1		;yes - only one floppy allowed
LCONF2
	cmpb	B_ROM_VER,#2		;did the rom size the RAM?
	ja	LCONF3			;yes - skip
;
; SIZE RAM FOR OLD VERSIONS OF ROM
;
	MOV	DX,ES
	MOV	CX,#4000H		;START AT TOP OF STANDARD RAM
	MOV	AX,#0B4B8H		;TEST PATTERN
B_SIZE1
	MOV	ES,CX			;SET UP SEG
	MOV	ES:3FEH,AX		;DO 1K AT A TIME
	CMP	ES:3FEH,AX
	JNE	B_SIZE2			;SORRY
	NOT	AX
	MOV	ES:3FEH,AX
	CMP	ES:3FEH,AX
	JNE	B_SIZE2
	NOT	AX
	ADD	CX,#40H			;BUMP TO NEXT 1K
	CMP	CX,#0F000H		;GOT TO VIDEO?
	JB	B_SIZE1			;NO - DO NEXT
B_SIZE2
	MOV	B_RAM_SIZ,CX		;SET UP RAM SIZE
	MOV	ES,DX	

LCONF3


;NOW GET CONFIG TABLE
	MOV	AX,DS
	LEA	DI,CNFTAB_BASE		;POINT TO DEST
	MOV	CX,#40H			;80H BYTES TO MOVE
	LDS	SI,B_BT_HDR		;POINTER NOW IN LOCAL COPY
	REP	MOVW			;GET CONFIG TABLE
	MOV	DS,AX			;RESTORE DS


;INITIALISE INTERRUPT VECTORS        
        call    BI_Init_Vect            ;Initialise interrupt vectors


;INITIALISE ALL THE HARDWARE
        call    BI_Init_HW              ; and set up hardware


;INITIALISE SOFTWARE
	sti                             ; interrupts are OK now
        call    sound_init              ; init sound generator
	call	BI_init_Hptr		;set up default pointers
        call    RESET_ALL		; init the screen
        call    TMR_init                ; init timer and sheduler
        call    PRN_init                ; init printer driver

	call	SER_init		; init aux device
        call	KBD_init		; init keyboard driver
	lea	si,CURO_MES		; SWITCH OFF THE CURSOR
	CALL	PRINT


;INITIALISE DISK DRIVER
        call    DIO_init                ; init disk drivers
	call    Wini_init               ; initialise the winchester
;
;
	CALL	BI_INIT_PTR		; SET UP 400H POINTERS AGAIN

;INITIALISE DEVICE LIST FOR MS-DOS

	CMPB	B_WIN_NUM,#0		; ANY WINCHESTER DEVICES?
	JNE	DLWINI			; YES - LEAVE WINCHESTER IN DEVICE LIST
	MOV	AX,#(MSDDEV-CODEBASEQQ)	;GET POINTER TO FLOPPY DEVICE
	MOV	CS:CLKDEV,AX		;AND POINT PAST WINIS
DLWINI
	MOV	AL,B_FLP_NUM		;GET NUMBER OF FLOPPIES
	MOV	CS:DRVMAX,AL		;AND FILL IN
	MOV	AL,B_WIN_NUM		;GET NUMBER OF WINCHESTERS
	MOV	CS:WINMAX,AL		;AND FILL IN
;
	page
;
;PERFORM A GET BPB CALL FOR THE BOOTING DRIVE
;
	LEA	SI,DISK_SCRATCH
	MOVW	2[SI],#(PRN_QUEUE-DATABASEQQ)
	MOVW	4[SI],DS		; BUFFER = UNUSED PRINT QUEUE
	MOV	AX,B_BT_DRIV		; GET BOOT DRIVE
	CMP	AX,#2			; IS IT A WINI?
	JB	GBPB_FLPY		; NO - FLOPPY
	SUB	AX,#2			; ADJUST DRIVE NUMBER
	MOV	BX,#40H			; WINCHESTER DEVICE
	MOV	CX,#04H			; COMMAND 4 - GET BPB
	JMPSH	GBPB_ANY		; SKIP
GBPB_FLPY
	MOV	BX,#39H			; FLOPPY DEVICE
	MOV	CX,#0AH			; COMMAND A - GET BPB
GBPB_ANY
	MOV	[SI],AX			; PUT DRIVE IN COMMAND TABLE
	MOV	DX,DS			; DX:SI -> COMMAND TABLE
	INT	#0FCH			; GO FOR A BPB
	CMP	AX,#MSE_OK		; ALL WELL?
	JE	GFONT			; YES - GET THE FONT
	JMP	BIOS_PANIC		; REBOOT THE MACHINE
;
	PAGE
;
;LOAD FONT FROM DISK

GFONT
	PUSH	BX
	PUSH	DS			; Get sector size of boot disk
	LDS	BX,2[SI]
	MOV	AX,[BX]
	POP	DS
	POP	BX
	MOV	BOOT_SECSZE,AX

	INCW	CX			; CX = 5 OR B - READ COMMAND
	MOV	AX,CNF_FONT_SEC		; GET START FONT SECTOR
	MOV	4[SI],AX		; PUT IN COMMAND TABLE
	XOR	AX,AX
	MOV	2[SI],AX		; COMMAND 0 - READ
	MOV	8[SI],AX		; OFFSET 0
	MOVW	10[SI],#FONTSEG		; DESTINATION SEGMENT
;	MOVW	6[SI],#16		; 16 SECTORS (8K)
;	mov	al,CNF_FONT_SIZ		; sectors in FONT
;	xor	ah,ah
;	mov	6[si],ax
	mov	ax,#FONTLEN		; load FONTLEN bytes
	add	ax,BOOT_SECSZE		; calculate sectors
	dec	ax
	push	dx
	xor	dx,dx
	divw	BOOT_SECSZE
	pop	dx
	mov	6[si],ax
	INT	#0FCH			; READ IN FONT
	CMP	AX,#MSE_OK		; ALL WELL?
	JE	GLOGO			; YES - GET LOGO
	JMP	BIOS_PANIC		; SORRY
GLOGO
;	ADDW	4[SI],#16		; POINT AT LOGO AREA OF FONT.SYS
;	MOVW	10[SI],#680H		; LOAD INTO 680:0H 
;	MOVW	6[SI],#4		; 2K TO READ
;	INT	#0FCH			; READ IN LOGO
;	CMP	AX,#MSE_OK		; OK?
;	JE	GKEYS			; YES - GET KEYBOARD TABLE	
;	JMP	BIOS_PANIC		; SORRY

;----------------------------------------------------------------------
	IF	BIOSLOW=FALSE
;----------------------------------------------------------------------
	push	ds			; copy logo area to 680:0
	push	es
	push	cx
	push	si
	mov	ax,#FONTSEG		; FONT segment
	mov	ds,ax
	mov	si,#8192		; plus 8k
	mov	ax,#680h
	mov	es,ax
	mov	di,0
	mov	cx,#2048		; copy 2k
	rep	movb
	pop	si
	pop	cx
	pop	es
	pop	ds
;--------------------------------------------------------------------------
	ENDIF
;--------------------------------------------------------------------------
;
;
;LOAD KEYBOARD TABLE FROM DISK

GKEYS
;
; BUT FIRST DO A SIGN-ON
;
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
;-----------------------------------------------------------------
	IF	BIOSLOW = TRUE
;-----------------------------------------------------------------
	cli
	in	al,#PIO_PORB		;and switch it on!
	and	al,#0F7h
	out	#PIO_PORB,al
	sti
;-----------------------------------------------------------------
	ENDIF
;-----------------------------------------------------------------
	CALL	SIGNON
	POP	SI
	POP	DX
	POP	CX
	POP	BX
;
	MOV	AX,CNF_KEYS_SEC		; GET START SECTOR
	MOV	4[SI],AX		; PUT IN COMMAND TABLE
	MOVW	10[SI],#KEYSEG		; DESTINATION SEGMENT
;	MOVW	6[SI],#2		; 2 SECTORS (1K)
;	mov	al,CNF_KEYS_SIZ		; length of keyboard table
;	xor 	ah,ah
;	mov	6[si],ax
	mov	ax,#1024		; load 1k
	add	ax,BOOT_SECSZE		; calculate sectors
	dec	ax
	push	dx
	xor	dx,dx
	divw	BOOT_SECSZE
	pop	dx
	mov	6[si],ax
	INT	#0FCH			; READ IN KEYBOARD TABLE
	CMP	AX,#MSE_OK		; ALL WELL?
	JE	GDOS			; YES - GET MS-DOS	
	JMP	BIOS_PANIC		; SORRY
;
;LOAD MS-DOS FROM DISK

GDOS
	MOV	AX,CNF_DOS_SEC		; GET START SECTOR
	MOV	4[SI],AX		; PUT IN COMMAND TABLE
	MOVW	10[SI],#DOSSEG		; DESTINATION SEGMENT
;	MOVW	6[SI],#DOSLEN		; X SECTORS (XK)
	mov	al,CNF_DOS_SIZ		; size of MS-DOS
	xor	ah,ah
	mov	6[si],ax
	INT	#0FCH			; READ IN KEYBOARD TABLE
	CMP	AX,#MSE_OK		; ALL WELL?
	JE	GOSYSINIT		; YES - GO TO SYSINIT	

BIOS_PANIC
	JMPS	0,0FFFFH		; CAN'T THINK OF ANYTHING ELSE

;GO TO SYSINIT

GOSYSINIT
	MOV	AX,#SYSISEG		;
	PUSH	AX
	MOV	ES,AX			; POINT AT SYSINIT
	XOR	AX,AX
	PUSH	AX			; ADDRESS ON STACK FOR RETS
	MOV	AX,B_BT_DRIV		; GET DRIVE BOOTED FROM
	MOV	CL,B_WIN_NUM		; GET NUMBER OF WINCHESTERS
	CMP	AL,#2			; BOOTED FROM WINI?
	JB	GOSFLOPY		; NO - FLOPPY BOOT
	SUB	AL,#1			; ADJUST WINI NUMBER TO 1,2
	JMPSH	GOSDISK			; SET UP DISK FOR SYSINIT
GOSFLOPY
	INC	AL			; ADJUST FLOPPY NUMBER
	ADD	AL,CL			; AND ADD IN WINCHESTER OFFSET
GOSDISK
	MOV	BX,#(SI_DEFAULT_DRIVE-SI_SYSINIT)
	MOVB	ES:[BX],AL		; SET UP DEFAULT DRIVE IN SYSINIT
	MOV	AX,B_RAM_SIZ		; GET RAM SIZE
	MOV	BX,#(SI_MEMORY_SIZE-SI_SYSINIT)
	MOV	ES:[BX],AX		; FILL IN RAM SIZE
	RETS				; GO TO SYSINIT

;
;	BI_RE_INIT	- CALLED BY SYSINIT ON RESTART
;
BI_RE_INIT
	RETS

        page
    page
;***********************************************************************
;******************   SUBROUTINE:  BI_init_ptr  ************************
;***********************************************************************
; BI_init_ptr - subroutine to load up low RAM pointers at 400H and 700H,
; for hardware config, character font & KBD tables
;-------------------------------------------------------------------------
;
BI_init_ptr
        
        pushf
        cli                             ;don't get interrupted
        cld
	push    es                      ;save current es
	lea	si,BI_rom_block		;source is rom block
	xor	di,di			;dest offset 0
	mov	ax,#40h			;segment 40:0
	mov	es,ax
	mov	cx,#20h			;20h words to move (40h bytes)
	rep	movw        
	jmpsh	BI_init_ptr1		;now do the high bits
;
BI_init_Hptr				;init high pointers only
	pushf
	cli
	cld
	push	es
BI_init_ptr1
	xor	ax,ax
	mov	es,ax
	mov	di,#606h		;clear ram between 606h & 800h
	mov	cx,#0FDh		;253 words to clear
	rep	stow

	lea	si,BI_pointer_block	;set source to pointer block
        movw    di,#700H                 ;set destination to 70:0 (700H)
        movw    cx,#18h                 ;18h words to move (30h bytes)
        rep     movw                    ;load block from DS:SI to ES:DI
        pop     es                      ;restore es
        popf
        ret

;
        page
;***********************************************************************
;******************   SUBROUTINE:  BI_init_HW  *************************
;***********************************************************************
; BI_Init_HW    - hardware specific initialisation
;               called with interrupts off.
;
;1)     Initialise PIC
;2)     Initialise PIO
;3)     Initialise PIT
;4)     Initialise SIO
;5)     Initialise CRTC
;
;-----------------------------------------------------------------------
BI_Init_HW

;INITIALISE  PIC (8259A)
        movb    al,#01Bh        ;Modes(Level Triggered,Single,IW4)
        out     #PIC_IW0,al     ;Start initialisation
        movb    al,#050h        ;Interrupt Vector
        out     #PIC_IW1,al
        movb    al,#01          ;8086 Mode
        out     #PIC_IW1,al
        movb    al,#0FFh        ;Disable Mask for all interrupts
        out     #PIC_IW1,al

;INITIALISE PIO (8255)
	mov	al,#081h	;Mode 0, Port C lower input, others output
	out	#PIO_COM,al
;---------------------------------------------------------------------
	IF	BIOSLOW = TRUE
;---------------------------------------------------------------------
	mov	al,#01Bh	;PORT B - set parallel output, drive 0 selected
				; head load off, text mode on, display off
;---------------------------------------------------------------------
	ELSE
;---------------------------------------------------------------------
	mov	al,#013h	;PORT B - set parallel output, drive 0 selected
				; head load off, text mode on, display on
;---------------------------------------------------------------------
	ENDIF
;---------------------------------------------------------------------
	out	#PIO_PORB,al	; CRTC reset high
	mov	al,#07Fh	;PORT C - upper - centronics lines high
	out	#PIO_PORC,al
		

;INITIALISE PIT (8253) 
        movb    al,#030h        ;Counter 0 Load,Mode 0
        out     #PIT_COM,al     ;Prepare to receive counter 0
        movb    al,#076h        ;Counter 1 Load,Mode 3
        out     #PIT_COM,al     ;Prepare to receive counter 1
        movb    al,#0B6h        ;Counter 2 Load,Mode 3
        out     #PIT_COM,al     ;Prepare to receive counter 2
        movw    ax,#05000       ;20ms - Counter value(System Timer)
        out     #PIT_CN0,al     ;Setup Counter 0
        movb    al,ah
        out     #PIT_CN0,al
        movw    ax,#013         ;9.6KHz - Counter value(SIO Clock)
        out     #PIT_CN1,al     ;Setup Counter 1
        movb    al,ah
        out     #PIT_CN1,al
        movw    ax,#013         ;9.6KHz - Counter value(SIO Clock)
        out     #PIT_CN2,al     ;Setup Counter 2
        movb    al,ah
        out     #PIT_CN2,al

;INITIALISE SIO (Z80-SIO/0) 
        movb    al,#018h        ;Write Register 0 - both Channels
        out     #SIO_B_COM,al   ;Channel Reset of B
        out     #SIO_A_COM,al   ;Channel Reset of A

;initialise keyboard (side-B)

	mov	al,#04		;Write register 4 - channel B
	out	#SIO_B_COM,al
        movb    al,#088h	;32 * clock, 1.5 stop bits, no parity
        out     #SIO_B_COM,al
        movb    COPY_SIO_W4B,al ;set up copy
        movb    al,#02h         ;Write Register 2 - Channel B
        out     #SIO_B_COM,al
        movb    al,#00          ;Interrupt Vector - Channel B
        out     #SIO_B_COM,al
        movb    al,#3           ;write register 3 - Channel B
        out     #SIO_B_COM,al
	movb	al,#0C1h	;rx on, 8 bits per character
        out     #SIO_B_COM,al
        movb    COPY_SIO_W3B,al ;set up copy
        movb    al,#5           ;write register 5 - Channel B
        out     #SIO_B_COM,al
	movb	al,#068h	;tx on, 8 bits per character
        out     #SIO_B_COM,al
        movb    COPY_SIO_W5B,al ;set up copy
        movb    al,#1           ;Write Register 1 - Channel B
        out     #SIO_B_COM,al
        movb    al,#04h         ;No ints enabled, S.A.V. - Channel B
        out     #SIO_B_COM,al
        movb    COPY_SIO_W1B,al ;set up copy

;initialise AUX port (side-A)
				
	movb	COPY_SIO_W5A,#01101000b	;initially DTR & RTS off
	call	auxset		;set up SIO side-A, & timer registers from 
				;data in configuration tables.

        

;INITIALISE THE CRTC
				;performed by diagnostics

;INITIALSE ODD PORTS
        ret                     ;BI_Init_HW finished
;
	PAGE
;**********************************************************************
;	SIGNON - Does machine & BIOS signons
;
nosign	lea	si,CUR_MES		;just switch on the cursor
	call	print
	ret

signon
	cmpb	CNF_signon,#1		;sign on disabled?
	je	nosign

	lea	si,boot_mes		;do the first bit
	call	print
	xor	dx,dx
	cmpb	B_WIN_NUM,#1		;any winchesters?
	jb	sign_nowin
;	je	sign_onwin		;only one
;	mov	al,WID_type2		;get second drive type
;	MOV	BX,WID_TRKSID2		;AND CYLINDER COUNT
;	call	winadd			;convert to MB in dx
;sign_onwin
;	mov	al,WID_type1		;get first drive type
;	MOV	BX,WID_TRKSID1		;AND CYLINDER COUNT
;	call	winadd
	mov	bx,#0			;look at winchester 1
	call	winadd
	add	dx,cx
	cmpb	B_WIN_NUM,#2		;two winchesters ?
	jb	sign_onwin
	mov	bx,#1			;look at winchester 2
	call	winadd
	add	dx,cx
	cmpb	B_WIN_NUM,#3		;three winchesters ?
	jb	sign_onwin
	mov	bx,#2			;look at winchester 3
	call	winadd
	add	dx,cx
	cmpb	B_WIN_NUM,#4		;four winchesters ?
	jb	sign_onwin
	mov	bx,#3			;look at winchester 4
	call	winadd
	add	dx,cx
sign_onwin
	call	D_D			;print DX as decimal
	lea	si,win_mes
	call	print
	lea	si,stor_mes
	call	print
sign_nowin
	mov	dx,#315			;set up disk for 70 T/SS
	cmpb	B_FLP_TYP,#2		;80 T/DS?
	jne	sign_ssflp		;no - skip
	mov	dx,#720			;set up size for floppy
sign_ssflp
	cmpb	B_FLP_NUM,#2		;two floppy drives?
	jne	sign_onflp		;no - only one
	shl	dx,#1			;multiply by two
sign_onflp
	call	D_D			;print dx as decimal
	lea	si,flp_mes
	call	print
	lea	si,stor_mes
	call	print
	mov	ax,B_RAM_SIZ		;now do the RAM size
	mov	cl,#6
	shr	ax,cl
	mov	dx,ax			;dx = ram size in kilobytes
	call	D_D
	lea	si,ram_mes
	call	print
	ret
;
;
winadd
;	CMP	BX,#306			;RODIME TYPE?
;	JE	WINADD1			;YES - SKIP
;	INC	AL			;ADJUST TYPE FOR NOW
;WINADD1
;	add	dx,#5			;5 meg
;	cmp	al,#3			;was it?
;	je	winaddx
;	add	dx,#5			;10 meg
;	cmp	al,#4			;was it
;	je	winaddx
;	add	dx,#10			;20 meg
;winaddx
;	ret

	xor	cx,cx			;size zero for now
	shl	bx,#1			;get BPB from table
	mov	bx,WINIT_table[bx]
	cmp	0dh[bx],#3		;2 head wini ?
	mov	ax,#2
	je	newwin
	cmp	0dh[bx],#4		;4 head wini ?
	mov	ax,#4
	je	newwin
	cmp	0dh[bx],#5		;8 head wini ?
	mov	ax,#8
	je	newwin
	cmp	0dh[bx],#80h		;New style wini
	jne	wini_addx

newwini	mov	ax,1ah[bx]		;number of heads
newwin	push	dx
	xor	dx,dx
	mov	cx,16h[bx]		;multiply by cylinders
	mulw	cx
	mov	cx,#8192		;multiply by bytes/track
	mulw	cx
;	add	ax,#25a0h		;add 2.5 million
;	adc	dx,#26h
	mov	cx,#10000		;divide by 10,000
	divw	cx
	xor	dx,dx			;divide by 500
	mov	cx,#100
	divw	cx
;	mov	cx,#5			;multiply by 5
;	mulw	cx
	mov	cx,ax
	pop	dx
wini_addx
	ret	

;
;
D_D	mov	ax,dx		;prints DX as decimal number
	xor	dx,dx
	mov	cx,#10
	div	cx
	push	dx
	mov	dx,ax
	or	ax,ax
	jz	d40
	call	D_D
d40	pop	bx
	add	bl,#30h
	mov	al,bl
	int	#0F1h
	ret
;
;
print	cld			;prints si string until '$'
	lodb
	cmp	al,#'$'
	je	printx
	int	#0F1h
	jmpsh	print
printx	ret


	page
;
        Section Bios.const,align(2),class=constQQ
;
BI_rom_block			;destination 400h
B_ROM_VER	WORD	0000h		;APRICOT version ?
B_RAM_SIZ	WORD	4000h		;RAM size in paragraphs
B_WATERMK	WORD	1234h		;BOOT watermark
B_WATERMK1	WORD	5678h
B_BT_DRIV	WORD	0		;Drive booted from
B_BT_HDR	WORD	0,0		;Pointer to loaded config
		WORD	0,0		;NOT USED
		BYTE	1		;8089 FLAG - not used
WID_BOARD
B_WIN_BRD	BYTE	0		;Winchester board type
B_WIN_TYP	BYTE	0		;Winchester Type
B_FLP_TYP	BYTE	2		;Floppy Type
B_FLP_NUM	BYTE	1		;Number of floppies
B_WIN_NUM	BYTE	0		;Number of winchesters
B_FLP_BPB	WORD	(Finit_Table-DatabaseQQ) ;Floppy BPB array table
		WORD	bits(DatabaseQQ,4,16)
B_WIN_BPB	WORD	(Winit_Table-DatabaseQQ) ;Winchester BPB array table
		WORD	bits(DatabaseQQ,4,16)
B_DIAGRES	WORD	0h		;Diagnostics result register
B_USR_RAM	WORD	0C80h		;paragraph address of user ram
B_STK_SEG	WORD	(STKBASEQQ-DATABASEQQ)	;BIOS stack top offset
		WORD	bits(databaseQQ,4,16)	;BIOS stack segment value
		WORD	0,0		;soft restart - not used
B_WIN0_NUM	BYTE	0		;winchesters on board 0
B_WIN1_NUM	BYTE	0		;winchesters on board 1
		WORD	0		;not used
B_log_ptr	WORD	(FS_logtab-DatabaseQQ)	;pointer to floppy logging table
		WORD	bits(databaseQQ,4,16)	;
		WORD	0,0,0,0,0,0		;spare

;	
;
BI_pointer_block		;destination 700h
        word    (CNFtab_base-DatabaseQQ)        ;pointer to config table
        word    bits(DatabaseQQ,4,16)
        word    80h                     ;length in bytes
        word    0,FONTSEG		;pointer to active character font
        word    8192                    ;length in bytes
        word    0,680H			;pointer to LOGO font
        word    2048                    ;length of font
        word    0			;double-word pointer
        word    KEYSEG			;to current Keyboard tables
        word    1024                    ;length in bytes
        word    0			;double-word pointer
        word    KEYSEG			;to default Keyboard tables
        word    1024                    ;length in bytes
	word	(LCDXLAT-DatabaseQQ)	;pointer to LCD translate table
	word	bits(DatabaseQQ,4,16)
	word	(COPY_BASE-DatabaseQQ)	;Doubleword pointer to Register
	word	bits(DatabaseQQ,4,16)	;Copy area
	word	0
	word	IMG_SEG			;pointer to ASCII video image
	word	0
	word	IMG_SEG			;pointer to LCD ascii image
	word	0			;spare
;
;	SIGN-ON MESSAGE
;
WIN_MES
	ASCII	' MB Winchester Disk$'
;
FLP_MES
	ASCII	' KB Floppy Disk$'
;
RAM_MES
	ASCII	' KB System Memory'
	BYTE	13,10
CUR_MES	BYTE	27,'y','5','$'
;
STOR_MES
	ASCII	' Storage'
	byte	13,10
	ASCII	'          : $'
;
CURO_MES
	BYTE	27,'x','5','$'
;
;
BOOT_MES
	BYTE	1BH,'i'			;PRINT LOGO
	BYTE	20H,5BH
	BYTE	1BH,'Y'			;Position cursor
	BYTE	20H,20H
;-----------------------------------------------------------------
	IF	DOSVER = 3
;-----------------------------------------------------------------
	ASCII	'ACT Apricot PC & XI MS-DOS 3.10 RAM BIOS'
	byte	13,10
;-----------------------------------------------------------------
	ELSE
;-----------------------------------------------------------------
	ASCII	'ACT Apricot PC & XI MS-DOS 2.11 RAM BIOS'
	byte	13,10
;-----------------------------------------------------------------
	ENDIF
;-----------------------------------------------------------------
	IF	BIOSLOW = TRUE
;-----------------------------------------------------------------
	ASCII	'Low-Loading Non-Graphics Server Version'
	byte	13,10
;-----------------------------------------------------------------
	ENDIF
;-----------------------------------------------------------------
	IF	BIOSVER = 3
;-----------------------------------------------------------------
	ascii	'Version  Beta 3.0a'
;-----------------------------------------------------------------
	ELSE
;-----------------------------------------------------------------
	ascii	'Version  A 2.8'
;-----------------------------------------------------------------
	ENDIF
;-----------------------------------------------------------------
	ascii	', 2nd May 1985'
	byte	13,10,10
	ascii	'Hardware  : $'
        page
;
        Section Bios.data,align(2),class=dataQQ
;
DISK_SCRATCH	BLOCK	12	;scratch space for disk command table

BOOT_SECSZE	BLOCK	2	;boot disk sector size
;
        
        end


$ 