                                                        [?3h
$ TYPE interrupt.asm

; [bios.apricot.rom]interrupt.asm
	title	'[bios.apricot.rom]interrupt.asm'
        INCLUDE 'legal.asi'
;*********************************************************************
;        
; MODULE:       [bios.apricot.rom]interrupt.asm
; PROGRAMMER:   G. Kurth
; STATUS:       Test
; IMPLEMENTED:  13-feb-84
; MODIFICATIONS:        apricot version 14-mar-84 G.K.
;			VAX version 2/5/84 GK
;			ROM BIOS interrupt handlers 21-may-84
;			Nicer Nesting Levels 5/2/84 GK
;
;*********************************************************************

	NAME	INTERRUPTS

	page

        INCLUDE 'Genequ.asi'
        INCLUDE 'ioregs.asi'
;	
;
; Interrupt handlers
; ==================
;

        GLOBAL  SCREEN_OUT	; fast screen output
        GLOBAL  Control_entry   ; call 600h control entry
;
        GLOBAL  TMR_int         ;PIT - system timer
        GLOBAL  SIO_int         ;SIO - KB or UART , Tx or Rx

; Interrupt entry points, vectors set up by BIOS.
; ===================================================
;
        GLOBAL  BI_Init_Vect    ;Interrupt vector table setup
        GLOBAL  INT_unexpected  ;Orphaned interrupt

        GLOBAL  IOP1_intv	;PIC 0-IOP channel 1 interrupt
        GLOBAL  IOP2_intv        ;PIC 1-IOP channel 2 interrupt
        GLOBAL  EXPNDA_intv	;PIC 2-Expansion interrupt 2 (winchester)
        GLOBAL  EXPNDB_intv     ;PIC 3-Expansion interrupt 3
        GLOBAL  DIO_intv	;PIC 4-FDC interrupt
        GLOBAL  SIO_intv	;PIC 5-SIO interrupt (KBD/RS232)
        GLOBAL  TMR_intv        ;PIC 6-System clock interrupt
        GLOBAL  NDP_intv        ;PIC 7-8087 Numeric Data Proc interrupt
;
        GLOBAL  Int_41          ;INT 29h - fast screen output
	GLOBAL	Int_229		;int E5h - disk protection
	GLOBAL	Int_238		;INT EEh - Send EOI to PIC
	GLOBAL	Int_241		;INT f1h - fast screen output
	GLOBAL	Int_244		;INT f4h - External Interrupt setup
        GLOBAL  Int_249         ;INT f9h - dummy keyboard int
        GLOBAL  Int_250         ;INT fah - dummy mouse int
        GLOBAL  Int_251         ;INT fbh - dummy mouse int 2
        GLOBAL  Int_252         ;INT fch - BIOS control interrupt
        GLOBAL  Int_253         ;INT fdh - dummy spooler int
        GLOBAL  Int_254         ;INT feh - dummy exec int
 
;---------------------------------------------------------------------------
;
;
; Things needed to communicate with Pascal system.
; ===============================================

        GLOBAL   DATABASEQQ;far
        GLOBAL   CODEBASEQQ;far
        GLOBAL   STKBASEQQ;far

	page
;
        Section INTERRUPT.CODE,align(1),class=INSTRQQ
        Assume ds:DataBaseQQ,CS:CodeBaseQQ,ss:DataBaseQQ

;-----------------------------------------------------------------------------;
;   Individual Interrupt Entry Points.                                        ;
;-----------------------------------------------------------------------------;

INT_unexpected
                                ;ignore invalid interrupts for the moment
        iret


;
PIT_intv			;PIT - system timer
        push    si
        movw    si,#(TMR_int-CodebaseQQ)
        jmpsh	ENTRY
;
SIO_intv			;SIO - data Tx or Rx either from KB or UART
        push    si
        movw    si,#(SIO_int-CodebaseQQ)
        jmpsh	ENTRY
;
	page
;-----------------------------------------------------------------------------;
;   System Interrupt Handler                                                  ;
;-----------------------------------------------------------------------------;
        

ENTRY   push    AX              ;Save all necessary registers.
        push	BX
	push	CX
	
	mov	ax,#bits(databaseqq,4,16)	;get bios data/stack seg
	mov	bx,ss				;check if same
	cmp	ax,bx
	je	P_Same_SS			;yes - go handle

	mov	cx,sp				;get current sp
	mov	ss,ax				;set up ss
	mov	sp,#(stkbaseqq-databaseqq)	;and sp

	push	bx				;save old ss
	push	cx				;old sp

	call	P_call_drvr

	pop	ax				;old sp
	pop	ss				;old ss
	mov	sp,ax
P_exit
	pop	cx
	pop	bx
	pop	ax
	pop	si
	iret

P_same_SS
	call	P_call_drvr
	jmpsh	P_exit

P_call_drvr
	push    DX
        push    DI
        push    BP
        push    DS
        push    ES
        
	mov	ds,ax			;set up ds
        mov	es,ax			;and es
        
	sti

        call    si			;call BIOS Device Driver.

        cli

        mov     al,#20h			;EOI
        out     #PIC_IW0,al		;to PIC
        				;Restore registers.
        pop     ES
        pop     DS
        pop     BP
        pop     DI
        pop     DX
	ret

	page

INT_238				;Send EOI to PIC
IOP1_intv			;Dummy interrupts not handled by BIOS
IOP2_intv
EXPNDA_intv
EXPNDB_intv
NDP_intv
FDC_intv	                ;FDC interrupt
        push    ax
        mov     al,#20h         ;EOI
        out     #PIC_IW0,al     ;to PIC
        pop     ax
        iret
;
;-----------------------------------------------------------------------------;
;   Sub-System Interrupt Handler                                              ;
;-----------------------------------------------------------------------------;

        
INT_41                          ;int 29H - screen output
INT_241				;int F1H - screen output
	push    DX              ;Save all necessary registers.
        push	BX
	push	CX
	
	mov	dx,#bits(databaseqq,4,16)	;get bios data/stack seg
	mov	bx,ss				;check if same
	cmp	dx,bx
	je	S_Same_SS				;yes - go handle

	mov	cx,sp				;get current sp
	mov	ss,dx				;set up ss
	mov	sp,#(stkbaseqq-databaseqq)	;and sp

	push	bx				;save old ss
	push	cx				;old sp

	call	S_call_drvr

	pop	dx				;old sp
	pop	ss				;old ss
	mov	sp,dx
S_exit
	pop	cx
	pop	bx
	pop	dx
	iret

S_same_SS
	call	S_call_drvr
	jmpsh	S_exit

S_call_drvr
	push    AX
        push    DI
	push	SI
        push    BP
        push    DS
        push    ES
        
	mov	ds,dx			;set up ds
        mov	es,dx			;and es
        
	sti

        call    SCREEN_OUT		;call BIOS Screen Driver.

        cli
        				;Restore registers.
        pop     ES
        pop     DS
        pop     BP
	pop	SI
        pop     DI
        pop     AX
	ret

	page

;------------------------------------------------------------------------------
;
;       Int_252 - Control call 600H/Int FCH handling
;
INT_252                         ;int FCH - Control Device Output
	push    DI              ;Save all necessary registers.
        push	BP
	
	mov	ax,#bits(databaseqq,4,16)	;get bios data/stack seg
	mov	di,ss				;check if same
	cmp	di,ax
	je	C_Same_SS			;yes - go handle

	mov	bp,sp				;get current sp
	mov	ss,ax				;set up ss
	mov	sp,#(stkbaseqq-databaseqq)	;and sp

	push	di				;save old ss
	push	bp				;old sp

	call	C_call_drvr

	pop	di				;old sp
	pop	ss				;old ss
	mov	sp,di
C_exit
	pop	BP
	pop	DI
	iret

C_same_SS
	call	C_call_drvr
	jmpsh	C_exit

C_call_drvr
	push    BX
	push	CX
	push	DX
	push	SI
        push    DS
        push    ES
        
	mov	ds,ax			;set up ds
        mov	es,ax			;and es
        
	sti

        call    BIOS_CONTROL		;call BIOS Screen Driver.

        cli
        				;Restore registers.
        pop     ES
        pop     DS
	pop	SI
        pop     DX
	pop	CX
	pop	BX
	ret

;
;----------------------------------------------------------------------------
; BIOS_control - enter with :   BX = device
;                               CX = command
;                               DX = data
;				or DX:SI = pointer
;                exit with status in AX.
;
        GLOBAL  SCR_Config, KBD_config, CLK_Config
        GLOBAL  AUX_config, PRN_config, sound_config
        GLOBAL  FDC_config, WINI_Config, LCD_config, Cache_ctrl
;
; All of the above are called with data in the following form:
;       CX= Command
;	DX = data
;	or DX:SI = pointer
;	AX = returned status
;
BIOS_control
        movw    ax,#0FFFFh              ;preload fail
        subw    bx,#31h                 ;adjust device number to zero base
        cmpw    bx,#0011h		;valid request
        ja      BIOS_con_x              ;no - quit with error
        shlw    bx,#1                   ;adjust to word index
        call    [cs:BIOS_CTAB][bx]      ;call function
BIOS_con_x
BIOS_dummy
        ret                             ;return status in ax
;
Cache_ctrl
	xor	ax,ax			;dummy for the present
        ret				;dummy device
;
BIOS_CTAB
        WORD    SCR_Config-CodebaseQQ           ;0 '1' - screen
        WORD    KBD_config-CodebaseQQ           ;1 '2' - keyboard
        WORD    LCD_Config-CodebaseQQ           ;2 '3' - microscreen
        WORD    AUX_config-CodebaseQQ           ;3 '4' - aux
        WORD    PRN_config-CodebaseQQ           ;4 '5' - printer
        WORD    BIOS_dummy-CodebaseQQ           ;5 '6' - mouse
        WORD    CLK_Config-CodebaseQQ           ;6 '7' - clock
        WORD    Sound_config-CodebaseQQ         ;7 '8' - sound
        WORD    FDC_config-CodebaseQQ           ;8 '9' - disks
	WORD	BIOS_dummy-CodebaseQQ		;9 ':' -dummy
	WORD	BIOS_dummy-CodebaseQQ		;A ';' -dummy
	WORD	BIOS_dummy-CodebaseQQ		;B '<' -dummy
	WORD	BIOS_dummy-CodebaseQQ		;C '=' -dummy
	WORD	BIOS_dummy-CodebaseQQ		;D '>' -dummy
	WORD	BIOS_dummy-CodebaseQQ		;E '?' -dummy
	WORD	WINI_Config-CodebaseQQ		;F '@' - Winchester
	WORD	BIOS_dummy-CodebaseQQ		;10 'A' - Modem Board
	WORD	Cache_ctrl-CodebaseQQ		;11 'B' - cache/graphics/IBM


        
;--------------------------------------------------------------------------
;
;       Int_249 - dummy INT F9H handler - returns AX=0FFFFH
;       Int_250 - dummy INT FAH handler - returns AX=0FFFFH
;       Int_251 - dummy INT FBH handler - returns AX=0FFFFH
;       Int_253 - dummy INT FDH handler - returns AX=0FFFFH
;       Int_254 - dummy INT FEH handler - returns AX=0FFFFH;
;
INT_249                         ;int F9H - keyboard dummy int
INT_250                         ;int FAH - mouse dummy int
INT_251                         ;int FBH - mouse dummy int 2
INT_253                         ;int FDH - spooler dummy routine
INT_254                         ;int FEH - exec dummy routine
        movw    AX,#0FFFFH
        iret
;
;
;---------------------------------------------------------------------------
; calls 600H handler - does int FCH
;---------------------------------------------------------------------------
;
Control_entry
        ; Call from BASIC.
        ; Stack is:
        ;                         | device.off  |   10
        ;                         | command.off |   8
        ;                         | data.off    |   6
        ;                         | result.off  |   4
        ;                         | return.seg  |   2
        ;                 (SP)--> | return.off  |   0
        ;                         +-------------+
        ;
        ; The offsets all point to BASIC word variables relative to the DS
        ; register.
        push    AX
        push    BX
        push    CX
        push    DX
        push    BP
	push	SI
        
        movw    bp,sp         ; SS:BP is top of stack
        movw    bx,16[bp]     ; DS:BX --> Pointer offset
        movw    si,[bx]       ; offset in SI
        movw    bx,18[bp]     ; DS:BX --> data or pointer seg
        movw    dx,[bx]       ; data in DX
        movw    bx,20[bp]     ; DS:BX --> command
        movw    cx,[bx]       ; command in CX
        movw    bx,22[bp]     ; DS:BX --> device
        movw    bx,[bx]       ; device in BX
        
        int     #0FCh         ; Call BIOS, BIOS preserves DS,ES,SS,DI,SI,BP.
                              ; Result returned in AX.
        movw    bx,16[bp]     ; DS:BX --> result
        movw    [bx],ax       ; result:=AX
        
	pop	SI
        pop     BP
        pop     DX
        pop     CX
        pop     BX
        pop     AX
        rets    #8            ; return to BASIC.

	page
;
;-----------------------------------------------------------------------
; BI_Init_Vect - sets up interrupt vector table in low RAM
;       and installs JMPS code at 600h for control calls
;       Called by BIOS.ASM with interrupts disabled
;
BI_Init_Vect
        cld                             ; fill all with default
        movw    bx,#Int_Unexpected-CodebaseQQ
        movw    cx,#256                 ; 256 vectors to set up
        xorw    ax,ax                   ; ax = 0
        movw    di,ax                   ; di = 0
        push    es
        movw    es,ax                   ; es = 0
BI_init_V1
        movw    ax,bx                   ; offset
        stow                            ; to ES:DI
        movw    ax,cs                   ; segment (this one)
        stow                            ; to ES:DI
        loop    BI_init_V1
        movw    cx,#256                 ; max of 256 ints to set up
        movw    si,#BI_intvtab-DatabaseQQ
        lodw                            ; get first address
BI_init_V2
        movw    di,ax                   ; put address in di
        movw                            ; copy offset (DS:SI -> ES:DI)
        movw                            ; copy segment
        lodw                            ; get next address
        andw    ax,ax                   ; check for end
        loopnz  BI_init_V2              ; do all in table
        
        movw    bx,#0600H               ; point at 600H
        movb    es:[bx],#0EAH           ;'jmps' opcode
        movw    es:1[bx],#Control_entry-CodebaseQQ ;control device offset
        movw    es:3[bx],#bits(CodebaseQQ,4,16)    ;control device segment
        
        pop     es
        ret

	page
;--------------------------------------------------------------------------
;	INT 244	- External Interrupt setup
;		On Entry	AL = 0 Set External Interrupt 2 (wini)
;				AL = 1 Set external Interrupt 3 (general)
;				BX = New Vector Offset
;				CX = New Vector Segment
;		On exit		BX = Old Vector Offset
;				CX = Old Vector Segment
;
Int_244		push	di		;save working registers
		push	es
		xor	di,di
		mov	es,di		;set es to zero
		mov	di,#(52h*4)	;set up for Ext 2 ( wini )
		cmp	al,#0		;asked for?
		jz	Int_244_1	;yes - skip
		mov	di,#(53h*4)	;no - set up Ext 3 ( general)
Int_244_1	xchg	es:[di],bx	;set up offset
		inc	di
		inc	di
		xchg	es:[di],cx	;and segment
		mov	ah,#11111011b	;mask for Ext 2 interrupt
		cmp	al,#0		;asking for the other one?
		jz	Int_244_2	;no - skip
		mov	ah,#11110111b	;mask for Ext 3 interrupt
Int_244_2	in	al,#PIC_IMR	;get current IMR
		and	al,ah		;clear mask bit
		out	#PIC_IMR,al	;and set up
		pop	es
		pop	di
		iret
;
	page
;
        Section INTERRUPT.CONST,align(2),class=CONSTQQ
;
; BI_intvtab - interrupt vector table
; Format:-  WORD - page zero address of vector (vector number * 4)
;           WORD - vector offset
;           WORD - vector segment
;           (repeat)
;           WORD - 0000h - table terminator
; NOTE: If interrupt zero is to be set up, this MUST be the first
;       entry in the table.
;
BI_intvtab

        word    41*4                    ;int 41 address
        word    Int_41-CodebaseQQ       ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    80*4                    ;int 80 address
        word    IOP1_intv-CodebaseQQ    ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    81*4                    ;int 81 address
        word    IOP2_intv-CodebaseQQ    ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    82*4                    ;int 82 address
        word    EXPNDA_intv-CodebaseQQ  ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    83*4                    ;int 83 address
        word    EXPNDB_intv-CodebaseQQ  ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    84*4                    ;int 84 address
        word    FDC_intv-CodebaseQQ     ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    85*4                    ;int 85 address
        word    SIO_intv-CodebaseQQ     ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    86*4                    ;int 86 address
        word    PIT_intv-CodebaseQQ     ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    87*4                    ;int 87 address
        word    NDP_intv-CodebaseQQ     ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
	word	229*4			;int 229 address
	word	Int_229-Codebaseqq	;offset
	word	bits(codebaseqq,4,16)	;segment
	WORD	238*4			;int 238 address
	WORD	INT_238-CODEBASEQQ	;offset
	WORD	BITS(CODEBASEQQ,4,16)	;segment
        word    241*4                   ;int 241 address
        word    Int_241-CodebaseQQ      ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
	WORD	244*4			;int 244 address
	WORD	INT_244-CODEBASEQQ	;offset
	WORD	BITS(CODEBASEQQ,4,16)	;segment
        word    249*4                   ;int 249 address
        word    Int_249-CodebaseQQ      ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    250*4                   ;int 250 address
        word    Int_250-CodebaseQQ      ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    251*4                   ;int 251 address
        word    Int_251-CodebaseQQ      ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    252*4                   ;int 252 address
        word    Int_252-CodebaseQQ      ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    253*4                   ;int 253 address
        word    Int_253-CodebaseQQ      ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    254*4                   ;int 254 address
        word    Int_254-CodebaseQQ      ; offset
        word    bits(CodebaseQQ,4,16)   ; segment
        word    0                       ; end of table
;
        end


$ 