
	PAGE 62,132
;**********************************************************
;*
;*	INTERNATIONAL KEYBOARD DEMONSTRATION
;*
;*	MS-DOS V2.0 DEVICE DRIVER
;*
;*	DATE:		10 JUNE 84
;*
;*
;*
;**********************************************************

FALSE		EQU 0
TRUE		EQU NOT FALSE

;**********************************************************
PAGE
;**********************************************************

KEY_D		SEGMENT PUBLIC 'DATA'

SAVESS			DW	0000H		;SAVE AREA FOR CALLING SS
SAVESP			DW	0000H		;SAVE AREA FOR CALLING SP

WRITE_INHIBIT		DB	0		;WRITE INHIBIT FLAG

KEY_D		ENDS

;**********************************************************
PAGE
;**********************************************************

KEY_C		SEGMENT PUBLIC 'CODE'

KEY_DRV		PROC	FAR

ASSUME CS:KEY_C,DS:NOTHING,SS:NOTHING,ES:NOTHING

	ORG 0000H		;DRIVER MAY BE LOADED ANYWHERE
				;WITHOUT PSP

;**********************************************************
;*	MS-DOS 2.00 DRIVER HEADER

DRV_HEAD	DW	-1,-1		;PTR TO NEXT DEV
		DW	8000H		;CHARACTER DEVICE
		DW	KEY_STRATEGY	;STRATEGY ENTRY
		DW	KEY_INT		;INTERRUPT ENTRY
		DB	"INTKEY  "	;DEVICE NAME

PAGE
;**********************************************************
;* STRATEGY ENTRY - IN MS-DOS V2.0 MERELY SAVES POINTER

KEY_STRATEGY:	MOV CS:[PTRSAV],BX
		MOV CS:[PTRSAV+2],ES
		RET

;**********************************************************

PTRSAV		DD	00000000H	;POINTER TO DRS

;**********************************************************
PAGE
;**********************************************************

ASSUME CS:KEY_C,DS:KEY_D,SS:KEY_L,ES:NOTHING

;**********************************************************
;* INTERRUPT ENTRY (I.E. MS-DOS CALL TO 'INTERRUPT' CODE)
;* POINTER SAVED WHEN STRATEGY CALLED POINTS TO THE FOLLOWING
;* REQUEST HEADER.
;*
;*	LENGTH (BYTE)		LENGTH OF HEADER
;*	UNIT CODE (BYTE)	SUB-UNIT NUMBER (BLOCK DEVICE ONLY)
;*	COMMAND (BYTE)
;*	STATUS (WORD)
;*	RESERVED (8 BYTES)
;*	DATA (DEFINED BY COMMAND)

;**********************************************************
;* HEADER OFFSET EQUATES

RQ_HDR_LEN	EQU	0
RQ_HDR_UNIT	EQU	1
RQ_HDR_CMD	EQU	2
RQ_HDR_STAT	EQU	3

RQ_DATA		EQU	13

;**********************************************************
;* FORMAT OF REQUEST HEADER STATUS WORD

ERR		EQU 1000000000000000B	;ERROR FLAG
BUSY		EQU 0000001000000000B	;BUSY FLAG
DONE		EQU 0000000100000000B	;DONE FLAG

UNKNOWN		EQU 	3		;UNKNOWN COMMAND

;**********************************************************
;* DISPATCH TABLE FOR FUNCTION CALLS

MAXFUN		EQU	12

KEY_TBL		DW	KEY_INITIAL	;INITIALISE
		DW	KEY_BAD_CMD	;NOT VALID
		DW	KEY_BAD_CMD	;NOT VALID
		DW	KEY_BAD_CMD	;IOCTL NOT IMPLEMENTED
		DW	KEY_BAD_CMD	;INPUT
		DW	KEY_BAD_CMD	;NON DESTRUCTIVE READ
		DW	KEY_BAD_CMD	;INPUT STATUS
		DW	KEY_BAD_CMD	;FLUSH INPUT BUFFER
		DW	KEY_BAD_CMD	;OUTPUT
		DW	KEY_BAD_CMD	;NO VERIFY POSSIBLE
		DW	KEY_BAD_CMD	;OUTPUT STATUS
		DW	KEY_BAD_CMD	;FLUSH OUTPUT BUFFER
		DW	KEY_BAD_CMD	;IOCTL NOT IMPLEMENTED

;**********************************************************

KEY_INT:	PUSH AX			;SAVE ALL REGS ON MS-DOS STACK
		PUSH BX
		PUSH CX
		PUSH DX
		PUSH BP
		PUSH SI
		PUSH DI
		PUSH DS
		PUSH ES

		PUSHF
		PUSHF			;DISABLE INTS DURING STACK SWITCH
		CLI
		POP BX			;FLAGS NOW IN BX

		MOV AX,KEY_D
		MOV DS,AX

		MOV [SAVESS],SS		;SAVE STACK SEGMENT
		MOV [SAVESP],SP
		MOV AX,KEY_L
		MOV SS,AX			;NEW STACK SEGMENT
		MOV SP,OFFSET KEY_STACKTOP	;NEW SP
		PUSH BX				;RESTORE FLAGS
		POPF

;**********************************************************
;*	NOW GET FUNCTION REQUESTED AND DISPATCH

		LES BX,CS:[PTRSAV]		;POINT TO PACKET
    		MOV AL,ES:[BX.RQ_HDR_CMD]	;GET COMMAND
		XOR AH,AH
		CMP AL,MAXFUN			;IS IT IN RANGE ?
		JA KEY_BAD_CMD

		SHL AX,1			;WORD OFFSET
		ADD AX,OFFSET KEY_TBL		;ADDRESS OF ROUTINE
		XCHG AX,SI
		JMP CS:WORD PTR [SI]		;DISPATCH

;**********************************************************
;*	COMMON EXIT ROUTINE

KEY_BAD_CMD:
		MOV AX,ERR+UNKNOWN+DONE
		JMP KEY_EX

KEY_EXIT:
		MOV AX,DONE

KEY_EX:
		LES BX,CS:[PTRSAV]
		MOV ES:[BX.RQ_HDR_STAT],AX

		CLI			;NO INTS DURING STACK SWITCH
		MOV SS,[SAVESS]		;RESTORE STACK SEG
		MOV SP,[SAVESP]		;RESTORE SP
		POPF			;RESTORE INTS IF THEY WERE ON
		POP ES			;RESTORE ALL REGS
		POP DS
		POP DI
		POP SI
		POP BP
		POP DX
		POP CX
		POP BX
		POP AX
		RET			;AND RETURN

;**********************************************************

KEY_DRV		ENDP

PAGE
;**********************************************************
 ;* MS-DOS DEVICE DRIVER INITIALISATION MODULE
;*
;* ENTRY:	ES:BX - REQUEST HEADER POINTER

RQ_DATA_BREAK	EQU 	RQ_DATA + 1

KEY_INITIAL:

; SET UP END OF CODE ADDRESS

		LES BX,CS:[PTRSAV]			;POINTER TO HEADER
		MOV AX,0
		MOV ES:[BX.RQ_DATA_BREAK],AX		;BREAK OFFSET
		MOV ES:[BX.RQ_DATA_BREAK+2],KEY_END	;BREAK SEGMENT

		MOV AH,09
		XOR AL,AL
		MOV DX,OFFSET MESSAGE
		PUSH DS
		MOV CX,CS
		MOV DS,CX
		INT 21H
		POP DS

		CALL KEY_INIT			;INIT INTERCEPT ROUTINE

		JMP KEY_EXIT

MESSAGE		DB 0DH,0AH
		DB 'INTERNATIONAL KEYBOARD DEMO'
		DB 0DH,0AH,'$'

PAGE
;**********************************************************

KEY_OFFSET	EQU	4 * 0F9H
KEY_SEGMENT	EQU	KEY_OFFSET+2

;**********************************************************
;* SET UP INTERCEPT ROUTINE INTERRUPT VECTOR

KEY_INIT:
		PUSH ES
		MOV AX,0
		MOV ES,AX

		MOV WORD PTR ES:[KEY_SEGMENT],CS
		MOV WORD PTR ES:[KEY_OFFSET],OFFSET KEY_INTERCEPT

		POP ES
		RET

;**********************************************************
;* KEY INTERCEPT ROUTINE
;*
;* ENTRY:	AL = BL = KEY CODE
;* EXIT:	BL = TRANSLATED KEY
;*		AX = -1 RETURN KEY TO DOS
;*		   = 0  IGNORE KEY


SPECIAL_FLAG	DB FALSE


KEY_INTERCEPT:
		MOV AX,-1				;SEND KEY TO DOS

		CMP CS:[SPECIAL_FLAG],TRUE
		JNE KEY_NOT_SPECIAL

		MOV CS:[SPECIAL_FLAG],FALSE

		CMP BL,'A'
		JB RETURN_KEY
		CMP BL,'z'
		JA RETURN_KEY
		CMP BL,'Z'
		JBE ADJUST_KEY
		CMP BL,'a'
		JB KEY_NOT_SPECIAL

ADJUST_KEY:
		AND BL,10011111B		;MAKE CONTROL KEY
		JMP RETURN_KEY

KEY_NOT_SPECIAL:
		CMP BL,'?'			;SPECIAL KEY ?
		JNE RETURN_KEY

		MOV AX,0			;DOS TO IGNORE KEY
		MOV CS:[SPECIAL_FLAG],TRUE

RETURN_KEY:
		IRET

;**********************************************************
KEY_C		ENDS

;**********************************************************
PAGE
;**********************************************************

KEY_L		SEGMENT	STACK 'STACK'

KEY_STACK	DW 128 DUP (0000)	;LOCAL STACK
KEY_STACKTOP	EQU	THIS NEAR

KEY_L		ENDS

;**********************************************************
;* NULL SEGMENT LOADED LAST TO GIVE US AN END OF DRIVER POINTER
 
KEY_END	SEGMENT 'END'

END_OF_DRIVER	DW 0

KEY_END		ENDS

;**********************************************************

		END
