

program MS_Pascal_Demo(input,output);

const
	open_cmd	=1;
	close_cmd	=2;
	clear_cmd	=3;

	pline_cmd	=6;
	text_cmd	=8;
	filarea_cmd	=9;
	gdp_cmd		=11;

	text_hgt_cmd	=12;
	
	line_styl_cmd	=15;
	fill_styl_cmd	=23;
	fill_indx_cmd	=24;

	max_cntl_vals	=10;
	max_intin_vals	=80;
	max_intout_vals =45;
	max_pts_vals	=100;

type
	cntrl_array 	= array[1..max_cntl_vals] of integer;
	intin_array	= array[1..max_intin_vals] of integer;
	intout_array	= array[1..max_intout_vals] of integer;
	ptsin_array	= array[1..max_pts_vals] of integer;
	ptsout_array	= array[1..max_pts_vals] of integer;

	i_point = record
		x,y : integer
		end;

	i_rectangle = record
		left,right,bottom,top : integer
		end;

	string		= lstring(200);
var
	contrl	:	cntrl_array;
	intin	:	intin_array;
	intout	:	intout_array;
	ptsin	:	ptsin_array;
	ptsout	:	ptsout_array;
	cur_dev	:	integer;
	ch	:	char;


procedure gsx( ptsout : adsmem;
	       intout : adsmem;
	       ptsin  : adsmem;
	       intin  : adsmem;
	       contrl : adsmem);extern;

procedure set_attrib(cmd,attribute:integer);forward;

procedure draw_text(x,y:integer;s:string);
var
	i:integer;
begin
	contrl[1] := text_cmd;
	contrl[2] := 1;
        contrl[4] := ord(s.len);
	ptsin[1]  := x;
	ptsin[2]  := y;
	for i := 1 to ord(s.len) do
		intin[i] := ord(s[i]);
	gsx(ads ptsout,ads intout,ads ptsin,ads intin,ads contrl);
end;

procedure draw_rect(rect : i_rectangle);
begin
	contrl[1] :=pline_cmd;
	contrl[2] :=5;
	with rect do
		begin
		ptsin[1] := left;
		ptsin[2] := bottom;
		ptsin[3] := right;
		ptsin[4] := bottom;
		ptsin[5] := right;
		ptsin[6] := top;
		ptsin[7] := left;
		ptsin[8] := top;
		ptsin[9] := left;
		ptsin[10]:= bottom;

	end;
	gsx(ads ptsout,ads intout,ads ptsin,ads intin,ads contrl);
end;


procedure bar(rect : i_rectangle );
begin
	contrl[1] :=gdp_cmd;
	contrl[2] :=2;
	contrl[4] :=0;
	contrl[6] :=1;
	with rect do
		begin
		ptsin[1] := left;
		ptsin[2] := bottom;
		ptsin[3] := right;
		ptsin[4] := top;
		end;
	gsx(ads ptsout,ads intout,ads ptsin,ads intin,ads contrl);
end;


procedure draw_bar (lowx,wide : integer);
var
	i_rect : i_rectangle;
	i      : integer;
begin
	for i := 1 to 6 do
	begin
		with i_rect do
		    begin
		    left  := lowx;
		    bottom:= lowx;
		    right := lowx+wide;
		    top   := lowx+wide;
		end;
		set_attrib(fill_indx_cmd,i);
		bar(i_rect);
		lowx := lowx+(wide div 2);
	end;
end;



procedure set_txt_hgt(height : integer);
begin
	contrl[1] := text_hgt_cmd;
	contrl[2] := 1;
	ptsin[1]  := 0;
	ptsin[2]  := height;
	gsx(ads ptsout,ads intout,ads ptsin,ads intin,ads contrl);
end;


procedure draw_line(x1,y1,x2,y2 : integer );

begin
	contrl[1] := pline_cmd;
	contrl[2] := 2;
	ptsin[1] :=  x1;
	ptsin[2] := y1;
	ptsin[3] := x2;
	ptsin[4] := y2;
	gsx(ads ptsout,ads intout,ads ptsin,ads intin,ads contrl);
end;

procedure set_attrib;
begin
	contrl[1] := cmd;
	contrl[2] := 0;
	intin[1]  := attribute;
	gsx(ads ptsout,ads intout,ads ptsin,ads intin,ads contrl);
end;


procedure draw_border;
var
	i_rect : i_rectangle;
begin
	with i_rect do
		begin
		left	:=0;
		bottom	:=0;
		right	:=32767;
		top	:=32767;
		end;
	draw_rect(i_rect);
end;


procedure exit_gsx;
begin
	contrl[1] := close_cmd;
	contrl[2] := 0;
	gsx(ads ptsout,ads intout,ads ptsin,ads intin,ads contrl);
end;


procedure clear_it;
begin
	contrl[1] :=clear_cmd;
	contrl[2] :=0;
	gsx(ads ptsout,ads intout,ads ptsin,ads intin,ads contrl);
end;
 	

procedure open_wk(dev_no : integer);

var
	i : integer;

begin
	contrl[1] := open_cmd;
	contrl[2] := 0;
	contrl[4] := 10;
	intin[1]  := dev_no;
	for i := 2 to 10 do
		intin[i] := 1;
	gsx(ads ptsout,ads intout,ads ptsin,ads intin,ads contrl);
end;


procedure init_gsx;
begin
	cur_dev := 1;
	open_wk(cur_dev);
end;


begin
	init_gsx;
	clear_it;
	draw_border;
	set_attrib(line_styl_cmd,3);
	draw_line(0,0,32767,32767);
	set_txt_hgt(1000);
	draw_text(16383,16383,'Pascal-GSX Demo');
	set_attrib(fill_styl_cmd,2);
	draw_bar(1200,1200);
	set_attrib(fill_styl_cmd,3);
	draw_bar(21968,1200);
	readln (ch);
	exit_gsx;
end.

