* Program..: BANKENT1.PRG
* Author...: David Holland
* Date.....: 14 January 1985
* Notice...: Copyright 1985 David Holland. All Rights Reserved
* Version..: Version 1.0 written in dBase II Version 2.4
* Notes....: Program to enter cheques for suite of personal banking programs

* Initialise memory variables
STORE 6 TO linenumber
STORE " " TO selection

* Clear screen and display headings
ERASE
? we:curoff
? we:invon
@ 1,0 SAY "PERSONAL BANK ACCOUNT                                             "
?? "ENTER CHEQUES"
?? we:invoff
@ 4,0 SAY "DATE"
@ 4,15 SAY "CHEQUE NO"
@ 4,26 SAY "NAME"
@ 4,61 SAY "CHEQUE AMT"
@ 5,0 SAY "----"
@ 5,15 SAY "---------"
@ 5,26 SAY "----"
@ 5,61 SAY "----------"

* Get the previous closing bank balance and open BANKTRN file
USE B:BANKBAL
STORE Endbal to currentbal
USE B:BANKTRN INDEX B:BANKTRN
?? we:curon

DO WHILE !(selection) <> "N"

    * Clear screen when full of transactions
    IF linenumber = 18
        STORE 6 TO linenumber
        DO WHILE linenumber <18
            @ linenumber,0
            STORE linenumber + 1 TO linenumber
        ENDDO
        STORE 6 TO linenumber
    ENDIF

    * Enter data
    APPEND BLANK
    @ linenumber,0 GET Date PICTURE "##/##/##"
    @ linenumber,15 GET Chqnumber
    @ linenumber,26 GET Name
    @ linenumber,61 GET Chqamount
    READ
    CLEAR GETS

    * Disregard entry if no date has been entered and display message
    IF VAL(Date) = 0
        @ 20,0 SAY "INVALID DATE - PRESS ANY KEY TO RE-ENTER"
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        @ 20,0
        DELETE
        PACK
        LOOP
    ENDIF

    * Ask if entry is ok - if not kill record and loop
    STORE " " TO selection
    DO WHILE !(selection) <> "Y" .AND. !(selection) <> "N"
        @ 20,0
        ACCEPT "ACCEPT THIS ENTRY ? (y/n) " TO selection
    ENDDO
    IF !(selection) = "N"
        DELETE
        PACK
        @ 22,0
        STORE " " to selection
        LOOP
    ENDIF

    * Deduct value of cheque from bank balance and increment line number
    STORE currentbal - Chqamount TO currentbal
    STORE linenumber + 1 TO linenumber

    * Ask if another entry required and clear question from screen
    STORE " " TO selection
    DO WHILE !(selection) <> "Y" .AND. !(selection) <> "N"
        @ 20,0
        ACCEPT "ENTER ANOTHER CHEQUE ? (y/n) " to selection
    ENDDO
    @ 22,0

ENDDO

* Store bank balance back to BANKBAL file
USE B:BANKBAL
REPLACE Endbal WITH currentbal

* Clear screen, release memory variables and return to calling file
USE
RELEASE currentbal, linenumber
ERASE
RETURN

* EOF: BANKENT1.PRG
