* Program..: BANKMEM.PRG
* Author...: David Holland
* Date.....: 4 January 1985
* Notice...: Copyright 1985 David Holland. All Rights Reserved
* Version..: Version 1.0 written in dBase II Version 2.4
* Notes....: For holding screen and printer display variables

* Clear screen and display explanatory text
ERASE
@ 3,0 SAY "UTILITY FUNCTIONS"
@ 4,0 SAY "-----------------"
@ 6,0 SAY "Use this facility to enter information about the size of paper"
@ 7,0 SAY "which is being used in your printer and the control codes which"
@ 8,0 SAY "enable certain features of the video display used by your computer."
@ 10,0 SAY "This information will be automatically requested the first time"
@ 11,0 SAY "you run your program.  At all other times it may be requested"
@ 12,0 SAY "from the main menu."
@ 14,0 SAY "Press any key to continue"

* Wait for key to be pressed
SET CONSOLE OFF
WAIT
SET CONSOLE ON

* Clear and display next screen
ERASE
@ 1,0 SAY "UTILITY FUNCTIONS"
@ 2,0 SAY "-----------------"
@ 4,0 SAY "Enter page depth of paper in lines"

* Check for existence of variables file
IF FILE ("B:BANKMEM.MEM")
    RESTORE FROM b:bankmem
ELSE
    STORE "  " TO we:pagline
ENDIF 1

* Input page depth setting
STORE " " TO continue
DO WHILE !(continue) <> "Y"
    @ 10,0
    @ 6,0 SAY "Current setting is"
    @ 6,19 GET we:pagline PICTURE "##"
    READ
    CLEAR GETS
    IF we:pagline = "  "
        LOOP
    ENDIF 1
    @ 8,0
    ACCEPT "Is this correct ? (y/n) " TO continue
ENDDO

* Save variables to file and return to calling file if no more entries
* are required
@ 12,0
ACCEPT "Do you wish to define screen control codes ? (y/n) " to continue
IF !(continue) = "N"
    SAVE ALL LIKE we:* TO B:BANKMEM
    ERASE
    RETURN
ENDIF 1

* Display explanatory text
ERASE
@ 1,0 SAY "UTILITY FUNCTIONS"
@ 2,0 SAY "-----------------"
@ 4,0 SAY "Use this screen to enter information about the control codes"
@ 5,0 SAY "which determine certain aspects of the display on your VDU"
@ 7,0 SAY "This information should be contained in the instruction manual"
@ 8,0 SAY "which came with your computer.  If you have any problems then"
@ 9,0 SAY "contact your dealer."
@ 11,0 SAY "Press any key to continue"

* Wait for key to be pressed
SET CONSOLE OFF
WAIT
SET CONSOLE ON

* Erase screen, delete previous screen control codes and input new ones
STORE " " to continue
DO WHILE !(continue) <> "Y"
    ERASE
    RELEASE ALL LIKE we:i*
    RELEASE ALL LIKE we:c*
    @ 1,0 SAY "UTILITY FUNCTIONS"
    @ 2,0 SAY "-----------------"
    INPUT "Enter control code to set INVERSE VIDEO ON " to we:invon
    ?
    INPUT "Enter control code to set INVERSE VIDEO OFF " to we:invoff
    ?
    INPUT "Enter control code to set CURSOR OFF " to we:curoff
    ?
    INPUT "Enter control code to set CURSOR ON " to we:curon
    ?
    ACCEPT "Is this correct ? (y/n) " TO continue
ENDDO

* Save variables to memory file and return to calling file
SAVE ALL LIKE we:* to B:BANKMEM
ERASE
RETURN

* EOF: BANKMEM.PRG
