* Program..: BANKPRT.PRG
* Author...: David Holland
* Date.....: 17 January 1985
* Notice ..: Copyright 1985 David Holland. All Rights Reserved
* Version..: Version 1.0 written in dBase II Version 2.4
* Notes....: Program to print records from suite of personal banking programs

* Initialise memory variables
STORE 0 TO printline
STORE 1 TO flag

* Clear screen and display heading
ERASE
? we:curoff
? we:invon
@ 1,0 SAY "PERSONAL BANK ACCOUNT"
?? "                                             PRINT RECORDS"
?? we:invoff
?? we:curon

* Open BANKTRN file, set pointer to EOF, and display no of records
USE B:BANKTRN
GOTO BOTTOM
@ 5,0 SAY "No of records to print: "
@ 5,24 SAY #
USE

* Enter report date
STORE " " to selection
DO WHILE !(selection) <> "Y"
    @ 9,18
    @ 10,22
    @ 7,0
    ACCEPT "ENTER REPORT DATE " TO reportdate
    ACCEPT "IS THIS CORRECT (y/n) " TO selection
ENDDO

* Display warning message
? we:curoff
? we:invon
@ 12,0 SAY "ENSURE PRINTER IS ON LINE - PRESS ANY KEY TO CONTINUE"
?? we:invoff
SET CONSOLE OFF
WAIT
SET CONSOLE ON

* Open BANKBAL file and get opening bank balance
USE B:BANKBAL
STORE Startbal TO currentbal

* Establish working environment and open BANKTRN file
SET FORMAT TO PRINT
SET EJECT OFF
USE B:BANKTRN INDEX B:BANKTRN

DO WHILE .NOT. EOF

    * Print page heading and increment line number
    IF printline = 0
        @ printline,0 SAY "PERSONAL BANK ACCOUNT    " + reportdate
        @ printline,46 SAY "TRANSACTION LIST"
        STORE 1 TO printline
        @ printline,0 SAY "-------------------------";
        + "-------------------------------------"
        ?
        ?
        ?
        STORE printline + 3 TO printline
  
        * Open BANKBAL file, print balances at start of report, increment
        * line number, set flag not to print balances again and open
        * BANKTRN file      
        IF flag = 1
            USE B:BANKBAL
            @ printline,0 SAY "Opening Bank Balance:"
            @ printline,22 SAY Startbal
            @ printline,47 SAY "Closing Bank Balance:"
            @ printline,69 SAY Endbal
            STORE printline + 2 TO printline
            STORE 2 TO flag
            USE B:BANKTRN INDEX B:BANKTRN
        ENDIF 2
 
        * Print column headings and increment line number
        @ printline,0 SAY "Date"
        @ printline,10 SAY "Ref No"
        @ printline,18 SAY "Details"
        @ printline,50 SAY "Cheque"
        @ printline,59 SAY "Banking"
        @ printline,69 SAY "Balance"
        STORE printline + 1 TO printline
        @ printline,0 SAY "----"
        @ printline,10 SAY "------"
        @ printline,18 SAY "-------"
        @ printline,50 SAY "------"
        @ printline,59 SAY "-------"
        @ printline,69 SAY "-------"
        STORE printline + 1 TO printline
    ENDIF 1

    * Update currentbal variable
    STORE currentbal - Chqamount + Bnkgamount TO currentbal

    * print records
    @ printline,0 SAY Date PICTURE "##/##/##"
    @ printline,10 SAY Chqnumber
    @ printline,18 SAY Name

    * Print either cheque or banking
    IF Chqamount > 0
        @ printline,49 SAY Chqamount
    ELSE
        IF Bnkgamount > 0
            @ printline,59 SAY Bnkgamount
        ENDIF 2
    ENDIF 1

    @ printline,66 SAY currentbal

    * Increment file pointer and line number
    SKIP
    STORE printline + 1 TO printline

    * At bottom of page form feed and loop
    IF printline = val(we:pagline) - 8
        EJECT
        STORE 0 TO printline
        LOOP
    ENDIF

ENDDO

* At EOF clear screen release variables set printer off and
* return to calling file
USE
EJECT
?? we:curon
ERASE
RELEASE printline, currentbal, flag, reportdate
SET FORMAT TO SCREEN
RETURN

* EOF: BANKPRT.PRG