PROGRAM LIFE;
{ Simulation of Conway's game of Life on a bounded grid. }
{ From Data Structures and Program Design by Robert Kruse  Prentice Hall }
{ Typed in by: Malcolm McCorquodale. }
{ Modified by: Jeff Firestone. }
{ Version 1. Page 6. }

(* Checked for Apricot by Dave Langford, Oct 1985. Originally used a
   character in procedure WRITEMAP that didn't work (character 2, perhaps a
   glitch for 42? Have substituted a more interesting one, and also added
   a procedure allowing you to escape gracefully from the program.
                                                                  DRL *)
{$C-}

CONST
     MAXROW = 23;      { max # of rows allowed }
     MAXCOL = 79;      { max # of cols allowed -- reduced from 80 by DRL }
     CursorOff = ^['x5';
     CursorOn  = ^['y5';  {Apricot escape sequences -- DRL}
TYPE
     ROW = 1..MAXROW;
     COL = 1..MAXCOL;
     STATUS = (DEAD,ALIVE);
     GRID = ARRAY[ROW,COL] OF STATUS;
VAR
     MAP, NEWMAP : GRID;
     I : ROW;
     J : COL;
     GENERATION, LASTGENERATION : INTEGER;
     Key: Char; {added by DRL -- see end}
     Healthy: Boolean;

{--------------------------------------------}

PROCEDURE GENERATECOORDINATES;
VAR
     CNT, NUMBERCOORDINATES : INTEGER;
BEGIN
     WRITE ('How many coordinates would you like generated: ');
     READLN (NUMBERCOORDINATES);
     Randomize;                              {And why not? DRL}
     FOR CNT:= 1 TO NUMBERCOORDINATES DO
       MAP[(RANDOM(MAXROW-1)+1), (RANDOM(MAXCOL-1)+1)]:= ALIVE;
END;

{--------------------------------------------}

PROCEDURE INITIALIZE;
VAR
     X,Y : INTEGER;    { COORDINATES OF CELL }
     ANSWER : STRING [10];
BEGIN
     Key:= ' '; {DRL}
     WRITELN ('This program is a simulation of the game of Life.');
     WRITE ('Enter the number of generations to run: ');
     READLN (LASTGENERATION);
     IF LASTGENERATION <= 0 THEN WRITELN ('No output for 0 generations.');
     FOR X := 1 TO MAXROW DO
        FOR Y := 1 TO MAXCOL DO
           MAP[X,Y] := DEAD;
     WRITE ('Do you wish to have the coordinate pairs generated ');
     WRITE ('automatically: ');
     READLN (ANSWER);
     IF UPCASE(ANSWER[1]) = 'Y' THEN
       GENERATECOORDINATES
     ELSE
     BEGIN
       WRITELN ('On each line give a pair of coordinates for a living cell.');
       WRITELN ('Terminate the list by entering a 0 for X and Y');
       READLN (X,Y);

       WHILE X <> 0 DO
       BEGIN
         IF (X>=1) AND (X<=MAXROW) AND (Y>=1) AND (Y<=MAXCOL)
             THEN MAP[X,Y] := ALIVE
             ELSE WRITELN ('Values out of range.');
         READLN (X,Y);
       END;  { WHILE }
     END; { ELSE }
END;

{--------------------------------------------}

PROCEDURE WRITEMAP;
Const
     FULL : String[3] = ^['8'^O;       {Graphics character 15 as literal. DRL}
VAR
     X : ROW;
     Y : COL;
BEGIN
    {FULL:= CHR(2);     Not very useful on the Apricot! DRL}
     CLRSCR;
     WRITELN ('The map at generation ',generation,' is:');
     FOR X := 1 TO MAXROW DO
     BEGIN
        FOR Y := 1 TO MAXCOL DO
           IF MAP[X,Y] = ALIVE THEN BEGIN
                                      GOTOXY(Y,X+2);
                                      WRITE (FULL);
                                    END;
     END;      { Processing row X }
     GOTOXY(1,1);
END;

{--------------------------------------------}

Procedure ConditionalHalt;     {Added by DRL to terminate program}
begin
 If KeyPressed then Read(Kbd,Key);
 If (Key=^[) or Not Healthy then begin
   DelLine;
   If Healthy then Write('LIFE aborted')
    else Write('LIFE stagnant or extinct');
   Write(' at generation ',Generation-1,'.',CursorOn);
   Halt
   end
end;

{--------------------------------------------}

FUNCTION NEIGHBORCOUNT (I:ROW;J:COL):INTEGER;
VAR
     X, XLOW, XHIGH : ROW;
     Y, YLOW, YHIGH : COL;
     COUNT : INTEGER;
BEGIN
     IF I = 1 THEN XLOW := 1
              ELSE XLOW := I - 1;
     IF I = MAXROW THEN XHIGH := 1
                   ELSE XHIGH := I + 1;
     IF J = 1 THEN YLOW := 1
              ELSE YLOW := J - 1;
     IF J = MAXCOL THEN YHIGH := J
                   ELSE YHIGH := J + 1;
     COUNT := 0;
     FOR X := XLOW TO XHIGH DO
        FOR Y := YLOW TO YHIGH DO
           IF MAP[X,Y] = ALIVE THEN COUNT := COUNT + 1;
     IF MAP [I,J] = ALIVE THEN COUNT := COUNT - 1;
     NEIGHBORCOUNT := COUNT;
END;

{--------------------------------------------}

BEGIN
     ClrScr;          {Me again -- DRL}
     INITIALIZE;
     Write(CursorOff);
     GENERATION := 0;
     WRITEMAP;
     FOR GENERATION := 1 TO LASTGENERATION DO
     BEGIN
        FOR I := 1 TO MAXROW DO FOR J := 1 TO MAXCOL DO
           CASE NEIGHBORCOUNT(I,J) OF
              0,1   : NEWMAP[I,J] := DEAD;
              2     : NEWMAP[I,J] := MAP[I,J];
              3     : NEWMAP[I,J] := ALIVE;
              4..8  : NEWMAP[I,J] := DEAD
              END;

        Healthy:= False;                       {Check for "no change"}
        For I:= 1 to MaxRow do For J:= 1 to MaxCol do
         Healthy:= Healthy or (NewMap[I,J] <> Map[I,J]);
        ConditionalHalt;                       {DRL -- see procedure above}

       { FOR I := 1 TO MAXROW DO FOR J := 1 TO MAXCOL DO
           MAP[I,J] := NEWMAP[I,J];       Come off it! DRL }
        Map:= NewMap;                 {That's better.}

        WRITEMAP;


     END      { Processing one generation }
END.
