1 ' Dix-Mille    Version 4.3					(c) Barbara Binless 1984
2 '
3 '	Dix Mille is a dice game, originally for any number of players although only
4 '	5 are allowed in this version - change DIM N$ and LATEST, and alter lines 130
5 '	and 140 for more players.  Lines without line numbers are continuations.
6 '	Graphics characters entered direct from the keyboard appear as:
7 '		     	 	 	 	 	 	 	 	 
8 '		  	 	 	  		 	 
9 '	
10	DIM DIE%(7),DIE$(7,5),TOTAL%(6),N$(5),LATEST(5),ROLL%(6),

	TEST%(6,6),SELECTION%(6,20),BIT%(6)
17 '
18 ' Common initialization block
19 '
20	DEF FNC$(ROW%,COL%)=ESC$+"Y"+CHR$(31+ROW%)+CHR$(31+COL%) : 

	DEF FNRAND(X%)=INT(RND(1)*X%+1)
30	DEF FNCENTRE$(ROW%,T$)=FNC$(ROW%,40-LEN(T$)\2)+T$ : 

	DEF FNUP$(X$)=CHR$(ASC(X$)+32*(ASC(X$)>96))
40	ESC$=CHR$(27) : CLS$=ESC$+"E" : EREOL$=ESC$+"K" : EREOF$=ESC$+"J" : 

	ERBOL$=ESC$+"o" : ERBOF$=ESC$+"b"
50	HION$=ESC$+"(" : HIOFF$=ESC$+")" : REVON$=ESC$+"p" : REVOFF$=ESC$+"q" :

	UNDON$=ESC$+"0" : UNDOFF$=ESC$+"1"
60	CURON$=ESC$+"y5" : CUROFF$=ESC$+"x5" : CURSAV$=ESC$+"j" : 

	CURBAK$=ESC$+"k" : BELL$=CHR$(7)
70	LINON$=CURSAV$+ESC$+"x1"+FNC$(25,1) : LINOFF$=ESC$+"y1"+CURBAK$ : 

	BLINKON$=ESC$+"2" : BLINKOFF$=ESC$+"3"
80	CLRALL$=ESC$+"z" : YES%=-1 : NO%=0 : WIDTH 255
87 '
88 ' Initialize - display rules, set up graphics, randomize
89 '
90	SCREEN$=CLS$+REVON$+FNCENTRE$(1,"  DIX-MILLE  ")+REVOFF$ : PRINT SCREEN$
100	GOSUB 10000 : GOSUB 11000
110	IF TIME=0 THEN COMP%=1 ELSE COMP%=10	'shortens delay routine if not compiled
120	A$=INKEY$ : COUNT=COUNT-(COUNT<32000) : 

	IF A$="" THEN 120 ELSE RANDOMIZE COUNT
130	PRINT SCREEN$ FNC$(10,10) "How many players  (1-5)"; : INPUT NO.PLAYERS%
140	IF NO.PLAYERS%<1 OR NO.PLAYERS%>5 THEN 130 ELSE 

	PRINT FNC$(10,10) "Press return for computer to take this hand"
147 '
148 ' Get names of players - if any name is null the computer will take that turn
149 '
150	FOR J%=1 TO NO.PLAYERS%
160		PRINT FNC$(12+J%,10) "What is player" STR$(J%) "'s name"; : 

		INPUT N$(J%) : IF N$(J%)="" THEN N$(J%)="SIRIUS"
170		FOR K%=1 TO LEN(N$(J%)) : 

			MID$(N$(J%),K%,1)=FNUP$(MID$(N$(J%),K%,1)) : 

		NEXT
180	NEXT : GOSUB 9000
190	WON%=NO% : FINISHED%=NO% : LAST%=NO.PLAYERS% : HIGHEST.SCORE=0
197 '
198 ' Main loop: runs until someone's score>10,000 and rest have had one turn
199 '
200	WHILE NOT WON% OR NOT FINISHED%
210		PRINT SCREEN$ CUROFF$
220		FOR PLAYER%=1 TO NO.PLAYERS%
230	      		IF WON% AND PLAYER%=LAST% THEN FINISHED%=YES% : 

			PLAYER%=NO.PLAYERS% : GOTO 440
240	      		PASSED%=NO% : SCORE=0 : 

			FOR J%=1 TO 6 : DIE%(J%)=1 : NEXT
250	      		BONUS%=0 : GOSUB 8000
260	      		FIRST.GO%=YES% : GOSUB 1000
270	      		FOR J%=1 TO 6 : PRINT FNC$(11,11*J%-1) J% : NEXT
280         		PRINT HION$ FNCENTRE$(4," "+N$(PLAYER%)+"'S TURN ") HIOFF$
290	 		IF N$(PLAYER%)="SIRIUS" THEN GOSUB 20000 : GOTO 400
297 '
298 ' Loop for each player's turn: runs until no score or player passes
299 '
300		        WHILE VALID% AND NOT PASSED% AND NOT TWOS%
310		        	IF WON% THEN PRINT REVON$ FNCENTRE$(17,

				" Score to beat is"+STR$(HIGHEST.SCORE)+" ") REVOFF$;
320		        	GOSUB 2000 : GOSUB 3000  : IF SC=0 THEN OK%=NO%
330				IF NOT OK% THEN GOSUB 6000 : GOTO 320
340				A$="" : IF AGAIN% THEN GOSUB 3600
350				GOSUB 3900 : IF AGAIN% THEN GOSUB 9010 

				ELSE IF A$="" THEN GOSUB 5000
360		        	IF NOT PASSED% 

				THEN GOSUB 7500 : FIRST.GO%=YES% : GOSUB 1000
370		        WEND
380			IF NOT VALID% THEN SCORE=0 : 

			PRINT FNCENTRE$(15,"Hard lines  - no score!") : 

			DELAY=1000 : GOSUB 7000
390			IF TWOS% THEN SCORE=0 : LATEST(PLAYER%)=0 : TWOS%=NO% :

			PRINT FNCENTRE$(15,"That wipes out your score!!") : 

			DELAY=1000 : GOSUB 7000
397 '
398 ' Display player's new score and check if on final knockout
399 '
400			GOSUB 9500
410			IF NOT WON% AND LATEST(PLAYER%)>=10000 THEN WON%=YES% : 

			LAST%=PLAYER%
420		        DELAY=1500 : GOSUB 7000
430			IF WON% THEN IF LATEST(PLAYER%)>HIGHEST.SCORE 

				     THEN HIGHEST.SCORE=LATEST(PLAYER%)
440		NEXT PLAYER%
447 '
448 ' Display score table after each round, and again when game is over
449 '
450		PRINT SCREEN$
460		IF NOT FINISHED% THEN PRINT FNC$(3,1) "Score table so far:-" 

		ELSE PRINT FNC$(3,1) "FINAL SCORE TABLE:-"
470		PRINT FNC$(5,17) "" STRING$(43,"") "": 

		PRINT FNC$(6,17)  " Name" FNC$(6,50) "    Score  " : 

		PRINT FNC$(7,17) "" STRING$(43,"") ""
480		FOR PLAYER%=1 TO NO.PLAYERS%
490		        PRINT FNC$(7+PLAYER%,17) " " N$(PLAYER%) 

			FNC$(7+PLAYER%,49); : PRINT USING " ########,  "; LATEST(PLAYER%)
500		NEXT PLAYER% : PRINT FNC$(8+NO.PLAYERS%,17) "" STRING$(43,"") ""
510		DELAY=2000 : GOSUB 7000
520	WEND	
597 '
598 ' Play again?
599 '
600	PRINT : PRINT "Do you want another game?";
610	A$=FNUP$(INPUT$(1)) : IF A$="Y" THEN GOSUB 9000 : GOTO 130
620	IF A$<>"N" THEN 610
630	PRINT CLS$ CURON$; : END
997 '
998 ' Roll all non-negative dice and display.  Check if scoreable/four 2's
999 '
1000	ROLLED%=0 : FOR J%=1 TO 6
1010		IF DIE%(J%)>0 THEN DIE%(J%)=FNRAND(6) : ROLLED%=ROLLED%+1
1020		GOSUB 4000
1030	NEXT : VALID%=YES%
1035	IF ROLLED%=0 THEN GOSUB 9010 : GOTO 1000
1037 '
1038 ' Count number of dice of each value
1039 '
1040	FOR NUMBER%=1 TO 6 : TOTAL%(NUMBER%)=0
1050		FOR DICE%=1 TO 6
1060			IF DIE%(DICE%)=NUMBER% THEN TOTAL%(NUMBER%)=TOTAL%(NUMBER%)+1
1070		NEXT DICE%
1090	NEXT NUMBER% : IF TOTAL%(2)>3 THEN TWOS%=YES% : RETURN
1100	IF ROLLED%=1 THEN 1200
1107 '
1108 ' Check for 1's or 5's
1109 '
1110	IF TOTAL%(1)>0 THEN RETURN
1120	IF TOTAL%(5)>0 THEN RETURN
1127 '
1128 ' Check for 3 of something
1129 '
1130	FOR NUMBER%=1 TO 6
1140		IF TOTAL%(NUMBER%)>2 THEN RETURN
1150	NEXT NUMBER%: IF ROLLED%<6 THEN VALID%=NO% : RETURN
1157 '
1158 ' Check for straight
1159 '
1160	IF TOTAL%(1)=1 AND TOTAL%(2)=1 AND TOTAL%(3)=1 AND TOTAL%(4)=1 

	AND TOTAL%(4)=1 AND TOTAL%(5)=1 AND TOTAL%(6)=1 THEN RETURN
1167 '
1168 ' Check for three pairs
1169 '
1170	FOR NUMBER%=1 TO 6
1180		IF TOTAL%(NUMBER%) MOD 2<>0 THEN VALID%=NO%
1190	NEXT NUMBER% : RETURN
1197 '
1198 ' Bump bonus if first throw of single die.
1199 '
1200	IF FIRST.GO% THEN BONUS%=BONUS%+1
1210	IF TOTAL%(1)=1 OR TOTAL%(5)=1 THEN VALID%=YES% : RETURN
1217 '
1218 ' Nothing doing, wipe display and reset tests
1219 '
1220	GOSUB 7500
1230	FIRST.GO%=NOT FIRST.GO% : IF NOT FIRST.GO% THEN 1000
1240	VALID%=NO% : RETURN
1997 '
1998 ' select dice to keep
1999 '
2000	PRINT FNCENTRE$(15,"Press numbers of dice to keep then press space") : A$=""
2010	WHILE A$<>" "
2020		A$=INPUT$(1) : IF A$=CHR$(3) THEN PRINT CLS$ : GOTO 600
2030		FOR J%=1 TO 6
2040			IF J%=7-VAL(A$) THEN DIE%(J%)=-DIE%(J%) : GOSUB 4000
2050		NEXT
2060	WEND : PRINT FNC$(15,1) EREOL$ FNC$(16,1) EREOL$
2070	RETURN
2997 '
2998 ' Score dice kept - set OK% and AGAIN% and calculate SCORE
2999 '
3000	KEPT%=0 : OK%=YES% : AGAIN%=NO% : SC=0
3007 '
3008 ' Count number of dice kept of each value
3009 '
3010	FOR NUMBER%=1 TO 6 : TOTAL%(NUMBER%)=0
3020		FOR DICE%=1 TO 6
3030			IF DIE%(DICE%)=-NUMBER% THEN TOTAL%(NUMBER%)=TOTAL%(NUMBER%)+1
3040		NEXT DICE%
3050		KEPT%=KEPT%+TOTAL%(NUMBER%)
3060	NEXT NUMBER%
3070	SCORED%=0 : ON KEPT% GOTO 3080,3080,3120,3190,3190,3500
3077 '
3078 ' One or two dice kept - must be 5's or 1's
3079 '
3080	SC=SC+100*TOTAL%(1)+50*TOTAL%(5) : 

	IF KEPT%=1 AND ROLLED%=1 THEN SC=SC+BONUS%*500
3090	IF SC=0 THEN OK%=NO%
3100	IF TOTAL%(2)>0 OR TOTAL%(3)>0 OR TOTAL%(4)>0 OR TOTAL%(6)>0 THEN OK%=NO%
3110	RETURN
3117 '
3118 ' Three dice kept - must be 5's, 1's or all the same
3119 '
3120	GOSUB 3080 : OK%=YES% : IF TOTAL%(1)=3 THEN SC=1000 : RETURN
3130	IF TOTAL%(5)=3 THEN SC=500 : RETURN
3140	IF TOTAL%(5)+TOTAL%(1)=3 THEN RETURN
3150	THREE%=NO% : FOR NUMBER%=1 TO 6
3160		IF TOTAL%(NUMBER%)=3 THEN SC=NUMBER%*100 : THREE%=YES%
3170	NEXT : IF NOT THREE% THEN OK%=NO%
3180	RETURN
3187 '
3188 ' More than 3 dice kept, could be combination of threes and 1's and 5's
3189 '
3190	ON TOTAL%(1)+1 GOTO 3260,3200,3210,3220,3230,3240',3250		'count 1's
3200	SC=SC+100 : SCORED%=SCORED%+1 : GOTO 3260
3210	SC=SC+200 : SCORED%=SCORED%+2 : GOTO 3260
3220	SC=SC+1000 : SCORED%=SCORED%+3 : GOTO 3260
3230	SC=SC+1100 : SCORED%=SCORED%+4 : GOTO 3260
3240	SC=SC+1200 : SCORED%=SCORED%+5
3257 '
3258 ' Test for three of a kind
3259 '
3260	FOR K%=2 TO 4
3270		IF TOTAL%(K%)=3 THEN SC=SC+K%*100 : SCORED%=SCORED%+3
3280	NEXT : ON TOTAL%(5)+1 GOTO 3350,3290,3300,3310,3320,3330,3340	'count 5's
3290	SC=SC+50 : SCORED%=SCORED%+1 : GOTO 3350
3300	SC=SC+100 : SCORED%=SCORED%+2 : GOTO 3350
3310	SC=SC+500 : SCORED%=SCORED%+3 : GOTO 3350
3320	SC=SC+550 : SCORED%=SCORED%+4 : GOTO 3350
3330	SC=SC+600 : SCORED%=SCORED%+5 : GOTO 3350
3340	SC=SC+1000 : RETURN
3350	IF TOTAL%(6)=3 THEN SC=SC+600 : SCORED%=SCORED%+3
3360	IF SCORED%<>KEPT% THEN OK%=NO%
3370	RETURN
3377 '
3378 ' Six dice kept, test for straight
3379 '
3500	FOR K%=1 TO 6
3510		IF TOTAL%(K%)<>1 THEN 3530
3520	NEXT : AGAIN%=YES% : SC=3000 : RETURN
3527 '
3528 ' Check for all 1's here otherwise wrongly scored as 3 pairs
3529 '
3530	IF TOTAL%(1)=6 THEN SC=2000 : RETURN
3537 '
3538 ' Test for three pairs
3539 '
3540	AGAIN%=YES% : FOR J%=1 TO 6
3550		IF TOTAL%(J%) MOD 2<>0 THEN AGAIN%=NO%
3560	NEXT : IF AGAIN% THEN SC=1500 : RETURN
3567 '
3568 ' Nothing special so treat same as four or five kept
3569 '
3570	GOTO 3190
3597 '
3598 ' Ask/decide how to score six of a kind
3599 '
3600	PROD%=1
3610	FOR J%=1 TO 6
3620		IF TOTAL%(J%)<>0 THEN PROD%=PROD%*TOTAL%(J%) : K%=J%
3630	NEXT
3640	IF PROD%<>6 THEN RETURN
3650	IF N$(PLAYER%)="SIRIUS" THEN 3700
3660	PRINT FNCENTRE$(15,"Is this 3 pairs, roll again (R) or 2 threes, pass (P)")
3670	A$=FNUP$(INPUT$(1)) : IF A$="R" THEN PASSED%=NO% : RETURN
3680	IF A$<>"P" THEN 3670
3690	SC=200*K% : AGAIN%=NO% : PASSED%=YES% : RETURN
3700	NEW.SCORE=LATEST(PLAYER%)+SCORE+200*K%
3710	IF (WON% AND NEW.SCORE>HIGHEST.SCORE) OR NEW.SCORE>10000 THEN 3730
3720	PRINT FNCENTRE$(15,"I will keep three pairs") : PASSED%=NO% : RETURN
3730	PRINT FNCENTRE$(15,"I will keep two threes")
3740	PASSED%=YES% : AGAIN%=NO% : SC=200*K% : RETURN
3897 '
3898 ' Remove kept dice from roll
3899 '
3900	FOR J%=1 TO 6 : IF DIE%(J%)<0 THEN DIE%(J%)=0
3910	NEXT : SCORE=SCORE+SC
3920	IF AGAIN% THEN GOSUB 9010
3930	PRINT FNC$(13,10) "Score this turn:"; : PRINT USING "#######,";SCORE
3940	IF LATEST(PLAYER%)>0 THEN PRINT FNC$(13,45) "Previous total:"; : 

	PRINT USING "#######,";LATEST(PLAYER%)
3997 '
3998 ' Display dice J% on bottom (keep) or top (roll again) row
3999 '
4000	IF DIE%(J%)<0 THEN ROW2%=5 : ROW1%=18 

	ELSE IF DIE%(J%)>0 THEN ROW2%=18 : ROW1%=5 ELSE ROW2%=0 : ROW1%=0
4010	FOR K%=1 TO 5
4020		IF ROW1%<>0 THEN PRINT FNC$(ROW1%+K%,73-11*J%) 

		DIE$(ABS(DIE%(J%)),K%)
4030		IF ROW2%<>0 THEN PRINT FNC$(ROW2%+K%,73-11*J%) DIE$(0,K%)
4040	NEXT
4050	RETURN
4997 '
4998 ' roll or pass option
4999 '
5000	PRINT FNCENTRE$(15,"Do you wish to roll again (R) or pass (P)?")
5010	A$=FNUP$(INPUT$(1)) : IF A$="P" THEN PASSED%=YES%  : RETURN
5020	IF A$=CHR$(3) THEN PRINT CLS$ : GOTO 600 

	ELSE IF A$<>"R" THEN 5010
5030	RETURN
5997 '
5998 ' subroutine to restore wrongly kept dice
5999 '
6000	PRINT FNCENTRE$(15,"That's not a scoring combination.")
6010	DELAY=800 : GOSUB 7000 : PRINT FNC$(15,15) EREOL$
6020	FOR J%=1 TO 6
6030		IF DIE%(J%)<0 THEN DIE%(J%)=-DIE%(J%) : GOSUB 4000
6040	NEXT : OK%=YES% : RETURN 
6997 '
6998 ' variable delay routine
6999 '
7000	FOR COUNT=1 TO DELAY/COMP%
7010		A$=INKEY$
7020		IF A$=CHR$(27) THEN COUNT=DELAY
7030	NEXT : RETURN
7497 '
7498 ' wipe top dice
7499 '
7500	PRINT FNC$(15,10) EREOL$ : DELAY=500 : GOSUB 7000
7510	FOR I=5 TO 9
7520		PRINT FNC$(I+1,1) EREOL$
7530	NEXT : RETURN
7997 '
7998 ' Clear screen and print box to keep dice in
7999 '
8000	PRINT SCREEN$ FNC$(18,3) "" STRING$(70,"") ""
8010	FOR I=1 TO 5 : PRINT FNC$(18+I,3) "" STRING$(70,32) ""
8020	NEXT : PRINT FNC$(24,3) "" STRING$(70,"") ""; : RETURN
8997 '
8998 ' Re-initialize arrays
8999 '
9000	FOR PLAYER%=1 TO NO.PLAYERS% : LATEST(PLAYER%)=0 : NEXT
9010	FOR J%=1 TO 6 : DIE%(J%)=7 : NEXT
9020	RETURN
9497 '
9498 ' Display latest scores
9499 '
9500	PRINT FNC$(13,10) EREOL$ "" STRING$(24,"") "" 

	FNC$(13,42) "" STRING$(24,"") ""
9510	PRINT FNC$(14,10) EREOL$ " Score this turn"; : 

	PRINT USING "######, "; SCORE
9520	PRINT FNC$(14,42) " New total score"; : 

	PRINT USING "######, "; SCORE+LATEST(PLAYER%)
9530	PRINT FNC$(15,10) EREOL$ "" STRING$(24,"") "" 

	FNC$(15,42) "" STRING$(24,"") "" : 

	LATEST(PLAYER%)=SCORE+LATEST(PLAYER%)
9540	RETURN
9997 '
9998 ' Rules
9999 '
10000	PRINT FNC$(4,1) "Dix-Mille is a dice game for up to 5 players, in which six dice are thrown"
10010	PRINT "and scoring combinations are put aside in the box at the bottom of the screen."
10020	PRINT "The dice remaining may be re-thrown, or the player can pass the dice and his"
10030   PRINT "score for that turn is added to his total for the game so far.  If a player"
10040   PRINT "fails to throw any scoring dice his score for that turn is lost." : PRINT
10050   PRINT "When a player is left with only one die to throw he is allowed two throws in"   
10060   PRINT "which to score.  If he is successful a bonus of 500 is added to his score, and" 
10070   PRINT "this bonus increases by 500 for each such throw in the same turn."              
10080	PRINT : PRINT "Once any player has scored 10,000 or more points, the remaining players are"
10090	PRINT "each allowed one further turn in order to beat that score."
10100	PRINT "The winner is the player with the most points at the end of the final round."
10110   PRINT FNCENTRE$(24,REVON$+"  Press a key when you are ready  "+REVOFF$); : A$=INPUT$(1)
10120   PRINT SCREEN$ : PRINT : PRINT
10130	PRINT "Scoring:	Each 1 scores 100"
10140	PRINT "		Each 5 scores 50"
10150	PRINT "		Three of a kind scores that number x 100"
10160	PRINT "		Three 1's scores 1,000"
10170	PRINT "		Three pairs scores 1,500 and the dice must be re-thrown"
10180	PRINT "		1-2-3-4-5-6 scores 3,000 and the dice must be re-thrown"
10190	PRINT "		Six of a kind may be scored as two sets of three OR as 3 pairs"
10200	PRINT "		Six 1's counts as two sets of three for 2,000"
10210	PRINT : PRINT "Four or more two's loses all the players score for the game so far."
10220   PRINT : PRINT : PRINT "Any number of players up to 5 can take part, when you are asked for the"
10230   PRINT "names of the players, pressing <return> will cause the computer to play"       
10240   PRINT "the current hand." : PRINT
10250   PRINT "To stop the game before the final round press ^C when asked which dice to"
10260   PRINT "keep.  To restore a wrong die to the top row, press the number again."
10270	PRINT "Press 'esc' to wipe messages and score tables immediately if you want to."
10280	PRINT FNCENTRE$(24,REVON$+"  Press a key to start  "+REVOFF$); : RETURN
10997 '
10998 ' Set up graphics arrays
10999 '
11000	FOR J%=0 TO 7 : FOR K%=1 TO 5 : READ DIE$(J%,K%) : NEXT : NEXT
11010	RETURN
19997 '
19998 ' Computer's turn
19999 '
20000	WHILE VALID% AND NOT PASSED% AND NOT TWOS%
20010		IF WON% THEN PRINT REVON$ FNCENTRE$(17,"  Score to beat is"+

		STR$(HIGHEST.SCORE)+"  ") REVOFF$;
20020		GOSUB 22000 : IF AGAIN% THEN GOSUB 3600 : DELAY=1000 : GOSUB 7000
20030		GOSUB 3900 : IF AGAIN% THEN GOSUB 9010 ELSE GOSUB 23000
20040		IF PASSED% THEN PRINT FNCENTRE$(15,"  I will pass the dice  ") :

		DELAY=1000 : GOSUB 7000
20050		IF NOT PASSED% THEN GOSUB 7500 : FIRST.GO%=YES% : GOSUB 1000
20060	WEND : IF NOT VALID% THEN SCORE=0 : 

	PRINT FNCENTRE$(15,"No score this time!") : DELAY=1000 : GOSUB 7000
20070	IF TWOS% THEN SCORE=0 : LATEST(PLAYER%)=0 : TWOS%=NO% : 

	PRINT FNCENTRE$(15,"That wipes out my score!!") : DELAY=1000 : GOSUB 7000
20080	RETURN
21997 '
21998 ' Computer selection of dice to keep
21999 '
22000	ROLL%=0 : MUST.ROLL%=NO% : PRINT FNC$(15,3) "Thinking ..";
22007 '
22008 ' Collect dice actually rolled for testing
22009 '
22010	PRINT ".."; : FOR DIE%=1 TO 6
22020		IF DIE%(DIE%)<>0 THEN ROLL%=ROLL%+1 : ROLL%(ROLL%)=DIE%
22030	NEXT
22037 '
22038 ' Test all dice rolled for possible score
22039 '
22040	PRINT ".."; : FOR DICE%=1 TO ROLL%
22050		DIE%(ROLL%(DICE%))=-DIE%(ROLL%(DICE%))
22060	NEXT : LEFT%=0
22070	GOSUB 3000 : IF OK% AND SC>0 THEN 22300
22077 '
22078 ' Keep all 1's and 5's but not others
22079 '
22080	PRINT ".."; : FOR DIE%=1 TO ROLL%
22090		IF DIE%(ROLL%(DIE%))<>-5 AND DIE%(ROLL%(DIE%))<>-1

		THEN DIE%(ROLL%(DIE%))=ABS(DIE%(ROLL%(DIE%))) : LEFT%=LEFT%+1
22100	NEXT
22107 '
22108 ' Keep any sets of three remaining
22109 '
22110	PRINT ".."; : FOR TEST%=1 TO 6
22120		IF TEST%<>1 AND TEST%<>5 AND TOTAL%(TEST%)>2 THEN GOSUB 22500
22130	NEXT
22200	GOSUB 3000 : IF SCORE+SC>700 OR LEFT%<>2 THEN 22300
22207 '
22208 ' Keep a 5 if possible if only two dice left
22209 '
22210	IF ROLL%=3 THEN 22300
22220	IF TOTAL%(5)=0 OR TOTAL%(5)=3 THEN 22300
22230	PRINT ".."; : FOR DIE%=1 TO ROLL%
22240		IF DIE%(ROLL%(DIE%))=-5 THEN DIE%(ROLL%(DIE%))=5 : DIE%=ROLL%
22250	NEXT : GOSUB 3000 : MUST.ROLL%=YES%
22297 '
22298 ' Display dice kept
22299 '
22300	FOR J%=1 TO 6 : GOSUB 4000 : NEXT
22310	PRINT FNC$(15,1) EREOL$ : RETURN
22497 '
22498 ' Keep set of TEST%'s
22499 '
22500	FLIPPED%=0 : DIE%=1
22510	WHILE FLIPPED%<3 AND DIE%<=ROLL%
22520		IF DIE%(ROLL%(DIE%))=TEST%

		THEN DIE%(ROLL%(DIE%))=-TEST% : FLIPPED%=FLIPPED%+1
22530		DIE%=DIE%+1
22540	WEND : LEFT%=LEFT%-3 : RETURN
22997 '
22998 ' Computer's decision to roll or pass
22999 '
23000	IF MUST.ROLL% THEN PASSED%=NO% : RETURN

	ELSE NEW.TOTAL=LATEST(PLAYER%)+SCORE : DICE.LEFT%=ROLL%-KEPT%
23007 '
23008 ' Win or bust if on final round
23009 '
23010	IF NOT WON% THEN 23030
23020		IF NEW.TOTAL>HIGHEST.SCORE 

		THEN HIGHEST.SCORE=NEW.TOTAL : PASSED%=YES% : RETURN 

		ELSE PASSED%=NO% : RETURN
23030	IF NEW.TOTAL>10000 THEN PASSED%=YES% : RETURN
23037 '
23038 ' Choose policy depending on number of dice remaining and present score
23039 '
23050	ON DICE.LEFT%+1 GOTO 23100,23200,23300,23400,23500,23600
23100	IF SCORE>3000+FNRAND(200) THEN PASSED%=YES% : RETURN
23110	IF SCORE>2000+FNRAND(500) 

	THEN IF FNRAND(50)<3 THEN PASSED%=YES% : RETURN ELSE PASSED%=NO% : RETURN
23120	PASSED%=NO% : RETURN
23200	IF (SCORE+FNRAND(100))<1125*(BONUS%+1) 

	THEN PASSED%=NO% ELSE PASSED%=YES%
23210	RETURN
23300	IF (SCORE+FNRAND(100))<570*(BONUS%+1) 

	THEN PASSED%=NO% ELSE PASSED%=YES%
23310	RETURN
23400	TEST%=FNRAND(200)
23410	IF SCORE<500+TEST% THEN PASSED%=NO% : RETURN
23420	IF SCORE>1500+TEST% THEN PASSED%=YES% : RETURN
23430	PASSED%=FNRAND(2)-2 : RETURN
23500	TEST%=FNRAND(300)
23510	IF SCORE<1000+TEST% THEN PASSED%=NO% : RETURN
23520	IF SCORE>2000+TEST% THEN PASSED%=YES% : RETURN
23530	PASSED%=FNRAND(2)-2 : RETURN
23600	TEST%=FNRAND(400)
23610	IF SCORE<1500+TEST% THEN PASSED%=NO% : RETURN
23620	IF SCORE>2500+TEST% THEN PASSED%=YES% : RETURN
23630	PASSED%=FNRAND(2)-2 : RETURN
30000	DATA "         ","         ","         ","         ","         "
30010	DATA "","       ","      ","       ",""
30020	DATA "","      ","       ","      ",""
30030	DATA "","      ","      ","      ",""
30040	DATA "","     ","       ","     ",""
30050	DATA "","     ","      ","     ",""
30060	DATA "","     ","     ","     ",""
30070	DATA "         ","         ","         ","         ","         "
","     ","     ","     ",""
30070	DATA "         ","        