10 REM: GRAPHIC1.DEM: L.DOYLE 4/85
20 REM: MSDOS MSBASIC APRICOT XI SCREEN
30 REM: INCORPORATES GSXSUBS.BAS
40 REM: IF YOUR BIOS IS PRIOR TO VERSION 2.7, INTERCHANGE FO = 1 AND FO = 2
50 REM: AND ADD  "G2%(6) = 2"  AFTER  "NEXT Z"  IN LINE 50120
100 REM: CALLING PARAMETERS AND CONSTANTS
110 REM: X1, Y1 = COORDINATES OF FIRST POINT
120 REM: X2, Y2 = COORDINATES OF SECOND POINT
130 REM: XN, YN = COORDINATES OF Nth POINT
140 REM: R = RADIUS OF CIRCLE OR PIE SLICE
150 REM: SA, EA = START ANGLE, END ANGLE OF PIE SLICE IN TENTHS OF DEGREES
160 REM: RA = ROTATION ANGLE OF TEXT IN TENTHS OF DEGREES
170 REM: CH = CHARACTER HEIGHT IN NDC UNITS
180 REM: MT, MH = MARKER TYPE, MARKER HEIGHT IN NDC UNITS
190 REM: FT, FS = FILL TYPE, FILL STYLE
200 REM: FO = FONT: 1 = STROKE FONT SUPPORTING ROTATION AND HEIGHT
210 REM:            2 = BIT IMAGE FONT 
220 REM: N = NUMBER OF POINTS
230 REM: LT, LW = LINE TYPE, LINE WIDTH IN NDC UNITS
240 REM: WM = WRITING MODE: 1 = REPLACE; 2 = TRANSPARENT; 3 = XOR; 4 = ERASE
250 REM: Z IS RESERVED AS A COUNTING VARIABLE IN THESE SUBROUTINES
260 REM: DW, DH = DEVICE WIDTH AND HEIGHT IN NDC UNITS
270 REM: LS, CS = LINE AND CHARACTER SPACING IN NDC UNITS
280 REM: DV = DEVICE NUMBER (KEYBOARD = 1)

300 GOSUB 50000: REM DIMENSION GSX ARRAYS
320 DW = 32767: REM DISPLAY WIDTH IN 'NORMALIZED DEVICE COORDINATES'
330 DH = DW:    REM DISPLAY HEIGHT
340 LS = DH/25: REM LINE SPACE
350 CS = DW/80: REM CHARACTER SPACE
360 PI = 355/113
370 R$ = "                    " + CHR$(27) + "p": REM REVERSE ON
380 O$ = CHR$(27) + "q": REM REVERSE OFF

400 REM: MENU
410 PRINT CHR$(27); "E                 ";
411 PRINT CHR$(27); "0";: REM SET UNDERLINE ON
412 PRINT " DEMONSTRATION OF APRICOT GSX CAPABILITIES ";
413 PRINT CHR$(27); "1": PRINT:  REM SET UNDERLINE OFF

416 PRINT R$; "A"; O$; "LL (EXCEPT PRINTOUT)": PRINT
417 PRINT R$; "B"; O$; "AR FILLS": PRINT
418 PRINT R$; "P"; O$; "IE SLICES": PRINT
419 PRINT R$; "M"; O$; "ARKERS": PRINT
420 PRINT R$; "L"; O$; "INE TYPES": PRINT
421 PRINT R$; "T"; O$; "EXT FONTS": PRINT
422 PRINT R$; "C"; O$; "ELL ARRAY": PRINT
423 PRINT R$; "I"; O$; "NTERFERENCE PATTERN": PRINT
424 PRINT R$; "D"; O$; "EVICE CHARACTERISTICS PRINTOUT": PRINT
425 PRINT R$; "Q"; O$; "UIT": PRINT


430 PRINT "                    PRESS INITIAL LETTER OF DESIRED FUNCTION."
432 M$ = INKEY$: IF M$ = "" THEN GOTO 432
435 PRINT CHR$(27); "E"
440 DV = 1: GOSUB 50100: REM OPEN WORKSTATION AND CLEAR GRAPHICS SCREEN
445 MHMAX = G5%(12): MHMIN = G5%(10): MTMAX = G4%(9): CHMIN = G5%(2)

450 IF M$ = "A" OR M$ = "a" THEN K$ = "": GOTO 500
455 MENU$ = "BPMLDTCIQE"
460 FOR K = 1 TO LEN(MENU$) + 1
465   K$ = MID$(MENU$,K,1): IF K$ = "E" THEN GOTO 6000
470   IF K$ <> M$ AND ASC(K$) + 32 <> ASC(M$) THEN NEXT K
475 ON K GOSUB 500, 600, 700, 800, 55000, 900, 1100, 1200, 5000
480 REM:       B    P    M    L    D      T    C    I     Q
485 GOSUB 50200: PRINT CHR$(27); "E": GOTO 400: REM DISPLAY MENU AGAIN

500 REM: DISPLAY HOLLOW, SOLID, HALFTONE, AND HATCHED BARS
505 T$ = "BAR FILLS": X1 = 2 * CS: Y1 = DH - 2 * LS: GOSUB 50800
510 BS = DW/22: REM BAR SPACING
511 BW = 3 * BS/4: REM BAR WIDTH
512 Y1 = 0: REM BOTTOM OF ALL BARS
513 Y2 = DH - 3 * LS: REM TOP OF ALL BARS
520 FS = 0: GOSUB 52300: REM SELECT HOLLOW FILL STYLE
521 X1 = BW: X2 = X1 + BW: GOSUB 51110: REM DRAW BAR
540 FS = 2: GOSUB 52300: REM SELECT HALFTONE FILL STYLES
541 FOR I = 1 TO 10
542   FT = I: GOSUB 52400: REM SELECT FILL TYPE
543   X1 = X1 + BS: X2 = X1 + BW: GOSUB 51110
544 NEXT I
550 FS = 3: GOSUB 52300: REM SELECT HATCH FILL STYLES
551 FOR I = 1 TO 10
552   FT = I: GOSUB 52400: REM SELECT FILL TYPE
553   X1 = X1 + BS: X2 = X1 + BW: GOSUB 51110
554 NEXT I
560 GOSUB 54100: IF K$ = "B" THEN RETURN

600 REM: DISPLAY PIE SLICES
601 FS = 2:GOSUB 52300: FT = 1: GOSUB 52400
602 X1 = 0: Y1 = 0: X2 = DW: Y2 = DH: GOSUB 51110: REM FILL SCREEN
605 T$ = "PIE SLICES": X1 = 2 * CS: Y1 = DH - 2 * LS: GOSUB 50800: REM LABEL
610 X1 = DW/2: Y1 = DH/2: R = .4 * DH: REM ORIGIN AT CENTRE OF DISPLAY
615 FS = 1: GOSUB 52300: GOSUB 51140: REM BACKGROUND CIRCLE

620 FS = 3: GOSUB 52300: REM SELECT FILL STYLE = HATCH
630 R = .3 * DH: SA = -360: EA = 0: REM START ANGLE, END ANGLE
631 FOR I = 1 TO 9
632   FT = I: GOSUB 52400: REM SELECT FILL TYPE
633   SA = SA + 360: EA = EA + 360: GOSUB 51130: REM SELECT ANGLE
634 NEXT I
635 X1 = X1 + .1 * DW: Y1 = Y1 - .045 * DH: FT = I: GOSUB 52400
636 SA = SA + 360: EA = EA + 370: GOSUB 51130
640 GOSUB 54100: IF K$ = "P" THEN RETURN

700 REM: DISPLAY MARKERS IN VARIOUS SIZES
710 T$ = "MARKERS IN VARIOUS SIZES": X1 = 0: Y1 = DH - 2 * LS: GOSUB 50800
720 MH = MHMIN: MT = 1: N = 1: X1 = DW/2: Y1 = DH/2: I = 0
730 GOSUB 51900: GOSUB 50700: REM SELECT MARKER HEIGHT, DRAW MARKER
740 MH = MH + 5 * MHMIN: I = I + 1: IF I = 50 THEN GOTO 760
750 GOTO 730
760 MH = MHMIN: MT = MT + 1: IF MT = MTMAX THEN GOTO 780
765 REM: INTENTIONALLY DELETED LAST MARKER
770 GOSUB 50300: I = 0: GOSUB 51800: GOTO 730: REM SELECT MARKER TYPE
780 GOSUB 54100: IF K$ = "M" THEN RETURN

800 REM: DISPLAY VARIOUS LINE TYPES
810 T$ = "LINE TYPES": X1 = 5 * CS: Y1 = DH - 2 * LS: GOSUB 50800
820 Y1 = 4 * LS: X1 = 2 * CS: X2 = DW - X1: N = 2
830 FOR J = 1 TO 7
840   LT = J: GOSUB 51500: REM SET LINE TYPE
850   Y1 = Y1 + 2 * LS: Y2 = Y1: GOSUB 50600: REM DRAW LINE
870   T$ = "TYPE " + STR$(J) + " ": GOSUB 50800: REM WRITE LABEL
880 NEXT J
890 GOSUB 54100: IF K$ = "L" THEN RETURN

900 REM: DISPLAY TEXT IN BIT_IMAGE FONT
910 FO = 1: GOSUB 52100: REM: SELECT FONT
920 T$ = "THIS TEXT IS IN BIT-IMAGE FONT."
930 X1 = 2 * CS: Y1 = DH - 2 * LS: GOSUB 50800
940 T$ = "[GSX]": XINIT = 2 * CS: X1 = XINIT: YINIT = DH/2: CH = CHMIN
945 XINC = (DW - 6 * CS)/100
950 FOR J = 0 TO 2 * PI STEP 2 * PI/100
960   X1 = X1 + XINC: Y1 = YINIT + 8 * LS * COS(J): CH = CH + CHMIN
965 REM: PRESENTLY DOES NOT CHANGE SIZE
970   GOSUB 51200: GOSUB 50800: REM SET CH HEIGHT, WRITE TEXT
980 NEXT J
990 GOSUB 54100

1000 REM: DISPLAY TEXT IN STROKE FONT 
1005 FO = 2: GOSUB 52100: REM SELECT FONT
1010 CH = 10 * CHMIN: GOSUB 51200: REM SET CHARACTER HEIGHT
1015 T$ = "THIS TEXT IS IN STROKE FONT WITH ROTATION
1020 X1 = 2 * CS: Y1 = DH - 2 * LS: GOSUB 50800: REM PRINT LABEL
1021 T$ = "AND HEIGHT CONTROL."
1022 Y1 = Y1 - LS: GOSUB 50800
1025 X1 = DW/2: Y1 = DH/2: RA = -100: T$ = " GSX": CH = 5 * CHMIN
1030 FOR I = 1 TO 8
1035   RA = RA + 450: GOSUB 51300: REM INCREMENT ROTATION ANGLE 45 DEGREES
1040     CH = CH + 5 * CHMIN: GOSUB 51200: REM INCREMENT CHARACTER HEIGHT
1045   GOSUB 50800: REM PRINT TEXT
1050 NEXT

1060 RA = 0: GOSUB 51300: CH = .8 * DH: GOSUB 51200
1070 T$ = "GSX": X1 = 0: Y1 = 3 * LS: GOSUB 50800
1080 CH = 10 * CHMIN: GOSUB 51200: GOSUB 54100: IF K$ = "T" THEN RETURN

1100 REM : DISPLAY 5 X 5 CELL ARRAY
1105 FO = 1: GOSUB 52100
1110 T$ = "CELL ARRAY IN ONE INSTRUCTION": X1 = 2 * CS: Y1 = DH - 2 * LS
1120 GOSUB 50800: REM WRITE LABEL

1130 NC = 25: NCR = 5: NR = 5: WM = 1
1140 FOR I = 1 TO 25 STEP 2
1150   G2%(I) = 0: G2%(I + 1) = 1: REM ALTERNATE BLACK AND WHITE CELLS
1160 NEXT I
1170 X1 = DW/4: X2 = 3 * X1: Y1 = DH/4: Y2 = 3 * Y1
1180 GOSUB 51000: REM DO CELL ARRAY
1190 GOSUB 54100: IF K$ = "C" THEN RETURN



1200 REM: DRAW INTERFERENCE  PATTERN
1210 T$ = "INTERFERENCE PATTERN USING XOR LINES": X1 = CS: Y1 = DH - LS
1220 GOSUB 50800

1230 WM = 3: GOSUB 53200
1240 D1 = CHMIN: D2 = .6 * D1: N = 5
1250 X1 = 0: Y1 = DH/2: X2 = DW/2: Y2 = DH
1260 X3 = DW: Y3 = Y1: X4 = X2: Y4 = 0

1280 X1 = X1 + D1: IF X1 >= DW/2 THEN GOTO 1340
1290 Y2 = Y2 - D2
1300 X3 = X3 - D1
1310 Y4 = Y4 + D2
1320 GOSUB 50600
1330 GOTO 1280
1340 WM = 1: GOSUB 53200: GOSUB 54100: IF K$ = "I" THEN RETURN

5000 GOSUB 50200: END: REM CLOSE WORKSTATION AND RETURN TO BASIC

6000 GOSUB 50200: PRINT CHR$(27); "EINVALID INPUT": PRINT: GOTO 416


50000 REM: GSX ARRAYS: CAN BE DIMENSIONED DIFFERENTLY TO SUIT APPLICATION.
50010 DIM G1%(10), G2%(80), G3%(16), G4%(45), G5%(12): RETURN

50100 REM: OPEN WORKSTATION
50110 G1%(1) = 1: G1%(2) = 0: G1%(4) = 10: G2%(1) = DV
50120 FOR Z = 2 TO 10: G2%(Z) = 1: NEXT Z: GOSUB 54000: RETURN

50200 REM: CLOSE WORKSTATION
50210 G1%(1) = 2: G1%(2) = 0: GOSUB 54000: RETURN

50300 REM: CLEAR
50310 G1%(1) = 3 :G1%(2) = 0: GOSUB 54000: RETURN

50400 REM: UPDATE WORKSTATION
50410 G1%(1) = 4: G1%(2) = 0: GOSUB 54000: RETURN

50500 REM: ESCAPE OPERATIONS ******* NOT IMPLEMENTED

50600 REM: DRAW UP TO FOUR LINES  [CAN BE EXPANDED]
50610 G1%(1) = 6: G1%(2) = N: G3%(1) = X1: G3%(2) = Y1: G3%(3) = X2
50620 G3%(4) = Y2: G3%(5) = X3: G3%(6) = Y3: G3%(7) = X4: G3%(8) = Y4
50630 G3%(9) = X1: G3%(10) = Y1: GOSUB 54000: RETURN

50700 REM: DRAW MARKER  (CAN BE EXPANDED FOR POLYMARKER)
50710 G1%(1) = 7: G1%(2) = N: G3%(1) = X1: G3%(2) = Y1: GOSUB 54000: RETURN

50800 REM: WRITE TEXT: MAX = 80 CHARACTERS UNLESS REDIMENSION G2( ).
50810 G1%(1) = 8: G1%(2) = 1: G1%(4) = LEN(T$): G3%(1) = X1: G3%(2) = Y1
50820 FOR Z = 1 TO LEN(T$): G2%(Z) = ASC(MID$(T$,Z,1)): NEXT Z: GOSUB 54000
50830 RETURN

50900 REM: FILL POLYGON  (IMPLEMENTED FOR UP TO 8 VERTICES: COULD BE MORE)
50910 G1%(1)=9: G1%(2)=N: G3%(1) = X1: G3%(2) = Y1: G3%(3) = X2: G3%(4) = Y2
50920 G3%(5) = X3: G3%(6) = Y3: G3%(7) = X4: G3%(8) = Y4: G3%(9) = X5
50930 G3%(10) = Y5: G3%(11) = X6: G3%(12) = Y6: G3%(13) = X7: G3%(14) = Y7
50940 G3%(15) = X8: G3%(16) = Y8: GOSUB 54000: RETURN

51000 REM: DISPLAY CELL ARRAY: [PASS CELL COLOR IN G2%()]
51010 G1%(1) = 10: G1%(2) = 2: G1%(4) = NC: G1%(6) = NCR: G1%(7) = NCR
51020 G1%(8) = NR: G1%(9) = WM
51030 G3%(1) = X1: G3%(2) = Y1: G3%(3) = X2: G3%(4) = Y2
51040 GOSUB 54000: RETURN


51100 REM: GENERALIZED DRAWING PRIMITIVES (GDP'S)
51110 REM: DRAW BAR
51111 G1%(1) = 11: G1%(2) = 2: G1%(6) = 1: G3%(1) = X1: G3%(2) = Y1
51112 G3%(3) = X2: G3%(4) = Y2: GOSUB 54000: RETURN

51120 REM: DRAW ARC
51121 G1%(1) = 11: G1%(2) = 4: G1%(6) = 2: G2%(1) = SA: G3%(2) = EA
51122 G3%(1) = X1: G3%(2) = Y1: G3%(7) = R: G3%(8) = 0: GOSUB 54000: RETURN

51130 REM: DRAW PIE SLICE
51131 G1%(1) = 11: G1%(2) = 4: G1%(6) = 3: G2%(1) = SA: G2%(2) = EA
51132 G3%(1) = X1: G3%(2) = Y1: G3%(7) = R: G3%(8) = 0: GOSUB 54000: RETURN

51140 REM: DRAW CIRCLE
51141 G1%(1) = 11: G1%(2) = 3: G1%(6) = 4: G3%(1) = X1: G3%(2) = Y1
51142 G3%(5) = R: G3%(6) = 0: GOSUB 54000: RETURN

51150 REM: RULING CHARACTERS ******* NOT IMPLEMENTED
51160 REM: END OF GDP'S

51200 REM: SET CHARACTER HEIGHT
51210 G1%(1) = 12: G1%(2) = 1: G3%(1) = 0: G3%(2) = CH: GOSUB 54000: RETURN

51300 REM: SET TEXT DIRECTION
51310 G1%(1) = 13: G1%(2) = 0: G2%(1) = RA: GOSUB 54000: RETURN

51400 REM: SPECIFY COLOUR INDEX VALUE ******* NOT IMPLEMENTED

51500 REM: SET LINE TYPE
51510 G1%(1) = 15: G1%(2) = 0: G2%(1) = LT: GOSUB 54000: RETURN

51600 REM: SET LINE WIDTH
51610 G1%(1) = 16: G1%(2) = 1: G3%(1) = LW: G3%(2) = 0: GOSUB 54000: RETURN

51700 REM: SET LINE COLOUR INDEX ******* NOT IMPLEMENTED

51800 REM: SELECT MARKER TYPE
51810 G1%(1) = 18: G1%(2) = 0: G2%(1) = MT: GOSUB 54000: RETURN

51900 REM: SELECT MARKER HEIGHT
51910 G1%(1) = 19: G1%(2) = 1: G3%(1) = 0: G3%(2) = MH: GOSUB 54000: RETURN

52000 REM SET MARKER COLOUR INDEX ******* NOT IMPLEMENTED

52100 REM: SELECT FONT
52110 G1%(1) = 21: G1%(2) = 0: G2%(1) = FO: GOSUB 54000: RETURN

52200 REM: SET TEXT COLOUR INDEX ******* NOT IMPLEMENTED

52300 REM: SELECT FILL STYLE
52310 G1%(1) = 23: G1%(2) = 0: G2%(1) = FS: GOSUB 54000: RETURN

52400 REM: SELECT FILL TYPE 
52410 G1%(1) = 24: G1%(2) = 0: G2%(1) = FT: GOSUB 54000: RETURN

52500 REM: SET FILL COLOUR INDEX ******* NOT IMPLEMENTED

52600 REM: INQUIRE COLOUR REPRESENTATION ******* NOT IMPLEMENTED

52700 REM: INQUIRE CELL ARRAY ******* NOT IMPLEMENTED

52800 REM INPUT LOCATOR  (IMPLEMENTED FOR KEYBOARD: CAN BE FOR MOUSE)
52810 G1%(1) = 28: G1%(2) = 1: G2%(1) = 1: G3%(1) = X1: G3%(2) = Y1
52820 GOSUB 54000: RETURN

52900 REM: INPUT VALUATOR ******* NOT IMPLEMENTED

53000 REM: INPUT CHOICE  (SELECTS FUNCTION KEYS: CAN BE EXPANDED)
53010 G1%(1) = 30: G1%(2) = 0: G2%(1) = 1: GOSUB 54000: RETURN

53100 REM: RETURN STRING FROM KEYBOARD, ECHO TO DEVICE, 80 CHARS MAX
53110 G1%(1) = 31: G1%(2) = 1: G2%(1) = 1: G2%(2) = 80: G2%(3) = 1
53120 G3%(1) = X1: G3%(2) = Y1: GOSUB 54000: RETURN

53200 REM: SET WRITING MODE
53210 G1%(1) = 32: G1%(2) = 0: G2%(1) = WM: GOSUB 54000: RETURN


54000 REM: CALL GSX ASSEMBLY SUBROUTINE
54010 DEF SEG = &H61: GSX% = 0: REM ASSIGN SEGMENT ADDRESS & OFFSET
54020 CALL GSX%(G1%(1), G2%(1), G3%(1), G4%(1), G5%(1))
54030 DEF SEG: RETURN

54100 REM: CONTINUE
54110 T$ = "PRESS SPACE KEY TO CONTINUE": X1 = 10000: Y1 = 500: GOSUB 50800
54120 IF INKEY$ <> "" THEN GOSUB 50300: RETURN
54130 GOTO 54120

55000 REM: PRINTOUT OF DEVICE CHARACTERISTICS
55005 REM: CALL TO THIS SUBR MUST IMMEDIATELY FOLLOW OPEN WORKSTATION
55010 LPRINT CHR$(27); "@": REM INITIALIZE PRINTER
55020 LPRINT "Display width in addressable increments:.........."; G4%(1) + 1
55030 LPRINT "Display height in addressable increments:........."; G4%(2) + 1
55040 LPRINT "Capable of producing precisely scaled images?.....";
55050 IF G4%(2) = 1 THEN LPRINT " no" ELSE LPRINT " yes"
55060 LPRINT "Width of one step in millimeters:................."; G4%(4) /1000
55070 LPRINT "Height of one step in millimeters:................"; G4%(5) /1000
55080 LPRINT "Number of character heights supported:............"; G4%(6)
55090 LPRINT "Maximum character height in NDC units:............"; G5%(4)
55100 LPRINT "Minimum character height in NDC units:............"; G5%(2)
55110 LPRINT "Number of line types:............................."; G4%(7)
55120 LPRINT "Number of line widths:............................"; G4%(8)
55130 LPRINT "Maximum line width in NDC units:.................."; G5%(7)
55140 LPRINT "Minimum line width in NDC units:.................."; G5%(5)
55150 LPRINT "Number of marker types:..........................."; G4%(9)
55160 LPRINT "Number of marker sizes:..........................."; G4%(10)
55170 LPRINT "Maximum marker height in NDC units:..............."; G5%(12)
55180 LPRINT "Minimum marker height in NDC units:..............."; G5%(10)
55190 LPRINT "Color supported?..................................";
55200 IF G4%(35) = 0 THEN LPRINT " no" ELSE LPRINT " yes"
55210 LPRINT "Simultaneous colors:.............................."; G4%(14)
55220 LPRINT "Total colors:....................................."; G4%(40)
55230 LPRINT "Number of fonts:.................................."; G4%(11)
55240 LPRINT "Number of halftones:.............................."; G4%(12)
55250 LPRINT "Number of hatchings:.............................."; G4%(13)

55260 LPRINT "Generalized Drawing Primitive Functions (GDPs) & their attributes:
55270 FOR J = 15 TO 24
55280    IF G4%(J) = 1 THEN LPRINT "BAR          ";
55290    IF G4%(J) = 2 THEN LPRINT "ARC          ";
55300    IF G4%(J) = 3 THEN LPRINT "PIE SLICE    ";
55310    IF G4%(J) = 4 THEN LPRINT "CIRCLE   ";
55320    IF G4%(J) = 5 THEN LPRINT "RULING CHARACTERS"
55330 NEXT J: LPRINT

55340 FOR J = 25 TO 34
55350   IF G4%(J) = 0 THEN LPRINT "POLYLINE  ";
55360   IF G4%(J) = 1 THEN LPRINT "POLYMARKER    ";
55370   IF G4%(J) = 2 THEN LPRINT "TEXT          ";
55380   IF G4%(J) = 3 THEN LPRINT "FILL AREA ";
55390   IF G4%(J) = 4 THEN LPRINT "NONE"
55400 NEXT J: LPRINT

55410 LPRINT "Text rotation supported?..........................";
55420 IF G4%(36) = 0 THEN LPRINT " no" ELSE LPRINT " yes"
55430 LPRINT "Fill area supported?..............................";
55440 IF G4%(37) = 0 THEN LPRINT " no" ELSE LPRINT " yes"
55450 LPRINT "Read cell operation supported?....................";
55460 IF G4%(38) = 0 THEN LPRINT " no" ELSE LPRINT " yes"
55470 LPRINT "Number of locator devices available:.............."; G4%(41)
55480 LPRINT "Number of valuator devices available:............."; G4%(42)
55490 LPRINT "Number of choice devices available:..............."; G4%(43)
55500 LPRINT "Number of string devices available:..............."; G4%(44)
55510 LPRINT: LPRINT "Device is ";
55520 IF G4%(44) = 0 THEN LPRINT "output only."
55530 IF G4%(44) = 1 THEN LPRINT "input only."
55540 IF G4%(44) = 2 THEN LPRINT "input/output."
55550 IF G4%(44) = 3 THEN LPRINT "device independent segment storage."
55560 IF G4%(44) = 4 THEN LPRINT "GKS Metafile output."
55570 LPRINT
55580  LPRINT "NDC = Normalized Device Coordinates, e.g. 32767 full scale.

55590 RETURN
