10 rem: IMPHEX for Apricot Xi, MSBASIC: L.Doyle 5/85
30 rem: this version includes GSXSUBS.BAS
40 rem: If your BIOS is prior to Version 2.7, interchange FO = 1 and FO = 2
50 rem: and add  "G2%(6) = 2"  after  "NEXT Z" in line 50120.

99 :
100 rem: GSX calling parameters and constants
110 rem: X1, Y1 = coordinates of first point
120 rem: X2, Y2 = coordinates of second point
140 rem: CH = character height in NDC units
150 rem: FT, FS = fill type, fill style
160 rem: FO = font: 2 = stroke font supporting rotation and height
170 rem:            1 = bit image font 
230 rem: LT = line type
250 rem: Z is reserved as a counting variable in these subroutines
299:
300 rem: IMPHEX constants
305 SW = 32768:                           rem = screen width = screen height in NDC units
310 LS = INT(SW/25): CS = INT(SW/80):     rem line spacing and character spacing in NDC units
315 FTH = 10:                             rem human's piece fill type = white
320 FTC = 1:                              rem computer's piece = black with dots
325 FTE = 5:                              rem board fill = neutral halftone
330 XH = 46 * CS: YH = 22 * LS:           rem heading origin
335 FW = 160: OF = 80:                    rem frame width for boards, offset for heading
340 XS1 = 2 * CS:  YS1 = 8 * LS:          rem scoreboard lower left corner
345 XS2 = 30 * CS: YS2 = 24 * LS:         rem scoreboard upper right corner
350 XC1 = 23758: XC2 = 16 * CS:           rem text printout centres, playing board & scoreboard
355 rem: lines on which text may be printed:
360 YT1 = 6 * LS:  YT2 = 4 * LS:   YT3 = 2 * LS:   YT4 = 23 * LS
365 YT5 = 21 * LS: YT6 = 18 * LS:  YT7 = 17 * LS:  YT8 = 16 * LS
370 YT9 = 14 * LS: YT10 = 13 * LS: YT11 = 12 * LS: YT12 = 3 * LS
375 BK = -1: WH = +1:                     rem array code for black and white pieces
399:
400 rem: variables (computer is black)
410 rem: BKWIN, WHWIN = black and white games won
420 rem: ROW, COL = board row, column, 1 to 3 from lower left
430 rem: ROWINIT, COLINIT = position of piece selected for move
440 rem: ROWFINL, COLFINL = position of piece after move
450 rem: F1 = illegal move count
460 rem: F2 = 1 if "I needed that" has been used
470 rem: F3 = BK if computer won last game or WH if human won
480 rem: BKTRIAL = -1, 0, or 1: trial move by black
490 rem: WHTRIAL = trial move for white by black to see if white can play
500 rem: DY = desired delay in seconds
510 rem: T1, T2 = TIME readings
520 rem: XC = centre line of next text, set to XC1 or XC2
599:
600 rem: string constants
610 CL$ = CHR$(27) + "E":                 rem clear screen
620 BP$ = CHR$(7):                        rem beep
630 ER$ = SPACE$(26):                     rem erase text
699:
700 rem: string variables
710 rem: T$ = computer text to be printed on screen
720 rem: R$ = human response to computer
730 rem: WHMOVE$ = two-digit human input
740 OPTION BASE 0:                        rem arrays to start at 0
799:
800 rem: dims, defs, seed random
810 DIM BOARD(3,4):                       rem 4 x 5 array for 3 x 3 board
820 DIM BADMOVE(3,3,15):                  rem bad moves array
830 DIM BRDCRD(3,3,4):                    rem coords of each cell of board for GSX
840 GOSUB 4300:                           rem fill BRDCRD array
850 GOSUB 50000:                          rem dim the GSX arrays
860 DEF FNC(XC) = XC - LEN(T$)/2 * CS:    rem centres text on column XC
870 RANDOMIZE TIME/3:                     rem secs since midnight seeds random
880 DIM TRIED(3, 3, 3):                   rem record of random moves
899:
900 rem: instructions?
910 PRINT CL$
920 INPUT "Instructions (Y or N)"; R$: PRINT "OK"
930 IF R$ <> "Y" AND R$ <> "y" AND R$ <> "N" AND R$ <> "n" THEN PRINT BP$: GOTO 910
940 IF R$ = "Y" OR R$ = "y" THEN GOSUB 60000
999:
1000 rem: GSX initialization
1099:
1100 rem: open workstation and draw scoreboard
1110 GOSUB 50100:                         rem open workstation
1120 FS = 0: GOSUB 52300:                 rem set fill style to black
1130 X1 = XS1: Y1 = YS1: X2 = XS2: Y2 = YS2: GOSUB 51110: rem draw scoreboard
1140 X1 = X1 - FW: Y1 = Y1 - FW: X2 = X2 + FW: Y2 = Y2 + FW: GOSUB 51110: rem draw outer frame
1150 T$ = "Computer is black.": XC = XC2: X1 = FNC(XC): Y1 = YT6: GOSUB 50800
1160 T$ = "Human plays first.": X1 = FNC(XC): Y1 = YT8: GOSUB 50800
1199:
1200 rem: draw heading
1210 T$ = "IMPHEX": X1 = XH: Y1 = YH
1220 FO = 2: GOSUB 52100: rem set to stroke font
1230 CH = 3000: GOSUB 51200: GOSUB 50800: rem set character height & write
1240 FOR I = 1 TO 5
1250    X1 = X1 + OF: Y1 = Y1 + OF: GOSUB 50800: rem rewrite offset
1260 NEXT I
1270 FO = 1: GOSUB 52100:                 rem reset to dot font
1299:
1300 rem: initialize BOARD array: next game in a sequence starts here
1310 F1 = 0: rem illegal move count
1320 FOR COL = 1 TO 3
1330    BOARD(1,COL) = WH: BOARD(2,COL) = 0: BOARD(3,COL) = BK
1340 NEXT COL
1399:
1400 rem: draw board frame 
1410 FS = 0: GOSUB 52300
1420 X1 = BRDCRD(1,1,1) - 2 * FW: Y1 = BRDCRD(1,1,2) - 2 * FW
1430 X2 = BRDCRD(3,3,3) + 2 * FW: Y2 = BRDCRD(3,3,4) + 2 * FW:  GOSUB 51110

1499:
1500 rem: draw pieces in starting position
1505 FS = 2: GOSUB 52300: rem set fill style = halftones
1510 FOR ROW = 1 TO 3
1515    ON ROW GOTO 1520, 1525, 1530
1520    FT = FTH: GOTO 1535: rem human
1525    FT = FTE: GOTO 1535: rem empty
1530    FT = FTC: rem computer
1535    GOSUB 52400: rem set fill type
1540    FOR COL = 1 TO 3
1545       X1 = BRDCRD(ROW, COL, 1): Y1 = BRDCRD(ROW, COL, 2)
1550       X2 = BRDCRD(ROW, COL, 3): Y2 = BRDCRD(ROW, COL, 4)
1555       GOSUB 51110: rem draw bar
1560    NEXT COL
1565 NEXT ROW
1599:
1600 rem: comments by computer
1610 XC = XC2: Y1 = YT9: GOSUB 4800: Y1 = YT10: GOSUB 4800: Y1 = YT11: GOSUB 4800: rem erase
1620 IF F3 = BK THEN GOTO 1700: rem computer won last game so no comments
1630 IF WHWIN > 0 THEN T$ = "I have learned": X1 = FNC(XC): Y1 = YT9: GOSUB 50800
1640 IF WHWIN = 1 THEN T$ = "a bad move.": X1 = FNC(XC): Y1 = YT10: GOSUB 50800
1650 IF WHWIN = 2 THEN T$ = "another one!": X1 = FNC(XC): Y1 = YT10: GOSUB 50800
1660 IF WHWIN > 2 THEN T$ = STR$(WHWIN) + " bad moves": X1 = FNC(XC): Y1 = YT10: GOSUB 50800
1670 IF WHWIN > 5 THEN T$ = "the hard way!": X1 = FNC(XC): Y1 = YT11: GOSUB 50800
1699:
1700 rem: human's turn
1705 XC = XC1: Y1 = YT1: GOSUB 4800
1710 T$ = "Your turn": X1 = FNC(XC) - 2 * CS: GOSUB 50800: rem offsets text
1715 X1 = X1 + (LEN(T$) + 1) * CS: GOSUB 53100: rem prints move after text
1720 Y1 = YT2: GOSUB 4800: Y1 = YT3: GOSUB 4800
1725 WHMOVE$ = ""
1730 FOR I = 1 TO 2
1735    IF G4%(I) > 48 AND G4%(I) < 58 THEN GOTO 1750: rem valid input keys 1 to 9
1740    Y1 = YT2: GOSUB 4800: PRINT BP$
1745    T$ = "Not in this game!": X1 = FNC(XC): GOSUB 50800: GOTO 1700
1750    WHMOVE$ = WHMOVE$ + CHR$(G4%(I)): rem recovers string from array storage
1755 NEXT I
1760 WHI = VAL(LEFT$(WHMOVE$,1)): WHF = VAL(RIGHT$(WHMOVE$,1))
1799:
1900 rem convert key number to row, col coordinates
1910 RESTORE 1990
1920 FOR I = 1 TO WHI
1930    READ ROWINIT, COLINIT
1940 NEXT I
1950 RESTORE 1990
1960 FOR I = 1 TO WHF
1970    READ ROWFINL, COLFINL
1980 NEXT I
1990 DATA 1,1, 1,2, 1,3, 2,1, 2,2, 2,3, 3,1, 3,2, 3,3
1995 rem:  1    2    3    4    5    6    7    8    9  key number
1999:
2000 rem: check for illegal moves
2010 IF BOARD(ROWINIT,COLINIT) <> WH THEN GOTO 2200
2020 IF ROWFINL - ROWINIT <> 1 THEN GOTO 2200
2030 IF ABS(COLFINL - COLINIT) > 1 THEN GOTO 2200
2040 IF (COLINIT = COLFINL) AND BOARD(ROWFINL, COLFINL) <> 0 THEN GOTO 2200
2050 IF (ABS(COLFINL - COLINIT) = 1) AND BOARD(ROWFINL,COLFINL) <> BK THEN GOTO 2200
2099:
2100 rem: legal, so record the move
2110 BOARD(ROWINIT,COLINIT) = 0
2120 BOARD(ROWFINL,COLFINL) = WH
2130 GOSUB 4100: rem copy board to screen
2140 IF ROWFINL = 3 THEN GOTO 3200: rem white wins
2150 GOTO 2500: rem computer's turn
2199:
2200 rem: illegal
2210 Y1 = YT2: GOSUB 4800: Y1 = YT3: GOSUB 4800: PRINT BP$
2220 F1 = F1 + 1: IF F1 = 4 THEN GOTO 2240
2230 T$ = "Illegal move.": X1 = FNC(XC): Y1 = YT2: GOSUB 50800: GOTO 1700
2240 DY = 1.5: GOSUB 4200: PRINT BP$
2250 T$ = "How many times do I have to tell you?": X1 = FNC(XC): Y1 = YT2: GOSUB 50800
2260 T$ = "Illegal move!": X1 = FNC(XC): Y1 = YT3: GOSUB 50800
2270 F1 = 0
2280 GOTO 1700: rem human's turn
2299:
2500 rem: computer's turn
2510 Y1 = YT1: GOSUB 4800
2520 T$ = "My turn": X1 = FNC(XC): GOSUB 50800
2599:
2600 rem: try moves at random until all have been tried or a valid move found
2605 ERASE TRIED: DIM TRIED(3, 3, 3)
2610 FOR I = 2 TO 3: FOR J = 1 TO 3: FOR K = 1 TO 3
2615 IF TRIED(I, J, K) = 0 THEN GOTO 2630: rem at least one move has not been tried
2620 NEXT K: NEXT J: NEXT I
2625 GOTO 3200: rem no move for black so white wins
2630 ROWINIT = INT(2 * RND + 2): rem row 2 or 3
2635 COLINIT = INT(3 * RND + 1): rem col 1, 2, or 3
2640 BKMOVE = INT(3 * RND - 1): rem move -1, 0, or +1
2645 IF TRIED(ROWINIT, COLINIT, BKMOVE + 2) = 1 THEN GOTO 2630: rem tried before
2650 TRIED(ROWINIT, COLINIT, BKMOVE + 2) = 1: rem mark as tried; then test
2655 IF BOARD(ROWINIT, COLINIT) <> BK THEN GOTO 2610: rem not computer's piece
2660 IF BOARD(ROWINIT - 1, COLINIT + BKMOVE) <> ABS(BKMOVE) THEN GOTO 2610: rem not legal move
2665 rem: found a move
2670 TEMPINIT = BOARD(ROWINIT, COLINIT): rem note contents in case they have to be replaced
2675 TEMPFINL = BOARD(ROWINIT - 1, COLINIT + BKMOVE)
2680 BOARD(ROWINIT, COLINIT) = 0: rem make move temporarily, subject to checking
2685 BOARD(ROWINIT - 1, COLINIT + BKMOVE) = BK

2700 rem: see if board matches a stored bad move record
2710 FOR I = 0 TO WHWIN: rem look through record of previous lost games
2720    FOR J = 1 TO 3: FOR K = 1 TO 3
2730          IF BOARD(J,K) <> BADMOVE(J,K,I) THEN GOTO 2790
2740       NEXT K: NEXT J
2750    rem: found a bad move, so unmake it
2760    BOARD(ROWINIT, COLINIT) = TEMPINIT
2770    BOARD(ROWINIT - 1, COLINIT + BKMOVE) = TEMPFINL
2780 GOTO 2610
2790 NEXT I


2800 rem: good move, so finalize it
2810 GOSUB 4100: rem copy board
2820 rem: now copy board into BADMOVE array: it will be overwritten if black wins
2830 FOR ROW = 1 TO 3: FOR COL = 1 TO 3
2840    BADMOVE(ROW, COL, WHWIN) = BOARD(ROW, COL)
2850 NEXT COL: NEXT ROW
2860 IF ROWINIT = 2 THEN GOTO 3100: rem must have gotten to row 3 and won

2900 rem: see if white has a move
2910 FOR ROW = 1 TO 3: FOR  COL = 1 TO 3
2920    IF BOARD(ROW, COL) <> WH THEN GOTO 2960
2930    FOR WHTRIAL = -1 TO 1: rem found white, see if there is any move for it
2940       IF BOARD(ROW + 1, COL + WHTRIAL) = - ABS(WHTRIAL) THEN GOTO 1700: rem human's turn
2950    NEXT WHTRIAL
2960 NEXT COL: NEXT ROW
2970 rem: whites all captured or have no move, so black wins
2999:
3000 rem end-of-game procedures
3099:
3100 rem black wins
3110 Y1 = YT1: GOSUB 4800
3120 PRINT BP$
3130 T$ = "I win!": X1 = FNC(XC): GOSUB 50800
3140 BKWIN = BKWIN + 1
3150 F3 = BK
3160 GOTO 3300
3199:
3200 rem: white wins
3210 Y1 = YT1: GOSUB 4800
3220 T$ = "You win!": X1 = FNC(XC): GOSUB 50800
3230 WHWIN = WHWIN + 1
3240 F3 = WH
3299:
3300 rem: score
3310 XC = XC2: T$ = " SCORE ": X1 = FNC(XC): Y1 = YT4: GOSUB 50800
3320 Y1 = YT5: GOSUB 4800
3330 T$ = "Computer: " + STR$(BKWIN) + "  Human: " + STR$(WHWIN): X1 = FNC(XC): GOSUB 50800
3340 IF BKWIN > WHWIN THEN F2 = 1
3350 IF NOT (F3 = BK AND F2 = 0 AND BKWIN = 1 AND WHWIN > 5) THEN GOTO 3400 
3360 XC = XC1: Y1 = YT2: GOSUB 4800
3370 T$ = "I needed that!": X1 = FNC(XC): F2 = 1: GOSUB 50800
3399:
3400 rem: another game?
3410 XC = XC1: Y1 = YT3: GOSUB 4800
3420 T$ = "Another game (Y or N)": X1 = FNC(XC) - 2 * CS: GOSUB 50800
3430 X1 = X1 + (LEN(T$) + 1) * CS: GOSUB 53100
3440 R$ = CHR$(G4%(1))
3450 IF R$ = "Y" OR R$ = "y" THEN GOTO 3500
3460 XC = XC2: T$ = " Sour grapes! So turn me off!": X1 = FNC(XC): Y1 = YT12: GOSUB 50800
3470 DY = 3: GOSUB 4200
3480 GOSUB 50200: END
3499:
3500 rem: erase and to new game
3510 GOSUB 4800
3520 Y1 = YT1: GOSUB 4800
3530 GOTO 1300
3599:
4000 rem subroutines
4099:
4100 rem scan board array and copy to screen
4110 FOR ROW = 1 TO 3
4120    FOR COL = 1 TO 3
4130       IF BOARD(ROW,COL) = BK THEN GOSUB 4500
4140       IF BOARD(ROW,COL) = WH THEN GOSUB 4600
4150       IF BOARD(ROW,COL) = 0  THEN GOSUB 4700
4160    NEXT COL
4170 NEXT ROW
4180 RETURN
4199:
4200 rem: adjustable delay
4210 T1 = TIME + DY
4220 T2 = TIME: IF T2 < T1 THEN GOTO 4220
4230 RETURN
4299:
4300 rem: fill BRDCRD array with coordinates
4310 RESTORE 4410
4320 FOR ROW = 1 TO 3
4330    FOR COL = 1 TO 3
4340       FOR COORD = 1 TO 2
4350          READ XY: BRDCRD(ROW, COL, COORD) = XY + FW: rem FW allows adjustment of border width
4360       NEXT COORD
4365       FOR COORD = 3 TO 4
4370          READ XY: BRDCRD(ROW, COL, COORD) = XY - FW
4375       NEXT COORD
4380    NEXT COL
4390 NEXT ROW: RETURN
4399:
4400 rem: data for BRDCRD = lower left and upper right corners of board cells
4410 DATA 17368, 10483, 21628, 16163
4420 DATA 21628, 10483, 25888, 16163
4430 DATA 25888, 10483, 30148, 16163
4440 DATA 17368, 16163, 21628, 21843
4450 DATA 21628, 16163, 25888, 21843
4460 DATA 25888, 16163, 30148, 21843
4470 DATA 17368, 21843, 21628, 27523
4480 DATA 21628, 21843, 25888, 27523
4490 DATA 25888, 21843, 30148, 27523
4499:
4500 rem: draw black piece
4510 X1 = BRDCRD(ROW, COL, 1): Y1 = BRDCRD(ROW, COL, 2)
4520 X2 = BRDCRD(ROW, COL, 3): Y2 = BRDCRD(ROW, COL, 4)
4530 FT = FTC: GOSUB 52400: GOSUB 51110: RETURN
4599:
4600 rem: draw white piece
4610 X1 = BRDCRD(ROW, COL, 1): Y1 = BRDCRD(ROW, COL, 2)
4620 X2 = BRDCRD(ROW, COL, 3): Y2 = BRDCRD(ROW, COL, 4)
4630 FT = FTH: GOSUB 52400: GOSUB 51110: RETURN
4699:
4700 rem: draw empty square
4710 X1 = BRDCRD(ROW, COL, 1): Y1 = BRDCRD(ROW, COL, 2)
4720 X2 = BRDCRD(ROW, COL, 3): Y2 = BRDCRD(ROW, COL, 4)
4730 FT = FTE: GOSUB 52400: GOSUB 51110: RETURN
4799:
4800 rem: erase text subroutine
4810 T$ = ER$: IF XC = XC1 THEN T$ = T$ + T$
4820 X1 = FNC(XC): GOSUB 50800
4830 RETURN
4899:
50000 REM: GSX ARRAYS: CAN BE DIMENSIONED DIFFERENTLY TO SUIT APPLICATION.
50010 DIM G1%(10), G2%(80), G3%(16), G4%(45), G5%(12): RETURN

50100 REM: OPEN WORKSTATION
50110 G1%(1) = 1: G1%(2) = 0: G1%(4) = 10: G2%(1) = DV
50120 FOR Z = 2 TO 10: G2%(Z) = 1: NEXT Z: GOSUB 54000: RETURN

50200 REM: CLOSE WORKSTATION
50210 G1%(1) = 2: G1%(2) = 0: GOSUB 54000: RETURN

50300 REM: CLEAR
50310 G1%(1) = 3 :G1%(2) = 0: GOSUB 54000: RETURN

50600 REM: DRAW UP TO FOUR LINES  [CAN BE EXPANDED]
50610 G1%(1) = 6: G1%(2) = N: G3%(1) = X1: G3%(2) = Y1: G3%(3) = X2
50620 G3%(4) = Y2: G3%(5) = X3: G3%(6) = Y3: G3%(7) = X4: G3%(8) = Y4
50630 G3%(9) = X1: G3%(10) = Y1: GOSUB 54000: RETURN

50700 REM: DRAW MARKER  (CAN BE EXPANDED FOR POLYMARKER)
50710 G1%(1) = 7: G1%(2) = N: G3%(1) = X1: G3%(2) = Y1: GOSUB 54000: RETURN

50800 REM: WRITE TEXT: MAX = 80 CHARACTERS UNLESS REDIMENSION G2( ).
50810 G1%(1) = 8: G1%(2) = 1: G1%(4) = LEN(T$): G3%(1) = X1: G3%(2) = Y1
50820 FOR Z = 1 TO LEN(T$): G2%(Z) = ASC(MID$(T$,Z,1)): NEXT Z: GOSUB 54000
50830 RETURN

50900 REM: FILL POLYGON  (IMPLEMENTED FOR UP TO 8 VERTICES: COULD BE MORE)
50910 G1%(1) = 9: G1%(2) = N: G3%(1) = X1: G3%(2) = Y1: G3%(3) = X2: G3%(4) = Y2
50920 G3%(5) = X3: G3%(6) = Y3: G3%(7) = X4: G3%(8) = Y4: G3%(9) = X5
50930 G3%(10) = Y5: G3%(11) = X6: G3%(12) = Y6: G3%(13) = X7: G3%(14) = Y7
50940 G3%(15) = X8: G3%(16) = Y8: GOSUB 54000: RETURN

51100 REM: GENERALIZED DRAWING PRIMITIVES (GDP'S)
51110 REM: DRAW BAR
51111 G1%(1) = 11: G1%(2) = 2: G1%(6) = 1: G3%(1) = X1: G3%(2) = Y1
51112 G3%(3) = X2: G3%(4) = Y2: GOSUB 54000: RETURN

51200 REM: SET CHARACTER HEIGHT
51210 G1%(1) = 12: G1%(2) = 1: G3%(1) = 0: G3%(2) = CH: GOSUB 54000: RETURN

51500 REM: SET LINE TYPE
51510 G1%(1) = 15: G1%(2) = 0: G2%(1) = LT: GOSUB 54000: RETURN

51800 REM: SELECT MARKER TYPE
51810 G1%(1) = 18: G1%(2) = 0: G2%(1) = MT: GOSUB 54000: RETURN

51900 REM: SELECT MARKER HEIGHT
51910 G1%(1) = 19: G1%(2) = 1: G3%(1) = 0: G3%(2) = MH: GOSUB 54000: RETURN

52100 REM: SELECT FONT
52110 G1%(1) = 21: G1%(2) = 0: G2%(1) = FO: GOSUB 54000: RETURN

52300 REM: SELECT FILL STYLE
52310 G1%(1) = 23: G1%(2) = 0: G2%(1) = FS: GOSUB 54000: RETURN

52400 REM: SELECT FILL TYPE 
52410 G1%(1) = 24: G1%(2) = 0: G2%(1) = FT: GOSUB 54000: RETURN

53100 REM: RETURN STRING FROM KEYBOARD, ECHO TO DEVICE, 80 CHARS MAX
53110 G1%(1) = 31: G1%(2) = 1: G2%(1) = 1: G2%(2) = 80: G2%(3) = 1
53120 G3%(1) = X1: G3%(2) = Y1: GOSUB 54000: RETURN

53200 REM: SET WRITING MODE
53210 G1%(1) = 32: G1%(2) = 0: G2%(1) = WM: GOSUB 54000: RETURN

54000 REM: CALL GSX ASSEMBLY SUBROUTINE
54010 DEF SEG = &H61: GSX% = 0: REM ASSIGN SEGMENT ADDRESS & OFFSET
54020 CALL GSX%(G1%(1), G2%(1), G3%(1), G4%(1), G5%(1))
54030 DEF SEG: RETURN

60000 rem: instructions
60010 PRINT CL$ 

60050 PRINT "IMPHEX, an improved version of HEXAPAWN, is played with pieces having the same "
60060 PRINT "moves as the pawns in chess, on a three-by-three board.  Your pieces are white "
60070 PRINT "squares.  Mine are black.  You may move upwards one square into an EMPTY square"
60080 PRINT "or diagonally upwards to the left or right into a square OCCUPIED BY BLACK,    "
60090 PRINT "capturing and replacing my piece in the process.                               "
60100 PRINT "    To enter a move when it is your turn, type the number of the square you    "
60110 PRINT "wish to move from, the number of the square you wish to move to, and RETURN.   "
60120 PRINT "    The squares are numbered like the number pad at the right of the keyboard, "
60130 PRINT "i.e the upper left square is number 7, the centre square is number 5, the lower"
60140 PRINT "left square is number 1, etc.  To win, you must move one of your pieces to the "
60150 PRINT "top edge of the board OR capture all my pieces OR block me from making a move. "
60160 PRINT "I start a series of games knowing only how to make legal moves and how to      "
60170 PRINT "recognize a win.  I have no initial strategy, but I keep a record of all bad   "
60180 PRINT "moves, improve my strategy with each game, and after eight games am unbeatable."
60190 PRINT: PRINT "Press SPACE key to continue."
60200 IF INKEY$ = "" THEN GOTO 60200
60210 ? " OK": RETURN
                                                85/05/19 10:59                      85/07/11 15:47 :o                   i     
 
B N     \                                                                     (08@HPX`hpx                    