10 REM: SKETCH1.BAS: L.DOYLE 4/85
20 REM: INCORPORATES GSXSUBS.BAS
30 REM: MSDOS MSBASIC APRICOT SCREEN
40 REM: IF YOUR BIOS IS PRIOR TO VERSION 2.7, INTERCHANGE FO = 1 AND FO = 2
50 REM: AND ADD  "G2%(6) = 2"  AFTER  "NEXT Z"  IN LINE 50120.

100 REM: CALLING PARAMETERS AND CONSTANTS
110 REM: X1, Y1 = COORDINATES OF FIRST POINT
120 REM: X2, Y2 = COORDINATES OF SECOND POINT
130 REM: XN, YN = COORDINATES OF Nth POINT
140 REM: R = RADIUS OF CIRCLE OR PIE SLICE
150 REM: SA, EA = START ANGLE, END ANGLE OF PIE SLICE IN TENTHS OF DEGREES
160 REM: RA = ROTATION ANGLE OF TEXT IN TENTHS OF DEGREES
170 REM: CH = CHARACTER HEIGHT IN NDC UNITS
180 REM: MT, MH = MARKER TYPE, MARKER HEIGHT IN NDC UNITS
190 REM: FT, FS = FILL TYPE, FILL STYLE
200 REM: FO = FONT: 2 = STROKE FONT SUPPORTING ROTATION AND HEIGHT
210 REM:            1 = BIT IMAGE FONT (BUT SEE LINE 40)
220 REM: N = NUMBER OF POINTS
230 REM: LT, LW = LINE TYPE, LINE WIDTH IN NDC UNITS
240 REM: WM = WRITING MODE: 1 = REPLACE; 2 = TRANSPARENT; 3 = XOR; 4 = ERASE
250 REM: Z IS RESERVED AS A COUNTING VARIABLE IN THESE SUBROUTINES
260 REM: DW, DH = DEVICE WIDTH AND HEIGHT IN NDC UNITS
270 REM: LS, CS = LINE AND CHARACTER SPACING IN NDC UNITS
280 REM: DV = DEVICE NUMBER (KEYBOARD = 1)

300 REM: INSTRUCTIONS OPTION
310 PRINT CHR$(27); "ESKETCH INSTRUCTIONS? (Y OR N)
320 I$ = INKEY$: IF I$ = "" THEN GOTO 320
330 IF I$ = "Y" OR I$ = "y" THEN GOSUB 60000

400 REM: INITIALIZE
410 DW = 32767: DH = DW: DV = 1: N = 2
420 GOSUB 50010: GOSUB 50100:              REM DIM ARRAYS, OPEN WORKSTATION

430 REM: REINITIALIZE
440 GOSUB 50300:                           REM CLEAR
450 WM = 1: GOSUB 53200:                   REM SET FILL TO WHITE, DRAW BAR
460 X1 = 0: Y1 = 0: X2 = DW: Y2 = DH: GOSUB 51110
470 WM = 4: GOSUB 53200:                   REM SET BLACK LINE
480 X1 = DW/2: Y1 = DH/2:                  REM START AT CENTRE OF SCREEN
490 GOSUB 52800:                           REM 'INPUT LOCATOR' GIVES CURSOR

500 REM: LINE DRAWING ROUTINE
510 REM: PRESS ANY KEY EXCEPT NUMBERS TO DROP OUT OF LOCATOR. THEN:
520 X2 = G5%(1): Y2 = G5%(2): IN = G4%(1): REM IN = THE KEY WHICH WAS PRESSED
530 IF IN = 81  THEN GOSUB 50200: END:     REM "Q" = QUIT
540 IF IN = 113 THEN GOSUB 50200: END
550 IF IN = 66  THEN WM = 4: GOSUB 53200:  REM "B" = BLACK LINE
560 IF IN = 98  THEN WM = 4: GOSUB 53200
570 IF IN = 87  THEN WM = 1: GOSUB 53200   REM "W" = WHITE LINE
580 IF IN = 119 THEN WM = 1: GOSUB 53200
590 IF IN = 67  THEN GOTO 440:             REM "C" = CLEAR GRAPHICS SCREEN
600 IF IN = 99  THEN GOTO 440
610 IF IN = 76  THEN GOSUB 700:            REM "L" = SELECT LINE TYPE
620 IF IN = 108 THEN GOSUB 700
630 IF IN = 72  THEN GOTO 480:             REM "H" = HOME TO CENTRE OF SCREEN
640 IF IN = 104 THEN GOTO 480
650 IF IN = 77  THEN GOTO 690:             REM "M" = MOVE WITHOUT WRITING
660 IF IN = 109 THEN GOTO 690

680 GOSUB 50600:                           REM DRAW LINE
690 X1 = X2: Y1 = Y2: GOTO 490:            REM LOOP

700 REM: SELECT LINE TYPE
730 LT$ = INKEY$: IF LT$ = "" THEN GOTO 730
740 LT  = VAL(LT$): IF LT < 1 OR LT > 7 THEN GOTO 730
750 GOSUB 51500:                           REM SET LINE TYPE
790 RETURN




50000 REM: GSX ARRAYS: CAN BE DIMENSIONED DIFFERENTLY TO SUIT APPLICATION.
50010 DIM G1%(10), G2%(80), G3%(16), G4%(45), G5%(12): RETURN

50100 REM: OPEN WORKSTATION
50110 G1%(1) = 1: G1%(2) = 0: G1%(4) = 10: G2%(1) = DV
50120 FOR Z = 2 TO 10: G2%(Z) = 1: NEXT Z: GOSUB 54000: RETURN

50200 REM: CLOSE WORKSTATION
50210 G1%(1) = 2: G1%(2) = 0: GOSUB 54000: RETURN

50300 REM: CLEAR
50310 G1%(1) = 3 :G1%(2) = 0: GOSUB 54000: RETURN

50400 REM: UPDATE WORKSTATION
50410 G1%(1) = 4: G1%(2) = 0: GOSUB 54000: RETURN

50500 REM: ESCAPE OPERATIONS ******* NOT IMPLEMENTED

50600 REM: DRAW UP TO FOUR LINES  [CAN BE EXPANDED]
50610 G1%(1) = 6: G1%(2) = N: G3%(1) = X1: G3%(2) = Y1: G3%(3) = X2
50620 G3%(4) = Y2: G3%(5) = X3: G3%(6) = Y3: G3%(7) = X4: G3%(8) = Y4
50630 G3%(9) = X1: G3%(10) = Y1: GOSUB 54000: RETURN

50700 REM: DRAW MARKER  (CAN BE EXPANDED FOR POLYMARKER)
50710 G1%(1) = 7: G1%(2) = N: G3%(1) = X1: G3%(2) = Y1: GOSUB 54000: RETURN

50800 REM: WRITE TEXT: MAX = 80 CHARACTERS UNLESS REDIMENSION G2( ).
50810 G1%(1) = 8: G1%(2) = 1: G1%(4) = LEN(T$): G3%(1) = X1: G3%(2) = Y1
50820 FOR Z = 1 TO LEN(T$): G2%(Z) = ASC(MID$(T$,Z,1)): NEXT Z: GOSUB 54000
50830 RETURN

50900 REM: FILL POLYGON  (IMPLEMENTED FOR UP TO 8 VERTICES: COULD BE MORE)
50910 G1%(1) = 9: G1%(2) = N: G3%(1) = X1: G3%(2) = Y1: G3%(3) = X2: G3%(4) = Y2
50920 G3%(5) = X3: G3%(6) = Y3: G3%(7) = X4: G3%(8) = Y4: G3%(9) = X5
50930 G3%(10) = Y5: G3%(11) = X6: G3%(12) = Y6: G3%(13) = X7: G3%(14) = Y7
50940 G3%(15) = X8: G3%(16) = Y8: GOSUB 54000: RETURN

51000 REM: DISPLAY CELL ARRAY: [PASS CELL COLOR IN A2%()]
51010 G1%(1) = 10: G1%(2) = 2: G1%(4) = NC: G1%(6) = NCR: G1%(7) = NCR
51020 G1%(8) = NR: G1%(9) = WM
51030 G3%(1) = X1: G3%(2) = Y1: G3%(3) = X2: G3%(4) = Y2
51040 GOSUB 54000: RETURN


51100 REM: GENERALIZED DRAWING PRIMITIVES (GDP'S)
51110 REM: DRAW BAR
51111 G1%(1) = 11: G1%(2) = 2: G1%(6) = 1: G3%(1) = X1: G3%(2) = Y1
51112 G3%(3) = X2: G3%(4) = Y2: GOSUB 54000: RETURN

51120 REM: DRAW ARC
51121 G1%(1) = 11: G1%(2) = 4: G1%(6) = 2: G2%(1) = SA: G3%(2) = EA
51122 G3%(1) = X1: G3%(2) = Y1: G3%(7) = R: G3%(8) = 0: GOSUB 54000: RETURN

51130 REM: DRAW PIE SLICE
51131 G1%(1) = 11: G1%(2) = 4: G1%(6) = 3: G2%(1) = SA: G2%(2) = EA
51132 G3%(1) = X1: G3%(2) = Y1: G3%(7) = R: G3%(8) = 0: GOSUB 54000: RETURN

51140 REM: DRAW CIRCLE
51141 G1%(1) = 11: G1%(2) = 3: G1%(6) = 4: G3%(1) = X1: G3%(2) = Y1
51142 G3%(5) = R: G3%(6) = 0: GOSUB 54000: RETURN

51150 REM: RULING CHARACTERS ******* NOT IMPLEMENTED
51160 REM: END OF GDP'S

51200 REM: SET CHARACTER HEIGHT
51210 G1%(1) = 12: G1%(2) = 1: G3%(1) = 0: G3%(2) = CH: GOSUB 54000: RETURN

51300 REM: SET TEXT DIRECTION
51310 G1%(1) = 13: G1%(2) = 0: G2%(1) = RA: GOSUB 54000: RETURN

51400 REM: SPECIFY COLOUR INDEX VALUE ******* NOT IMPLEMENTED

51500 REM: SET LINE TYPE
51510 G1%(1) = 15: G1%(2) = 0: G2%(1) = LT: GOSUB 54000: RETURN

51600 REM: SET LINE WIDTH
51610 G1%(1) = 16: G1%(2) = 1: G3%(1) = LW: G3%(2) = 0: GOSUB 54000: RETURN

51700 REM: SET LINE COLOUR INDEX ******* NOT IMPLEMENTED

51800 REM: SELECT MARKER TYPE
51810 G1%(1) = 18: G1%(2) = 0: G2%(1) = MT: GOSUB 54000: RETURN

51900 REM: SELECT MARKER HEIGHT
51910 G1%(1) = 19: G1%(2) = 1: G3%(1) = 0: G3%(2) = MH: GOSUB 54000: RETURN

52000 REM SET MARKER COLOUR INDEX ******* NOT IMPLEMENTED

52100 REM: SELECT FONT
52110 G1%(1) = 21: G1%(2) = 0: G2%(1) = FO: GOSUB 54000: RETURN

52200 REM: SET TEXT COLOUR INDEX ******* NOT IMPLEMENTED

52300 REM: SELECT FILL STYLE
52310 G1%(1) = 23: G1%(2) = 0: G2%(1) = FS: GOSUB 54000: RETURN

52400 REM: SELECT FILL TYPE 
52410 G1%(1) = 24: G1%(2) = 0: G2%(1) = FT: GOSUB 54000: RETURN

52500 REM: SET FILL COLOUR INDEX ******* NOT IMPLEMENTED

52600 REM: INQUIRE COLOUR REPRESENTATION ******* NOT IMPLEMENTED

52700 REM: INQUIRE CELL ARRAY ******* NOT IMPLEMENTED

52800 REM INPUT LOCATOR  (IMPLEMENTED FOR KEYBOARD: CAN BE FOR MOUSE)
52810 G1%(1) = 28: G1%(2) = 1: G2%(1) = 1: G3%(1) = X1: G3%(2) = Y1
52820 GOSUB 54000: RETURN

52900 REM: INPUT VALUATOR ******* NOT IMPLEMENTED

53000 REM: INPUT CHOICE  (SELECTS FUNCTION KEYS: CAN BE EXPANDED)
53010 G1%(1) = 30: G1%(2) = 0: G2%(1) = 1: GOSUB 54000: RETURN

53100 REM: RETURN STRING FROM KEYBOARD, ECHO TO DEVICE, 80 CHARS MAX
53110 G1%(1) = 31: G1%(2) = 1: G2%(1) = 1: G2%(2) = 80: G2%(3) = 1
53120 G3%(1) = X1: G3%(2) = Y1: GOSUB 54000: RETURN

53200 REM: SET WRITING MODE
53210 G1%(1) = 32: G1%(2) = 0: G2%(1) = WM: GOSUB 54000: RETURN


54000 REM: CALL GSX ASSEMBLY SUBROUTINE
54010 DEF SEG = &H61: GSX% = 0: REM ASSIGN SEGMENT ADDRESS & OFFSET
54020 CALL GSX%(G1%(1), G2%(1), G3%(1), G4%(1), G5%(1))
54030 DEF SEG: RETURN

54100 REM: CONTINUE
54110 T$ = "PRESS SPACE KEY TO CONTINUE": X1 = 10000: Y1 = 500: GOSUB 50800
54120 IF INKEY$ <> "" THEN GOSUB 50300: RETURN
54130 GOTO 54120

55000 REM: PRINTOUT OF DEVICE CHARACTERISTICS
55005 REM: CALL TO THIS SUBR MUST IMMEDIATELY FOLLOW OPEN WORKSTATION
55010 LPRINT CHR$(27); "@": REM INITIALIZE PRINTER
55020 LPRINT "Display width in addressable increments:.........."; G4%(1) + 1
55030 LPRINT "Display height in addressable increments:........."; G4%(2) + 1
55040 LPRINT "Capable of producing precisely scaled images?.....";
55050 IF G4%(2) = 1 THEN LPRINT " no" ELSE LPRINT " yes"
55060 LPRINT "Width of one step in millimeters:................."; G4%(4) / 1000
55070 LPRINT "Height of one step in millimeters:................"; G4%(5) / 1000
55080 LPRINT "Number of character heights supported:............"; G4%(6)
55090 LPRINT "Maximum character height in NDC units:............"; G5%(4)
55100 LPRINT "Minimum character height in NDC units:............"; G5%(2)
55110 LPRINT "Number of line types:............................."; G4%(7)
55120 LPRINT "Number of line widths:............................"; G4%(8)
55130 LPRINT "Maximum line width in NDC units:.................."; G5%(7)
55140 LPRINT "Minimum line width in NDC units:.................."; G5%(5)
55150 LPRINT "Number of marker types:..........................."; G4%(9)
55160 LPRINT "Number of marker sizes:..........................."; G4%(10)
55170 LPRINT "Maximum marker height in NDC units:..............."; G5%(12)
55180 LPRINT "Minimum marker height in NDC units:..............."; G5%(10)
55190 LPRINT "Color supported?..................................";
55200 IF G4%(35) = 0 THEN LPRINT " no" ELSE LPRINT " yes"
55210 LPRINT "Simultaneous colors:.............................."; G4%(14)
55220 LPRINT "Total colors:....................................."; G4%(40)
55230 LPRINT "Number of fonts:.................................."; G4%(11)
55240 LPRINT "Number of halftones:.............................."; G4%(12)
55250 LPRINT "Number of hatchings:.............................."; G4%(13)

55260 LPRINT "Generalized Drawing Primitive Functions (GDPs) & their attributes:
55270 FOR J = 15 TO 24
55280    IF G4%(J) = 1 THEN LPRINT "BAR		 ";
55290    IF G4%(J) = 2 THEN LPRINT "ARC		 ";
55300    IF G4%(J) = 3 THEN LPRINT "PIE SLICE	 ";
55310    IF G4%(J) = 4 THEN LPRINT "CIRCLE   ";
55320    IF G4%(J) = 5 THEN LPRINT "RULING CHARACTERS"
55330 NEXT J: LPRINT

55340 FOR J = 25 TO 34
55350   IF G4%(J) = 0 THEN LPRINT "POLYLINE  ";
55360   IF G4%(J) = 1 THEN LPRINT "POLYMARKER	 ";
55370   IF G4%(J) = 2 THEN LPRINT "TEXT		 ";
55380   IF G4%(J) = 3 THEN LPRINT "FILL AREA ";
55390   IF G4%(J) = 4 THEN LPRINT "NONE"
55400 NEXT J: LPRINT

55410 LPRINT "Text rotation supported?..........................";
55420 IF G4%(36) = 0 THEN LPRINT " no" ELSE LPRINT " yes"
55430 LPRINT "Fill area supported?..............................";
55440 IF G4%(37) = 0 THEN LPRINT " no" ELSE LPRINT " yes"
55450 LPRINT "Read cell operation supported?....................";
55460 IF G4%(38) = 0 THEN LPRINT " no" ELSE LPRINT " yes"
55470 LPRINT "Number of locator devices available:.............."; G4%(41)
55480 LPRINT "Number of valuator devices available:............."; G4%(42)
55490 LPRINT "Number of choice devices available:..............."; G4%(43)
55500 LPRINT "Number of string devices available:..............."; G4%(44)
55510 LPRINT: LPRINT "Device is ";
55520 IF G4%(44) = 0 THEN LPRINT "output only."
55530 IF G4%(44) = 1 THEN LPRINT "input only."
55540 IF G4%(44) = 2 THEN LPRINT "input/output."
55550 IF G4%(44) = 3 THEN LPRINT "device independent segment storage."
55560 IF G4%(44) = 4 THEN LPRINT "GKS Metafile output."
55570 LPRINT
55580  LPRINT "NDC = Normalized Device Coordinates, e.g. 32767 full scale.

55590 RETURN

60000 REM: INSTRUCTIONS
60010 PRINT CHR$(27); "ESKETCH draws black lines on 800 X 400-dot white field";
60020 PRINT " in eight directions.
60030 PRINT "Press the initial letter to get any of the following functions:"
60040 PRINT: PRINT "B = BLACK LINE"; SPC(32) "W = WHITE LINE (erase)"
60050 PRINT: PRINT "M = MOVE WITHOUT DRAWING (use M at beginning and end of";
60060 PRINT " move)": PRINT
60070 PRINT "<SPACE> KEY DRAWS LINE FROM PRESENT TO PREVIOUS CURSOR POSITION.
60080 PRINT: PRINT "(to draw an isolated dot press M <SPACE> M.)"
60090 PRINT: PRINT "C = CLEAR SCREEN"; SPC(31) "H = HOME TO CENTRE
60100 PRINT: PRINT "5 = TOGGLE FROM HIGH TO LOW SPEED"
60110 PRINT: PRINT "OTHER NUMBER KEYS 1 TO 9 MOVE CURSOR IN INDICATED DIRECTION
60120 PRINT: PRINT "L = LINE FOLLOWED BY 1 TO 7 TO CHANGE LINE TYPE";
60130 PRINT "  (Always use L1 for erasing.)"
60140 PRINT: PRINT "Q = QUIT THE PROGRAM"; SPC(27) "<RETURN> key not required
60150 PRINT: PRINT
60160 PRINT SPC(20) "PRESS <SPACE> KEY WHEN READY TO PROCEED
60170 I$ = INKEY$: IF I$ = "" THEN GOTO 60170
60180 RETURN
