1  ' Character editor based on "GRAFCHAR.BAS" on 16-Bit Computing disk
2  ' Originally based on Sirius Grafchar by Barbara Binless in
3  ' Personal Computer World, November 1984, p224.
4  '
5  ' Modified by Tim Hines, August 1985:
6  ' To allow the selection of between one and eight characters for editing
7  ' at one time, and to allow movement to the Last as well as Next block
8  ' of characters (L and N), or shifting one character at a time (+ and -).
9  ' Also the menu selection characters have been changed from control
10 ' characters to normal characters to save keystrokes.
11 '
12 ' This program allows the user to redefine the current character set
13 ' and to save and load complete sets of characters.  Characters may
14 ' also be saved as DATA statements for use in BASIC programs.  To read
15 ' back from DATA statements into CHR$(CHAR%):
16 ' DEF SEG = 128: FOR J% = 0 TO 31: READ X%: POKE 32*CHAR% + J%, X%: NEXT
17 ' Characters are displayed for editing in blocks of 1 to 8, but the whole set
18 ' is used for S and L, and any number of consecutive characters may be
19 ' saved as data.
20 '
21 '
22 '
23 ' define functions
24 '
25 ' return positive number X as text without leading blank
26    DEF FNNUM$(X) = RIGHT$(STR$(X),LEN(STR$(X))-1)
27 ' print following text at row ROW% and column COL%
28    DEF FNC$(ROW%,COL%) = ESC$ + "Y" + CHR$(31 + ROW%) + CHR$(31 + COL%)
29 ' random number between 1 and X%
30    DEF FNRAND(X%) = INT(RND(1)*X% + 1)
31 ' centre following text T$ on row ROW%
32    DEF FNCENTRE$(ROW%,T$) = FNC$(ROW%,40-LEN(T$)\2) + T$
33 ' return uppercase value of character X$
34    DEF FNUP$(X$) = CHR$(ASC(X$) + 32*(ASC(X$)>96))
35 ' print logo at row ROW% and column COL%
36    DEF FNLOGO$(ROW%,COL%) = ESC$ + "i" + CHR$(31 + ROW%) + CHR$(31 + COL%)
37 '
38 ' initialisation block
39 '
40    ESC$      = CHR$(27)    :'Escape character
41    CLS$      = ESC$ + "E"  :'Clear screen and home cursor, not line 25
42    EREOL$    = ESC$ + "K"  :'Erase to end of line
43    EREOF$    = ESC$ + "J"  :'Erase to end of screen
44    ERBOL$    = ESC$ + "o"  :'Erase to beginning of line
45    ERBOF$    = ESC$ + "b"  :'Erase to beginning of screen
50    HION$     = ESC$ + "("  :'High intensity on
51    HIOFF$    = ESC$ + ")"  :'High intensity off
52    REVON$    = ESC$ + "p"  :'Reverse on
53    REVOFF$   = ESC$ + "q"  :'Reverse off
54    UNDON$    = ESC$ + "0"  :'Underline on
55    UNDOFF$   = ESC$ + "1"  :'Underline off
60    CURON$    = ESC$ + "y5" :'Cursor on
61    CUROFF$   = ESC$ + "x5" :'Cursor off
62    CURSAV$   = ESC$ + "j"  :'Save cursor position
63    CURBAK$   = ESC$ + "k"  :'Return cursor position
64    BELL$     = CHR$(7)	   :'Bell
65    BLINKON$  = ESC$ + "2"  :'Cursor blink on
66    BLINKOFF$ = ESC$ + "3"  :'Cursor blink off
67    LINOFF$   = ESC$ + "y1" + CURBAK$  :'Line 25 off, return cursor
70    LINON$    = CURSAV$ + ESC$ + "x1" + FNC$(25,1)  :'Save cursor, line 25 on, goto column 1
71    LITERAL$  = ESC$ + "8"  :'Literal test mode, display chars < ASCII 20
80    CLRALL$   = ESC$ + "z"  :'Clear everything
81    YES%      = -1
82    NO%       = 0
83    WIDTH 255
84    BLOCK%    = 5
87 '
88 ' trap odd file names, set segment to start of characters
89 '
90    ON ERROR GOTO 20000
91    DEF SEG = 128
97 '
98 ' set up initial screen
99 '
100    PRINT CLRALL$; LINON$
101    WIDTH 255
102    FINISHED% = NO%
103    CH$(0) = "."
104    CH$(1) = "O"
105    PRINT FNLOGO$(1,57)
110    FOR J% = 0 TO 254
120      PRINT FNC$(21 + J%\64, 11 + J% MOD 64); LITERAL$; CHR$(J%);
130      IF J% MOD 64 = 0 THEN PRINT FNC$(21 + J%\64, 6);: PRINT USING "###";J%;
140    NEXT
150    PRINT REVON$; FNCENTRE$(1," CHARACTER EDITOR "); REVOFF$
151    GOSUB 10000
157 '
158 ' save current character set
159 '
160    BSAVE "charset.$$$",O,8192
197 '
198 ' loop until Q to quit
199 '
200    WHILE NOT FINISHED%
210      IN$    = FNUP$(INPUT$(1))
220      IF IN$ = "S" THEN GOSUB 1000       :'S  Save character set
230      IF IN$ = "L" THEN GOSUB 2000       :'L  Load character set
240      IF IN$ = "D" THEN GOSUB 3000       :'D  Save as DATA statements
245      IF IN$ = "B" THEN GOSUB 5000       :'B  Modify edit block size
250      IF IN$ = "E" THEN GOSUB 4000       :'E  Edit
260      IF IN$ = "Q" THEN FINISHED% = YES% :'Q  Quit
270    WEND
277 '
278 ' restore old character set if required
279 '
280    PRINT FNC$(25,1); EREOL$; "Do you want to restore the original character set? ";
290    IF FNUP$(INPUT$(1)) = "Y" THEN BLOAD "charset.$$$",0
300    DEF SEG
301    KILL "charset.$$$"
302    PRINT CLRALL$
303    END
398 '
399 '----------------------------------------------------------------------
997 '
998 ' save character set to disk
999 '
1000    PRINT FNC$(25,1); EREOL$;
1010    INPUT "Name to give character set (up to 8 characters): ", FILE.NAME$
1020    IF INSTR(FILE.NAME$,".") = 0 THEN FILE.NAME$ = FILE.NAME$ + ".GCH"
1030    BSAVE FILE.NAME$,0,8192
1040    GOSUB 10000
1090    RETURN
1997 '
1998 ' load character set from disk
1999 '
2000    PRINT FNC$(25,1); EREOL$;
2010    INPUT "Name of character set to load: ", FILE.NAME$
2020    IF INSTR(FILE.NAME$,".") = 0 THEN FILE.NAME$ = FILE.NAME$ + ".GCH"
2030    BLOAD FILE.NAME$,0
2040    GOSUB 10000
2090    RETURN
2997 '
2998 ' save block of characters as DATA statements
2999 '
3000    PRINT FNC$(25,1); EREOL$;
3005    INPUT "Save from character: ", CHAR%
3009    PRINT EREOL$;
3010    INPUT "To character: ", CHAR2%
3020    PRINT EREOL$;
3030    INPUT "File name for DATA statements (up to 8 letters): ", FILE.NAME$
3035    FILE.NAME$ = FILE.NAME$ + ".BAS"
3040    PRINT EREOL$;
3045    INPUT "Starting line number: ", LINE.NUM
3049    PRINT EREOL$;
3050    INPUT "With step size: ", STEP.SIZE
3055    PRINT EREOL$; "Saving data.....";
3060    OPEN "O",#1,FILE.NAME$
3065    NO.CHARS% = CHAR2% - CHAR%
3070    PNTR% = 32*CHAR%
3080    FOR CH% = 0 TO NO.CHARS%
3090      PRINT #1, FNNUM$(LINE.NUM); " Data ";
3100      FOR ADDR% = PNTR% TO PNTR% + 30 STEP 2
3110        LOBYT% = PEEK(ADDR%)
3115        HIBYT% = PEEK(ADDR% + 1)
3120        PRINT #1,FNNUM$(LOBYT%); ","; FNNUM$(HIBYT%);
3130        IF ADDR%<PNTR% + 30 THEN PRINT #1, ",";
3140      NEXT
3145      PRINT #1, ""
3150      PNTR% = PNTR% + 32
3155      LINE.NUM = LINE.NUM + STEP.SIZE
3160    NEXT
3170    CLOSE #1
3180    GOSUB 10000
3190    RETURN
3997 '
3998 ' edit existing character set
3999 '
4000    PRINT FNC$(25,1); EREOL$;
4002    INPUT "Character number to start at: ", CHAR%
4003    IF CHAR% < 0 THEN CHAR% = 0
4004    IF CHAR% > (255 - BLOCK%) THEN CHAR% = 255 - BLOCK%
4005    IN$ = ""
4010    PRINT EREOL$; REVON$; FNCENTRE$(25," 5 (Toggle)  1-9 (Move)  +  -  Next block  Last block  End "); REVOFF$
4017 '
4018 ' display existing characters
4019 '
4020    WHILE IN$ <> "E"
4030      FOR J% = 4 TO 20
4032        PRINT FNC$(J%,1); EREOL$ ;
4035      NEXT
4037      COL1% = 41 - 5*BLOCK%
4040      PNTR% = 32*CHAR%
4041      IF BLOCK% = 1 THEN PRINT FNC$(4,COL1%); "<-      ->"
4042      IF BLOCK% = 2 THEN PRINT FNC$(4,COL1%); "<-      -><-      ->"
4043      IF BLOCK% = 3 THEN PRINT FNC$(4,COL1%); "<-      -><-      -><-      ->"
4044      IF BLOCK% = 4 THEN PRINT FNC$(4,COL1%); "<-      -><-      -><-      -><-      ->"
4045      IF BLOCK% = 5 THEN PRINT FNC$(4,COL1%); "<-      -><-      -><-      -><-      -><-      ->"
4046      IF BLOCK% = 6 THEN PRINT FNC$(4,COL1%); "<-      -><-      -><-      -><-      -><-      -><-      ->"
4047      IF BLOCK% = 7 THEN PRINT FNC$(4,COL1%); "<-      -><-      -><-      -><-      -><-      -><-      -><-      ->"
4048      IF BLOCK% = 8 THEN PRINT FNC$(4,COL1%); "<-      -><-      -><-      -><-      -><-      -><-      -><-      -><-      ->"
4050      FOR CH% = 0 TO BLOCK%-1
4060        COL% = 10*CH% + COL1%
4065        PRINT FNC$(4,COL% + 3); CHAR%+CH%;
4070        FOR ADDR% = PNTR% TO (PNTR% + 30) STEP 2
4080          LOBYT% = PEEK(ADDR%)
4085          HIBYT% = PEEK(ADDR% + 1)
4090          ROW%   = (ADDR%-PNTR%)\2 + 5
4100          FOR C% = 0 TO 9
4110            BIT% = NO%
4120            IF C% < 8 AND (LOBYT% AND 2^C%) > 0     THEN BIT% = YES%
4130            IF C% > 7 AND (HIBYT% AND 2^(C%-8)) > 0 THEN BIT% = YES%
4140            PRINT FNC$(ROW%,COL% + C%); CH$(ABS(BIT%));
4150          NEXT
4160        NEXT
4165        PNTR% = PNTR% + 32
4170      NEXT
4175      GOSUB 4200
4180    WEND
4182    IN$ = ""
4185    GOSUB 10000
4190    RETURN
4197 '
4198 ' use numeric pad to move cursor and toggle bit
4199 '
4200    ROW% = 5
4205    COL% = COL1%
4210    WHILE IN$ <> "E" AND IN$ <> "N" AND IN$ <> "L" AND IN$ <> "+" AND IN$ <> "-"
4220      PRINT FNC$(ROW%,COL%);
4222      IN$ = ""
4225      IN$ = FNUP$(INPUT$(1))
4230      IF IN$ = "5" THEN GOSUB 4500
4240      IF IN$ = "1" OR IN$ = "2" OR IN$ = "3" THEN ROW% = ROW% - (ROW%<20)
4250      IF IN$ = "7" OR IN$ = "8" OR IN$ = "9" THEN ROW% = ROW% + (ROW%>5)
4260      IF IN$ = "1" OR IN$ = "4" OR IN$ = "7" THEN COL% = COL% + (COL%>COL1%)
4270      IF IN$ = "3" OR IN$ = "6" OR IN$ = "9" THEN COL% = COL% - (COL%<(10*BLOCK%+COL1%-1))
4290    WEND
4292    IF IN$ = "+" THEN CHAR% = CHAR% + 1: IN$ = ""
4293    IF IN$ = "-" THEN CHAR% = CHAR% - 1: IN$ = ""
4295    IF IN$ = "N" THEN CHAR% = CHAR% + BLOCK%: IN$ = ""
4297    IF IN$ = "L" THEN CHAR% = CHAR% - BLOCK%: IN$ = ""
4390    RETURN
4497 '
4498 ' toggle bit at cursor
4499 '
4500    X% = ROW% - 5
4505    Y% = COL% - COL1%
4510    ADDR% = 32*(CHAR% + Y%\10) + 2*X% - (Y% MOD 10>7)
4520    Y% = Y% MOD 10
4525    IF Y% > 7 THEN Y% = Y% - 8
4530    POKE ADDR%, PEEK(ADDR%) XOR 2^Y%
4540    IF (PEEK(ADDR%) AND 2^Y%) > 0 THEN BIT% = YES% ELSE BIT% = NO%
4550    PRINT FNC$(ROW%,COL%); CH$(ABS(BIT%));
4590    RETURN
4997 '
4998 ' modify block size for editing (between 1 and 8 characters)
4999 '
5000    PRINT FNC$(25,1); EREOL$;
5010    INPUT "Number of characters in block to edit at once: ", BLOCK%
5020	IF BLOCK% < 1 THEN BLOCK% = 1
5030	IF BLOCK% > 8 THEN BLOCK% = 8
5040    GOSUB 10000
5090    RETURN
9997 '
9998 ' display control keys, clear edit section of screen
9999 '
10000    PRINT FNC$(25,1); EREOL$; REVON$
10010    PRINT FNCENTRE$(25," Quit  Edit  Block  Data  Save  Load ")
10020    FOR J% = 4 TO 20
10022      PRINT FNC$(J%,1); EREOL$;
10025    NEXT
10030    PRINT REVOFF$; FNC$(25,78);
10090    RETURN
10097 '
10098 ' recover after bad file name, otherwise stop
10099 '
20000    IF ERL <> 3060 AND ERL <> 1030 AND ERL <> 2030 THEN PRINT "Error"; ERR; "in line"; ERL: STOP
20010    PRINT FNC$(25,1); "Invalid file name - press a key to continue"
20020    IN$ = INPUT$(1)
20025    GOSUB 10000
20090    IF ERL = 3060 THEN RESUME 3170 ELSE RESUME NEXT
