10 REM: SKETCH.BAS BY F.CHAMBERS 4/85: MSDOS, MSBASIC

30 REM: CALLING PARAMETERS AND CONSTANTS FOR GSX SUBRS.
40 REM: ALL PARAMETERS ARE IN GSX NORMALIZED DEVICE COORDINATES (NDC UNITS)
50 REM: ON 32767 BY 32767 FIELD.

100 REM: X1, Y1 = COORDINATES OF FIRST POINT
110 REM: X2, Y2 = COORDINATES OF SECOND POINT
120 REM: N = ASCII NUMBER OF DEPRESSED KEY
130 REM: LT = LINE TYPE: 1 TO 7
140 REM: WM = WRITING MODE: 1 = WHITE; 4 = BLACK
150 REM: Z IS RESERVED AS A COUNTING VARIABLE IN THESE SUBROUTINES
160 REM: DW, DH = DEVICE WIDTH AND HEIGHT IN NDC UNITS

180 REM: CERTAIN PARAMETERS ASSUME DEFAULT SETTING BUT MIGHT HAVE TO
190 REM: BE RESET IF USED WITHIN ANOTHER PROGRAM.

200 REM: INSTRUCTIONS OPTION
210 PRINT CHR$(27); "ESKETCH INSTRUCTIONS? (Y OR N)
220 I$ = INKEY$: IF I$ = "" THEN GOTO 220
230 IF I$ = "Y" OR I$ = "y" THEN GOSUB 60000

300 REM: INITIALIZE
310 DW = 32767: DH = DW
320 GOSUB 50010: GOSUB 50100:              REM DIM ARRAYS, OPEN WORKSTATION

400 REM: REINITIALIZE
410 GOSUB 50300: GOSUB 50400:              REM CLEAR
420 WM = 4: GOSUB 53200:                   REM SET BLACK LINE
430 X1 = DW/2: Y1 = DH/2:                  REM START AT CENTRE OF SCREEN
440 GOSUB 52800:                           REM 'INPUT LOCATOR' GIVES CURSOR

500 REM: LINE DRAWING ROUTINE
510 REM: PRESS ANY KEY EXCEPT NUMBERS TO DROP OUT OF LOCATOR. THEN:
520 X2 = A5%(1): Y2 = A5%(2): N = A4%(1):  REM N = THE KEY WHICH WAS PRESSED
530 IF N = 81  THEN GOSUB 50200: END:      REM "Q" = QUIT
540 IF N = 113 THEN GOSUB 50200: END
550 IF N = 66  THEN WM = 4: GOSUB 53200:   REM "B" = BLACK LINE
560 IF N = 98  THEN WM = 4: GOSUB 53200
570 IF N = 87  THEN WM = 1: GOSUB 53200:   REM "W" = WHITE LINE
580 IF N = 119 THEN WM = 1: GOSUB 53200
590 IF N = 67  THEN GOTO 410:              REM "C" = CLEAR GRAPHICS SCREEN
600 IF N = 99  THEN GOTO 410
610 IF N = 76  THEN GOSUB 700:             REM "L" = SELECT LINE TYPE
620 IF N = 108 THEN GOSUB 700
630 IF N = 72  THEN GOTO 430:              REM "H" = HOME TO CENTRE OF SCREEN
640 IF N = 104 THEN GOTO 430
650 IF N = 77  THEN GOTO 690:              REM "M" = MOVE WITHOUT WRITING
660 IF N = 109 THEN GOTO 690

680 GOSUB 50600:                           REM DRAW LINE
690 X1 = X2: Y1 = Y2: GOTO 440:            REM LOOP

700 REM: SELECT LINE TYPE
730 LT$ = INKEY$: IF LT$ = "" THEN GOTO 730
740 LT  = VAL(LT$): IF LT < 1 OR LT > 7 THEN GOTO 730
750 GOSUB 51500:                           REM SET LINE TYPE
790 RETURN

50000 REM: GSX SUBROUTINES (NOT ALL ARE INCLUDED)

50010 REM: GSX ARRAYS
50011 DIM A1%(9), A2%(79), A3%(300), A4%(55), A5%(22): RETURN

50100 REM: OPEN WORKSTATION
50110 A1%(1) = 1: A1%(2) = 0: A1%(4) = 10
50120 FOR Z = 1 TO 10: A2%(Z) = 1: NEXT Z
50130 GOSUB 54000: RETURN

50200 REM: CLOSE WORKSTATION
50210 A1%(1) = 2: A1%(2) = 0: GOSUB 54000: RETURN

50300 REM: CLEAR
50310 A1%(1) = 3 :A1%(2) = 0: GOSUB 54000: RETURN

50400 REM: FILL SCREEN WITH WHITE
50410 WM = 1: GOSUB 53200: REM SET FILL TO WHITE, THEN DRAW BAR...
50420 X1 = 0: Y1 = 0: X2 = DW: Y2 = DH: GOSUB 51110: RETURN

50600 REM: DRAW LINE  (CAN BE EXPANDED FOR POLYLINE)
50610 A1%(1) = 6: A1%(2) = 2: A3%(1) = X1: A3%(2) = Y1: A3%(3) = X2
50620 A3%(4) = Y2: GOSUB 54000: RETURN

51100 REM: GENERALIZED DRAWING PRIMITIVES (GDP'S) (ONLY ONE USED HERE)
51110 REM: DRAW BAR
51111 A1%(1) = 11: A1%(2) = 2: A1%(6) = 1: A3%(1) = X1: A3%(2) = Y1
51112 A3%(3) = X2: A3%(4) = Y2: GOSUB 54000: RETURN

51500 REM: SET LINE TYPE
51510 A1%(1) = 15: A1%(2) = 0: A2%(1) = LT: GOSUB 54000: RETURN

52800 REM INPUT LOCATOR  (IMPLEMENTED FOR KEYBOARD: CAN BE FOR MOUSE)
52810 A1%(1) = 28: A1%(2) = 1: A2%(1) = 1: A3%(1) = X1: A3%(2) = Y1
52820 GOSUB 54000: RETURN

53200 REM: SET WRITING MODE
53210 A1%(1) = 32: A1%(2) = 0: A2%(1) = WM: GOSUB 54000: RETURN

54000 REM: CALL GSX ASSEMBLY SUBROUTINE
54010 DEF SEG = &H61: GSX% = 0: REM ASSIGN SEGMENT ADDRESS & OFFSET
54020 CALL GSX%(A1%(1), A2%(1), A3%(1), A4%(1), A5%(1))
54030 DEF SEG: RETURN

60000 REM: INSTRUCTIONS
60010 PRINT CHR$(27); "ESKETCH draws black lines on 800 X 400-dot white field";
60015 PRINT " in eight directions.
60016 PRINT "Press the initial letter to get any of the following functions:"
60020 PRINT: PRINT "B = BLACK LINE";
60030 PRINT "					W = WHITE LINE (erase)"
60040 PRINT: PRINT "M = MOVE WITHOUT DRAWING (use M at beginning and end of move)
60050 PRINT
60060 PRINT "<SPACE> KEY DRAWS LINE FROM PRESENT TO PREVIOUS CURSOR POSITION.
60070 PRINT: PRINT "(to draw an isolated dot press M <SPACE> M.)"
60080 PRINT: PRINT "C = CLEAR SCREEN";
60090 PRINT "				H = HOME TO CENTRE
60100 PRINT: PRINT "5 = TOGGLE FROM HIGH TO LOW SPEED"
60110 PRINT: PRINT "OTHER NUMBER KEYS 1 TO 9 MOVE CURSOR IN INDICATED DIRECTION
60120 PRINT: PRINT "L = LINE FOLLOWED BY 1 TO 7 TO CHANGE LINE TYPE";
60130 PRINT "  (Always use L1 for erasing.)"
60140 PRINT: PRINT "Q = QUIT THE PROGRAM";
60150 PRINT "				<RETURN> key not required
60155 PRINT: PRINT
60160 PRINT "                    PRESS <SPACE> KEY WHEN READY TO PROCEED
60170 I$ = INKEY$: IF I$ = "" THEN GOTO 60170
60180 RETURN
